// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/monitoring/v3/service_service.proto

#include "google/cloud/monitoring/v3/internal/service_monitoring_auth_decorator.h"
#include <google/monitoring/v3/service_service.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace monitoring_v3_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

ServiceMonitoringServiceAuth::ServiceMonitoringServiceAuth(
    std::shared_ptr<google::cloud::internal::GrpcAuthenticationStrategy> auth,
    std::shared_ptr<ServiceMonitoringServiceStub> child)
    : auth_(std::move(auth)), child_(std::move(child)) {}

StatusOr<google::monitoring::v3::Service>
ServiceMonitoringServiceAuth::CreateService(
    grpc::ClientContext& context,
    google::monitoring::v3::CreateServiceRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->CreateService(context, request);
}

StatusOr<google::monitoring::v3::Service>
ServiceMonitoringServiceAuth::GetService(
    grpc::ClientContext& context,
    google::monitoring::v3::GetServiceRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->GetService(context, request);
}

StatusOr<google::monitoring::v3::ListServicesResponse>
ServiceMonitoringServiceAuth::ListServices(
    grpc::ClientContext& context,
    google::monitoring::v3::ListServicesRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ListServices(context, request);
}

StatusOr<google::monitoring::v3::Service>
ServiceMonitoringServiceAuth::UpdateService(
    grpc::ClientContext& context,
    google::monitoring::v3::UpdateServiceRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->UpdateService(context, request);
}

Status ServiceMonitoringServiceAuth::DeleteService(
    grpc::ClientContext& context,
    google::monitoring::v3::DeleteServiceRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->DeleteService(context, request);
}

StatusOr<google::monitoring::v3::ServiceLevelObjective>
ServiceMonitoringServiceAuth::CreateServiceLevelObjective(
    grpc::ClientContext& context,
    google::monitoring::v3::CreateServiceLevelObjectiveRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->CreateServiceLevelObjective(context, request);
}

StatusOr<google::monitoring::v3::ServiceLevelObjective>
ServiceMonitoringServiceAuth::GetServiceLevelObjective(
    grpc::ClientContext& context,
    google::monitoring::v3::GetServiceLevelObjectiveRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->GetServiceLevelObjective(context, request);
}

StatusOr<google::monitoring::v3::ListServiceLevelObjectivesResponse>
ServiceMonitoringServiceAuth::ListServiceLevelObjectives(
    grpc::ClientContext& context,
    google::monitoring::v3::ListServiceLevelObjectivesRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ListServiceLevelObjectives(context, request);
}

StatusOr<google::monitoring::v3::ServiceLevelObjective>
ServiceMonitoringServiceAuth::UpdateServiceLevelObjective(
    grpc::ClientContext& context,
    google::monitoring::v3::UpdateServiceLevelObjectiveRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->UpdateServiceLevelObjective(context, request);
}

Status ServiceMonitoringServiceAuth::DeleteServiceLevelObjective(
    grpc::ClientContext& context,
    google::monitoring::v3::DeleteServiceLevelObjectiveRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->DeleteServiceLevelObjective(context, request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace monitoring_v3_internal
}  // namespace cloud
}  // namespace google
