// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dialogflow/v2/answer_record.proto

#include "google/cloud/dialogflow_es/internal/answer_records_tracing_stub.h"
#include "google/cloud/internal/grpc_opentelemetry.h"

namespace google {
namespace cloud {
namespace dialogflow_es_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

AnswerRecordsTracingStub::AnswerRecordsTracingStub(
    std::shared_ptr<AnswerRecordsStub> child)
    : child_(std::move(child)), propagator_(internal::MakePropagator()) {}

StatusOr<google::cloud::dialogflow::v2::ListAnswerRecordsResponse>
AnswerRecordsTracingStub::ListAnswerRecords(
    grpc::ClientContext& context,
    google::cloud::dialogflow::v2::ListAnswerRecordsRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.dialogflow.v2.AnswerRecords",
                                     "ListAnswerRecords");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListAnswerRecords(context, request));
}

StatusOr<google::cloud::dialogflow::v2::AnswerRecord>
AnswerRecordsTracingStub::UpdateAnswerRecord(
    grpc::ClientContext& context,
    google::cloud::dialogflow::v2::UpdateAnswerRecordRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.dialogflow.v2.AnswerRecords",
                                     "UpdateAnswerRecord");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->UpdateAnswerRecord(context, request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<AnswerRecordsStub> MakeAnswerRecordsTracingStub(
    std::shared_ptr<AnswerRecordsStub> stub) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return std::make_shared<AnswerRecordsTracingStub>(std::move(stub));
#else
  return stub;
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dialogflow_es_internal
}  // namespace cloud
}  // namespace google
