// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dialogflow/cx/v3/transition_route_group.proto

#include "google/cloud/dialogflow_cx/transition_route_groups_connection.h"
#include "google/cloud/dialogflow_cx/internal/transition_route_groups_connection_impl.h"
#include "google/cloud/dialogflow_cx/internal/transition_route_groups_option_defaults.h"
#include "google/cloud/dialogflow_cx/internal/transition_route_groups_stub_factory.h"
#include "google/cloud/dialogflow_cx/internal/transition_route_groups_tracing_connection.h"
#include "google/cloud/dialogflow_cx/transition_route_groups_options.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include <memory>

namespace google {
namespace cloud {
namespace dialogflow_cx {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

TransitionRouteGroupsConnection::~TransitionRouteGroupsConnection() = default;

StreamRange<google::cloud::dialogflow::cx::v3::TransitionRouteGroup>
TransitionRouteGroupsConnection::ListTransitionRouteGroups(
    google::cloud::dialogflow::cx::v3::
        ListTransitionRouteGroupsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::dialogflow::cx::v3::TransitionRouteGroup>>();
}

StatusOr<google::cloud::dialogflow::cx::v3::TransitionRouteGroup>
TransitionRouteGroupsConnection::GetTransitionRouteGroup(
    google::cloud::dialogflow::cx::v3::GetTransitionRouteGroupRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::dialogflow::cx::v3::TransitionRouteGroup>
TransitionRouteGroupsConnection::CreateTransitionRouteGroup(
    google::cloud::dialogflow::cx::v3::
        CreateTransitionRouteGroupRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::dialogflow::cx::v3::TransitionRouteGroup>
TransitionRouteGroupsConnection::UpdateTransitionRouteGroup(
    google::cloud::dialogflow::cx::v3::
        UpdateTransitionRouteGroupRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

Status TransitionRouteGroupsConnection::DeleteTransitionRouteGroup(
    google::cloud::dialogflow::cx::v3::
        DeleteTransitionRouteGroupRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

std::shared_ptr<TransitionRouteGroupsConnection>
MakeTransitionRouteGroupsConnection(std::string const& location,
                                    Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 UnifiedCredentialsOptionList,
                                 TransitionRouteGroupsPolicyOptionList>(
      options, __func__);
  options = dialogflow_cx_internal::TransitionRouteGroupsDefaultOptions(
      location, std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto stub = dialogflow_cx_internal::CreateDefaultTransitionRouteGroupsStub(
      background->cq(), options);
  return dialogflow_cx_internal::MakeTransitionRouteGroupsTracingConnection(
      std::make_shared<
          dialogflow_cx_internal::TransitionRouteGroupsConnectionImpl>(
          std::move(background), std::move(stub), std::move(options)));
}

std::shared_ptr<TransitionRouteGroupsConnection>
MakeTransitionRouteGroupsConnection(Options options) {
  return MakeTransitionRouteGroupsConnection(std::string{}, std::move(options));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dialogflow_cx
}  // namespace cloud
}  // namespace google
