// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dataproc/v1/jobs.proto

#include "google/cloud/dataproc/v1/job_controller_connection.h"
#include "google/cloud/dataproc/v1/internal/job_controller_connection_impl.h"
#include "google/cloud/dataproc/v1/internal/job_controller_option_defaults.h"
#include "google/cloud/dataproc/v1/internal/job_controller_stub_factory.h"
#include "google/cloud/dataproc/v1/internal/job_controller_tracing_connection.h"
#include "google/cloud/dataproc/v1/job_controller_options.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include <memory>

namespace google {
namespace cloud {
namespace dataproc_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

JobControllerConnection::~JobControllerConnection() = default;

StatusOr<google::cloud::dataproc::v1::Job> JobControllerConnection::SubmitJob(
    google::cloud::dataproc::v1::SubmitJobRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::dataproc::v1::Job>>
JobControllerConnection::SubmitJobAsOperation(
    google::cloud::dataproc::v1::SubmitJobRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::dataproc::v1::Job>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::cloud::dataproc::v1::Job> JobControllerConnection::GetJob(
    google::cloud::dataproc::v1::GetJobRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::dataproc::v1::Job> JobControllerConnection::ListJobs(
    google::cloud::dataproc::v1::
        ListJobsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::dataproc::v1::Job>>();
}

StatusOr<google::cloud::dataproc::v1::Job> JobControllerConnection::UpdateJob(
    google::cloud::dataproc::v1::UpdateJobRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::dataproc::v1::Job> JobControllerConnection::CancelJob(
    google::cloud::dataproc::v1::CancelJobRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

Status JobControllerConnection::DeleteJob(
    google::cloud::dataproc::v1::DeleteJobRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

std::shared_ptr<JobControllerConnection> MakeJobControllerConnection(
    std::string const& location, Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 UnifiedCredentialsOptionList,
                                 JobControllerPolicyOptionList>(options,
                                                                __func__);
  options = dataproc_v1_internal::JobControllerDefaultOptions(
      location, std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto stub = dataproc_v1_internal::CreateDefaultJobControllerStub(
      background->cq(), options);
  return dataproc_v1_internal::MakeJobControllerTracingConnection(
      std::make_shared<dataproc_v1_internal::JobControllerConnectionImpl>(
          std::move(background), std::move(stub), std::move(options)));
}

std::shared_ptr<JobControllerConnection> MakeJobControllerConnection(
    Options options) {
  return MakeJobControllerConnection(std::string{}, std::move(options));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dataproc_v1
}  // namespace cloud
}  // namespace google
