// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/compute/target_grpc_proxies/v1/target_grpc_proxies.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMPUTE_TARGET_GRPC_PROXIES_V1_INTERNAL_TARGET_GRPC_PROXIES_REST_CONNECTION_IMPL_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMPUTE_TARGET_GRPC_PROXIES_V1_INTERNAL_TARGET_GRPC_PROXIES_REST_CONNECTION_IMPL_H

#include "google/cloud/compute/target_grpc_proxies/v1/internal/target_grpc_proxies_rest_stub.h"
#include "google/cloud/compute/target_grpc_proxies/v1/internal/target_grpc_proxies_retry_traits.h"
#include "google/cloud/compute/target_grpc_proxies/v1/target_grpc_proxies_connection.h"
#include "google/cloud/compute/target_grpc_proxies/v1/target_grpc_proxies_connection_idempotency_policy.h"
#include "google/cloud/compute/target_grpc_proxies/v1/target_grpc_proxies_options.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/options.h"
#include "google/cloud/status_or.h"
#include "google/cloud/stream_range.h"
#include "google/cloud/version.h"
#include <google/cloud/compute/global_operations/v1/global_operations.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace compute_target_grpc_proxies_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class TargetGrpcProxiesRestConnectionImpl
    : public compute_target_grpc_proxies_v1::TargetGrpcProxiesConnection {
 public:
  ~TargetGrpcProxiesRestConnectionImpl() override = default;

  TargetGrpcProxiesRestConnectionImpl(
      std::unique_ptr<google::cloud::BackgroundThreads> background,
      std::shared_ptr<
          compute_target_grpc_proxies_v1_internal::TargetGrpcProxiesRestStub>
          stub,
      Options options);

  Options options() override { return options_; }

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  DeleteTargetGrpcProxy(
      google::cloud::cpp::compute::target_grpc_proxies::v1::
          DeleteTargetGrpcProxyRequest const& request) override;

  StatusOr<google::cloud::cpp::compute::v1::TargetGrpcProxy> GetTargetGrpcProxy(
      google::cloud::cpp::compute::target_grpc_proxies::v1::
          GetTargetGrpcProxyRequest const& request) override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  InsertTargetGrpcProxy(
      google::cloud::cpp::compute::target_grpc_proxies::v1::
          InsertTargetGrpcProxyRequest const& request) override;

  StreamRange<google::cloud::cpp::compute::v1::TargetGrpcProxy>
  ListTargetGrpcProxies(google::cloud::cpp::compute::target_grpc_proxies::v1::
                            ListTargetGrpcProxiesRequest request) override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  PatchTargetGrpcProxy(google::cloud::cpp::compute::target_grpc_proxies::v1::
                           PatchTargetGrpcProxyRequest const& request) override;

 private:
  static std::unique_ptr<
      compute_target_grpc_proxies_v1::TargetGrpcProxiesRetryPolicy>
  retry_policy(Options const& options) {
    return options
        .get<compute_target_grpc_proxies_v1::
                 TargetGrpcProxiesRetryPolicyOption>()
        ->clone();
  }

  static std::unique_ptr<BackoffPolicy> backoff_policy(Options const& options) {
    return options
        .get<compute_target_grpc_proxies_v1::
                 TargetGrpcProxiesBackoffPolicyOption>()
        ->clone();
  }

  static std::unique_ptr<compute_target_grpc_proxies_v1::
                             TargetGrpcProxiesConnectionIdempotencyPolicy>
  idempotency_policy(Options const& options) {
    return options
        .get<compute_target_grpc_proxies_v1::
                 TargetGrpcProxiesConnectionIdempotencyPolicyOption>()
        ->clone();
  }

  static std::unique_ptr<PollingPolicy> polling_policy(Options const& options) {
    return options
        .get<compute_target_grpc_proxies_v1::
                 TargetGrpcProxiesPollingPolicyOption>()
        ->clone();
  }

  std::unique_ptr<google::cloud::BackgroundThreads> background_;
  std::shared_ptr<
      compute_target_grpc_proxies_v1_internal::TargetGrpcProxiesRestStub>
      stub_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_target_grpc_proxies_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMPUTE_TARGET_GRPC_PROXIES_V1_INTERNAL_TARGET_GRPC_PROXIES_REST_CONNECTION_IMPL_H
