// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source:
// google/cloud/compute/region_instance_templates/v1/region_instance_templates.proto

#include "google/cloud/compute/region_instance_templates/v1/region_instance_templates_client.h"
#include <memory>

namespace google {
namespace cloud {
namespace compute_region_instance_templates_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

RegionInstanceTemplatesClient::RegionInstanceTemplatesClient(
    std::shared_ptr<RegionInstanceTemplatesConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
RegionInstanceTemplatesClient::~RegionInstanceTemplatesClient() = default;

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionInstanceTemplatesClient::DeleteInstanceTemplate(
    std::string const& project, std::string const& region,
    std::string const& instance_template, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::region_instance_templates::v1::
      DeleteInstanceTemplateRequest request;
  request.set_project(project);
  request.set_region(region);
  request.set_instance_template(instance_template);
  return connection_->DeleteInstanceTemplate(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionInstanceTemplatesClient::DeleteInstanceTemplate(
    google::cloud::cpp::compute::region_instance_templates::v1::
        DeleteInstanceTemplateRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteInstanceTemplate(request);
}

StatusOr<google::cloud::cpp::compute::v1::InstanceTemplate>
RegionInstanceTemplatesClient::GetInstanceTemplate(
    std::string const& project, std::string const& region,
    std::string const& instance_template, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::region_instance_templates::v1::
      GetInstanceTemplateRequest request;
  request.set_project(project);
  request.set_region(region);
  request.set_instance_template(instance_template);
  return connection_->GetInstanceTemplate(request);
}

StatusOr<google::cloud::cpp::compute::v1::InstanceTemplate>
RegionInstanceTemplatesClient::GetInstanceTemplate(
    google::cloud::cpp::compute::region_instance_templates::v1::
        GetInstanceTemplateRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetInstanceTemplate(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionInstanceTemplatesClient::InsertInstanceTemplate(
    std::string const& project, std::string const& region,
    google::cloud::cpp::compute::v1::InstanceTemplate const&
        instance_template_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::region_instance_templates::v1::
      InsertInstanceTemplateRequest request;
  request.set_project(project);
  request.set_region(region);
  *request.mutable_instance_template_resource() = instance_template_resource;
  return connection_->InsertInstanceTemplate(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionInstanceTemplatesClient::InsertInstanceTemplate(
    google::cloud::cpp::compute::region_instance_templates::v1::
        InsertInstanceTemplateRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->InsertInstanceTemplate(request);
}

StreamRange<google::cloud::cpp::compute::v1::InstanceTemplate>
RegionInstanceTemplatesClient::ListRegionInstanceTemplates(
    std::string const& project, std::string const& region, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::region_instance_templates::v1::
      ListRegionInstanceTemplatesRequest request;
  request.set_project(project);
  request.set_region(region);
  return connection_->ListRegionInstanceTemplates(request);
}

StreamRange<google::cloud::cpp::compute::v1::InstanceTemplate>
RegionInstanceTemplatesClient::ListRegionInstanceTemplates(
    google::cloud::cpp::compute::region_instance_templates::v1::
        ListRegionInstanceTemplatesRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListRegionInstanceTemplates(std::move(request));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_region_instance_templates_v1
}  // namespace cloud
}  // namespace google
