// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/compute/projects/v1/projects.proto

#include "google/cloud/compute/projects/v1/internal/projects_rest_metadata_decorator.h"
#include "google/cloud/common_options.h"
#include "google/cloud/internal/absl_str_cat_quiet.h"
#include "google/cloud/internal/absl_str_join_quiet.h"
#include "google/cloud/internal/api_client_header.h"
#include "google/cloud/status_or.h"
#include "absl/strings/str_format.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace compute_projects_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

ProjectsRestMetadata::ProjectsRestMetadata(
    std::shared_ptr<ProjectsRestStub> child, std::string api_client_header)
    : child_(std::move(child)),
      api_client_header_(
          api_client_header.empty()
              ? google::cloud::internal::GeneratedLibClientHeader()
              : std::move(api_client_header)) {}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
ProjectsRestMetadata::AsyncDisableXpnHost(
    CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    Options const& options,
    google::cloud::cpp::compute::projects::v1::DisableXpnHostRequest const&
        request) {
  SetMetadata(*rest_context, options);
  return child_->AsyncDisableXpnHost(cq, std::move(rest_context), options,
                                     request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
ProjectsRestMetadata::AsyncDisableXpnResource(
    CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    Options const& options,
    google::cloud::cpp::compute::projects::v1::DisableXpnResourceRequest const&
        request) {
  SetMetadata(*rest_context, options);
  return child_->AsyncDisableXpnResource(cq, std::move(rest_context), options,
                                         request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
ProjectsRestMetadata::AsyncEnableXpnHost(
    CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    Options const& options,
    google::cloud::cpp::compute::projects::v1::EnableXpnHostRequest const&
        request) {
  SetMetadata(*rest_context, options);
  return child_->AsyncEnableXpnHost(cq, std::move(rest_context), options,
                                    request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
ProjectsRestMetadata::AsyncEnableXpnResource(
    CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    Options const& options,
    google::cloud::cpp::compute::projects::v1::EnableXpnResourceRequest const&
        request) {
  SetMetadata(*rest_context, options);
  return child_->AsyncEnableXpnResource(cq, std::move(rest_context), options,
                                        request);
}

StatusOr<google::cloud::cpp::compute::v1::Project>
ProjectsRestMetadata::GetProject(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::projects::v1::GetProjectRequest const&
        request) {
  SetMetadata(rest_context, options);
  return child_->GetProject(rest_context, options, request);
}

StatusOr<google::cloud::cpp::compute::v1::Project>
ProjectsRestMetadata::GetXpnHost(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::projects::v1::GetXpnHostRequest const&
        request) {
  SetMetadata(rest_context, options);
  return child_->GetXpnHost(rest_context, options, request);
}

StatusOr<google::cloud::cpp::compute::v1::ProjectsGetXpnResources>
ProjectsRestMetadata::GetXpnResources(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::projects::v1::GetXpnResourcesRequest const&
        request) {
  SetMetadata(rest_context, options);
  return child_->GetXpnResources(rest_context, options, request);
}

StatusOr<google::cloud::cpp::compute::v1::XpnHostList>
ProjectsRestMetadata::ListXpnHosts(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::projects::v1::ListXpnHostsRequest const&
        request) {
  SetMetadata(rest_context, options);
  return child_->ListXpnHosts(rest_context, options, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
ProjectsRestMetadata::AsyncMoveDisk(
    CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    Options const& options,
    google::cloud::cpp::compute::projects::v1::MoveDiskRequest const& request) {
  SetMetadata(*rest_context, options);
  return child_->AsyncMoveDisk(cq, std::move(rest_context), options, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
ProjectsRestMetadata::AsyncMoveInstance(
    CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    Options const& options,
    google::cloud::cpp::compute::projects::v1::MoveInstanceRequest const&
        request) {
  SetMetadata(*rest_context, options);
  return child_->AsyncMoveInstance(cq, std::move(rest_context), options,
                                   request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
ProjectsRestMetadata::AsyncSetCommonInstanceMetadata(
    CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    Options const& options,
    google::cloud::cpp::compute::projects::v1::
        SetCommonInstanceMetadataRequest const& request) {
  SetMetadata(*rest_context, options);
  return child_->AsyncSetCommonInstanceMetadata(cq, std::move(rest_context),
                                                options, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
ProjectsRestMetadata::AsyncSetDefaultNetworkTier(
    CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    Options const& options,
    google::cloud::cpp::compute::projects::v1::
        SetDefaultNetworkTierRequest const& request) {
  SetMetadata(*rest_context, options);
  return child_->AsyncSetDefaultNetworkTier(cq, std::move(rest_context),
                                            options, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
ProjectsRestMetadata::AsyncSetUsageExportBucket(
    CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    Options const& options,
    google::cloud::cpp::compute::projects::v1::
        SetUsageExportBucketRequest const& request) {
  SetMetadata(*rest_context, options);
  return child_->AsyncSetUsageExportBucket(cq, std::move(rest_context), options,
                                           request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
ProjectsRestMetadata::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    Options const& options,
    google::cloud::cpp::compute::global_operations::v1::
        GetOperationRequest const& request) {
  SetMetadata(*rest_context, options);
  return child_->AsyncGetOperation(cq, std::move(rest_context), options,
                                   request);
}

future<Status> ProjectsRestMetadata::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    Options const& options,
    google::cloud::cpp::compute::global_operations::v1::
        DeleteOperationRequest const& request) {
  SetMetadata(*rest_context, options);
  return child_->AsyncCancelOperation(cq, std::move(rest_context), options,
                                      request);
}

void ProjectsRestMetadata::SetMetadata(rest_internal::RestContext& rest_context,
                                       Options const& options,
                                       std::vector<std::string> const& params) {
  rest_context.AddHeader("x-goog-api-client", api_client_header_);
  if (!params.empty()) {
    rest_context.AddHeader("x-goog-request-params", absl::StrJoin(params, "&"));
  }
  if (options.has<UserProjectOption>()) {
    rest_context.AddHeader("x-goog-user-project",
                           options.get<UserProjectOption>());
  }
  if (options.has<google::cloud::QuotaUserOption>()) {
    rest_context.AddHeader("x-goog-quota-user",
                           options.get<google::cloud::QuotaUserOption>());
  }
  if (options.has<google::cloud::ServerTimeoutOption>()) {
    auto ms_rep = absl::StrCat(
        absl::Dec(options.get<google::cloud::ServerTimeoutOption>().count(),
                  absl::kZeroPad4));
    rest_context.AddHeader("x-server-timeout",
                           ms_rep.insert(ms_rep.size() - 3, "."));
  }
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_projects_v1_internal
}  // namespace cloud
}  // namespace google
