// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/compute/firewalls/v1/firewalls.proto

#include "google/cloud/compute/firewalls/v1/internal/firewalls_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>

namespace google {
namespace cloud {
namespace compute_firewalls_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

FirewallsTracingConnection::FirewallsTracingConnection(
    std::shared_ptr<compute_firewalls_v1::FirewallsConnection> child)
    : child_(std::move(child)) {}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
FirewallsTracingConnection::DeleteFirewall(
    google::cloud::cpp::compute::firewalls::v1::DeleteFirewallRequest const&
        request) {
  auto span = internal::MakeSpan(
      "compute_firewalls_v1::FirewallsConnection::DeleteFirewall");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteFirewall(request));
}

StatusOr<google::cloud::cpp::compute::v1::Firewall>
FirewallsTracingConnection::GetFirewall(
    google::cloud::cpp::compute::firewalls::v1::GetFirewallRequest const&
        request) {
  auto span = internal::MakeSpan(
      "compute_firewalls_v1::FirewallsConnection::GetFirewall");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetFirewall(request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
FirewallsTracingConnection::InsertFirewall(
    google::cloud::cpp::compute::firewalls::v1::InsertFirewallRequest const&
        request) {
  auto span = internal::MakeSpan(
      "compute_firewalls_v1::FirewallsConnection::InsertFirewall");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->InsertFirewall(request));
}

StreamRange<google::cloud::cpp::compute::v1::Firewall>
FirewallsTracingConnection::ListFirewalls(
    google::cloud::cpp::compute::firewalls::v1::ListFirewallsRequest request) {
  auto span = internal::MakeSpan(
      "compute_firewalls_v1::FirewallsConnection::ListFirewalls");
  internal::OTelScope scope(span);
  auto sr = child_->ListFirewalls(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::cpp::compute::v1::Firewall>(std::move(span),
                                                 std::move(sr));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
FirewallsTracingConnection::PatchFirewall(
    google::cloud::cpp::compute::firewalls::v1::PatchFirewallRequest const&
        request) {
  auto span = internal::MakeSpan(
      "compute_firewalls_v1::FirewallsConnection::PatchFirewall");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->PatchFirewall(request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
FirewallsTracingConnection::UpdateFirewall(
    google::cloud::cpp::compute::firewalls::v1::UpdateFirewallRequest const&
        request) {
  auto span = internal::MakeSpan(
      "compute_firewalls_v1::FirewallsConnection::UpdateFirewall");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateFirewall(request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<compute_firewalls_v1::FirewallsConnection>
MakeFirewallsTracingConnection(
    std::shared_ptr<compute_firewalls_v1::FirewallsConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<FirewallsTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_firewalls_v1_internal
}  // namespace cloud
}  // namespace google
