// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/compute/disk_types/v1/disk_types.proto

#include "google/cloud/compute/disk_types/v1/disk_types_client.h"
#include <memory>

namespace google {
namespace cloud {
namespace compute_disk_types_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

DiskTypesClient::DiskTypesClient(
    std::shared_ptr<DiskTypesConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
DiskTypesClient::~DiskTypesClient() = default;

StreamRange<std::pair<std::string,
                      google::cloud::cpp::compute::v1::DiskTypesScopedList>>
DiskTypesClient::AggregatedListDiskTypes(std::string const& project,
                                         Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::disk_types::v1::AggregatedListDiskTypesRequest
      request;
  request.set_project(project);
  return connection_->AggregatedListDiskTypes(request);
}

StreamRange<std::pair<std::string,
                      google::cloud::cpp::compute::v1::DiskTypesScopedList>>
DiskTypesClient::AggregatedListDiskTypes(
    google::cloud::cpp::compute::disk_types::v1::AggregatedListDiskTypesRequest
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->AggregatedListDiskTypes(std::move(request));
}

StatusOr<google::cloud::cpp::compute::v1::DiskType>
DiskTypesClient::GetDiskType(std::string const& project,
                             std::string const& zone,
                             std::string const& disk_type, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::disk_types::v1::GetDiskTypeRequest request;
  request.set_project(project);
  request.set_zone(zone);
  request.set_disk_type(disk_type);
  return connection_->GetDiskType(request);
}

StatusOr<google::cloud::cpp::compute::v1::DiskType>
DiskTypesClient::GetDiskType(
    google::cloud::cpp::compute::disk_types::v1::GetDiskTypeRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetDiskType(request);
}

StreamRange<google::cloud::cpp::compute::v1::DiskType>
DiskTypesClient::ListDiskTypes(std::string const& project,
                               std::string const& zone, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::disk_types::v1::ListDiskTypesRequest request;
  request.set_project(project);
  request.set_zone(zone);
  return connection_->ListDiskTypes(request);
}

StreamRange<google::cloud::cpp::compute::v1::DiskType>
DiskTypesClient::ListDiskTypes(
    google::cloud::cpp::compute::disk_types::v1::ListDiskTypesRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListDiskTypes(std::move(request));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_disk_types_v1
}  // namespace cloud
}  // namespace google
