// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/billing/budgets/v1/budget_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BILLING_BUDGETS_V1_INTERNAL_BUDGET_STUB_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BILLING_BUDGETS_V1_INTERNAL_BUDGET_STUB_H

#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/cloud/billing/budgets/v1/budget_service.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace billing_budgets_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class BudgetServiceStub {
 public:
  virtual ~BudgetServiceStub() = 0;

  virtual StatusOr<google::cloud::billing::budgets::v1::Budget> CreateBudget(
      grpc::ClientContext& context,
      google::cloud::billing::budgets::v1::CreateBudgetRequest const&
          request) = 0;

  virtual StatusOr<google::cloud::billing::budgets::v1::Budget> UpdateBudget(
      grpc::ClientContext& context,
      google::cloud::billing::budgets::v1::UpdateBudgetRequest const&
          request) = 0;

  virtual StatusOr<google::cloud::billing::budgets::v1::Budget> GetBudget(
      grpc::ClientContext& context,
      google::cloud::billing::budgets::v1::GetBudgetRequest const& request) = 0;

  virtual StatusOr<google::cloud::billing::budgets::v1::ListBudgetsResponse>
  ListBudgets(grpc::ClientContext& context,
              google::cloud::billing::budgets::v1::ListBudgetsRequest const&
                  request) = 0;

  virtual Status DeleteBudget(
      grpc::ClientContext& context,
      google::cloud::billing::budgets::v1::DeleteBudgetRequest const&
          request) = 0;
};

class DefaultBudgetServiceStub : public BudgetServiceStub {
 public:
  explicit DefaultBudgetServiceStub(
      std::unique_ptr<
          google::cloud::billing::budgets::v1::BudgetService::StubInterface>
          grpc_stub)
      : grpc_stub_(std::move(grpc_stub)) {}

  StatusOr<google::cloud::billing::budgets::v1::Budget> CreateBudget(
      grpc::ClientContext& context,
      google::cloud::billing::budgets::v1::CreateBudgetRequest const& request)
      override;

  StatusOr<google::cloud::billing::budgets::v1::Budget> UpdateBudget(
      grpc::ClientContext& context,
      google::cloud::billing::budgets::v1::UpdateBudgetRequest const& request)
      override;

  StatusOr<google::cloud::billing::budgets::v1::Budget> GetBudget(
      grpc::ClientContext& context,
      google::cloud::billing::budgets::v1::GetBudgetRequest const& request)
      override;

  StatusOr<google::cloud::billing::budgets::v1::ListBudgetsResponse>
  ListBudgets(grpc::ClientContext& context,
              google::cloud::billing::budgets::v1::ListBudgetsRequest const&
                  request) override;

  Status DeleteBudget(
      grpc::ClientContext& context,
      google::cloud::billing::budgets::v1::DeleteBudgetRequest const& request)
      override;

 private:
  std::unique_ptr<
      google::cloud::billing::budgets::v1::BudgetService::StubInterface>
      grpc_stub_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace billing_budgets_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BILLING_BUDGETS_V1_INTERNAL_BUDGET_STUB_H
