// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/bigquery/biglake/v1/metastore.proto

#include "google/cloud/bigquery/biglake/v1/internal/metastore_logging_decorator.h"
#include "google/cloud/internal/log_wrapper.h"
#include "google/cloud/status_or.h"
#include <google/cloud/bigquery/biglake/v1/metastore.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace bigquery_biglake_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

MetastoreServiceLogging::MetastoreServiceLogging(
    std::shared_ptr<MetastoreServiceStub> child, TracingOptions tracing_options,
    std::set<std::string> const& components)
    : child_(std::move(child)),
      tracing_options_(std::move(tracing_options)),
      stream_logging_(components.find("rpc-streams") != components.end()) {}

StatusOr<google::cloud::bigquery::biglake::v1::Catalog>
MetastoreServiceLogging::CreateCatalog(
    grpc::ClientContext& context,
    google::cloud::bigquery::biglake::v1::CreateCatalogRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::bigquery::biglake::v1::CreateCatalogRequest const&
                 request) { return child_->CreateCatalog(context, request); },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::bigquery::biglake::v1::Catalog>
MetastoreServiceLogging::DeleteCatalog(
    grpc::ClientContext& context,
    google::cloud::bigquery::biglake::v1::DeleteCatalogRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::bigquery::biglake::v1::DeleteCatalogRequest const&
                 request) { return child_->DeleteCatalog(context, request); },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::bigquery::biglake::v1::Catalog>
MetastoreServiceLogging::GetCatalog(
    grpc::ClientContext& context,
    google::cloud::bigquery::biglake::v1::GetCatalogRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::bigquery::biglake::v1::GetCatalogRequest const&
                 request) { return child_->GetCatalog(context, request); },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::bigquery::biglake::v1::ListCatalogsResponse>
MetastoreServiceLogging::ListCatalogs(
    grpc::ClientContext& context,
    google::cloud::bigquery::biglake::v1::ListCatalogsRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::bigquery::biglake::v1::ListCatalogsRequest const&
                 request) { return child_->ListCatalogs(context, request); },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::bigquery::biglake::v1::Database>
MetastoreServiceLogging::CreateDatabase(
    grpc::ClientContext& context,
    google::cloud::bigquery::biglake::v1::CreateDatabaseRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::bigquery::biglake::v1::CreateDatabaseRequest const&
                 request) { return child_->CreateDatabase(context, request); },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::bigquery::biglake::v1::Database>
MetastoreServiceLogging::DeleteDatabase(
    grpc::ClientContext& context,
    google::cloud::bigquery::biglake::v1::DeleteDatabaseRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::bigquery::biglake::v1::DeleteDatabaseRequest const&
                 request) { return child_->DeleteDatabase(context, request); },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::bigquery::biglake::v1::Database>
MetastoreServiceLogging::UpdateDatabase(
    grpc::ClientContext& context,
    google::cloud::bigquery::biglake::v1::UpdateDatabaseRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::bigquery::biglake::v1::UpdateDatabaseRequest const&
                 request) { return child_->UpdateDatabase(context, request); },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::bigquery::biglake::v1::Database>
MetastoreServiceLogging::GetDatabase(
    grpc::ClientContext& context,
    google::cloud::bigquery::biglake::v1::GetDatabaseRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::bigquery::biglake::v1::GetDatabaseRequest const&
                 request) { return child_->GetDatabase(context, request); },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::bigquery::biglake::v1::ListDatabasesResponse>
MetastoreServiceLogging::ListDatabases(
    grpc::ClientContext& context,
    google::cloud::bigquery::biglake::v1::ListDatabasesRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::bigquery::biglake::v1::ListDatabasesRequest const&
                 request) { return child_->ListDatabases(context, request); },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::bigquery::biglake::v1::Table>
MetastoreServiceLogging::CreateTable(
    grpc::ClientContext& context,
    google::cloud::bigquery::biglake::v1::CreateTableRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::bigquery::biglake::v1::CreateTableRequest const&
                 request) { return child_->CreateTable(context, request); },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::bigquery::biglake::v1::Table>
MetastoreServiceLogging::DeleteTable(
    grpc::ClientContext& context,
    google::cloud::bigquery::biglake::v1::DeleteTableRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::bigquery::biglake::v1::DeleteTableRequest const&
                 request) { return child_->DeleteTable(context, request); },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::bigquery::biglake::v1::Table>
MetastoreServiceLogging::UpdateTable(
    grpc::ClientContext& context,
    google::cloud::bigquery::biglake::v1::UpdateTableRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::bigquery::biglake::v1::UpdateTableRequest const&
                 request) { return child_->UpdateTable(context, request); },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::bigquery::biglake::v1::Table>
MetastoreServiceLogging::RenameTable(
    grpc::ClientContext& context,
    google::cloud::bigquery::biglake::v1::RenameTableRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::bigquery::biglake::v1::RenameTableRequest const&
                 request) { return child_->RenameTable(context, request); },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::bigquery::biglake::v1::Table>
MetastoreServiceLogging::GetTable(
    grpc::ClientContext& context,
    google::cloud::bigquery::biglake::v1::GetTableRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::bigquery::biglake::v1::GetTableRequest const&
                 request) { return child_->GetTable(context, request); },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::bigquery::biglake::v1::ListTablesResponse>
MetastoreServiceLogging::ListTables(
    grpc::ClientContext& context,
    google::cloud::bigquery::biglake::v1::ListTablesRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::bigquery::biglake::v1::ListTablesRequest const&
                 request) { return child_->ListTables(context, request); },
      context, request, __func__, tracing_options_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace bigquery_biglake_v1_internal
}  // namespace cloud
}  // namespace google
