// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/appengine/v1/appengine.proto

#include "google/cloud/appengine/v1/internal/versions_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>

namespace google {
namespace cloud {
namespace appengine_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

VersionsTracingConnection::VersionsTracingConnection(
    std::shared_ptr<appengine_v1::VersionsConnection> child)
    : child_(std::move(child)) {}

StreamRange<google::appengine::v1::Version>
VersionsTracingConnection::ListVersions(
    google::appengine::v1::ListVersionsRequest request) {
  auto span =
      internal::MakeSpan("appengine_v1::VersionsConnection::ListVersions");
  internal::OTelScope scope(span);
  auto sr = child_->ListVersions(std::move(request));
  return internal::MakeTracedStreamRange<google::appengine::v1::Version>(
      std::move(span), std::move(sr));
}

StatusOr<google::appengine::v1::Version> VersionsTracingConnection::GetVersion(
    google::appengine::v1::GetVersionRequest const& request) {
  auto span =
      internal::MakeSpan("appengine_v1::VersionsConnection::GetVersion");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetVersion(request));
}

future<StatusOr<google::appengine::v1::Version>>
VersionsTracingConnection::CreateVersion(
    google::appengine::v1::CreateVersionRequest const& request) {
  auto span =
      internal::MakeSpan("appengine_v1::VersionsConnection::CreateVersion");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateVersion(request));
}

future<StatusOr<google::appengine::v1::Version>>
VersionsTracingConnection::UpdateVersion(
    google::appengine::v1::UpdateVersionRequest const& request) {
  auto span =
      internal::MakeSpan("appengine_v1::VersionsConnection::UpdateVersion");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateVersion(request));
}

future<StatusOr<google::appengine::v1::OperationMetadataV1>>
VersionsTracingConnection::DeleteVersion(
    google::appengine::v1::DeleteVersionRequest const& request) {
  auto span =
      internal::MakeSpan("appengine_v1::VersionsConnection::DeleteVersion");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteVersion(request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<appengine_v1::VersionsConnection> MakeVersionsTracingConnection(
    std::shared_ptr<appengine_v1::VersionsConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<VersionsTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace appengine_v1_internal
}  // namespace cloud
}  // namespace google
