// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/aiplatform/v1/tensorboard_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_TENSORBOARD_CONNECTION_IDEMPOTENCY_POLICY_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_TENSORBOARD_CONNECTION_IDEMPOTENCY_POLICY_H

#include "google/cloud/idempotency.h"
#include "google/cloud/version.h"
#include <google/cloud/aiplatform/v1/tensorboard_service.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace aiplatform_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class TensorboardServiceConnectionIdempotencyPolicy {
 public:
  virtual ~TensorboardServiceConnectionIdempotencyPolicy();

  /// Create a new copy of this object.
  virtual std::unique_ptr<TensorboardServiceConnectionIdempotencyPolicy> clone()
      const;

  virtual google::cloud::Idempotency CreateTensorboard(
      google::cloud::aiplatform::v1::CreateTensorboardRequest const& request);

  virtual google::cloud::Idempotency GetTensorboard(
      google::cloud::aiplatform::v1::GetTensorboardRequest const& request);

  virtual google::cloud::Idempotency UpdateTensorboard(
      google::cloud::aiplatform::v1::UpdateTensorboardRequest const& request);

  virtual google::cloud::Idempotency ListTensorboards(
      google::cloud::aiplatform::v1::ListTensorboardsRequest request);

  virtual google::cloud::Idempotency DeleteTensorboard(
      google::cloud::aiplatform::v1::DeleteTensorboardRequest const& request);

  virtual google::cloud::Idempotency ReadTensorboardUsage(
      google::cloud::aiplatform::v1::ReadTensorboardUsageRequest const&
          request);

  virtual google::cloud::Idempotency ReadTensorboardSize(
      google::cloud::aiplatform::v1::ReadTensorboardSizeRequest const& request);

  virtual google::cloud::Idempotency CreateTensorboardExperiment(
      google::cloud::aiplatform::v1::CreateTensorboardExperimentRequest const&
          request);

  virtual google::cloud::Idempotency GetTensorboardExperiment(
      google::cloud::aiplatform::v1::GetTensorboardExperimentRequest const&
          request);

  virtual google::cloud::Idempotency UpdateTensorboardExperiment(
      google::cloud::aiplatform::v1::UpdateTensorboardExperimentRequest const&
          request);

  virtual google::cloud::Idempotency ListTensorboardExperiments(
      google::cloud::aiplatform::v1::ListTensorboardExperimentsRequest request);

  virtual google::cloud::Idempotency DeleteTensorboardExperiment(
      google::cloud::aiplatform::v1::DeleteTensorboardExperimentRequest const&
          request);

  virtual google::cloud::Idempotency CreateTensorboardRun(
      google::cloud::aiplatform::v1::CreateTensorboardRunRequest const&
          request);

  virtual google::cloud::Idempotency BatchCreateTensorboardRuns(
      google::cloud::aiplatform::v1::BatchCreateTensorboardRunsRequest const&
          request);

  virtual google::cloud::Idempotency GetTensorboardRun(
      google::cloud::aiplatform::v1::GetTensorboardRunRequest const& request);

  virtual google::cloud::Idempotency UpdateTensorboardRun(
      google::cloud::aiplatform::v1::UpdateTensorboardRunRequest const&
          request);

  virtual google::cloud::Idempotency ListTensorboardRuns(
      google::cloud::aiplatform::v1::ListTensorboardRunsRequest request);

  virtual google::cloud::Idempotency DeleteTensorboardRun(
      google::cloud::aiplatform::v1::DeleteTensorboardRunRequest const&
          request);

  virtual google::cloud::Idempotency BatchCreateTensorboardTimeSeries(
      google::cloud::aiplatform::v1::
          BatchCreateTensorboardTimeSeriesRequest const& request);

  virtual google::cloud::Idempotency CreateTensorboardTimeSeries(
      google::cloud::aiplatform::v1::CreateTensorboardTimeSeriesRequest const&
          request);

  virtual google::cloud::Idempotency GetTensorboardTimeSeries(
      google::cloud::aiplatform::v1::GetTensorboardTimeSeriesRequest const&
          request);

  virtual google::cloud::Idempotency UpdateTensorboardTimeSeries(
      google::cloud::aiplatform::v1::UpdateTensorboardTimeSeriesRequest const&
          request);

  virtual google::cloud::Idempotency ListTensorboardTimeSeries(
      google::cloud::aiplatform::v1::ListTensorboardTimeSeriesRequest request);

  virtual google::cloud::Idempotency DeleteTensorboardTimeSeries(
      google::cloud::aiplatform::v1::DeleteTensorboardTimeSeriesRequest const&
          request);

  virtual google::cloud::Idempotency BatchReadTensorboardTimeSeriesData(
      google::cloud::aiplatform::v1::
          BatchReadTensorboardTimeSeriesDataRequest const& request);

  virtual google::cloud::Idempotency ReadTensorboardTimeSeriesData(
      google::cloud::aiplatform::v1::ReadTensorboardTimeSeriesDataRequest const&
          request);

  virtual google::cloud::Idempotency WriteTensorboardExperimentData(
      google::cloud::aiplatform::v1::
          WriteTensorboardExperimentDataRequest const& request);

  virtual google::cloud::Idempotency WriteTensorboardRunData(
      google::cloud::aiplatform::v1::WriteTensorboardRunDataRequest const&
          request);

  virtual google::cloud::Idempotency ExportTensorboardTimeSeriesData(
      google::cloud::aiplatform::v1::ExportTensorboardTimeSeriesDataRequest
          request);
};

std::unique_ptr<TensorboardServiceConnectionIdempotencyPolicy>
MakeDefaultTensorboardServiceConnectionIdempotencyPolicy();

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace aiplatform_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_TENSORBOARD_CONNECTION_IDEMPOTENCY_POLICY_H
