// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/aiplatform/v1/pipeline_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_PIPELINE_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_PIPELINE_CLIENT_H

#include "google/cloud/aiplatform/v1/pipeline_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <map>
#include <memory>

namespace google {
namespace cloud {
namespace aiplatform_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// A service for creating and managing Vertex AI's pipelines. This includes
/// both `TrainingPipeline` resources (used for AutoML and custom training) and
/// `PipelineJob` resources (used for Vertex AI Pipelines).
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class PipelineServiceClient {
 public:
  explicit PipelineServiceClient(
      std::shared_ptr<PipelineServiceConnection> connection, Options opts = {});
  ~PipelineServiceClient();

  ///@{
  /// @name Copy and move support
  PipelineServiceClient(PipelineServiceClient const&) = default;
  PipelineServiceClient& operator=(PipelineServiceClient const&) = default;
  PipelineServiceClient(PipelineServiceClient&&) = default;
  PipelineServiceClient& operator=(PipelineServiceClient&&) = default;
  ///@}

  ///@{
  /// @name Equality
  friend bool operator==(PipelineServiceClient const& a,
                         PipelineServiceClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(PipelineServiceClient const& a,
                         PipelineServiceClient const& b) {
    return !(a == b);
  }
  ///@}

  // clang-format off
  ///
  /// Creates a TrainingPipeline. A created TrainingPipeline right away will be
  /// attempted to be run.
  ///
  /// @param parent  Required. The resource name of the Location to create the TrainingPipeline
  ///  in. Format: `projects/{project}/locations/{location}`
  /// @param training_pipeline  Required. The TrainingPipeline to create.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.TrainingPipeline])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.CreateTrainingPipelineRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/pipeline_service.proto#L176}
  /// [google.cloud.aiplatform.v1.TrainingPipeline]: @googleapis_reference_link{google/cloud/aiplatform/v1/training_pipeline.proto#L42}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::TrainingPipeline>
  CreateTrainingPipeline(
      std::string const& parent,
      google::cloud::aiplatform::v1::TrainingPipeline const& training_pipeline,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a TrainingPipeline. A created TrainingPipeline right away will be
  /// attempted to be run.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.CreateTrainingPipelineRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.TrainingPipeline])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.CreateTrainingPipelineRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/pipeline_service.proto#L176}
  /// [google.cloud.aiplatform.v1.TrainingPipeline]: @googleapis_reference_link{google/cloud/aiplatform/v1/training_pipeline.proto#L42}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::TrainingPipeline>
  CreateTrainingPipeline(
      google::cloud::aiplatform::v1::CreateTrainingPipelineRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets a TrainingPipeline.
  ///
  /// @param name  Required. The name of the TrainingPipeline resource.
  ///  Format:
  ///  `projects/{project}/locations/{location}/trainingPipelines/{training_pipeline}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.TrainingPipeline])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.GetTrainingPipelineRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/pipeline_service.proto#L193}
  /// [google.cloud.aiplatform.v1.TrainingPipeline]: @googleapis_reference_link{google/cloud/aiplatform/v1/training_pipeline.proto#L42}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::TrainingPipeline> GetTrainingPipeline(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets a TrainingPipeline.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.GetTrainingPipelineRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.TrainingPipeline])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.GetTrainingPipelineRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/pipeline_service.proto#L193}
  /// [google.cloud.aiplatform.v1.TrainingPipeline]: @googleapis_reference_link{google/cloud/aiplatform/v1/training_pipeline.proto#L42}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::TrainingPipeline> GetTrainingPipeline(
      google::cloud::aiplatform::v1::GetTrainingPipelineRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists TrainingPipelines in a Location.
  ///
  /// @param parent  Required. The resource name of the Location to list the TrainingPipelines
  ///  from. Format: `projects/{project}/locations/{location}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.aiplatform.v1.TrainingPipeline], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.ListTrainingPipelinesRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/pipeline_service.proto#L207}
  /// [google.cloud.aiplatform.v1.TrainingPipeline]: @googleapis_reference_link{google/cloud/aiplatform/v1/training_pipeline.proto#L42}
  ///
  // clang-format on
  StreamRange<google::cloud::aiplatform::v1::TrainingPipeline>
  ListTrainingPipelines(std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists TrainingPipelines in a Location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.ListTrainingPipelinesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.aiplatform.v1.TrainingPipeline], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.ListTrainingPipelinesRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/pipeline_service.proto#L207}
  /// [google.cloud.aiplatform.v1.TrainingPipeline]: @googleapis_reference_link{google/cloud/aiplatform/v1/training_pipeline.proto#L42}
  ///
  // clang-format on
  StreamRange<google::cloud::aiplatform::v1::TrainingPipeline>
  ListTrainingPipelines(
      google::cloud::aiplatform::v1::ListTrainingPipelinesRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Deletes a TrainingPipeline.
  ///
  /// @param name  Required. The name of the TrainingPipeline resource to be deleted.
  ///  Format:
  ///  `projects/{project}/locations/{location}/trainingPipelines/{training_pipeline}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.aiplatform.v1.DeleteOperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.DeleteOperationMetadata]: @googleapis_reference_link{google/cloud/aiplatform/v1/operation.proto#L52}
  /// [google.cloud.aiplatform.v1.DeleteTrainingPipelineRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/pipeline_service.proto#L269}
  ///
  // clang-format on
  future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
  DeleteTrainingPipeline(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes a TrainingPipeline.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.DeleteTrainingPipelineRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.aiplatform.v1.DeleteOperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.DeleteOperationMetadata]: @googleapis_reference_link{google/cloud/aiplatform/v1/operation.proto#L52}
  /// [google.cloud.aiplatform.v1.DeleteTrainingPipelineRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/pipeline_service.proto#L269}
  ///
  // clang-format on
  future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
  DeleteTrainingPipeline(
      google::cloud::aiplatform::v1::DeleteTrainingPipelineRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Cancels a TrainingPipeline.
  /// Starts asynchronous cancellation on the TrainingPipeline. The server
  /// makes a best effort to cancel the pipeline, but success is not
  /// guaranteed. Clients can use
  /// [PipelineService.GetTrainingPipeline][google.cloud.aiplatform.v1.PipelineService.GetTrainingPipeline]
  /// or other methods to check whether the cancellation succeeded or whether the
  /// pipeline completed despite cancellation. On successful cancellation,
  /// the TrainingPipeline is not deleted; instead it becomes a pipeline with
  /// a
  /// [TrainingPipeline.error][google.cloud.aiplatform.v1.TrainingPipeline.error]
  /// value with a [google.rpc.Status.code][google.rpc.Status.code] of 1,
  /// corresponding to `Code.CANCELLED`, and
  /// [TrainingPipeline.state][google.cloud.aiplatform.v1.TrainingPipeline.state]
  /// is set to `CANCELLED`.
  ///
  /// @param name  Required. The name of the TrainingPipeline to cancel.
  ///  Format:
  ///  `projects/{project}/locations/{location}/trainingPipelines/{training_pipeline}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.CancelTrainingPipelineRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/pipeline_service.proto#L283}
  /// [google.cloud.aiplatform.v1.PipelineService.GetTrainingPipeline]: @googleapis_reference_link{google/cloud/aiplatform/v1/pipeline_service.proto#L58}
  /// [google.cloud.aiplatform.v1.TrainingPipeline.error]: @googleapis_reference_link{google/cloud/aiplatform/v1/training_pipeline.proto#L127}
  /// [google.cloud.aiplatform.v1.TrainingPipeline.state]: @googleapis_reference_link{google/cloud/aiplatform/v1/training_pipeline.proto#L123}
  /// [google.rpc.Status.code]: @googleapis_reference_link{google/rpc/status.proto#L38}
  ///
  // clang-format on
  Status CancelTrainingPipeline(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Cancels a TrainingPipeline.
  /// Starts asynchronous cancellation on the TrainingPipeline. The server
  /// makes a best effort to cancel the pipeline, but success is not
  /// guaranteed. Clients can use
  /// [PipelineService.GetTrainingPipeline][google.cloud.aiplatform.v1.PipelineService.GetTrainingPipeline]
  /// or other methods to check whether the cancellation succeeded or whether the
  /// pipeline completed despite cancellation. On successful cancellation,
  /// the TrainingPipeline is not deleted; instead it becomes a pipeline with
  /// a
  /// [TrainingPipeline.error][google.cloud.aiplatform.v1.TrainingPipeline.error]
  /// value with a [google.rpc.Status.code][google.rpc.Status.code] of 1,
  /// corresponding to `Code.CANCELLED`, and
  /// [TrainingPipeline.state][google.cloud.aiplatform.v1.TrainingPipeline.state]
  /// is set to `CANCELLED`.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.CancelTrainingPipelineRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.CancelTrainingPipelineRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/pipeline_service.proto#L283}
  /// [google.cloud.aiplatform.v1.PipelineService.GetTrainingPipeline]: @googleapis_reference_link{google/cloud/aiplatform/v1/pipeline_service.proto#L58}
  /// [google.cloud.aiplatform.v1.TrainingPipeline.error]: @googleapis_reference_link{google/cloud/aiplatform/v1/training_pipeline.proto#L127}
  /// [google.cloud.aiplatform.v1.TrainingPipeline.state]: @googleapis_reference_link{google/cloud/aiplatform/v1/training_pipeline.proto#L123}
  /// [google.rpc.Status.code]: @googleapis_reference_link{google/rpc/status.proto#L38}
  ///
  // clang-format on
  Status CancelTrainingPipeline(
      google::cloud::aiplatform::v1::CancelTrainingPipelineRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a PipelineJob. A PipelineJob will run immediately when created.
  ///
  /// @param parent  Required. The resource name of the Location to create the PipelineJob in.
  ///  Format: `projects/{project}/locations/{location}`
  /// @param pipeline_job  Required. The PipelineJob to create.
  /// @param pipeline_job_id  The ID to use for the PipelineJob, which will become the final component of
  ///  the PipelineJob name. If not provided, an ID will be automatically
  ///  generated.
  ///  @n
  ///  This value should be less than 128 characters, and valid characters
  ///  are `/[a-z][0-9]-/`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.PipelineJob])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.CreatePipelineJobRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/pipeline_service.proto#L297}
  /// [google.cloud.aiplatform.v1.PipelineJob]: @googleapis_reference_link{google/cloud/aiplatform/v1/pipeline_job.proto#L45}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::PipelineJob> CreatePipelineJob(
      std::string const& parent,
      google::cloud::aiplatform::v1::PipelineJob const& pipeline_job,
      std::string const& pipeline_job_id, Options opts = {});

  // clang-format off
  ///
  /// Creates a PipelineJob. A PipelineJob will run immediately when created.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.CreatePipelineJobRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.PipelineJob])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.CreatePipelineJobRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/pipeline_service.proto#L297}
  /// [google.cloud.aiplatform.v1.PipelineJob]: @googleapis_reference_link{google/cloud/aiplatform/v1/pipeline_job.proto#L45}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::PipelineJob> CreatePipelineJob(
      google::cloud::aiplatform::v1::CreatePipelineJobRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets a PipelineJob.
  ///
  /// @param name  Required. The name of the PipelineJob resource.
  ///  Format:
  ///  `projects/{project}/locations/{location}/pipelineJobs/{pipeline_job}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.PipelineJob])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.GetPipelineJobRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/pipeline_service.proto#L321}
  /// [google.cloud.aiplatform.v1.PipelineJob]: @googleapis_reference_link{google/cloud/aiplatform/v1/pipeline_job.proto#L45}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::PipelineJob> GetPipelineJob(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets a PipelineJob.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.GetPipelineJobRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.PipelineJob])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.GetPipelineJobRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/pipeline_service.proto#L321}
  /// [google.cloud.aiplatform.v1.PipelineJob]: @googleapis_reference_link{google/cloud/aiplatform/v1/pipeline_job.proto#L45}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::PipelineJob> GetPipelineJob(
      google::cloud::aiplatform::v1::GetPipelineJobRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists PipelineJobs in a Location.
  ///
  /// @param parent  Required. The resource name of the Location to list the PipelineJobs from.
  ///  Format: `projects/{project}/locations/{location}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.aiplatform.v1.PipelineJob], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.ListPipelineJobsRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/pipeline_service.proto#L335}
  /// [google.cloud.aiplatform.v1.PipelineJob]: @googleapis_reference_link{google/cloud/aiplatform/v1/pipeline_job.proto#L45}
  ///
  // clang-format on
  StreamRange<google::cloud::aiplatform::v1::PipelineJob> ListPipelineJobs(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists PipelineJobs in a Location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.ListPipelineJobsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.aiplatform.v1.PipelineJob], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.ListPipelineJobsRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/pipeline_service.proto#L335}
  /// [google.cloud.aiplatform.v1.PipelineJob]: @googleapis_reference_link{google/cloud/aiplatform/v1/pipeline_job.proto#L45}
  ///
  // clang-format on
  StreamRange<google::cloud::aiplatform::v1::PipelineJob> ListPipelineJobs(
      google::cloud::aiplatform::v1::ListPipelineJobsRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Deletes a PipelineJob.
  ///
  /// @param name  Required. The name of the PipelineJob resource to be deleted.
  ///  Format:
  ///  `projects/{project}/locations/{location}/pipelineJobs/{pipeline_job}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.aiplatform.v1.DeleteOperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.DeleteOperationMetadata]: @googleapis_reference_link{google/cloud/aiplatform/v1/operation.proto#L52}
  /// [google.cloud.aiplatform.v1.DeletePipelineJobRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/pipeline_service.proto#L426}
  ///
  // clang-format on
  future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
  DeletePipelineJob(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes a PipelineJob.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.DeletePipelineJobRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.aiplatform.v1.DeleteOperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.DeleteOperationMetadata]: @googleapis_reference_link{google/cloud/aiplatform/v1/operation.proto#L52}
  /// [google.cloud.aiplatform.v1.DeletePipelineJobRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/pipeline_service.proto#L426}
  ///
  // clang-format on
  future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
  DeletePipelineJob(
      google::cloud::aiplatform::v1::DeletePipelineJobRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Cancels a PipelineJob.
  /// Starts asynchronous cancellation on the PipelineJob. The server
  /// makes a best effort to cancel the pipeline, but success is not
  /// guaranteed. Clients can use
  /// [PipelineService.GetPipelineJob][google.cloud.aiplatform.v1.PipelineService.GetPipelineJob]
  /// or other methods to check whether the cancellation succeeded or whether the
  /// pipeline completed despite cancellation. On successful cancellation,
  /// the PipelineJob is not deleted; instead it becomes a pipeline with
  /// a [PipelineJob.error][google.cloud.aiplatform.v1.PipelineJob.error] value
  /// with a [google.rpc.Status.code][google.rpc.Status.code] of 1, corresponding
  /// to `Code.CANCELLED`, and
  /// [PipelineJob.state][google.cloud.aiplatform.v1.PipelineJob.state] is set to
  /// `CANCELLED`.
  ///
  /// @param name  Required. The name of the PipelineJob to cancel.
  ///  Format:
  ///  `projects/{project}/locations/{location}/pipelineJobs/{pipeline_job}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.CancelPipelineJobRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/pipeline_service.proto#L440}
  /// [google.cloud.aiplatform.v1.PipelineJob.error]: @googleapis_reference_link{google/cloud/aiplatform/v1/pipeline_job.proto#L141}
  /// [google.cloud.aiplatform.v1.PipelineJob.state]: @googleapis_reference_link{google/cloud/aiplatform/v1/pipeline_job.proto#L134}
  /// [google.cloud.aiplatform.v1.PipelineService.GetPipelineJob]: @googleapis_reference_link{google/cloud/aiplatform/v1/pipeline_service.proto#L122}
  /// [google.rpc.Status.code]: @googleapis_reference_link{google/rpc/status.proto#L38}
  ///
  // clang-format on
  Status CancelPipelineJob(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Cancels a PipelineJob.
  /// Starts asynchronous cancellation on the PipelineJob. The server
  /// makes a best effort to cancel the pipeline, but success is not
  /// guaranteed. Clients can use
  /// [PipelineService.GetPipelineJob][google.cloud.aiplatform.v1.PipelineService.GetPipelineJob]
  /// or other methods to check whether the cancellation succeeded or whether the
  /// pipeline completed despite cancellation. On successful cancellation,
  /// the PipelineJob is not deleted; instead it becomes a pipeline with
  /// a [PipelineJob.error][google.cloud.aiplatform.v1.PipelineJob.error] value
  /// with a [google.rpc.Status.code][google.rpc.Status.code] of 1, corresponding
  /// to `Code.CANCELLED`, and
  /// [PipelineJob.state][google.cloud.aiplatform.v1.PipelineJob.state] is set to
  /// `CANCELLED`.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.CancelPipelineJobRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.CancelPipelineJobRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/pipeline_service.proto#L440}
  /// [google.cloud.aiplatform.v1.PipelineJob.error]: @googleapis_reference_link{google/cloud/aiplatform/v1/pipeline_job.proto#L141}
  /// [google.cloud.aiplatform.v1.PipelineJob.state]: @googleapis_reference_link{google/cloud/aiplatform/v1/pipeline_job.proto#L134}
  /// [google.cloud.aiplatform.v1.PipelineService.GetPipelineJob]: @googleapis_reference_link{google/cloud/aiplatform/v1/pipeline_service.proto#L122}
  /// [google.rpc.Status.code]: @googleapis_reference_link{google/rpc/status.proto#L38}
  ///
  // clang-format on
  Status CancelPipelineJob(
      google::cloud::aiplatform::v1::CancelPipelineJobRequest const& request,
      Options opts = {});

 private:
  std::shared_ptr<PipelineServiceConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace aiplatform_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_PIPELINE_CLIENT_H
