// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/vmmigration/v1/vmmigration.proto

#include "google/cloud/vmmigration/v1/internal/vm_migration_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>

namespace google {
namespace cloud {
namespace vmmigration_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

VmMigrationTracingConnection::VmMigrationTracingConnection(
    std::shared_ptr<vmmigration_v1::VmMigrationConnection> child)
    : child_(std::move(child)) {}

StreamRange<google::cloud::vmmigration::v1::Source>
VmMigrationTracingConnection::ListSources(
    google::cloud::vmmigration::v1::ListSourcesRequest request) {
  auto span =
      internal::MakeSpan("vmmigration_v1::VmMigrationConnection::ListSources");
  internal::OTelScope scope(span);
  auto sr = child_->ListSources(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::vmmigration::v1::Source>(std::move(span), std::move(sr));
}

StatusOr<google::cloud::vmmigration::v1::Source>
VmMigrationTracingConnection::GetSource(
    google::cloud::vmmigration::v1::GetSourceRequest const& request) {
  auto span =
      internal::MakeSpan("vmmigration_v1::VmMigrationConnection::GetSource");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetSource(request));
}

future<StatusOr<google::cloud::vmmigration::v1::Source>>
VmMigrationTracingConnection::CreateSource(
    google::cloud::vmmigration::v1::CreateSourceRequest const& request) {
  auto span =
      internal::MakeSpan("vmmigration_v1::VmMigrationConnection::CreateSource");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateSource(request));
}

future<StatusOr<google::cloud::vmmigration::v1::Source>>
VmMigrationTracingConnection::UpdateSource(
    google::cloud::vmmigration::v1::UpdateSourceRequest const& request) {
  auto span =
      internal::MakeSpan("vmmigration_v1::VmMigrationConnection::UpdateSource");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateSource(request));
}

future<StatusOr<google::cloud::vmmigration::v1::OperationMetadata>>
VmMigrationTracingConnection::DeleteSource(
    google::cloud::vmmigration::v1::DeleteSourceRequest const& request) {
  auto span =
      internal::MakeSpan("vmmigration_v1::VmMigrationConnection::DeleteSource");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteSource(request));
}

StatusOr<google::cloud::vmmigration::v1::FetchInventoryResponse>
VmMigrationTracingConnection::FetchInventory(
    google::cloud::vmmigration::v1::FetchInventoryRequest const& request) {
  auto span = internal::MakeSpan(
      "vmmigration_v1::VmMigrationConnection::FetchInventory");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->FetchInventory(request));
}

StreamRange<google::cloud::vmmigration::v1::UtilizationReport>
VmMigrationTracingConnection::ListUtilizationReports(
    google::cloud::vmmigration::v1::ListUtilizationReportsRequest request) {
  auto span = internal::MakeSpan(
      "vmmigration_v1::VmMigrationConnection::ListUtilizationReports");
  internal::OTelScope scope(span);
  auto sr = child_->ListUtilizationReports(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::vmmigration::v1::UtilizationReport>(std::move(span),
                                                         std::move(sr));
}

StatusOr<google::cloud::vmmigration::v1::UtilizationReport>
VmMigrationTracingConnection::GetUtilizationReport(
    google::cloud::vmmigration::v1::GetUtilizationReportRequest const&
        request) {
  auto span = internal::MakeSpan(
      "vmmigration_v1::VmMigrationConnection::GetUtilizationReport");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetUtilizationReport(request));
}

future<StatusOr<google::cloud::vmmigration::v1::UtilizationReport>>
VmMigrationTracingConnection::CreateUtilizationReport(
    google::cloud::vmmigration::v1::CreateUtilizationReportRequest const&
        request) {
  auto span = internal::MakeSpan(
      "vmmigration_v1::VmMigrationConnection::CreateUtilizationReport");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->CreateUtilizationReport(request));
}

future<StatusOr<google::cloud::vmmigration::v1::OperationMetadata>>
VmMigrationTracingConnection::DeleteUtilizationReport(
    google::cloud::vmmigration::v1::DeleteUtilizationReportRequest const&
        request) {
  auto span = internal::MakeSpan(
      "vmmigration_v1::VmMigrationConnection::DeleteUtilizationReport");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->DeleteUtilizationReport(request));
}

StreamRange<google::cloud::vmmigration::v1::DatacenterConnector>
VmMigrationTracingConnection::ListDatacenterConnectors(
    google::cloud::vmmigration::v1::ListDatacenterConnectorsRequest request) {
  auto span = internal::MakeSpan(
      "vmmigration_v1::VmMigrationConnection::ListDatacenterConnectors");
  internal::OTelScope scope(span);
  auto sr = child_->ListDatacenterConnectors(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::vmmigration::v1::DatacenterConnector>(std::move(span),
                                                           std::move(sr));
}

StatusOr<google::cloud::vmmigration::v1::DatacenterConnector>
VmMigrationTracingConnection::GetDatacenterConnector(
    google::cloud::vmmigration::v1::GetDatacenterConnectorRequest const&
        request) {
  auto span = internal::MakeSpan(
      "vmmigration_v1::VmMigrationConnection::GetDatacenterConnector");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetDatacenterConnector(request));
}

future<StatusOr<google::cloud::vmmigration::v1::DatacenterConnector>>
VmMigrationTracingConnection::CreateDatacenterConnector(
    google::cloud::vmmigration::v1::CreateDatacenterConnectorRequest const&
        request) {
  auto span = internal::MakeSpan(
      "vmmigration_v1::VmMigrationConnection::CreateDatacenterConnector");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->CreateDatacenterConnector(request));
}

future<StatusOr<google::cloud::vmmigration::v1::OperationMetadata>>
VmMigrationTracingConnection::DeleteDatacenterConnector(
    google::cloud::vmmigration::v1::DeleteDatacenterConnectorRequest const&
        request) {
  auto span = internal::MakeSpan(
      "vmmigration_v1::VmMigrationConnection::DeleteDatacenterConnector");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->DeleteDatacenterConnector(request));
}

future<StatusOr<google::cloud::vmmigration::v1::UpgradeApplianceResponse>>
VmMigrationTracingConnection::UpgradeAppliance(
    google::cloud::vmmigration::v1::UpgradeApplianceRequest const& request) {
  auto span = internal::MakeSpan(
      "vmmigration_v1::VmMigrationConnection::UpgradeAppliance");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpgradeAppliance(request));
}

future<StatusOr<google::cloud::vmmigration::v1::MigratingVm>>
VmMigrationTracingConnection::CreateMigratingVm(
    google::cloud::vmmigration::v1::CreateMigratingVmRequest const& request) {
  auto span = internal::MakeSpan(
      "vmmigration_v1::VmMigrationConnection::CreateMigratingVm");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateMigratingVm(request));
}

StreamRange<google::cloud::vmmigration::v1::MigratingVm>
VmMigrationTracingConnection::ListMigratingVms(
    google::cloud::vmmigration::v1::ListMigratingVmsRequest request) {
  auto span = internal::MakeSpan(
      "vmmigration_v1::VmMigrationConnection::ListMigratingVms");
  internal::OTelScope scope(span);
  auto sr = child_->ListMigratingVms(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::vmmigration::v1::MigratingVm>(std::move(span),
                                                   std::move(sr));
}

StatusOr<google::cloud::vmmigration::v1::MigratingVm>
VmMigrationTracingConnection::GetMigratingVm(
    google::cloud::vmmigration::v1::GetMigratingVmRequest const& request) {
  auto span = internal::MakeSpan(
      "vmmigration_v1::VmMigrationConnection::GetMigratingVm");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetMigratingVm(request));
}

future<StatusOr<google::cloud::vmmigration::v1::MigratingVm>>
VmMigrationTracingConnection::UpdateMigratingVm(
    google::cloud::vmmigration::v1::UpdateMigratingVmRequest const& request) {
  auto span = internal::MakeSpan(
      "vmmigration_v1::VmMigrationConnection::UpdateMigratingVm");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateMigratingVm(request));
}

future<StatusOr<google::cloud::vmmigration::v1::OperationMetadata>>
VmMigrationTracingConnection::DeleteMigratingVm(
    google::cloud::vmmigration::v1::DeleteMigratingVmRequest const& request) {
  auto span = internal::MakeSpan(
      "vmmigration_v1::VmMigrationConnection::DeleteMigratingVm");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteMigratingVm(request));
}

future<StatusOr<google::cloud::vmmigration::v1::StartMigrationResponse>>
VmMigrationTracingConnection::StartMigration(
    google::cloud::vmmigration::v1::StartMigrationRequest const& request) {
  auto span = internal::MakeSpan(
      "vmmigration_v1::VmMigrationConnection::StartMigration");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->StartMigration(request));
}

future<StatusOr<google::cloud::vmmigration::v1::ResumeMigrationResponse>>
VmMigrationTracingConnection::ResumeMigration(
    google::cloud::vmmigration::v1::ResumeMigrationRequest const& request) {
  auto span = internal::MakeSpan(
      "vmmigration_v1::VmMigrationConnection::ResumeMigration");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->ResumeMigration(request));
}

future<StatusOr<google::cloud::vmmigration::v1::PauseMigrationResponse>>
VmMigrationTracingConnection::PauseMigration(
    google::cloud::vmmigration::v1::PauseMigrationRequest const& request) {
  auto span = internal::MakeSpan(
      "vmmigration_v1::VmMigrationConnection::PauseMigration");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->PauseMigration(request));
}

future<StatusOr<google::cloud::vmmigration::v1::FinalizeMigrationResponse>>
VmMigrationTracingConnection::FinalizeMigration(
    google::cloud::vmmigration::v1::FinalizeMigrationRequest const& request) {
  auto span = internal::MakeSpan(
      "vmmigration_v1::VmMigrationConnection::FinalizeMigration");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->FinalizeMigration(request));
}

future<StatusOr<google::cloud::vmmigration::v1::CloneJob>>
VmMigrationTracingConnection::CreateCloneJob(
    google::cloud::vmmigration::v1::CreateCloneJobRequest const& request) {
  auto span = internal::MakeSpan(
      "vmmigration_v1::VmMigrationConnection::CreateCloneJob");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateCloneJob(request));
}

future<StatusOr<google::cloud::vmmigration::v1::CancelCloneJobResponse>>
VmMigrationTracingConnection::CancelCloneJob(
    google::cloud::vmmigration::v1::CancelCloneJobRequest const& request) {
  auto span = internal::MakeSpan(
      "vmmigration_v1::VmMigrationConnection::CancelCloneJob");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CancelCloneJob(request));
}

StreamRange<google::cloud::vmmigration::v1::CloneJob>
VmMigrationTracingConnection::ListCloneJobs(
    google::cloud::vmmigration::v1::ListCloneJobsRequest request) {
  auto span = internal::MakeSpan(
      "vmmigration_v1::VmMigrationConnection::ListCloneJobs");
  internal::OTelScope scope(span);
  auto sr = child_->ListCloneJobs(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::vmmigration::v1::CloneJob>(std::move(span), std::move(sr));
}

StatusOr<google::cloud::vmmigration::v1::CloneJob>
VmMigrationTracingConnection::GetCloneJob(
    google::cloud::vmmigration::v1::GetCloneJobRequest const& request) {
  auto span =
      internal::MakeSpan("vmmigration_v1::VmMigrationConnection::GetCloneJob");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetCloneJob(request));
}

future<StatusOr<google::cloud::vmmigration::v1::CutoverJob>>
VmMigrationTracingConnection::CreateCutoverJob(
    google::cloud::vmmigration::v1::CreateCutoverJobRequest const& request) {
  auto span = internal::MakeSpan(
      "vmmigration_v1::VmMigrationConnection::CreateCutoverJob");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateCutoverJob(request));
}

future<StatusOr<google::cloud::vmmigration::v1::CancelCutoverJobResponse>>
VmMigrationTracingConnection::CancelCutoverJob(
    google::cloud::vmmigration::v1::CancelCutoverJobRequest const& request) {
  auto span = internal::MakeSpan(
      "vmmigration_v1::VmMigrationConnection::CancelCutoverJob");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CancelCutoverJob(request));
}

StreamRange<google::cloud::vmmigration::v1::CutoverJob>
VmMigrationTracingConnection::ListCutoverJobs(
    google::cloud::vmmigration::v1::ListCutoverJobsRequest request) {
  auto span = internal::MakeSpan(
      "vmmigration_v1::VmMigrationConnection::ListCutoverJobs");
  internal::OTelScope scope(span);
  auto sr = child_->ListCutoverJobs(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::vmmigration::v1::CutoverJob>(std::move(span),
                                                  std::move(sr));
}

StatusOr<google::cloud::vmmigration::v1::CutoverJob>
VmMigrationTracingConnection::GetCutoverJob(
    google::cloud::vmmigration::v1::GetCutoverJobRequest const& request) {
  auto span = internal::MakeSpan(
      "vmmigration_v1::VmMigrationConnection::GetCutoverJob");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetCutoverJob(request));
}

StreamRange<google::cloud::vmmigration::v1::Group>
VmMigrationTracingConnection::ListGroups(
    google::cloud::vmmigration::v1::ListGroupsRequest request) {
  auto span =
      internal::MakeSpan("vmmigration_v1::VmMigrationConnection::ListGroups");
  internal::OTelScope scope(span);
  auto sr = child_->ListGroups(std::move(request));
  return internal::MakeTracedStreamRange<google::cloud::vmmigration::v1::Group>(
      std::move(span), std::move(sr));
}

StatusOr<google::cloud::vmmigration::v1::Group>
VmMigrationTracingConnection::GetGroup(
    google::cloud::vmmigration::v1::GetGroupRequest const& request) {
  auto span =
      internal::MakeSpan("vmmigration_v1::VmMigrationConnection::GetGroup");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetGroup(request));
}

future<StatusOr<google::cloud::vmmigration::v1::Group>>
VmMigrationTracingConnection::CreateGroup(
    google::cloud::vmmigration::v1::CreateGroupRequest const& request) {
  auto span =
      internal::MakeSpan("vmmigration_v1::VmMigrationConnection::CreateGroup");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateGroup(request));
}

future<StatusOr<google::cloud::vmmigration::v1::Group>>
VmMigrationTracingConnection::UpdateGroup(
    google::cloud::vmmigration::v1::UpdateGroupRequest const& request) {
  auto span =
      internal::MakeSpan("vmmigration_v1::VmMigrationConnection::UpdateGroup");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateGroup(request));
}

future<StatusOr<google::cloud::vmmigration::v1::OperationMetadata>>
VmMigrationTracingConnection::DeleteGroup(
    google::cloud::vmmigration::v1::DeleteGroupRequest const& request) {
  auto span =
      internal::MakeSpan("vmmigration_v1::VmMigrationConnection::DeleteGroup");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteGroup(request));
}

future<StatusOr<google::cloud::vmmigration::v1::AddGroupMigrationResponse>>
VmMigrationTracingConnection::AddGroupMigration(
    google::cloud::vmmigration::v1::AddGroupMigrationRequest const& request) {
  auto span = internal::MakeSpan(
      "vmmigration_v1::VmMigrationConnection::AddGroupMigration");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->AddGroupMigration(request));
}

future<StatusOr<google::cloud::vmmigration::v1::RemoveGroupMigrationResponse>>
VmMigrationTracingConnection::RemoveGroupMigration(
    google::cloud::vmmigration::v1::RemoveGroupMigrationRequest const&
        request) {
  auto span = internal::MakeSpan(
      "vmmigration_v1::VmMigrationConnection::RemoveGroupMigration");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->RemoveGroupMigration(request));
}

StreamRange<google::cloud::vmmigration::v1::TargetProject>
VmMigrationTracingConnection::ListTargetProjects(
    google::cloud::vmmigration::v1::ListTargetProjectsRequest request) {
  auto span = internal::MakeSpan(
      "vmmigration_v1::VmMigrationConnection::ListTargetProjects");
  internal::OTelScope scope(span);
  auto sr = child_->ListTargetProjects(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::vmmigration::v1::TargetProject>(std::move(span),
                                                     std::move(sr));
}

StatusOr<google::cloud::vmmigration::v1::TargetProject>
VmMigrationTracingConnection::GetTargetProject(
    google::cloud::vmmigration::v1::GetTargetProjectRequest const& request) {
  auto span = internal::MakeSpan(
      "vmmigration_v1::VmMigrationConnection::GetTargetProject");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetTargetProject(request));
}

future<StatusOr<google::cloud::vmmigration::v1::TargetProject>>
VmMigrationTracingConnection::CreateTargetProject(
    google::cloud::vmmigration::v1::CreateTargetProjectRequest const& request) {
  auto span = internal::MakeSpan(
      "vmmigration_v1::VmMigrationConnection::CreateTargetProject");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->CreateTargetProject(request));
}

future<StatusOr<google::cloud::vmmigration::v1::TargetProject>>
VmMigrationTracingConnection::UpdateTargetProject(
    google::cloud::vmmigration::v1::UpdateTargetProjectRequest const& request) {
  auto span = internal::MakeSpan(
      "vmmigration_v1::VmMigrationConnection::UpdateTargetProject");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->UpdateTargetProject(request));
}

future<StatusOr<google::cloud::vmmigration::v1::OperationMetadata>>
VmMigrationTracingConnection::DeleteTargetProject(
    google::cloud::vmmigration::v1::DeleteTargetProjectRequest const& request) {
  auto span = internal::MakeSpan(
      "vmmigration_v1::VmMigrationConnection::DeleteTargetProject");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->DeleteTargetProject(request));
}

StreamRange<google::cloud::vmmigration::v1::ReplicationCycle>
VmMigrationTracingConnection::ListReplicationCycles(
    google::cloud::vmmigration::v1::ListReplicationCyclesRequest request) {
  auto span = internal::MakeSpan(
      "vmmigration_v1::VmMigrationConnection::ListReplicationCycles");
  internal::OTelScope scope(span);
  auto sr = child_->ListReplicationCycles(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::vmmigration::v1::ReplicationCycle>(std::move(span),
                                                        std::move(sr));
}

StatusOr<google::cloud::vmmigration::v1::ReplicationCycle>
VmMigrationTracingConnection::GetReplicationCycle(
    google::cloud::vmmigration::v1::GetReplicationCycleRequest const& request) {
  auto span = internal::MakeSpan(
      "vmmigration_v1::VmMigrationConnection::GetReplicationCycle");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetReplicationCycle(request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<vmmigration_v1::VmMigrationConnection>
MakeVmMigrationTracingConnection(
    std::shared_ptr<vmmigration_v1::VmMigrationConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<VmMigrationTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace vmmigration_v1_internal
}  // namespace cloud
}  // namespace google
