// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/retail/v2/model_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_RETAIL_V2_MODEL_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_RETAIL_V2_MODEL_CLIENT_H

#include "google/cloud/retail/v2/model_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace retail_v2 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// Service for performing CRUD operations on models.
/// Recommendation models contain all the metadata necessary to generate a set
/// of models for the `Predict()` API. A model is queried indirectly via a
/// ServingConfig, which associates a model with a given Placement (e.g.
/// Frequently Bought Together on Home Page).
///
/// This service allows you to do the following:
///
/// * Initiate training of a model.
/// * Pause training of an existing model.
/// * List all the available models along with their metadata.
/// * Control their tuning schedule.
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class ModelServiceClient {
 public:
  explicit ModelServiceClient(
      std::shared_ptr<ModelServiceConnection> connection, Options opts = {});
  ~ModelServiceClient();

  ///@{
  /// @name Copy and move support
  ModelServiceClient(ModelServiceClient const&) = default;
  ModelServiceClient& operator=(ModelServiceClient const&) = default;
  ModelServiceClient(ModelServiceClient&&) = default;
  ModelServiceClient& operator=(ModelServiceClient&&) = default;
  ///@}

  ///@{
  /// @name Equality
  friend bool operator==(ModelServiceClient const& a,
                         ModelServiceClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(ModelServiceClient const& a,
                         ModelServiceClient const& b) {
    return !(a == b);
  }
  ///@}

  // clang-format off
  ///
  /// Creates a new model.
  ///
  /// @param parent  Required. The parent resource under which to create the model. Format:
  ///  `projects/{project_number}/locations/{location_id}/catalogs/{catalog_id}`
  /// @param model  Required. The payload of the [Model][google.cloud.retail.v2.Model]  to
  ///  create.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.retail.v2.Model] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.retail.v2.CreateModelRequest]: @googleapis_reference_link{google/cloud/retail/v2/model_service.proto#L136}
  /// [google.cloud.retail.v2.Model]: @googleapis_reference_link{google/cloud/retail/v2/model.proto#L38}
  ///
  // clang-format on
  future<StatusOr<google::cloud::retail::v2::Model>> CreateModel(
      std::string const& parent, google::cloud::retail::v2::Model const& model,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a new model.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.retail.v2.CreateModelRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.retail.v2.Model] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.retail.v2.CreateModelRequest]: @googleapis_reference_link{google/cloud/retail/v2/model_service.proto#L136}
  /// [google.cloud.retail.v2.Model]: @googleapis_reference_link{google/cloud/retail/v2/model.proto#L38}
  ///
  // clang-format on
  future<StatusOr<google::cloud::retail::v2::Model>> CreateModel(
      google::cloud::retail::v2::CreateModelRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets a model.
  ///
  /// @param name  Required. The resource name of the [Model][google.cloud.retail.v2.Model] to
  ///  get. Format:
  ///  `projects/{project_number}/locations/{location_id}/catalogs/{catalog}/models/{model_id}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.retail.v2.Model])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.retail.v2.GetModelRequest]: @googleapis_reference_link{google/cloud/retail/v2/model_service.proto#L165}
  /// [google.cloud.retail.v2.Model]: @googleapis_reference_link{google/cloud/retail/v2/model.proto#L38}
  ///
  // clang-format on
  StatusOr<google::cloud::retail::v2::Model> GetModel(std::string const& name,
                                                      Options opts = {});

  // clang-format off
  ///
  /// Gets a model.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.retail.v2.GetModelRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.retail.v2.Model])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.retail.v2.GetModelRequest]: @googleapis_reference_link{google/cloud/retail/v2/model_service.proto#L165}
  /// [google.cloud.retail.v2.Model]: @googleapis_reference_link{google/cloud/retail/v2/model.proto#L38}
  ///
  // clang-format on
  StatusOr<google::cloud::retail::v2::Model> GetModel(
      google::cloud::retail::v2::GetModelRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Pauses the training of an existing model.
  ///
  /// @param name  Required. The name of the model to pause.
  ///  Format:
  ///  `projects/{project_number}/locations/{location_id}/catalogs/{catalog_id}/models/{model_id}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.retail.v2.Model])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.retail.v2.Model]: @googleapis_reference_link{google/cloud/retail/v2/model.proto#L38}
  /// [google.cloud.retail.v2.PauseModelRequest]: @googleapis_reference_link{google/cloud/retail/v2/model_service.proto#L176}
  ///
  // clang-format on
  StatusOr<google::cloud::retail::v2::Model> PauseModel(std::string const& name,
                                                        Options opts = {});

  // clang-format off
  ///
  /// Pauses the training of an existing model.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.retail.v2.PauseModelRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.retail.v2.Model])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.retail.v2.Model]: @googleapis_reference_link{google/cloud/retail/v2/model.proto#L38}
  /// [google.cloud.retail.v2.PauseModelRequest]: @googleapis_reference_link{google/cloud/retail/v2/model_service.proto#L176}
  ///
  // clang-format on
  StatusOr<google::cloud::retail::v2::Model> PauseModel(
      google::cloud::retail::v2::PauseModelRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Resumes the training of an existing model.
  ///
  /// @param name  Required. The name of the model to resume.
  ///  Format:
  ///  `projects/{project_number}/locations/{location_id}/catalogs/{catalog_id}/models/{model_id}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.retail.v2.Model])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.retail.v2.Model]: @googleapis_reference_link{google/cloud/retail/v2/model.proto#L38}
  /// [google.cloud.retail.v2.ResumeModelRequest]: @googleapis_reference_link{google/cloud/retail/v2/model_service.proto#L187}
  ///
  // clang-format on
  StatusOr<google::cloud::retail::v2::Model> ResumeModel(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Resumes the training of an existing model.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.retail.v2.ResumeModelRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.retail.v2.Model])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.retail.v2.Model]: @googleapis_reference_link{google/cloud/retail/v2/model.proto#L38}
  /// [google.cloud.retail.v2.ResumeModelRequest]: @googleapis_reference_link{google/cloud/retail/v2/model_service.proto#L187}
  ///
  // clang-format on
  StatusOr<google::cloud::retail::v2::Model> ResumeModel(
      google::cloud::retail::v2::ResumeModelRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Deletes an existing model.
  ///
  /// @param name  Required. The resource name of the [Model][google.cloud.retail.v2.Model] to
  ///  delete. Format:
  ///  `projects/{project_number}/locations/{location_id}/catalogs/{catalog_id}/models/{model_id}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.retail.v2.DeleteModelRequest]: @googleapis_reference_link{google/cloud/retail/v2/model_service.proto#L214}
  ///
  // clang-format on
  Status DeleteModel(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes an existing model.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.retail.v2.DeleteModelRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.retail.v2.DeleteModelRequest]: @googleapis_reference_link{google/cloud/retail/v2/model_service.proto#L214}
  ///
  // clang-format on
  Status DeleteModel(
      google::cloud::retail::v2::DeleteModelRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists all the models linked to this event store.
  ///
  /// @param parent  Required. The parent for which to list models.
  ///  Format:
  ///  `projects/{project_number}/locations/{location_id}/catalogs/{catalog_id}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.retail.v2.Model], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.retail.v2.ListModelsRequest]: @googleapis_reference_link{google/cloud/retail/v2/model_service.proto#L195}
  /// [google.cloud.retail.v2.Model]: @googleapis_reference_link{google/cloud/retail/v2/model.proto#L38}
  ///
  // clang-format on
  StreamRange<google::cloud::retail::v2::Model> ListModels(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists all the models linked to this event store.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.retail.v2.ListModelsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.retail.v2.Model], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.retail.v2.ListModelsRequest]: @googleapis_reference_link{google/cloud/retail/v2/model_service.proto#L195}
  /// [google.cloud.retail.v2.Model]: @googleapis_reference_link{google/cloud/retail/v2/model.proto#L38}
  ///
  // clang-format on
  StreamRange<google::cloud::retail::v2::Model> ListModels(
      google::cloud::retail::v2::ListModelsRequest request, Options opts = {});

  // clang-format off
  ///
  /// Update of model metadata. Only fields that
  /// currently can be updated are: `filtering_option` and
  /// `periodic_tuning_state`.
  /// If other values are provided, this API method ignores them.
  ///
  /// @param model  Required. The body of the updated [Model][google.cloud.retail.v2.Model].
  /// @param update_mask  Optional. Indicates which fields in the provided 'model' to
  ///  update. If not set, by default updates all fields.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.retail.v2.Model])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.retail.v2.Model]: @googleapis_reference_link{google/cloud/retail/v2/model.proto#L38}
  /// [google.cloud.retail.v2.UpdateModelRequest]: @googleapis_reference_link{google/cloud/retail/v2/model_service.proto#L154}
  ///
  // clang-format on
  StatusOr<google::cloud::retail::v2::Model> UpdateModel(
      google::cloud::retail::v2::Model const& model,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Update of model metadata. Only fields that
  /// currently can be updated are: `filtering_option` and
  /// `periodic_tuning_state`.
  /// If other values are provided, this API method ignores them.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.retail.v2.UpdateModelRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.retail.v2.Model])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.retail.v2.Model]: @googleapis_reference_link{google/cloud/retail/v2/model.proto#L38}
  /// [google.cloud.retail.v2.UpdateModelRequest]: @googleapis_reference_link{google/cloud/retail/v2/model_service.proto#L154}
  ///
  // clang-format on
  StatusOr<google::cloud::retail::v2::Model> UpdateModel(
      google::cloud::retail::v2::UpdateModelRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Tunes an existing model.
  ///
  /// @param name  Required. The resource name of the model to tune.
  ///  Format:
  ///  `projects/{project_number}/locations/{location_id}/catalogs/{catalog_id}/models/{model_id}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.retail.v2.TuneModelResponse] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.retail.v2.TuneModelRequest]: @googleapis_reference_link{google/cloud/retail/v2/model_service.proto#L235}
  /// [google.cloud.retail.v2.TuneModelResponse]: @googleapis_reference_link{google/cloud/retail/v2/model_service.proto#L262}
  ///
  // clang-format on
  future<StatusOr<google::cloud::retail::v2::TuneModelResponse>> TuneModel(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Tunes an existing model.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.retail.v2.TuneModelRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.retail.v2.TuneModelResponse] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.retail.v2.TuneModelRequest]: @googleapis_reference_link{google/cloud/retail/v2/model_service.proto#L235}
  /// [google.cloud.retail.v2.TuneModelResponse]: @googleapis_reference_link{google/cloud/retail/v2/model_service.proto#L262}
  ///
  // clang-format on
  future<StatusOr<google::cloud::retail::v2::TuneModelResponse>> TuneModel(
      google::cloud::retail::v2::TuneModelRequest const& request,
      Options opts = {});

 private:
  std::shared_ptr<ModelServiceConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace retail_v2
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_RETAIL_V2_MODEL_CLIENT_H
