// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/monitoring/v3/notification_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_MONITORING_V3_NOTIFICATION_CHANNEL_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_MONITORING_V3_NOTIFICATION_CHANNEL_CLIENT_H

#include "google/cloud/monitoring/v3/notification_channel_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <map>
#include <memory>

namespace google {
namespace cloud {
namespace monitoring_v3 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// The Notification Channel API provides access to configuration that
/// controls how messages related to incidents are sent.
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class NotificationChannelServiceClient {
 public:
  explicit NotificationChannelServiceClient(
      std::shared_ptr<NotificationChannelServiceConnection> connection,
      Options opts = {});
  ~NotificationChannelServiceClient();

  ///@{
  /// @name Copy and move support
  NotificationChannelServiceClient(NotificationChannelServiceClient const&) =
      default;
  NotificationChannelServiceClient& operator=(
      NotificationChannelServiceClient const&) = default;
  NotificationChannelServiceClient(NotificationChannelServiceClient&&) =
      default;
  NotificationChannelServiceClient& operator=(
      NotificationChannelServiceClient&&) = default;
  ///@}

  ///@{
  /// @name Equality
  friend bool operator==(NotificationChannelServiceClient const& a,
                         NotificationChannelServiceClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(NotificationChannelServiceClient const& a,
                         NotificationChannelServiceClient const& b) {
    return !(a == b);
  }
  ///@}

  // clang-format off
  ///
  /// Lists the descriptors for supported channel types. The use of descriptors
  /// makes it possible for new channel types to be dynamically added.
  ///
  /// @param name  Required. The REST resource name of the parent from which to retrieve
  ///  the notification channel descriptors. The expected syntax is:
  ///  @n
  ///      projects/[PROJECT_ID_OR_NUMBER]
  ///  @n
  ///  Note that this
  ///  [names](https://cloud.google.com/monitoring/api/v3#project_name) the parent
  ///  container in which to look for the descriptors; to retrieve a single
  ///  descriptor by name, use the
  ///  [GetNotificationChannelDescriptor][google.monitoring.v3.NotificationChannelService.GetNotificationChannelDescriptor]
  ///  operation, instead.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.monitoring.v3.NotificationChannelDescriptor], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.monitoring.v3.ListNotificationChannelDescriptorsRequest]: @googleapis_reference_link{google/monitoring/v3/notification_service.proto#L193}
  /// [google.monitoring.v3.NotificationChannelDescriptor]: @googleapis_reference_link{google/monitoring/v3/notification.proto#L37}
  ///
  // clang-format on
  StreamRange<google::monitoring::v3::NotificationChannelDescriptor>
  ListNotificationChannelDescriptors(std::string const& name,
                                     Options opts = {});

  // clang-format off
  ///
  /// Lists the descriptors for supported channel types. The use of descriptors
  /// makes it possible for new channel types to be dynamically added.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.monitoring.v3.ListNotificationChannelDescriptorsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.monitoring.v3.NotificationChannelDescriptor], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.monitoring.v3.ListNotificationChannelDescriptorsRequest]: @googleapis_reference_link{google/monitoring/v3/notification_service.proto#L193}
  /// [google.monitoring.v3.NotificationChannelDescriptor]: @googleapis_reference_link{google/monitoring/v3/notification.proto#L37}
  ///
  // clang-format on
  StreamRange<google::monitoring::v3::NotificationChannelDescriptor>
  ListNotificationChannelDescriptors(
      google::monitoring::v3::ListNotificationChannelDescriptorsRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets a single channel descriptor. The descriptor indicates which fields
  /// are expected / permitted for a notification channel of the given type.
  ///
  /// @param name  Required. The channel type for which to execute the request. The format is:
  ///  @n
  ///      projects/[PROJECT_ID_OR_NUMBER]/notificationChannelDescriptors/[CHANNEL_TYPE]
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.monitoring.v3.NotificationChannelDescriptor])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.monitoring.v3.GetNotificationChannelDescriptorRequest]: @googleapis_reference_link{google/monitoring/v3/notification_service.proto#L237}
  /// [google.monitoring.v3.NotificationChannelDescriptor]: @googleapis_reference_link{google/monitoring/v3/notification.proto#L37}
  ///
  // clang-format on
  StatusOr<google::monitoring::v3::NotificationChannelDescriptor>
  GetNotificationChannelDescriptor(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets a single channel descriptor. The descriptor indicates which fields
  /// are expected / permitted for a notification channel of the given type.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.monitoring.v3.GetNotificationChannelDescriptorRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.monitoring.v3.NotificationChannelDescriptor])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.monitoring.v3.GetNotificationChannelDescriptorRequest]: @googleapis_reference_link{google/monitoring/v3/notification_service.proto#L237}
  /// [google.monitoring.v3.NotificationChannelDescriptor]: @googleapis_reference_link{google/monitoring/v3/notification.proto#L37}
  ///
  // clang-format on
  StatusOr<google::monitoring::v3::NotificationChannelDescriptor>
  GetNotificationChannelDescriptor(
      google::monitoring::v3::GetNotificationChannelDescriptorRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists the notification channels that have been created for the project.
  /// To list the types of notification channels that are supported, use
  /// the `ListNotificationChannelDescriptors` method.
  ///
  /// @param name  Required. The
  ///  [project](https://cloud.google.com/monitoring/api/v3#project_name) on which
  ///  to execute the request. The format is:
  ///  @n
  ///      projects/[PROJECT_ID_OR_NUMBER]
  ///  @n
  ///  This names the container
  ///  in which to look for the notification channels; it does not name a
  ///  specific channel. To query a specific channel by REST resource name, use
  ///  the
  ///  [`GetNotificationChannel`][google.monitoring.v3.NotificationChannelService.GetNotificationChannel]
  ///  operation.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.monitoring.v3.NotificationChannel], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.monitoring.v3.ListNotificationChannelsRequest]: @googleapis_reference_link{google/monitoring/v3/notification_service.proto#L274}
  /// [google.monitoring.v3.NotificationChannel]: @googleapis_reference_link{google/monitoring/v3/notification.proto#L87}
  ///
  // clang-format on
  StreamRange<google::monitoring::v3::NotificationChannel>
  ListNotificationChannels(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Lists the notification channels that have been created for the project.
  /// To list the types of notification channels that are supported, use
  /// the `ListNotificationChannelDescriptors` method.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.monitoring.v3.ListNotificationChannelsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.monitoring.v3.NotificationChannel], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.monitoring.v3.ListNotificationChannelsRequest]: @googleapis_reference_link{google/monitoring/v3/notification_service.proto#L274}
  /// [google.monitoring.v3.NotificationChannel]: @googleapis_reference_link{google/monitoring/v3/notification.proto#L87}
  ///
  // clang-format on
  StreamRange<google::monitoring::v3::NotificationChannel>
  ListNotificationChannels(
      google::monitoring::v3::ListNotificationChannelsRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets a single notification channel. The channel includes the relevant
  /// configuration details with which the channel was created. However, the
  /// response may truncate or omit passwords, API keys, or other private key
  /// matter and thus the response may not be 100% identical to the information
  /// that was supplied in the call to the create method.
  ///
  /// @param name  Required. The channel for which to execute the request. The format is:
  ///  @n
  ///      projects/[PROJECT_ID_OR_NUMBER]/notificationChannels/[CHANNEL_ID]
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.monitoring.v3.NotificationChannel])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.monitoring.v3.GetNotificationChannelRequest]: @googleapis_reference_link{google/monitoring/v3/notification_service.proto#L337}
  /// [google.monitoring.v3.NotificationChannel]: @googleapis_reference_link{google/monitoring/v3/notification.proto#L87}
  ///
  // clang-format on
  StatusOr<google::monitoring::v3::NotificationChannel> GetNotificationChannel(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets a single notification channel. The channel includes the relevant
  /// configuration details with which the channel was created. However, the
  /// response may truncate or omit passwords, API keys, or other private key
  /// matter and thus the response may not be 100% identical to the information
  /// that was supplied in the call to the create method.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.monitoring.v3.GetNotificationChannelRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.monitoring.v3.NotificationChannel])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.monitoring.v3.GetNotificationChannelRequest]: @googleapis_reference_link{google/monitoring/v3/notification_service.proto#L337}
  /// [google.monitoring.v3.NotificationChannel]: @googleapis_reference_link{google/monitoring/v3/notification.proto#L87}
  ///
  // clang-format on
  StatusOr<google::monitoring::v3::NotificationChannel> GetNotificationChannel(
      google::monitoring::v3::GetNotificationChannelRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a new notification channel, representing a single notification
  /// endpoint such as an email address, SMS number, or PagerDuty service.
  ///
  /// Design your application to single-thread API calls that modify the state of
  /// notification channels in a single project. This includes calls to
  /// CreateNotificationChannel, DeleteNotificationChannel and
  /// UpdateNotificationChannel.
  ///
  /// @param name  Required. The
  ///  [project](https://cloud.google.com/monitoring/api/v3#project_name) on which
  ///  to execute the request. The format is:
  ///  @n
  ///      projects/[PROJECT_ID_OR_NUMBER]
  ///  @n
  ///  This names the container into which the channel will be
  ///  written, this does not name the newly created channel. The resulting
  ///  channel's name will have a normalized version of this field as a prefix,
  ///  but will add `/notificationChannels/[CHANNEL_ID]` to identify the channel.
  /// @param notification_channel  Required. The definition of the `NotificationChannel` to create.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.monitoring.v3.NotificationChannel])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.monitoring.v3.CreateNotificationChannelRequest]: @googleapis_reference_link{google/monitoring/v3/notification_service.proto#L250}
  /// [google.monitoring.v3.NotificationChannel]: @googleapis_reference_link{google/monitoring/v3/notification.proto#L87}
  ///
  // clang-format on
  StatusOr<google::monitoring::v3::NotificationChannel>
  CreateNotificationChannel(
      std::string const& name,
      google::monitoring::v3::NotificationChannel const& notification_channel,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a new notification channel, representing a single notification
  /// endpoint such as an email address, SMS number, or PagerDuty service.
  ///
  /// Design your application to single-thread API calls that modify the state of
  /// notification channels in a single project. This includes calls to
  /// CreateNotificationChannel, DeleteNotificationChannel and
  /// UpdateNotificationChannel.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.monitoring.v3.CreateNotificationChannelRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.monitoring.v3.NotificationChannel])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.monitoring.v3.CreateNotificationChannelRequest]: @googleapis_reference_link{google/monitoring/v3/notification_service.proto#L250}
  /// [google.monitoring.v3.NotificationChannel]: @googleapis_reference_link{google/monitoring/v3/notification.proto#L87}
  ///
  // clang-format on
  StatusOr<google::monitoring::v3::NotificationChannel>
  CreateNotificationChannel(
      google::monitoring::v3::CreateNotificationChannelRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Updates a notification channel. Fields not specified in the field mask
  /// remain unchanged.
  ///
  /// Design your application to single-thread API calls that modify the state of
  /// notification channels in a single project. This includes calls to
  /// CreateNotificationChannel, DeleteNotificationChannel and
  /// UpdateNotificationChannel.
  ///
  /// @param update_mask  The fields to update.
  /// @param notification_channel  Required. A description of the changes to be applied to the specified
  ///  notification channel. The description must provide a definition for
  ///  fields to be updated; the names of these fields should also be
  ///  included in the `update_mask`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.monitoring.v3.NotificationChannel])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.monitoring.v3.NotificationChannel]: @googleapis_reference_link{google/monitoring/v3/notification.proto#L87}
  /// [google.monitoring.v3.UpdateNotificationChannelRequest]: @googleapis_reference_link{google/monitoring/v3/notification_service.proto#L350}
  ///
  // clang-format on
  StatusOr<google::monitoring::v3::NotificationChannel>
  UpdateNotificationChannel(
      google::protobuf::FieldMask const& update_mask,
      google::monitoring::v3::NotificationChannel const& notification_channel,
      Options opts = {});

  // clang-format off
  ///
  /// Updates a notification channel. Fields not specified in the field mask
  /// remain unchanged.
  ///
  /// Design your application to single-thread API calls that modify the state of
  /// notification channels in a single project. This includes calls to
  /// CreateNotificationChannel, DeleteNotificationChannel and
  /// UpdateNotificationChannel.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.monitoring.v3.UpdateNotificationChannelRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.monitoring.v3.NotificationChannel])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.monitoring.v3.NotificationChannel]: @googleapis_reference_link{google/monitoring/v3/notification.proto#L87}
  /// [google.monitoring.v3.UpdateNotificationChannelRequest]: @googleapis_reference_link{google/monitoring/v3/notification_service.proto#L350}
  ///
  // clang-format on
  StatusOr<google::monitoring::v3::NotificationChannel>
  UpdateNotificationChannel(
      google::monitoring::v3::UpdateNotificationChannelRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Deletes a notification channel.
  ///
  /// Design your application to single-thread API calls that modify the state of
  /// notification channels in a single project. This includes calls to
  /// CreateNotificationChannel, DeleteNotificationChannel and
  /// UpdateNotificationChannel.
  ///
  /// @param name  Required. The channel for which to execute the request. The format is:
  ///  @n
  ///      projects/[PROJECT_ID_OR_NUMBER]/notificationChannels/[CHANNEL_ID]
  /// @param force  If true, the notification channel will be deleted regardless of its
  ///  use in alert policies (the policies will be updated to remove the
  ///  channel). If false, channels that are still referenced by an existing
  ///  alerting policy will fail to be deleted in a delete operation.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.monitoring.v3.DeleteNotificationChannelRequest]: @googleapis_reference_link{google/monitoring/v3/notification_service.proto#L363}
  ///
  // clang-format on
  Status DeleteNotificationChannel(std::string const& name, bool force,
                                   Options opts = {});

  // clang-format off
  ///
  /// Deletes a notification channel.
  ///
  /// Design your application to single-thread API calls that modify the state of
  /// notification channels in a single project. This includes calls to
  /// CreateNotificationChannel, DeleteNotificationChannel and
  /// UpdateNotificationChannel.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.monitoring.v3.DeleteNotificationChannelRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.monitoring.v3.DeleteNotificationChannelRequest]: @googleapis_reference_link{google/monitoring/v3/notification_service.proto#L363}
  ///
  // clang-format on
  Status DeleteNotificationChannel(
      google::monitoring::v3::DeleteNotificationChannelRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Causes a verification code to be delivered to the channel. The code
  /// can then be supplied in `VerifyNotificationChannel` to verify the channel.
  ///
  /// @param name  Required. The notification channel to which to send a verification code.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.monitoring.v3.SendNotificationChannelVerificationCodeRequest]: @googleapis_reference_link{google/monitoring/v3/notification_service.proto#L382}
  ///
  // clang-format on
  Status SendNotificationChannelVerificationCode(std::string const& name,
                                                 Options opts = {});

  // clang-format off
  ///
  /// Causes a verification code to be delivered to the channel. The code
  /// can then be supplied in `VerifyNotificationChannel` to verify the channel.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.monitoring.v3.SendNotificationChannelVerificationCodeRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.monitoring.v3.SendNotificationChannelVerificationCodeRequest]: @googleapis_reference_link{google/monitoring/v3/notification_service.proto#L382}
  ///
  // clang-format on
  Status SendNotificationChannelVerificationCode(
      google::monitoring::v3::
          SendNotificationChannelVerificationCodeRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Requests a verification code for an already verified channel that can then
  /// be used in a call to VerifyNotificationChannel() on a different channel
  /// with an equivalent identity in the same or in a different project. This
  /// makes it possible to copy a channel between projects without requiring
  /// manual reverification of the channel. If the channel is not in the
  /// verified state, this method will fail (in other words, this may only be
  /// used if the SendNotificationChannelVerificationCode and
  /// VerifyNotificationChannel paths have already been used to put the given
  /// channel into the verified state).
  ///
  /// There is no guarantee that the verification codes returned by this method
  /// will be of a similar structure or form as the ones that are delivered
  /// to the channel via SendNotificationChannelVerificationCode; while
  /// VerifyNotificationChannel() will recognize both the codes delivered via
  /// SendNotificationChannelVerificationCode() and returned from
  /// GetNotificationChannelVerificationCode(), it is typically the case that
  /// the verification codes delivered via
  /// SendNotificationChannelVerificationCode() will be shorter and also
  /// have a shorter expiration (e.g. codes such as "G-123456") whereas
  /// GetVerificationCode() will typically return a much longer, websafe base
  /// 64 encoded string that has a longer expiration time.
  ///
  /// @param name  Required. The notification channel for which a verification code is to be
  ///  generated and retrieved. This must name a channel that is already verified;
  ///  if the specified channel is not verified, the request will fail.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.monitoring.v3.GetNotificationChannelVerificationCodeResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.monitoring.v3.GetNotificationChannelVerificationCodeRequest]: @googleapis_reference_link{google/monitoring/v3/notification_service.proto#L393}
  /// [google.monitoring.v3.GetNotificationChannelVerificationCodeResponse]: @googleapis_reference_link{google/monitoring/v3/notification_service.proto#L417}
  ///
  // clang-format on
  StatusOr<
      google::monitoring::v3::GetNotificationChannelVerificationCodeResponse>
  GetNotificationChannelVerificationCode(std::string const& name,
                                         Options opts = {});

  // clang-format off
  ///
  /// Requests a verification code for an already verified channel that can then
  /// be used in a call to VerifyNotificationChannel() on a different channel
  /// with an equivalent identity in the same or in a different project. This
  /// makes it possible to copy a channel between projects without requiring
  /// manual reverification of the channel. If the channel is not in the
  /// verified state, this method will fail (in other words, this may only be
  /// used if the SendNotificationChannelVerificationCode and
  /// VerifyNotificationChannel paths have already been used to put the given
  /// channel into the verified state).
  ///
  /// There is no guarantee that the verification codes returned by this method
  /// will be of a similar structure or form as the ones that are delivered
  /// to the channel via SendNotificationChannelVerificationCode; while
  /// VerifyNotificationChannel() will recognize both the codes delivered via
  /// SendNotificationChannelVerificationCode() and returned from
  /// GetNotificationChannelVerificationCode(), it is typically the case that
  /// the verification codes delivered via
  /// SendNotificationChannelVerificationCode() will be shorter and also
  /// have a shorter expiration (e.g. codes such as "G-123456") whereas
  /// GetVerificationCode() will typically return a much longer, websafe base
  /// 64 encoded string that has a longer expiration time.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.monitoring.v3.GetNotificationChannelVerificationCodeRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.monitoring.v3.GetNotificationChannelVerificationCodeResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.monitoring.v3.GetNotificationChannelVerificationCodeRequest]: @googleapis_reference_link{google/monitoring/v3/notification_service.proto#L393}
  /// [google.monitoring.v3.GetNotificationChannelVerificationCodeResponse]: @googleapis_reference_link{google/monitoring/v3/notification_service.proto#L417}
  ///
  // clang-format on
  StatusOr<
      google::monitoring::v3::GetNotificationChannelVerificationCodeResponse>
  GetNotificationChannelVerificationCode(
      google::monitoring::v3::
          GetNotificationChannelVerificationCodeRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Verifies a `NotificationChannel` by proving receipt of the code
  /// delivered to the channel as a result of calling
  /// `SendNotificationChannelVerificationCode`.
  ///
  /// @param name  Required. The notification channel to verify.
  /// @param code  Required. The verification code that was delivered to the channel as
  ///  a result of invoking the `SendNotificationChannelVerificationCode` API
  ///  method or that was retrieved from a verified channel via
  ///  `GetNotificationChannelVerificationCode`. For example, one might have
  ///  "G-123456" or "TKNZGhhd2EyN3I1MnRnMjRv" (in general, one is only
  ///  guaranteed that the code is valid UTF-8; one should not
  ///  make any assumptions regarding the structure or format of the code).
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.monitoring.v3.NotificationChannel])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.monitoring.v3.NotificationChannel]: @googleapis_reference_link{google/monitoring/v3/notification.proto#L87}
  /// [google.monitoring.v3.VerifyNotificationChannelRequest]: @googleapis_reference_link{google/monitoring/v3/notification_service.proto#L431}
  ///
  // clang-format on
  StatusOr<google::monitoring::v3::NotificationChannel>
  VerifyNotificationChannel(std::string const& name, std::string const& code,
                            Options opts = {});

  // clang-format off
  ///
  /// Verifies a `NotificationChannel` by proving receipt of the code
  /// delivered to the channel as a result of calling
  /// `SendNotificationChannelVerificationCode`.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.monitoring.v3.VerifyNotificationChannelRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.monitoring.v3.NotificationChannel])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.monitoring.v3.NotificationChannel]: @googleapis_reference_link{google/monitoring/v3/notification.proto#L87}
  /// [google.monitoring.v3.VerifyNotificationChannelRequest]: @googleapis_reference_link{google/monitoring/v3/notification_service.proto#L431}
  ///
  // clang-format on
  StatusOr<google::monitoring::v3::NotificationChannel>
  VerifyNotificationChannel(
      google::monitoring::v3::VerifyNotificationChannelRequest const& request,
      Options opts = {});

 private:
  std::shared_ptr<NotificationChannelServiceConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace monitoring_v3
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_MONITORING_V3_NOTIFICATION_CHANNEL_CLIENT_H
