// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/memcache/v1/cloud_memcache.proto

#include "google/cloud/memcache/v1/internal/cloud_memcache_option_defaults.h"
#include "google/cloud/memcache/v1/cloud_memcache_connection.h"
#include "google/cloud/memcache/v1/cloud_memcache_options.h"
#include "google/cloud/internal/populate_common_options.h"
#include "google/cloud/internal/populate_grpc_options.h"
#include <memory>

namespace google {
namespace cloud {
namespace memcache_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

namespace {
auto constexpr kBackoffScaling = 2.0;
}  // namespace

Options CloudMemcacheDefaultOptions(Options options) {
  options = google::cloud::internal::PopulateCommonOptions(
      std::move(options), "GOOGLE_CLOUD_CPP_CLOUD_MEMCACHE_ENDPOINT", "",
      "GOOGLE_CLOUD_CPP_CLOUD_MEMCACHE_AUTHORITY", "memcache.googleapis.com");
  options =
      google::cloud::internal::PopulateGrpcOptions(std::move(options), "");
  if (!options.has<memcache_v1::CloudMemcacheRetryPolicyOption>()) {
    options.set<memcache_v1::CloudMemcacheRetryPolicyOption>(
        memcache_v1::CloudMemcacheLimitedTimeRetryPolicy(
            std::chrono::minutes(30))
            .clone());
  }
  if (!options.has<memcache_v1::CloudMemcacheBackoffPolicyOption>()) {
    options.set<memcache_v1::CloudMemcacheBackoffPolicyOption>(
        ExponentialBackoffPolicy(
            std::chrono::seconds(0), std::chrono::seconds(1),
            std::chrono::minutes(5), kBackoffScaling, kBackoffScaling)
            .clone());
  }
  if (!options.has<memcache_v1::CloudMemcachePollingPolicyOption>()) {
    options.set<memcache_v1::CloudMemcachePollingPolicyOption>(
        GenericPollingPolicy<
            memcache_v1::CloudMemcacheRetryPolicyOption::Type,
            memcache_v1::CloudMemcacheBackoffPolicyOption::Type>(
            options.get<memcache_v1::CloudMemcacheRetryPolicyOption>()->clone(),
            ExponentialBackoffPolicy(std::chrono::seconds(1),
                                     std::chrono::minutes(5), kBackoffScaling)
                .clone())
            .clone());
  }
  if (!options.has<
          memcache_v1::CloudMemcacheConnectionIdempotencyPolicyOption>()) {
    options.set<memcache_v1::CloudMemcacheConnectionIdempotencyPolicyOption>(
        memcache_v1::MakeDefaultCloudMemcacheConnectionIdempotencyPolicy());
  }

  return options;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace memcache_v1_internal
}  // namespace cloud
}  // namespace google
