// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/documentai/v1/document_processor_service.proto

#include "google/cloud/documentai/v1/internal/document_processor_tracing_stub.h"
#include "google/cloud/internal/grpc_opentelemetry.h"

namespace google {
namespace cloud {
namespace documentai_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

DocumentProcessorServiceTracingStub::DocumentProcessorServiceTracingStub(
    std::shared_ptr<DocumentProcessorServiceStub> child)
    : child_(std::move(child)), propagator_(internal::MakePropagator()) {}

StatusOr<google::cloud::documentai::v1::ProcessResponse>
DocumentProcessorServiceTracingStub::ProcessDocument(
    grpc::ClientContext& context,
    google::cloud::documentai::v1::ProcessRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.documentai.v1.DocumentProcessorService", "ProcessDocument");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ProcessDocument(context, request));
}

future<StatusOr<google::longrunning::Operation>>
DocumentProcessorServiceTracingStub::AsyncBatchProcessDocuments(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::documentai::v1::BatchProcessRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.documentai.v1.DocumentProcessorService",
      "BatchProcessDocuments");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncBatchProcessDocuments(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::cloud::documentai::v1::FetchProcessorTypesResponse>
DocumentProcessorServiceTracingStub::FetchProcessorTypes(
    grpc::ClientContext& context,
    google::cloud::documentai::v1::FetchProcessorTypesRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.documentai.v1.DocumentProcessorService",
      "FetchProcessorTypes");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->FetchProcessorTypes(context, request));
}

StatusOr<google::cloud::documentai::v1::ListProcessorTypesResponse>
DocumentProcessorServiceTracingStub::ListProcessorTypes(
    grpc::ClientContext& context,
    google::cloud::documentai::v1::ListProcessorTypesRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.documentai.v1.DocumentProcessorService",
      "ListProcessorTypes");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListProcessorTypes(context, request));
}

StatusOr<google::cloud::documentai::v1::ProcessorType>
DocumentProcessorServiceTracingStub::GetProcessorType(
    grpc::ClientContext& context,
    google::cloud::documentai::v1::GetProcessorTypeRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.documentai.v1.DocumentProcessorService",
      "GetProcessorType");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetProcessorType(context, request));
}

StatusOr<google::cloud::documentai::v1::ListProcessorsResponse>
DocumentProcessorServiceTracingStub::ListProcessors(
    grpc::ClientContext& context,
    google::cloud::documentai::v1::ListProcessorsRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.documentai.v1.DocumentProcessorService", "ListProcessors");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListProcessors(context, request));
}

StatusOr<google::cloud::documentai::v1::Processor>
DocumentProcessorServiceTracingStub::GetProcessor(
    grpc::ClientContext& context,
    google::cloud::documentai::v1::GetProcessorRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.documentai.v1.DocumentProcessorService", "GetProcessor");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetProcessor(context, request));
}

future<StatusOr<google::longrunning::Operation>>
DocumentProcessorServiceTracingStub::AsyncTrainProcessorVersion(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::documentai::v1::TrainProcessorVersionRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.documentai.v1.DocumentProcessorService",
      "TrainProcessorVersion");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncTrainProcessorVersion(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::cloud::documentai::v1::ProcessorVersion>
DocumentProcessorServiceTracingStub::GetProcessorVersion(
    grpc::ClientContext& context,
    google::cloud::documentai::v1::GetProcessorVersionRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.documentai.v1.DocumentProcessorService",
      "GetProcessorVersion");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetProcessorVersion(context, request));
}

StatusOr<google::cloud::documentai::v1::ListProcessorVersionsResponse>
DocumentProcessorServiceTracingStub::ListProcessorVersions(
    grpc::ClientContext& context,
    google::cloud::documentai::v1::ListProcessorVersionsRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.documentai.v1.DocumentProcessorService",
      "ListProcessorVersions");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListProcessorVersions(context, request));
}

future<StatusOr<google::longrunning::Operation>>
DocumentProcessorServiceTracingStub::AsyncDeleteProcessorVersion(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::documentai::v1::DeleteProcessorVersionRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.documentai.v1.DocumentProcessorService",
      "DeleteProcessorVersion");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncDeleteProcessorVersion(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

future<StatusOr<google::longrunning::Operation>>
DocumentProcessorServiceTracingStub::AsyncDeployProcessorVersion(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::documentai::v1::DeployProcessorVersionRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.documentai.v1.DocumentProcessorService",
      "DeployProcessorVersion");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncDeployProcessorVersion(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

future<StatusOr<google::longrunning::Operation>>
DocumentProcessorServiceTracingStub::AsyncUndeployProcessorVersion(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::documentai::v1::UndeployProcessorVersionRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.documentai.v1.DocumentProcessorService",
      "UndeployProcessorVersion");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncUndeployProcessorVersion(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::cloud::documentai::v1::Processor>
DocumentProcessorServiceTracingStub::CreateProcessor(
    grpc::ClientContext& context,
    google::cloud::documentai::v1::CreateProcessorRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.documentai.v1.DocumentProcessorService", "CreateProcessor");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->CreateProcessor(context, request));
}

future<StatusOr<google::longrunning::Operation>>
DocumentProcessorServiceTracingStub::AsyncDeleteProcessor(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::documentai::v1::DeleteProcessorRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.documentai.v1.DocumentProcessorService", "DeleteProcessor");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncDeleteProcessor(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

future<StatusOr<google::longrunning::Operation>>
DocumentProcessorServiceTracingStub::AsyncEnableProcessor(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::documentai::v1::EnableProcessorRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.documentai.v1.DocumentProcessorService", "EnableProcessor");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncEnableProcessor(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

future<StatusOr<google::longrunning::Operation>>
DocumentProcessorServiceTracingStub::AsyncDisableProcessor(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::documentai::v1::DisableProcessorRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.documentai.v1.DocumentProcessorService",
      "DisableProcessor");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncDisableProcessor(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

future<StatusOr<google::longrunning::Operation>>
DocumentProcessorServiceTracingStub::AsyncSetDefaultProcessorVersion(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::documentai::v1::SetDefaultProcessorVersionRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.documentai.v1.DocumentProcessorService",
      "SetDefaultProcessorVersion");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncSetDefaultProcessorVersion(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

future<StatusOr<google::longrunning::Operation>>
DocumentProcessorServiceTracingStub::AsyncReviewDocument(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::documentai::v1::ReviewDocumentRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.documentai.v1.DocumentProcessorService", "ReviewDocument");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncReviewDocument(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

future<StatusOr<google::longrunning::Operation>>
DocumentProcessorServiceTracingStub::AsyncEvaluateProcessorVersion(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::documentai::v1::EvaluateProcessorVersionRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.documentai.v1.DocumentProcessorService",
      "EvaluateProcessorVersion");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncEvaluateProcessorVersion(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::cloud::documentai::v1::Evaluation>
DocumentProcessorServiceTracingStub::GetEvaluation(
    grpc::ClientContext& context,
    google::cloud::documentai::v1::GetEvaluationRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.documentai.v1.DocumentProcessorService", "GetEvaluation");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetEvaluation(context, request));
}

StatusOr<google::cloud::documentai::v1::ListEvaluationsResponse>
DocumentProcessorServiceTracingStub::ListEvaluations(
    grpc::ClientContext& context,
    google::cloud::documentai::v1::ListEvaluationsRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.documentai.v1.DocumentProcessorService", "ListEvaluations");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListEvaluations(context, request));
}

future<StatusOr<google::longrunning::Operation>>
DocumentProcessorServiceTracingStub::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::longrunning::GetOperationRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.longrunning.Operations", "GetOperation");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncGetOperation(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

future<Status> DocumentProcessorServiceTracingStub::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::longrunning::CancelOperationRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.longrunning.Operations",
                                     "CancelOperation");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncCancelOperation(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<DocumentProcessorServiceStub>
MakeDocumentProcessorServiceTracingStub(
    std::shared_ptr<DocumentProcessorServiceStub> stub) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return std::make_shared<DocumentProcessorServiceTracingStub>(std::move(stub));
#else
  return stub;
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace documentai_v1_internal
}  // namespace cloud
}  // namespace google
