// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/privacy/dlp/v2/dlp.proto

#include "google/cloud/dlp/v2/internal/dlp_logging_decorator.h"
#include "google/cloud/internal/log_wrapper.h"
#include "google/cloud/status_or.h"
#include <google/privacy/dlp/v2/dlp.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace dlp_v2_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

DlpServiceLogging::DlpServiceLogging(std::shared_ptr<DlpServiceStub> child,
                                     TracingOptions tracing_options,
                                     std::set<std::string> const& components)
    : child_(std::move(child)),
      tracing_options_(std::move(tracing_options)),
      stream_logging_(components.find("rpc-streams") != components.end()) {}

StatusOr<google::privacy::dlp::v2::InspectContentResponse>
DlpServiceLogging::InspectContent(
    grpc::ClientContext& context,
    google::privacy::dlp::v2::InspectContentRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::privacy::dlp::v2::InspectContentRequest const& request) {
        return child_->InspectContent(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::privacy::dlp::v2::RedactImageResponse>
DlpServiceLogging::RedactImage(
    grpc::ClientContext& context,
    google::privacy::dlp::v2::RedactImageRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::privacy::dlp::v2::RedactImageRequest const& request) {
        return child_->RedactImage(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::privacy::dlp::v2::DeidentifyContentResponse>
DlpServiceLogging::DeidentifyContent(
    grpc::ClientContext& context,
    google::privacy::dlp::v2::DeidentifyContentRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context,
          google::privacy::dlp::v2::DeidentifyContentRequest const& request) {
        return child_->DeidentifyContent(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::privacy::dlp::v2::ReidentifyContentResponse>
DlpServiceLogging::ReidentifyContent(
    grpc::ClientContext& context,
    google::privacy::dlp::v2::ReidentifyContentRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context,
          google::privacy::dlp::v2::ReidentifyContentRequest const& request) {
        return child_->ReidentifyContent(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::privacy::dlp::v2::ListInfoTypesResponse>
DlpServiceLogging::ListInfoTypes(
    grpc::ClientContext& context,
    google::privacy::dlp::v2::ListInfoTypesRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::privacy::dlp::v2::ListInfoTypesRequest const& request) {
        return child_->ListInfoTypes(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::privacy::dlp::v2::InspectTemplate>
DlpServiceLogging::CreateInspectTemplate(
    grpc::ClientContext& context,
    google::privacy::dlp::v2::CreateInspectTemplateRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::privacy::dlp::v2::CreateInspectTemplateRequest const&
                 request) {
        return child_->CreateInspectTemplate(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::privacy::dlp::v2::InspectTemplate>
DlpServiceLogging::UpdateInspectTemplate(
    grpc::ClientContext& context,
    google::privacy::dlp::v2::UpdateInspectTemplateRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::privacy::dlp::v2::UpdateInspectTemplateRequest const&
                 request) {
        return child_->UpdateInspectTemplate(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::privacy::dlp::v2::InspectTemplate>
DlpServiceLogging::GetInspectTemplate(
    grpc::ClientContext& context,
    google::privacy::dlp::v2::GetInspectTemplateRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context,
          google::privacy::dlp::v2::GetInspectTemplateRequest const& request) {
        return child_->GetInspectTemplate(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::privacy::dlp::v2::ListInspectTemplatesResponse>
DlpServiceLogging::ListInspectTemplates(
    grpc::ClientContext& context,
    google::privacy::dlp::v2::ListInspectTemplatesRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::privacy::dlp::v2::ListInspectTemplatesRequest const&
                 request) {
        return child_->ListInspectTemplates(context, request);
      },
      context, request, __func__, tracing_options_);
}

Status DlpServiceLogging::DeleteInspectTemplate(
    grpc::ClientContext& context,
    google::privacy::dlp::v2::DeleteInspectTemplateRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::privacy::dlp::v2::DeleteInspectTemplateRequest const&
                 request) {
        return child_->DeleteInspectTemplate(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::privacy::dlp::v2::DeidentifyTemplate>
DlpServiceLogging::CreateDeidentifyTemplate(
    grpc::ClientContext& context,
    google::privacy::dlp::v2::CreateDeidentifyTemplateRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::privacy::dlp::v2::CreateDeidentifyTemplateRequest const&
                 request) {
        return child_->CreateDeidentifyTemplate(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::privacy::dlp::v2::DeidentifyTemplate>
DlpServiceLogging::UpdateDeidentifyTemplate(
    grpc::ClientContext& context,
    google::privacy::dlp::v2::UpdateDeidentifyTemplateRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::privacy::dlp::v2::UpdateDeidentifyTemplateRequest const&
                 request) {
        return child_->UpdateDeidentifyTemplate(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::privacy::dlp::v2::DeidentifyTemplate>
DlpServiceLogging::GetDeidentifyTemplate(
    grpc::ClientContext& context,
    google::privacy::dlp::v2::GetDeidentifyTemplateRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::privacy::dlp::v2::GetDeidentifyTemplateRequest const&
                 request) {
        return child_->GetDeidentifyTemplate(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::privacy::dlp::v2::ListDeidentifyTemplatesResponse>
DlpServiceLogging::ListDeidentifyTemplates(
    grpc::ClientContext& context,
    google::privacy::dlp::v2::ListDeidentifyTemplatesRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::privacy::dlp::v2::ListDeidentifyTemplatesRequest const&
                 request) {
        return child_->ListDeidentifyTemplates(context, request);
      },
      context, request, __func__, tracing_options_);
}

Status DlpServiceLogging::DeleteDeidentifyTemplate(
    grpc::ClientContext& context,
    google::privacy::dlp::v2::DeleteDeidentifyTemplateRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::privacy::dlp::v2::DeleteDeidentifyTemplateRequest const&
                 request) {
        return child_->DeleteDeidentifyTemplate(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::privacy::dlp::v2::JobTrigger>
DlpServiceLogging::CreateJobTrigger(
    grpc::ClientContext& context,
    google::privacy::dlp::v2::CreateJobTriggerRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::privacy::dlp::v2::CreateJobTriggerRequest const& request) {
        return child_->CreateJobTrigger(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::privacy::dlp::v2::JobTrigger>
DlpServiceLogging::UpdateJobTrigger(
    grpc::ClientContext& context,
    google::privacy::dlp::v2::UpdateJobTriggerRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::privacy::dlp::v2::UpdateJobTriggerRequest const& request) {
        return child_->UpdateJobTrigger(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::privacy::dlp::v2::HybridInspectResponse>
DlpServiceLogging::HybridInspectJobTrigger(
    grpc::ClientContext& context,
    google::privacy::dlp::v2::HybridInspectJobTriggerRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::privacy::dlp::v2::HybridInspectJobTriggerRequest const&
                 request) {
        return child_->HybridInspectJobTrigger(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::privacy::dlp::v2::JobTrigger> DlpServiceLogging::GetJobTrigger(
    grpc::ClientContext& context,
    google::privacy::dlp::v2::GetJobTriggerRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::privacy::dlp::v2::GetJobTriggerRequest const& request) {
        return child_->GetJobTrigger(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::privacy::dlp::v2::ListJobTriggersResponse>
DlpServiceLogging::ListJobTriggers(
    grpc::ClientContext& context,
    google::privacy::dlp::v2::ListJobTriggersRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::privacy::dlp::v2::ListJobTriggersRequest const& request) {
        return child_->ListJobTriggers(context, request);
      },
      context, request, __func__, tracing_options_);
}

Status DlpServiceLogging::DeleteJobTrigger(
    grpc::ClientContext& context,
    google::privacy::dlp::v2::DeleteJobTriggerRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::privacy::dlp::v2::DeleteJobTriggerRequest const& request) {
        return child_->DeleteJobTrigger(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::privacy::dlp::v2::DlpJob>
DlpServiceLogging::ActivateJobTrigger(
    grpc::ClientContext& context,
    google::privacy::dlp::v2::ActivateJobTriggerRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context,
          google::privacy::dlp::v2::ActivateJobTriggerRequest const& request) {
        return child_->ActivateJobTrigger(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::privacy::dlp::v2::DiscoveryConfig>
DlpServiceLogging::CreateDiscoveryConfig(
    grpc::ClientContext& context,
    google::privacy::dlp::v2::CreateDiscoveryConfigRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::privacy::dlp::v2::CreateDiscoveryConfigRequest const&
                 request) {
        return child_->CreateDiscoveryConfig(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::privacy::dlp::v2::DiscoveryConfig>
DlpServiceLogging::UpdateDiscoveryConfig(
    grpc::ClientContext& context,
    google::privacy::dlp::v2::UpdateDiscoveryConfigRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::privacy::dlp::v2::UpdateDiscoveryConfigRequest const&
                 request) {
        return child_->UpdateDiscoveryConfig(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::privacy::dlp::v2::DiscoveryConfig>
DlpServiceLogging::GetDiscoveryConfig(
    grpc::ClientContext& context,
    google::privacy::dlp::v2::GetDiscoveryConfigRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context,
          google::privacy::dlp::v2::GetDiscoveryConfigRequest const& request) {
        return child_->GetDiscoveryConfig(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::privacy::dlp::v2::ListDiscoveryConfigsResponse>
DlpServiceLogging::ListDiscoveryConfigs(
    grpc::ClientContext& context,
    google::privacy::dlp::v2::ListDiscoveryConfigsRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::privacy::dlp::v2::ListDiscoveryConfigsRequest const&
                 request) {
        return child_->ListDiscoveryConfigs(context, request);
      },
      context, request, __func__, tracing_options_);
}

Status DlpServiceLogging::DeleteDiscoveryConfig(
    grpc::ClientContext& context,
    google::privacy::dlp::v2::DeleteDiscoveryConfigRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::privacy::dlp::v2::DeleteDiscoveryConfigRequest const&
                 request) {
        return child_->DeleteDiscoveryConfig(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::privacy::dlp::v2::DlpJob> DlpServiceLogging::CreateDlpJob(
    grpc::ClientContext& context,
    google::privacy::dlp::v2::CreateDlpJobRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::privacy::dlp::v2::CreateDlpJobRequest const& request) {
        return child_->CreateDlpJob(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::privacy::dlp::v2::ListDlpJobsResponse>
DlpServiceLogging::ListDlpJobs(
    grpc::ClientContext& context,
    google::privacy::dlp::v2::ListDlpJobsRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::privacy::dlp::v2::ListDlpJobsRequest const& request) {
        return child_->ListDlpJobs(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::privacy::dlp::v2::DlpJob> DlpServiceLogging::GetDlpJob(
    grpc::ClientContext& context,
    google::privacy::dlp::v2::GetDlpJobRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::privacy::dlp::v2::GetDlpJobRequest const& request) {
        return child_->GetDlpJob(context, request);
      },
      context, request, __func__, tracing_options_);
}

Status DlpServiceLogging::DeleteDlpJob(
    grpc::ClientContext& context,
    google::privacy::dlp::v2::DeleteDlpJobRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::privacy::dlp::v2::DeleteDlpJobRequest const& request) {
        return child_->DeleteDlpJob(context, request);
      },
      context, request, __func__, tracing_options_);
}

Status DlpServiceLogging::CancelDlpJob(
    grpc::ClientContext& context,
    google::privacy::dlp::v2::CancelDlpJobRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::privacy::dlp::v2::CancelDlpJobRequest const& request) {
        return child_->CancelDlpJob(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::privacy::dlp::v2::StoredInfoType>
DlpServiceLogging::CreateStoredInfoType(
    grpc::ClientContext& context,
    google::privacy::dlp::v2::CreateStoredInfoTypeRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::privacy::dlp::v2::CreateStoredInfoTypeRequest const&
                 request) {
        return child_->CreateStoredInfoType(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::privacy::dlp::v2::StoredInfoType>
DlpServiceLogging::UpdateStoredInfoType(
    grpc::ClientContext& context,
    google::privacy::dlp::v2::UpdateStoredInfoTypeRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::privacy::dlp::v2::UpdateStoredInfoTypeRequest const&
                 request) {
        return child_->UpdateStoredInfoType(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::privacy::dlp::v2::StoredInfoType>
DlpServiceLogging::GetStoredInfoType(
    grpc::ClientContext& context,
    google::privacy::dlp::v2::GetStoredInfoTypeRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context,
          google::privacy::dlp::v2::GetStoredInfoTypeRequest const& request) {
        return child_->GetStoredInfoType(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::privacy::dlp::v2::ListStoredInfoTypesResponse>
DlpServiceLogging::ListStoredInfoTypes(
    grpc::ClientContext& context,
    google::privacy::dlp::v2::ListStoredInfoTypesRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context,
          google::privacy::dlp::v2::ListStoredInfoTypesRequest const& request) {
        return child_->ListStoredInfoTypes(context, request);
      },
      context, request, __func__, tracing_options_);
}

Status DlpServiceLogging::DeleteStoredInfoType(
    grpc::ClientContext& context,
    google::privacy::dlp::v2::DeleteStoredInfoTypeRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::privacy::dlp::v2::DeleteStoredInfoTypeRequest const&
                 request) {
        return child_->DeleteStoredInfoType(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::privacy::dlp::v2::HybridInspectResponse>
DlpServiceLogging::HybridInspectDlpJob(
    grpc::ClientContext& context,
    google::privacy::dlp::v2::HybridInspectDlpJobRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context,
          google::privacy::dlp::v2::HybridInspectDlpJobRequest const& request) {
        return child_->HybridInspectDlpJob(context, request);
      },
      context, request, __func__, tracing_options_);
}

Status DlpServiceLogging::FinishDlpJob(
    grpc::ClientContext& context,
    google::privacy::dlp::v2::FinishDlpJobRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::privacy::dlp::v2::FinishDlpJobRequest const& request) {
        return child_->FinishDlpJob(context, request);
      },
      context, request, __func__, tracing_options_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dlp_v2_internal
}  // namespace cloud
}  // namespace google
