// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/discoveryengine/v1/document_service.proto

#include "google/cloud/discoveryengine/v1/document_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace discoveryengine_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

DocumentServiceConnectionIdempotencyPolicy::
    ~DocumentServiceConnectionIdempotencyPolicy() = default;

std::unique_ptr<DocumentServiceConnectionIdempotencyPolicy>
DocumentServiceConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<DocumentServiceConnectionIdempotencyPolicy>(*this);
}

Idempotency DocumentServiceConnectionIdempotencyPolicy::GetDocument(
    google::cloud::discoveryengine::v1::GetDocumentRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency DocumentServiceConnectionIdempotencyPolicy::ListDocuments(
    google::cloud::discoveryengine::v1::ListDocumentsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency DocumentServiceConnectionIdempotencyPolicy::CreateDocument(
    google::cloud::discoveryengine::v1::CreateDocumentRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency DocumentServiceConnectionIdempotencyPolicy::UpdateDocument(
    google::cloud::discoveryengine::v1::UpdateDocumentRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency DocumentServiceConnectionIdempotencyPolicy::DeleteDocument(
    google::cloud::discoveryengine::v1::DeleteDocumentRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency DocumentServiceConnectionIdempotencyPolicy::ImportDocuments(
    google::cloud::discoveryengine::v1::ImportDocumentsRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency DocumentServiceConnectionIdempotencyPolicy::PurgeDocuments(
    google::cloud::discoveryengine::v1::PurgeDocumentsRequest const&) {
  return Idempotency::kNonIdempotent;
}

std::unique_ptr<DocumentServiceConnectionIdempotencyPolicy>
MakeDefaultDocumentServiceConnectionIdempotencyPolicy() {
  return std::make_unique<DocumentServiceConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace discoveryengine_v1
}  // namespace cloud
}  // namespace google
