// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dialogflow/cx/v3/transition_route_group.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DIALOGFLOW_CX_TRANSITION_ROUTE_GROUPS_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DIALOGFLOW_CX_TRANSITION_ROUTE_GROUPS_CLIENT_H

#include "google/cloud/dialogflow_cx/transition_route_groups_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace dialogflow_cx {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// Service for managing
/// [TransitionRouteGroups][google.cloud.dialogflow.cx.v3.TransitionRouteGroup].
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
/// [google.cloud.dialogflow.cx.v3.TransitionRouteGroup]:
/// @googleapis_reference_link{google/cloud/dialogflow/cx/v3/transition_route_group.proto#L129}
///
class TransitionRouteGroupsClient {
 public:
  explicit TransitionRouteGroupsClient(
      std::shared_ptr<TransitionRouteGroupsConnection> connection,
      Options opts = {});
  ~TransitionRouteGroupsClient();

  ///@{
  /// @name Copy and move support
  TransitionRouteGroupsClient(TransitionRouteGroupsClient const&) = default;
  TransitionRouteGroupsClient& operator=(TransitionRouteGroupsClient const&) =
      default;
  TransitionRouteGroupsClient(TransitionRouteGroupsClient&&) = default;
  TransitionRouteGroupsClient& operator=(TransitionRouteGroupsClient&&) =
      default;
  ///@}

  ///@{
  /// @name Equality
  friend bool operator==(TransitionRouteGroupsClient const& a,
                         TransitionRouteGroupsClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(TransitionRouteGroupsClient const& a,
                         TransitionRouteGroupsClient const& b) {
    return !(a == b);
  }
  ///@}

  // clang-format off
  ///
  /// Returns the list of all transition route groups in the specified flow.
  ///
  /// @param parent  Required. The flow to list all transition route groups for.
  ///  Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>`
  ///  or `projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.dialogflow.cx.v3.TransitionRouteGroup], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.dialogflow.cx.v3.ListTransitionRouteGroupsRequest]: @googleapis_reference_link{google/cloud/dialogflow/cx/v3/transition_route_group.proto#L157}
  /// [google.cloud.dialogflow.cx.v3.TransitionRouteGroup]: @googleapis_reference_link{google/cloud/dialogflow/cx/v3/transition_route_group.proto#L129}
  ///
  // clang-format on
  StreamRange<google::cloud::dialogflow::cx::v3::TransitionRouteGroup>
  ListTransitionRouteGroups(std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Returns the list of all transition route groups in the specified flow.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.dialogflow.cx.v3.ListTransitionRouteGroupsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.dialogflow.cx.v3.TransitionRouteGroup], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.dialogflow.cx.v3.ListTransitionRouteGroupsRequest]: @googleapis_reference_link{google/cloud/dialogflow/cx/v3/transition_route_group.proto#L157}
  /// [google.cloud.dialogflow.cx.v3.TransitionRouteGroup]: @googleapis_reference_link{google/cloud/dialogflow/cx/v3/transition_route_group.proto#L129}
  ///
  // clang-format on
  StreamRange<google::cloud::dialogflow::cx::v3::TransitionRouteGroup>
  ListTransitionRouteGroups(
      google::cloud::dialogflow::cx::v3::ListTransitionRouteGroupsRequest
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Retrieves the specified
  /// [TransitionRouteGroup][google.cloud.dialogflow.cx.v3.TransitionRouteGroup].
  ///
  /// @param name  Required. The name of the
  ///  [TransitionRouteGroup][google.cloud.dialogflow.cx.v3.TransitionRouteGroup].
  ///  Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>/transitionRouteGroups/<Transition Route Group ID>`
  ///  or `projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/transitionRouteGroups/<Transition Route Group ID>`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.dialogflow.cx.v3.TransitionRouteGroup])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.dialogflow.cx.v3.GetTransitionRouteGroupRequest]: @googleapis_reference_link{google/cloud/dialogflow/cx/v3/transition_route_group.proto#L208}
  /// [google.cloud.dialogflow.cx.v3.TransitionRouteGroup]: @googleapis_reference_link{google/cloud/dialogflow/cx/v3/transition_route_group.proto#L129}
  ///
  // clang-format on
  StatusOr<google::cloud::dialogflow::cx::v3::TransitionRouteGroup>
  GetTransitionRouteGroup(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Retrieves the specified
  /// [TransitionRouteGroup][google.cloud.dialogflow.cx.v3.TransitionRouteGroup].
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.dialogflow.cx.v3.GetTransitionRouteGroupRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.dialogflow.cx.v3.TransitionRouteGroup])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.dialogflow.cx.v3.GetTransitionRouteGroupRequest]: @googleapis_reference_link{google/cloud/dialogflow/cx/v3/transition_route_group.proto#L208}
  /// [google.cloud.dialogflow.cx.v3.TransitionRouteGroup]: @googleapis_reference_link{google/cloud/dialogflow/cx/v3/transition_route_group.proto#L129}
  ///
  // clang-format on
  StatusOr<google::cloud::dialogflow::cx::v3::TransitionRouteGroup>
  GetTransitionRouteGroup(
      google::cloud::dialogflow::cx::v3::GetTransitionRouteGroupRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates an
  /// [TransitionRouteGroup][google.cloud.dialogflow.cx.v3.TransitionRouteGroup]
  /// in the specified flow.
  ///
  /// Note: You should always train a flow prior to sending it queries. See the
  /// [training
  /// documentation](https://cloud.google.com/dialogflow/cx/docs/concept/training).
  ///
  /// @param parent  Required. The flow to create an
  ///  [TransitionRouteGroup][google.cloud.dialogflow.cx.v3.TransitionRouteGroup]
  ///  for. Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>`
  ///  or `projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>`
  ///  for agent-level groups.
  /// @param transition_route_group  Required. The transition route group to create.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.dialogflow.cx.v3.TransitionRouteGroup])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.dialogflow.cx.v3.CreateTransitionRouteGroupRequest]: @googleapis_reference_link{google/cloud/dialogflow/cx/v3/transition_route_group.proto#L239}
  /// [google.cloud.dialogflow.cx.v3.TransitionRouteGroup]: @googleapis_reference_link{google/cloud/dialogflow/cx/v3/transition_route_group.proto#L129}
  ///
  // clang-format on
  StatusOr<google::cloud::dialogflow::cx::v3::TransitionRouteGroup>
  CreateTransitionRouteGroup(
      std::string const& parent,
      google::cloud::dialogflow::cx::v3::TransitionRouteGroup const&
          transition_route_group,
      Options opts = {});

  // clang-format off
  ///
  /// Creates an
  /// [TransitionRouteGroup][google.cloud.dialogflow.cx.v3.TransitionRouteGroup]
  /// in the specified flow.
  ///
  /// Note: You should always train a flow prior to sending it queries. See the
  /// [training
  /// documentation](https://cloud.google.com/dialogflow/cx/docs/concept/training).
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.dialogflow.cx.v3.CreateTransitionRouteGroupRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.dialogflow.cx.v3.TransitionRouteGroup])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.dialogflow.cx.v3.CreateTransitionRouteGroupRequest]: @googleapis_reference_link{google/cloud/dialogflow/cx/v3/transition_route_group.proto#L239}
  /// [google.cloud.dialogflow.cx.v3.TransitionRouteGroup]: @googleapis_reference_link{google/cloud/dialogflow/cx/v3/transition_route_group.proto#L129}
  ///
  // clang-format on
  StatusOr<google::cloud::dialogflow::cx::v3::TransitionRouteGroup>
  CreateTransitionRouteGroup(
      google::cloud::dialogflow::cx::v3::
          CreateTransitionRouteGroupRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Updates the specified
  /// [TransitionRouteGroup][google.cloud.dialogflow.cx.v3.TransitionRouteGroup].
  ///
  /// Note: You should always train a flow prior to sending it queries. See the
  /// [training
  /// documentation](https://cloud.google.com/dialogflow/cx/docs/concept/training).
  ///
  /// @param transition_route_group  Required. The transition route group to update.
  /// @param update_mask  The mask to control which fields get updated.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.dialogflow.cx.v3.TransitionRouteGroup])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.dialogflow.cx.v3.TransitionRouteGroup]: @googleapis_reference_link{google/cloud/dialogflow/cx/v3/transition_route_group.proto#L129}
  /// [google.cloud.dialogflow.cx.v3.UpdateTransitionRouteGroupRequest]: @googleapis_reference_link{google/cloud/dialogflow/cx/v3/transition_route_group.proto#L273}
  ///
  // clang-format on
  StatusOr<google::cloud::dialogflow::cx::v3::TransitionRouteGroup>
  UpdateTransitionRouteGroup(
      google::cloud::dialogflow::cx::v3::TransitionRouteGroup const&
          transition_route_group,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Updates the specified
  /// [TransitionRouteGroup][google.cloud.dialogflow.cx.v3.TransitionRouteGroup].
  ///
  /// Note: You should always train a flow prior to sending it queries. See the
  /// [training
  /// documentation](https://cloud.google.com/dialogflow/cx/docs/concept/training).
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.dialogflow.cx.v3.UpdateTransitionRouteGroupRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.dialogflow.cx.v3.TransitionRouteGroup])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.dialogflow.cx.v3.TransitionRouteGroup]: @googleapis_reference_link{google/cloud/dialogflow/cx/v3/transition_route_group.proto#L129}
  /// [google.cloud.dialogflow.cx.v3.UpdateTransitionRouteGroupRequest]: @googleapis_reference_link{google/cloud/dialogflow/cx/v3/transition_route_group.proto#L273}
  ///
  // clang-format on
  StatusOr<google::cloud::dialogflow::cx::v3::TransitionRouteGroup>
  UpdateTransitionRouteGroup(
      google::cloud::dialogflow::cx::v3::
          UpdateTransitionRouteGroupRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Deletes the specified
  /// [TransitionRouteGroup][google.cloud.dialogflow.cx.v3.TransitionRouteGroup].
  ///
  /// Note: You should always train a flow prior to sending it queries. See the
  /// [training
  /// documentation](https://cloud.google.com/dialogflow/cx/docs/concept/training).
  ///
  /// @param name  Required. The name of the
  ///  [TransitionRouteGroup][google.cloud.dialogflow.cx.v3.TransitionRouteGroup]
  ///  to delete. Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>/transitionRouteGroups/<Transition Route Group ID>` or `projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/transitionRouteGroups/<Transition Route Group ID>`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.dialogflow.cx.v3.DeleteTransitionRouteGroupRequest]: @googleapis_reference_link{google/cloud/dialogflow/cx/v3/transition_route_group.proto#L297}
  /// [google.cloud.dialogflow.cx.v3.TransitionRouteGroup]: @googleapis_reference_link{google/cloud/dialogflow/cx/v3/transition_route_group.proto#L129}
  ///
  // clang-format on
  Status DeleteTransitionRouteGroup(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes the specified
  /// [TransitionRouteGroup][google.cloud.dialogflow.cx.v3.TransitionRouteGroup].
  ///
  /// Note: You should always train a flow prior to sending it queries. See the
  /// [training
  /// documentation](https://cloud.google.com/dialogflow/cx/docs/concept/training).
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.dialogflow.cx.v3.DeleteTransitionRouteGroupRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.dialogflow.cx.v3.DeleteTransitionRouteGroupRequest]: @googleapis_reference_link{google/cloud/dialogflow/cx/v3/transition_route_group.proto#L297}
  /// [google.cloud.dialogflow.cx.v3.TransitionRouteGroup]: @googleapis_reference_link{google/cloud/dialogflow/cx/v3/transition_route_group.proto#L129}
  ///
  // clang-format on
  Status DeleteTransitionRouteGroup(
      google::cloud::dialogflow::cx::v3::
          DeleteTransitionRouteGroupRequest const& request,
      Options opts = {});

 private:
  std::shared_ptr<TransitionRouteGroupsConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dialogflow_cx
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DIALOGFLOW_CX_TRANSITION_ROUTE_GROUPS_CLIENT_H
