// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dataplex/v1/content.proto

#include "google/cloud/dataplex/v1/internal/content_logging_decorator.h"
#include "google/cloud/internal/log_wrapper.h"
#include "google/cloud/status_or.h"
#include <google/cloud/dataplex/v1/content.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace dataplex_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

ContentServiceLogging::ContentServiceLogging(
    std::shared_ptr<ContentServiceStub> child, TracingOptions tracing_options,
    std::set<std::string> const& components)
    : child_(std::move(child)),
      tracing_options_(std::move(tracing_options)),
      stream_logging_(components.find("rpc-streams") != components.end()) {}

StatusOr<google::cloud::dataplex::v1::Content>
ContentServiceLogging::CreateContent(
    grpc::ClientContext& context,
    google::cloud::dataplex::v1::CreateContentRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::dataplex::v1::CreateContentRequest const& request) {
        return child_->CreateContent(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::dataplex::v1::Content>
ContentServiceLogging::UpdateContent(
    grpc::ClientContext& context,
    google::cloud::dataplex::v1::UpdateContentRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::dataplex::v1::UpdateContentRequest const& request) {
        return child_->UpdateContent(context, request);
      },
      context, request, __func__, tracing_options_);
}

Status ContentServiceLogging::DeleteContent(
    grpc::ClientContext& context,
    google::cloud::dataplex::v1::DeleteContentRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::dataplex::v1::DeleteContentRequest const& request) {
        return child_->DeleteContent(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::dataplex::v1::Content>
ContentServiceLogging::GetContent(
    grpc::ClientContext& context,
    google::cloud::dataplex::v1::GetContentRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::dataplex::v1::GetContentRequest const& request) {
        return child_->GetContent(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::iam::v1::Policy> ContentServiceLogging::GetIamPolicy(
    grpc::ClientContext& context,
    google::iam::v1::GetIamPolicyRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::iam::v1::GetIamPolicyRequest const& request) {
        return child_->GetIamPolicy(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::iam::v1::Policy> ContentServiceLogging::SetIamPolicy(
    grpc::ClientContext& context,
    google::iam::v1::SetIamPolicyRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::iam::v1::SetIamPolicyRequest const& request) {
        return child_->SetIamPolicy(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
ContentServiceLogging::TestIamPermissions(
    grpc::ClientContext& context,
    google::iam::v1::TestIamPermissionsRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::iam::v1::TestIamPermissionsRequest const& request) {
        return child_->TestIamPermissions(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::dataplex::v1::ListContentResponse>
ContentServiceLogging::ListContent(
    grpc::ClientContext& context,
    google::cloud::dataplex::v1::ListContentRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::dataplex::v1::ListContentRequest const& request) {
        return child_->ListContent(context, request);
      },
      context, request, __func__, tracing_options_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dataplex_v1_internal
}  // namespace cloud
}  // namespace google
