// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/config/v1/config.proto

#include "google/cloud/config/v1/config_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace config_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

ConfigConnectionIdempotencyPolicy::~ConfigConnectionIdempotencyPolicy() =
    default;

std::unique_ptr<ConfigConnectionIdempotencyPolicy>
ConfigConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<ConfigConnectionIdempotencyPolicy>(*this);
}

Idempotency ConfigConnectionIdempotencyPolicy::ListDeployments(
    google::cloud::config::v1::ListDeploymentsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency ConfigConnectionIdempotencyPolicy::GetDeployment(
    google::cloud::config::v1::GetDeploymentRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency ConfigConnectionIdempotencyPolicy::CreateDeployment(
    google::cloud::config::v1::CreateDeploymentRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ConfigConnectionIdempotencyPolicy::UpdateDeployment(
    google::cloud::config::v1::UpdateDeploymentRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ConfigConnectionIdempotencyPolicy::DeleteDeployment(
    google::cloud::config::v1::DeleteDeploymentRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ConfigConnectionIdempotencyPolicy::ListRevisions(
    google::cloud::config::v1::ListRevisionsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency ConfigConnectionIdempotencyPolicy::GetRevision(
    google::cloud::config::v1::GetRevisionRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency ConfigConnectionIdempotencyPolicy::GetResource(
    google::cloud::config::v1::GetResourceRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency ConfigConnectionIdempotencyPolicy::ListResources(
    google::cloud::config::v1::ListResourcesRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency ConfigConnectionIdempotencyPolicy::ExportDeploymentStatefile(
    google::cloud::config::v1::ExportDeploymentStatefileRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ConfigConnectionIdempotencyPolicy::ExportRevisionStatefile(
    google::cloud::config::v1::ExportRevisionStatefileRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ConfigConnectionIdempotencyPolicy::ImportStatefile(
    google::cloud::config::v1::ImportStatefileRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ConfigConnectionIdempotencyPolicy::DeleteStatefile(
    google::cloud::config::v1::DeleteStatefileRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ConfigConnectionIdempotencyPolicy::LockDeployment(
    google::cloud::config::v1::LockDeploymentRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ConfigConnectionIdempotencyPolicy::UnlockDeployment(
    google::cloud::config::v1::UnlockDeploymentRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ConfigConnectionIdempotencyPolicy::ExportLockInfo(
    google::cloud::config::v1::ExportLockInfoRequest const&) {
  return Idempotency::kIdempotent;
}

std::unique_ptr<ConfigConnectionIdempotencyPolicy>
MakeDefaultConfigConnectionIdempotencyPolicy() {
  return std::make_unique<ConfigConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace config_v1
}  // namespace cloud
}  // namespace google
