// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/aiplatform/v1/schedule_service.proto

#include "google/cloud/aiplatform/v1/internal/schedule_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>

namespace google {
namespace cloud {
namespace aiplatform_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

ScheduleServiceTracingConnection::ScheduleServiceTracingConnection(
    std::shared_ptr<aiplatform_v1::ScheduleServiceConnection> child)
    : child_(std::move(child)) {}

StatusOr<google::cloud::aiplatform::v1::Schedule>
ScheduleServiceTracingConnection::CreateSchedule(
    google::cloud::aiplatform::v1::CreateScheduleRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::ScheduleServiceConnection::CreateSchedule");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->CreateSchedule(request));
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
ScheduleServiceTracingConnection::DeleteSchedule(
    google::cloud::aiplatform::v1::DeleteScheduleRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::ScheduleServiceConnection::DeleteSchedule");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteSchedule(request));
}

StatusOr<google::cloud::aiplatform::v1::Schedule>
ScheduleServiceTracingConnection::GetSchedule(
    google::cloud::aiplatform::v1::GetScheduleRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::ScheduleServiceConnection::GetSchedule");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetSchedule(request));
}

StreamRange<google::cloud::aiplatform::v1::Schedule>
ScheduleServiceTracingConnection::ListSchedules(
    google::cloud::aiplatform::v1::ListSchedulesRequest request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::ScheduleServiceConnection::ListSchedules");
  internal::OTelScope scope(span);
  auto sr = child_->ListSchedules(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::aiplatform::v1::Schedule>(std::move(span), std::move(sr));
}

Status ScheduleServiceTracingConnection::PauseSchedule(
    google::cloud::aiplatform::v1::PauseScheduleRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::ScheduleServiceConnection::PauseSchedule");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->PauseSchedule(request));
}

Status ScheduleServiceTracingConnection::ResumeSchedule(
    google::cloud::aiplatform::v1::ResumeScheduleRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::ScheduleServiceConnection::ResumeSchedule");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->ResumeSchedule(request));
}

StatusOr<google::cloud::aiplatform::v1::Schedule>
ScheduleServiceTracingConnection::UpdateSchedule(
    google::cloud::aiplatform::v1::UpdateScheduleRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::ScheduleServiceConnection::UpdateSchedule");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->UpdateSchedule(request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<aiplatform_v1::ScheduleServiceConnection>
MakeScheduleServiceTracingConnection(
    std::shared_ptr<aiplatform_v1::ScheduleServiceConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<ScheduleServiceTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace aiplatform_v1_internal
}  // namespace cloud
}  // namespace google
