/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// UpdateDBTargetDetails struct for UpdateDBTargetDetails
type UpdateDBTargetDetails struct {
	DbType *string `json:"db_type,omitempty"`
	HostName *string `json:"host_name,omitempty"`
	// Set output format to JSON
	Json *bool `json:"json,omitempty"`
	// Whether to keep previous version [true/false]. If not set, use default according to account settings
	KeepPrevVersion *string `json:"keep-prev-version,omitempty"`
	MongoDbName *string `json:"mongo_db_name,omitempty"`
	MongoUri *string `json:"mongo_uri,omitempty"`
	// Target name
	Name string `json:"name"`
	// Deprecated
	NewVersion *bool `json:"new-version,omitempty"`
	Port *string `json:"port,omitempty"`
	// The name of a key that used to encrypt the target secret value (if empty, the account default protectionKey key will be used)
	ProtectionKey *string `json:"protection_key,omitempty"`
	Pwd *string `json:"pwd,omitempty"`
	// Authentication token (see `/auth` and `/configure`)
	Token *string `json:"token,omitempty"`
	// The universal identity token, Required only for universal_identity authentication
	UidToken *string `json:"uid-token,omitempty"`
	UserName *string `json:"user_name,omitempty"`
}

// NewUpdateDBTargetDetails instantiates a new UpdateDBTargetDetails object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewUpdateDBTargetDetails(name string, ) *UpdateDBTargetDetails {
	this := UpdateDBTargetDetails{}
	var json bool = false
	this.Json = &json
	this.Name = name
	return &this
}

// NewUpdateDBTargetDetailsWithDefaults instantiates a new UpdateDBTargetDetails object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewUpdateDBTargetDetailsWithDefaults() *UpdateDBTargetDetails {
	this := UpdateDBTargetDetails{}
	var json bool = false
	this.Json = &json
	return &this
}

// GetDbType returns the DbType field value if set, zero value otherwise.
func (o *UpdateDBTargetDetails) GetDbType() string {
	if o == nil || o.DbType == nil {
		var ret string
		return ret
	}
	return *o.DbType
}

// GetDbTypeOk returns a tuple with the DbType field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateDBTargetDetails) GetDbTypeOk() (*string, bool) {
	if o == nil || o.DbType == nil {
		return nil, false
	}
	return o.DbType, true
}

// HasDbType returns a boolean if a field has been set.
func (o *UpdateDBTargetDetails) HasDbType() bool {
	if o != nil && o.DbType != nil {
		return true
	}

	return false
}

// SetDbType gets a reference to the given string and assigns it to the DbType field.
func (o *UpdateDBTargetDetails) SetDbType(v string) {
	o.DbType = &v
}

// GetHostName returns the HostName field value if set, zero value otherwise.
func (o *UpdateDBTargetDetails) GetHostName() string {
	if o == nil || o.HostName == nil {
		var ret string
		return ret
	}
	return *o.HostName
}

// GetHostNameOk returns a tuple with the HostName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateDBTargetDetails) GetHostNameOk() (*string, bool) {
	if o == nil || o.HostName == nil {
		return nil, false
	}
	return o.HostName, true
}

// HasHostName returns a boolean if a field has been set.
func (o *UpdateDBTargetDetails) HasHostName() bool {
	if o != nil && o.HostName != nil {
		return true
	}

	return false
}

// SetHostName gets a reference to the given string and assigns it to the HostName field.
func (o *UpdateDBTargetDetails) SetHostName(v string) {
	o.HostName = &v
}

// GetJson returns the Json field value if set, zero value otherwise.
func (o *UpdateDBTargetDetails) GetJson() bool {
	if o == nil || o.Json == nil {
		var ret bool
		return ret
	}
	return *o.Json
}

// GetJsonOk returns a tuple with the Json field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateDBTargetDetails) GetJsonOk() (*bool, bool) {
	if o == nil || o.Json == nil {
		return nil, false
	}
	return o.Json, true
}

// HasJson returns a boolean if a field has been set.
func (o *UpdateDBTargetDetails) HasJson() bool {
	if o != nil && o.Json != nil {
		return true
	}

	return false
}

// SetJson gets a reference to the given bool and assigns it to the Json field.
func (o *UpdateDBTargetDetails) SetJson(v bool) {
	o.Json = &v
}

// GetKeepPrevVersion returns the KeepPrevVersion field value if set, zero value otherwise.
func (o *UpdateDBTargetDetails) GetKeepPrevVersion() string {
	if o == nil || o.KeepPrevVersion == nil {
		var ret string
		return ret
	}
	return *o.KeepPrevVersion
}

// GetKeepPrevVersionOk returns a tuple with the KeepPrevVersion field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateDBTargetDetails) GetKeepPrevVersionOk() (*string, bool) {
	if o == nil || o.KeepPrevVersion == nil {
		return nil, false
	}
	return o.KeepPrevVersion, true
}

// HasKeepPrevVersion returns a boolean if a field has been set.
func (o *UpdateDBTargetDetails) HasKeepPrevVersion() bool {
	if o != nil && o.KeepPrevVersion != nil {
		return true
	}

	return false
}

// SetKeepPrevVersion gets a reference to the given string and assigns it to the KeepPrevVersion field.
func (o *UpdateDBTargetDetails) SetKeepPrevVersion(v string) {
	o.KeepPrevVersion = &v
}

// GetMongoDbName returns the MongoDbName field value if set, zero value otherwise.
func (o *UpdateDBTargetDetails) GetMongoDbName() string {
	if o == nil || o.MongoDbName == nil {
		var ret string
		return ret
	}
	return *o.MongoDbName
}

// GetMongoDbNameOk returns a tuple with the MongoDbName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateDBTargetDetails) GetMongoDbNameOk() (*string, bool) {
	if o == nil || o.MongoDbName == nil {
		return nil, false
	}
	return o.MongoDbName, true
}

// HasMongoDbName returns a boolean if a field has been set.
func (o *UpdateDBTargetDetails) HasMongoDbName() bool {
	if o != nil && o.MongoDbName != nil {
		return true
	}

	return false
}

// SetMongoDbName gets a reference to the given string and assigns it to the MongoDbName field.
func (o *UpdateDBTargetDetails) SetMongoDbName(v string) {
	o.MongoDbName = &v
}

// GetMongoUri returns the MongoUri field value if set, zero value otherwise.
func (o *UpdateDBTargetDetails) GetMongoUri() string {
	if o == nil || o.MongoUri == nil {
		var ret string
		return ret
	}
	return *o.MongoUri
}

// GetMongoUriOk returns a tuple with the MongoUri field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateDBTargetDetails) GetMongoUriOk() (*string, bool) {
	if o == nil || o.MongoUri == nil {
		return nil, false
	}
	return o.MongoUri, true
}

// HasMongoUri returns a boolean if a field has been set.
func (o *UpdateDBTargetDetails) HasMongoUri() bool {
	if o != nil && o.MongoUri != nil {
		return true
	}

	return false
}

// SetMongoUri gets a reference to the given string and assigns it to the MongoUri field.
func (o *UpdateDBTargetDetails) SetMongoUri(v string) {
	o.MongoUri = &v
}

// GetName returns the Name field value
func (o *UpdateDBTargetDetails) GetName() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.Name
}

// GetNameOk returns a tuple with the Name field value
// and a boolean to check if the value has been set.
func (o *UpdateDBTargetDetails) GetNameOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.Name, true
}

// SetName sets field value
func (o *UpdateDBTargetDetails) SetName(v string) {
	o.Name = v
}

// GetNewVersion returns the NewVersion field value if set, zero value otherwise.
func (o *UpdateDBTargetDetails) GetNewVersion() bool {
	if o == nil || o.NewVersion == nil {
		var ret bool
		return ret
	}
	return *o.NewVersion
}

// GetNewVersionOk returns a tuple with the NewVersion field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateDBTargetDetails) GetNewVersionOk() (*bool, bool) {
	if o == nil || o.NewVersion == nil {
		return nil, false
	}
	return o.NewVersion, true
}

// HasNewVersion returns a boolean if a field has been set.
func (o *UpdateDBTargetDetails) HasNewVersion() bool {
	if o != nil && o.NewVersion != nil {
		return true
	}

	return false
}

// SetNewVersion gets a reference to the given bool and assigns it to the NewVersion field.
func (o *UpdateDBTargetDetails) SetNewVersion(v bool) {
	o.NewVersion = &v
}

// GetPort returns the Port field value if set, zero value otherwise.
func (o *UpdateDBTargetDetails) GetPort() string {
	if o == nil || o.Port == nil {
		var ret string
		return ret
	}
	return *o.Port
}

// GetPortOk returns a tuple with the Port field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateDBTargetDetails) GetPortOk() (*string, bool) {
	if o == nil || o.Port == nil {
		return nil, false
	}
	return o.Port, true
}

// HasPort returns a boolean if a field has been set.
func (o *UpdateDBTargetDetails) HasPort() bool {
	if o != nil && o.Port != nil {
		return true
	}

	return false
}

// SetPort gets a reference to the given string and assigns it to the Port field.
func (o *UpdateDBTargetDetails) SetPort(v string) {
	o.Port = &v
}

// GetProtectionKey returns the ProtectionKey field value if set, zero value otherwise.
func (o *UpdateDBTargetDetails) GetProtectionKey() string {
	if o == nil || o.ProtectionKey == nil {
		var ret string
		return ret
	}
	return *o.ProtectionKey
}

// GetProtectionKeyOk returns a tuple with the ProtectionKey field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateDBTargetDetails) GetProtectionKeyOk() (*string, bool) {
	if o == nil || o.ProtectionKey == nil {
		return nil, false
	}
	return o.ProtectionKey, true
}

// HasProtectionKey returns a boolean if a field has been set.
func (o *UpdateDBTargetDetails) HasProtectionKey() bool {
	if o != nil && o.ProtectionKey != nil {
		return true
	}

	return false
}

// SetProtectionKey gets a reference to the given string and assigns it to the ProtectionKey field.
func (o *UpdateDBTargetDetails) SetProtectionKey(v string) {
	o.ProtectionKey = &v
}

// GetPwd returns the Pwd field value if set, zero value otherwise.
func (o *UpdateDBTargetDetails) GetPwd() string {
	if o == nil || o.Pwd == nil {
		var ret string
		return ret
	}
	return *o.Pwd
}

// GetPwdOk returns a tuple with the Pwd field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateDBTargetDetails) GetPwdOk() (*string, bool) {
	if o == nil || o.Pwd == nil {
		return nil, false
	}
	return o.Pwd, true
}

// HasPwd returns a boolean if a field has been set.
func (o *UpdateDBTargetDetails) HasPwd() bool {
	if o != nil && o.Pwd != nil {
		return true
	}

	return false
}

// SetPwd gets a reference to the given string and assigns it to the Pwd field.
func (o *UpdateDBTargetDetails) SetPwd(v string) {
	o.Pwd = &v
}

// GetToken returns the Token field value if set, zero value otherwise.
func (o *UpdateDBTargetDetails) GetToken() string {
	if o == nil || o.Token == nil {
		var ret string
		return ret
	}
	return *o.Token
}

// GetTokenOk returns a tuple with the Token field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateDBTargetDetails) GetTokenOk() (*string, bool) {
	if o == nil || o.Token == nil {
		return nil, false
	}
	return o.Token, true
}

// HasToken returns a boolean if a field has been set.
func (o *UpdateDBTargetDetails) HasToken() bool {
	if o != nil && o.Token != nil {
		return true
	}

	return false
}

// SetToken gets a reference to the given string and assigns it to the Token field.
func (o *UpdateDBTargetDetails) SetToken(v string) {
	o.Token = &v
}

// GetUidToken returns the UidToken field value if set, zero value otherwise.
func (o *UpdateDBTargetDetails) GetUidToken() string {
	if o == nil || o.UidToken == nil {
		var ret string
		return ret
	}
	return *o.UidToken
}

// GetUidTokenOk returns a tuple with the UidToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateDBTargetDetails) GetUidTokenOk() (*string, bool) {
	if o == nil || o.UidToken == nil {
		return nil, false
	}
	return o.UidToken, true
}

// HasUidToken returns a boolean if a field has been set.
func (o *UpdateDBTargetDetails) HasUidToken() bool {
	if o != nil && o.UidToken != nil {
		return true
	}

	return false
}

// SetUidToken gets a reference to the given string and assigns it to the UidToken field.
func (o *UpdateDBTargetDetails) SetUidToken(v string) {
	o.UidToken = &v
}

// GetUserName returns the UserName field value if set, zero value otherwise.
func (o *UpdateDBTargetDetails) GetUserName() string {
	if o == nil || o.UserName == nil {
		var ret string
		return ret
	}
	return *o.UserName
}

// GetUserNameOk returns a tuple with the UserName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateDBTargetDetails) GetUserNameOk() (*string, bool) {
	if o == nil || o.UserName == nil {
		return nil, false
	}
	return o.UserName, true
}

// HasUserName returns a boolean if a field has been set.
func (o *UpdateDBTargetDetails) HasUserName() bool {
	if o != nil && o.UserName != nil {
		return true
	}

	return false
}

// SetUserName gets a reference to the given string and assigns it to the UserName field.
func (o *UpdateDBTargetDetails) SetUserName(v string) {
	o.UserName = &v
}

func (o UpdateDBTargetDetails) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.DbType != nil {
		toSerialize["db_type"] = o.DbType
	}
	if o.HostName != nil {
		toSerialize["host_name"] = o.HostName
	}
	if o.Json != nil {
		toSerialize["json"] = o.Json
	}
	if o.KeepPrevVersion != nil {
		toSerialize["keep-prev-version"] = o.KeepPrevVersion
	}
	if o.MongoDbName != nil {
		toSerialize["mongo_db_name"] = o.MongoDbName
	}
	if o.MongoUri != nil {
		toSerialize["mongo_uri"] = o.MongoUri
	}
	if true {
		toSerialize["name"] = o.Name
	}
	if o.NewVersion != nil {
		toSerialize["new-version"] = o.NewVersion
	}
	if o.Port != nil {
		toSerialize["port"] = o.Port
	}
	if o.ProtectionKey != nil {
		toSerialize["protection_key"] = o.ProtectionKey
	}
	if o.Pwd != nil {
		toSerialize["pwd"] = o.Pwd
	}
	if o.Token != nil {
		toSerialize["token"] = o.Token
	}
	if o.UidToken != nil {
		toSerialize["uid-token"] = o.UidToken
	}
	if o.UserName != nil {
		toSerialize["user_name"] = o.UserName
	}
	return json.Marshal(toSerialize)
}

type NullableUpdateDBTargetDetails struct {
	value *UpdateDBTargetDetails
	isSet bool
}

func (v NullableUpdateDBTargetDetails) Get() *UpdateDBTargetDetails {
	return v.value
}

func (v *NullableUpdateDBTargetDetails) Set(val *UpdateDBTargetDetails) {
	v.value = val
	v.isSet = true
}

func (v NullableUpdateDBTargetDetails) IsSet() bool {
	return v.isSet
}

func (v *NullableUpdateDBTargetDetails) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableUpdateDBTargetDetails(val *UpdateDBTargetDetails) *NullableUpdateDBTargetDetails {
	return &NullableUpdateDBTargetDetails{value: val, isSet: true}
}

func (v NullableUpdateDBTargetDetails) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableUpdateDBTargetDetails) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


