/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// TargetObjectAssociation TargetObjectAssociation includes details of an association between a target and an object (target, migration_id).
type TargetObjectAssociation struct {
	AssocId *string `json:"assoc_id,omitempty"`
	Attributes *map[string]string `json:"attributes,omitempty"`
	ObjectId *string `json:"object_id,omitempty"`
	ObjectName *string `json:"object_name,omitempty"`
	ObjectType *string `json:"object_type,omitempty"`
	TargetName *string `json:"target_name,omitempty"`
}

// NewTargetObjectAssociation instantiates a new TargetObjectAssociation object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewTargetObjectAssociation() *TargetObjectAssociation {
	this := TargetObjectAssociation{}
	return &this
}

// NewTargetObjectAssociationWithDefaults instantiates a new TargetObjectAssociation object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewTargetObjectAssociationWithDefaults() *TargetObjectAssociation {
	this := TargetObjectAssociation{}
	return &this
}

// GetAssocId returns the AssocId field value if set, zero value otherwise.
func (o *TargetObjectAssociation) GetAssocId() string {
	if o == nil || o.AssocId == nil {
		var ret string
		return ret
	}
	return *o.AssocId
}

// GetAssocIdOk returns a tuple with the AssocId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TargetObjectAssociation) GetAssocIdOk() (*string, bool) {
	if o == nil || o.AssocId == nil {
		return nil, false
	}
	return o.AssocId, true
}

// HasAssocId returns a boolean if a field has been set.
func (o *TargetObjectAssociation) HasAssocId() bool {
	if o != nil && o.AssocId != nil {
		return true
	}

	return false
}

// SetAssocId gets a reference to the given string and assigns it to the AssocId field.
func (o *TargetObjectAssociation) SetAssocId(v string) {
	o.AssocId = &v
}

// GetAttributes returns the Attributes field value if set, zero value otherwise.
func (o *TargetObjectAssociation) GetAttributes() map[string]string {
	if o == nil || o.Attributes == nil {
		var ret map[string]string
		return ret
	}
	return *o.Attributes
}

// GetAttributesOk returns a tuple with the Attributes field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TargetObjectAssociation) GetAttributesOk() (*map[string]string, bool) {
	if o == nil || o.Attributes == nil {
		return nil, false
	}
	return o.Attributes, true
}

// HasAttributes returns a boolean if a field has been set.
func (o *TargetObjectAssociation) HasAttributes() bool {
	if o != nil && o.Attributes != nil {
		return true
	}

	return false
}

// SetAttributes gets a reference to the given map[string]string and assigns it to the Attributes field.
func (o *TargetObjectAssociation) SetAttributes(v map[string]string) {
	o.Attributes = &v
}

// GetObjectId returns the ObjectId field value if set, zero value otherwise.
func (o *TargetObjectAssociation) GetObjectId() string {
	if o == nil || o.ObjectId == nil {
		var ret string
		return ret
	}
	return *o.ObjectId
}

// GetObjectIdOk returns a tuple with the ObjectId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TargetObjectAssociation) GetObjectIdOk() (*string, bool) {
	if o == nil || o.ObjectId == nil {
		return nil, false
	}
	return o.ObjectId, true
}

// HasObjectId returns a boolean if a field has been set.
func (o *TargetObjectAssociation) HasObjectId() bool {
	if o != nil && o.ObjectId != nil {
		return true
	}

	return false
}

// SetObjectId gets a reference to the given string and assigns it to the ObjectId field.
func (o *TargetObjectAssociation) SetObjectId(v string) {
	o.ObjectId = &v
}

// GetObjectName returns the ObjectName field value if set, zero value otherwise.
func (o *TargetObjectAssociation) GetObjectName() string {
	if o == nil || o.ObjectName == nil {
		var ret string
		return ret
	}
	return *o.ObjectName
}

// GetObjectNameOk returns a tuple with the ObjectName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TargetObjectAssociation) GetObjectNameOk() (*string, bool) {
	if o == nil || o.ObjectName == nil {
		return nil, false
	}
	return o.ObjectName, true
}

// HasObjectName returns a boolean if a field has been set.
func (o *TargetObjectAssociation) HasObjectName() bool {
	if o != nil && o.ObjectName != nil {
		return true
	}

	return false
}

// SetObjectName gets a reference to the given string and assigns it to the ObjectName field.
func (o *TargetObjectAssociation) SetObjectName(v string) {
	o.ObjectName = &v
}

// GetObjectType returns the ObjectType field value if set, zero value otherwise.
func (o *TargetObjectAssociation) GetObjectType() string {
	if o == nil || o.ObjectType == nil {
		var ret string
		return ret
	}
	return *o.ObjectType
}

// GetObjectTypeOk returns a tuple with the ObjectType field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TargetObjectAssociation) GetObjectTypeOk() (*string, bool) {
	if o == nil || o.ObjectType == nil {
		return nil, false
	}
	return o.ObjectType, true
}

// HasObjectType returns a boolean if a field has been set.
func (o *TargetObjectAssociation) HasObjectType() bool {
	if o != nil && o.ObjectType != nil {
		return true
	}

	return false
}

// SetObjectType gets a reference to the given string and assigns it to the ObjectType field.
func (o *TargetObjectAssociation) SetObjectType(v string) {
	o.ObjectType = &v
}

// GetTargetName returns the TargetName field value if set, zero value otherwise.
func (o *TargetObjectAssociation) GetTargetName() string {
	if o == nil || o.TargetName == nil {
		var ret string
		return ret
	}
	return *o.TargetName
}

// GetTargetNameOk returns a tuple with the TargetName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TargetObjectAssociation) GetTargetNameOk() (*string, bool) {
	if o == nil || o.TargetName == nil {
		return nil, false
	}
	return o.TargetName, true
}

// HasTargetName returns a boolean if a field has been set.
func (o *TargetObjectAssociation) HasTargetName() bool {
	if o != nil && o.TargetName != nil {
		return true
	}

	return false
}

// SetTargetName gets a reference to the given string and assigns it to the TargetName field.
func (o *TargetObjectAssociation) SetTargetName(v string) {
	o.TargetName = &v
}

func (o TargetObjectAssociation) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.AssocId != nil {
		toSerialize["assoc_id"] = o.AssocId
	}
	if o.Attributes != nil {
		toSerialize["attributes"] = o.Attributes
	}
	if o.ObjectId != nil {
		toSerialize["object_id"] = o.ObjectId
	}
	if o.ObjectName != nil {
		toSerialize["object_name"] = o.ObjectName
	}
	if o.ObjectType != nil {
		toSerialize["object_type"] = o.ObjectType
	}
	if o.TargetName != nil {
		toSerialize["target_name"] = o.TargetName
	}
	return json.Marshal(toSerialize)
}

type NullableTargetObjectAssociation struct {
	value *TargetObjectAssociation
	isSet bool
}

func (v NullableTargetObjectAssociation) Get() *TargetObjectAssociation {
	return v.value
}

func (v *NullableTargetObjectAssociation) Set(val *TargetObjectAssociation) {
	v.value = val
	v.isSet = true
}

func (v NullableTargetObjectAssociation) IsSet() bool {
	return v.isSet
}

func (v *NullableTargetObjectAssociation) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableTargetObjectAssociation(val *TargetObjectAssociation) *NullableTargetObjectAssociation {
	return &NullableTargetObjectAssociation{value: val, isSet: true}
}

func (v NullableTargetObjectAssociation) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableTargetObjectAssociation) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


