// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package groundstation

import (
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
)

// WaitUntilContactScheduled uses the AWS Ground Station API operation
// DescribeContact to wait for a condition to be met before returning.
// If the condition is not met within the max attempt window, an error will
// be returned.
func (c *GroundStation) WaitUntilContactScheduled(input *DescribeContactInput) error {
	return c.WaitUntilContactScheduledWithContext(aws.BackgroundContext(), input)
}

// WaitUntilContactScheduledWithContext is an extended version of WaitUntilContactScheduled.
// With the support for passing in a context and options to configure the
// Waiter and the underlying request options.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GroundStation) WaitUntilContactScheduledWithContext(ctx aws.Context, input *DescribeContactInput, opts ...request.WaiterOption) error {
	w := request.Waiter{
		Name:        "WaitUntilContactScheduled",
		MaxAttempts: 180,
		Delay:       request.ConstantWaiterDelay(5 * time.Second),
		Acceptors: []request.WaiterAcceptor{
			{
				State:   request.FailureWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "contactStatus",
				Expected: "FAILED_TO_SCHEDULE",
			},
			{
				State:   request.SuccessWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "contactStatus",
				Expected: "SCHEDULED",
			},
		},
		Logger: c.Config.Logger,
		NewRequest: func(opts []request.Option) (*request.Request, error) {
			var inCpy *DescribeContactInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeContactRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}
	w.ApplyOptions(opts...)

	return w.WaitWithContext(ctx)
}
