/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// DynamicSecretUpdateEks dynamicSecretUpdateEks is a command that updates eks dynamic secret
type DynamicSecretUpdateEks struct {
	// Protection from accidental deletion of this object [true/false]
	DeleteProtection *string `json:"delete_protection,omitempty"`
	// Description of the object
	Description *string `json:"description,omitempty"`
	// Access Key ID
	EksAccessKeyId *string `json:"eks-access-key-id,omitempty"`
	// IAM assume role
	EksAssumeRole *string `json:"eks-assume-role,omitempty"`
	// EKS cluster CA certificate
	EksClusterCaCert *string `json:"eks-cluster-ca-cert,omitempty"`
	// EKS cluster URL endpoint
	EksClusterEndpoint *string `json:"eks-cluster-endpoint,omitempty"`
	// EKS cluster name
	EksClusterName *string `json:"eks-cluster-name,omitempty"`
	// Region
	EksRegion *string `json:"eks-region,omitempty"`
	// Secret Access Key
	EksSecretAccessKey *string `json:"eks-secret-access-key,omitempty"`
	// Set output format to JSON
	Json *bool `json:"json,omitempty"`
	// Dynamic secret name
	Name string `json:"name"`
	// Dynamic secret name
	NewName *string `json:"new-name,omitempty"`
	// Dynamic producer encryption key
	ProducerEncryptionKeyName *string `json:"producer-encryption-key-name,omitempty"`
	// Enable Port forwarding while using CLI access
	SecureAccessAllowPortForwading *bool `json:"secure-access-allow-port-forwading,omitempty"`
	// Path to the SSH Certificate Issuer for your Akeyless Bastion
	SecureAccessBastionIssuer *string `json:"secure-access-bastion-issuer,omitempty"`
	// The K8s cluster endpoint URL
	SecureAccessClusterEndpoint *string `json:"secure-access-cluster-endpoint,omitempty"`
	// Enable/Disable secure remote access [true/false]
	SecureAccessEnable *string `json:"secure-access-enable,omitempty"`
	// Enable Web Secure Remote Access
	SecureAccessWeb *bool `json:"secure-access-web,omitempty"`
	// Add tags attached to this object
	Tags *[]string `json:"tags,omitempty"`
	// Target name
	TargetName *string `json:"target-name,omitempty"`
	// Authentication token (see `/auth` and `/configure`)
	Token *string `json:"token,omitempty"`
	// The universal identity token, Required only for universal_identity authentication
	UidToken *string `json:"uid-token,omitempty"`
	// User TTL
	UserTtl *string `json:"user-ttl,omitempty"`
}

// NewDynamicSecretUpdateEks instantiates a new DynamicSecretUpdateEks object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewDynamicSecretUpdateEks(name string, ) *DynamicSecretUpdateEks {
	this := DynamicSecretUpdateEks{}
	var eksRegion string = "us-east-2"
	this.EksRegion = &eksRegion
	var json bool = false
	this.Json = &json
	this.Name = name
	var secureAccessWeb bool = false
	this.SecureAccessWeb = &secureAccessWeb
	var userTtl string = "15m"
	this.UserTtl = &userTtl
	return &this
}

// NewDynamicSecretUpdateEksWithDefaults instantiates a new DynamicSecretUpdateEks object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewDynamicSecretUpdateEksWithDefaults() *DynamicSecretUpdateEks {
	this := DynamicSecretUpdateEks{}
	var eksRegion string = "us-east-2"
	this.EksRegion = &eksRegion
	var json bool = false
	this.Json = &json
	var secureAccessWeb bool = false
	this.SecureAccessWeb = &secureAccessWeb
	var userTtl string = "15m"
	this.UserTtl = &userTtl
	return &this
}

// GetDeleteProtection returns the DeleteProtection field value if set, zero value otherwise.
func (o *DynamicSecretUpdateEks) GetDeleteProtection() string {
	if o == nil || o.DeleteProtection == nil {
		var ret string
		return ret
	}
	return *o.DeleteProtection
}

// GetDeleteProtectionOk returns a tuple with the DeleteProtection field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateEks) GetDeleteProtectionOk() (*string, bool) {
	if o == nil || o.DeleteProtection == nil {
		return nil, false
	}
	return o.DeleteProtection, true
}

// HasDeleteProtection returns a boolean if a field has been set.
func (o *DynamicSecretUpdateEks) HasDeleteProtection() bool {
	if o != nil && o.DeleteProtection != nil {
		return true
	}

	return false
}

// SetDeleteProtection gets a reference to the given string and assigns it to the DeleteProtection field.
func (o *DynamicSecretUpdateEks) SetDeleteProtection(v string) {
	o.DeleteProtection = &v
}

// GetDescription returns the Description field value if set, zero value otherwise.
func (o *DynamicSecretUpdateEks) GetDescription() string {
	if o == nil || o.Description == nil {
		var ret string
		return ret
	}
	return *o.Description
}

// GetDescriptionOk returns a tuple with the Description field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateEks) GetDescriptionOk() (*string, bool) {
	if o == nil || o.Description == nil {
		return nil, false
	}
	return o.Description, true
}

// HasDescription returns a boolean if a field has been set.
func (o *DynamicSecretUpdateEks) HasDescription() bool {
	if o != nil && o.Description != nil {
		return true
	}

	return false
}

// SetDescription gets a reference to the given string and assigns it to the Description field.
func (o *DynamicSecretUpdateEks) SetDescription(v string) {
	o.Description = &v
}

// GetEksAccessKeyId returns the EksAccessKeyId field value if set, zero value otherwise.
func (o *DynamicSecretUpdateEks) GetEksAccessKeyId() string {
	if o == nil || o.EksAccessKeyId == nil {
		var ret string
		return ret
	}
	return *o.EksAccessKeyId
}

// GetEksAccessKeyIdOk returns a tuple with the EksAccessKeyId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateEks) GetEksAccessKeyIdOk() (*string, bool) {
	if o == nil || o.EksAccessKeyId == nil {
		return nil, false
	}
	return o.EksAccessKeyId, true
}

// HasEksAccessKeyId returns a boolean if a field has been set.
func (o *DynamicSecretUpdateEks) HasEksAccessKeyId() bool {
	if o != nil && o.EksAccessKeyId != nil {
		return true
	}

	return false
}

// SetEksAccessKeyId gets a reference to the given string and assigns it to the EksAccessKeyId field.
func (o *DynamicSecretUpdateEks) SetEksAccessKeyId(v string) {
	o.EksAccessKeyId = &v
}

// GetEksAssumeRole returns the EksAssumeRole field value if set, zero value otherwise.
func (o *DynamicSecretUpdateEks) GetEksAssumeRole() string {
	if o == nil || o.EksAssumeRole == nil {
		var ret string
		return ret
	}
	return *o.EksAssumeRole
}

// GetEksAssumeRoleOk returns a tuple with the EksAssumeRole field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateEks) GetEksAssumeRoleOk() (*string, bool) {
	if o == nil || o.EksAssumeRole == nil {
		return nil, false
	}
	return o.EksAssumeRole, true
}

// HasEksAssumeRole returns a boolean if a field has been set.
func (o *DynamicSecretUpdateEks) HasEksAssumeRole() bool {
	if o != nil && o.EksAssumeRole != nil {
		return true
	}

	return false
}

// SetEksAssumeRole gets a reference to the given string and assigns it to the EksAssumeRole field.
func (o *DynamicSecretUpdateEks) SetEksAssumeRole(v string) {
	o.EksAssumeRole = &v
}

// GetEksClusterCaCert returns the EksClusterCaCert field value if set, zero value otherwise.
func (o *DynamicSecretUpdateEks) GetEksClusterCaCert() string {
	if o == nil || o.EksClusterCaCert == nil {
		var ret string
		return ret
	}
	return *o.EksClusterCaCert
}

// GetEksClusterCaCertOk returns a tuple with the EksClusterCaCert field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateEks) GetEksClusterCaCertOk() (*string, bool) {
	if o == nil || o.EksClusterCaCert == nil {
		return nil, false
	}
	return o.EksClusterCaCert, true
}

// HasEksClusterCaCert returns a boolean if a field has been set.
func (o *DynamicSecretUpdateEks) HasEksClusterCaCert() bool {
	if o != nil && o.EksClusterCaCert != nil {
		return true
	}

	return false
}

// SetEksClusterCaCert gets a reference to the given string and assigns it to the EksClusterCaCert field.
func (o *DynamicSecretUpdateEks) SetEksClusterCaCert(v string) {
	o.EksClusterCaCert = &v
}

// GetEksClusterEndpoint returns the EksClusterEndpoint field value if set, zero value otherwise.
func (o *DynamicSecretUpdateEks) GetEksClusterEndpoint() string {
	if o == nil || o.EksClusterEndpoint == nil {
		var ret string
		return ret
	}
	return *o.EksClusterEndpoint
}

// GetEksClusterEndpointOk returns a tuple with the EksClusterEndpoint field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateEks) GetEksClusterEndpointOk() (*string, bool) {
	if o == nil || o.EksClusterEndpoint == nil {
		return nil, false
	}
	return o.EksClusterEndpoint, true
}

// HasEksClusterEndpoint returns a boolean if a field has been set.
func (o *DynamicSecretUpdateEks) HasEksClusterEndpoint() bool {
	if o != nil && o.EksClusterEndpoint != nil {
		return true
	}

	return false
}

// SetEksClusterEndpoint gets a reference to the given string and assigns it to the EksClusterEndpoint field.
func (o *DynamicSecretUpdateEks) SetEksClusterEndpoint(v string) {
	o.EksClusterEndpoint = &v
}

// GetEksClusterName returns the EksClusterName field value if set, zero value otherwise.
func (o *DynamicSecretUpdateEks) GetEksClusterName() string {
	if o == nil || o.EksClusterName == nil {
		var ret string
		return ret
	}
	return *o.EksClusterName
}

// GetEksClusterNameOk returns a tuple with the EksClusterName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateEks) GetEksClusterNameOk() (*string, bool) {
	if o == nil || o.EksClusterName == nil {
		return nil, false
	}
	return o.EksClusterName, true
}

// HasEksClusterName returns a boolean if a field has been set.
func (o *DynamicSecretUpdateEks) HasEksClusterName() bool {
	if o != nil && o.EksClusterName != nil {
		return true
	}

	return false
}

// SetEksClusterName gets a reference to the given string and assigns it to the EksClusterName field.
func (o *DynamicSecretUpdateEks) SetEksClusterName(v string) {
	o.EksClusterName = &v
}

// GetEksRegion returns the EksRegion field value if set, zero value otherwise.
func (o *DynamicSecretUpdateEks) GetEksRegion() string {
	if o == nil || o.EksRegion == nil {
		var ret string
		return ret
	}
	return *o.EksRegion
}

// GetEksRegionOk returns a tuple with the EksRegion field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateEks) GetEksRegionOk() (*string, bool) {
	if o == nil || o.EksRegion == nil {
		return nil, false
	}
	return o.EksRegion, true
}

// HasEksRegion returns a boolean if a field has been set.
func (o *DynamicSecretUpdateEks) HasEksRegion() bool {
	if o != nil && o.EksRegion != nil {
		return true
	}

	return false
}

// SetEksRegion gets a reference to the given string and assigns it to the EksRegion field.
func (o *DynamicSecretUpdateEks) SetEksRegion(v string) {
	o.EksRegion = &v
}

// GetEksSecretAccessKey returns the EksSecretAccessKey field value if set, zero value otherwise.
func (o *DynamicSecretUpdateEks) GetEksSecretAccessKey() string {
	if o == nil || o.EksSecretAccessKey == nil {
		var ret string
		return ret
	}
	return *o.EksSecretAccessKey
}

// GetEksSecretAccessKeyOk returns a tuple with the EksSecretAccessKey field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateEks) GetEksSecretAccessKeyOk() (*string, bool) {
	if o == nil || o.EksSecretAccessKey == nil {
		return nil, false
	}
	return o.EksSecretAccessKey, true
}

// HasEksSecretAccessKey returns a boolean if a field has been set.
func (o *DynamicSecretUpdateEks) HasEksSecretAccessKey() bool {
	if o != nil && o.EksSecretAccessKey != nil {
		return true
	}

	return false
}

// SetEksSecretAccessKey gets a reference to the given string and assigns it to the EksSecretAccessKey field.
func (o *DynamicSecretUpdateEks) SetEksSecretAccessKey(v string) {
	o.EksSecretAccessKey = &v
}

// GetJson returns the Json field value if set, zero value otherwise.
func (o *DynamicSecretUpdateEks) GetJson() bool {
	if o == nil || o.Json == nil {
		var ret bool
		return ret
	}
	return *o.Json
}

// GetJsonOk returns a tuple with the Json field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateEks) GetJsonOk() (*bool, bool) {
	if o == nil || o.Json == nil {
		return nil, false
	}
	return o.Json, true
}

// HasJson returns a boolean if a field has been set.
func (o *DynamicSecretUpdateEks) HasJson() bool {
	if o != nil && o.Json != nil {
		return true
	}

	return false
}

// SetJson gets a reference to the given bool and assigns it to the Json field.
func (o *DynamicSecretUpdateEks) SetJson(v bool) {
	o.Json = &v
}

// GetName returns the Name field value
func (o *DynamicSecretUpdateEks) GetName() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.Name
}

// GetNameOk returns a tuple with the Name field value
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateEks) GetNameOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.Name, true
}

// SetName sets field value
func (o *DynamicSecretUpdateEks) SetName(v string) {
	o.Name = v
}

// GetNewName returns the NewName field value if set, zero value otherwise.
func (o *DynamicSecretUpdateEks) GetNewName() string {
	if o == nil || o.NewName == nil {
		var ret string
		return ret
	}
	return *o.NewName
}

// GetNewNameOk returns a tuple with the NewName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateEks) GetNewNameOk() (*string, bool) {
	if o == nil || o.NewName == nil {
		return nil, false
	}
	return o.NewName, true
}

// HasNewName returns a boolean if a field has been set.
func (o *DynamicSecretUpdateEks) HasNewName() bool {
	if o != nil && o.NewName != nil {
		return true
	}

	return false
}

// SetNewName gets a reference to the given string and assigns it to the NewName field.
func (o *DynamicSecretUpdateEks) SetNewName(v string) {
	o.NewName = &v
}

// GetProducerEncryptionKeyName returns the ProducerEncryptionKeyName field value if set, zero value otherwise.
func (o *DynamicSecretUpdateEks) GetProducerEncryptionKeyName() string {
	if o == nil || o.ProducerEncryptionKeyName == nil {
		var ret string
		return ret
	}
	return *o.ProducerEncryptionKeyName
}

// GetProducerEncryptionKeyNameOk returns a tuple with the ProducerEncryptionKeyName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateEks) GetProducerEncryptionKeyNameOk() (*string, bool) {
	if o == nil || o.ProducerEncryptionKeyName == nil {
		return nil, false
	}
	return o.ProducerEncryptionKeyName, true
}

// HasProducerEncryptionKeyName returns a boolean if a field has been set.
func (o *DynamicSecretUpdateEks) HasProducerEncryptionKeyName() bool {
	if o != nil && o.ProducerEncryptionKeyName != nil {
		return true
	}

	return false
}

// SetProducerEncryptionKeyName gets a reference to the given string and assigns it to the ProducerEncryptionKeyName field.
func (o *DynamicSecretUpdateEks) SetProducerEncryptionKeyName(v string) {
	o.ProducerEncryptionKeyName = &v
}

// GetSecureAccessAllowPortForwading returns the SecureAccessAllowPortForwading field value if set, zero value otherwise.
func (o *DynamicSecretUpdateEks) GetSecureAccessAllowPortForwading() bool {
	if o == nil || o.SecureAccessAllowPortForwading == nil {
		var ret bool
		return ret
	}
	return *o.SecureAccessAllowPortForwading
}

// GetSecureAccessAllowPortForwadingOk returns a tuple with the SecureAccessAllowPortForwading field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateEks) GetSecureAccessAllowPortForwadingOk() (*bool, bool) {
	if o == nil || o.SecureAccessAllowPortForwading == nil {
		return nil, false
	}
	return o.SecureAccessAllowPortForwading, true
}

// HasSecureAccessAllowPortForwading returns a boolean if a field has been set.
func (o *DynamicSecretUpdateEks) HasSecureAccessAllowPortForwading() bool {
	if o != nil && o.SecureAccessAllowPortForwading != nil {
		return true
	}

	return false
}

// SetSecureAccessAllowPortForwading gets a reference to the given bool and assigns it to the SecureAccessAllowPortForwading field.
func (o *DynamicSecretUpdateEks) SetSecureAccessAllowPortForwading(v bool) {
	o.SecureAccessAllowPortForwading = &v
}

// GetSecureAccessBastionIssuer returns the SecureAccessBastionIssuer field value if set, zero value otherwise.
func (o *DynamicSecretUpdateEks) GetSecureAccessBastionIssuer() string {
	if o == nil || o.SecureAccessBastionIssuer == nil {
		var ret string
		return ret
	}
	return *o.SecureAccessBastionIssuer
}

// GetSecureAccessBastionIssuerOk returns a tuple with the SecureAccessBastionIssuer field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateEks) GetSecureAccessBastionIssuerOk() (*string, bool) {
	if o == nil || o.SecureAccessBastionIssuer == nil {
		return nil, false
	}
	return o.SecureAccessBastionIssuer, true
}

// HasSecureAccessBastionIssuer returns a boolean if a field has been set.
func (o *DynamicSecretUpdateEks) HasSecureAccessBastionIssuer() bool {
	if o != nil && o.SecureAccessBastionIssuer != nil {
		return true
	}

	return false
}

// SetSecureAccessBastionIssuer gets a reference to the given string and assigns it to the SecureAccessBastionIssuer field.
func (o *DynamicSecretUpdateEks) SetSecureAccessBastionIssuer(v string) {
	o.SecureAccessBastionIssuer = &v
}

// GetSecureAccessClusterEndpoint returns the SecureAccessClusterEndpoint field value if set, zero value otherwise.
func (o *DynamicSecretUpdateEks) GetSecureAccessClusterEndpoint() string {
	if o == nil || o.SecureAccessClusterEndpoint == nil {
		var ret string
		return ret
	}
	return *o.SecureAccessClusterEndpoint
}

// GetSecureAccessClusterEndpointOk returns a tuple with the SecureAccessClusterEndpoint field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateEks) GetSecureAccessClusterEndpointOk() (*string, bool) {
	if o == nil || o.SecureAccessClusterEndpoint == nil {
		return nil, false
	}
	return o.SecureAccessClusterEndpoint, true
}

// HasSecureAccessClusterEndpoint returns a boolean if a field has been set.
func (o *DynamicSecretUpdateEks) HasSecureAccessClusterEndpoint() bool {
	if o != nil && o.SecureAccessClusterEndpoint != nil {
		return true
	}

	return false
}

// SetSecureAccessClusterEndpoint gets a reference to the given string and assigns it to the SecureAccessClusterEndpoint field.
func (o *DynamicSecretUpdateEks) SetSecureAccessClusterEndpoint(v string) {
	o.SecureAccessClusterEndpoint = &v
}

// GetSecureAccessEnable returns the SecureAccessEnable field value if set, zero value otherwise.
func (o *DynamicSecretUpdateEks) GetSecureAccessEnable() string {
	if o == nil || o.SecureAccessEnable == nil {
		var ret string
		return ret
	}
	return *o.SecureAccessEnable
}

// GetSecureAccessEnableOk returns a tuple with the SecureAccessEnable field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateEks) GetSecureAccessEnableOk() (*string, bool) {
	if o == nil || o.SecureAccessEnable == nil {
		return nil, false
	}
	return o.SecureAccessEnable, true
}

// HasSecureAccessEnable returns a boolean if a field has been set.
func (o *DynamicSecretUpdateEks) HasSecureAccessEnable() bool {
	if o != nil && o.SecureAccessEnable != nil {
		return true
	}

	return false
}

// SetSecureAccessEnable gets a reference to the given string and assigns it to the SecureAccessEnable field.
func (o *DynamicSecretUpdateEks) SetSecureAccessEnable(v string) {
	o.SecureAccessEnable = &v
}

// GetSecureAccessWeb returns the SecureAccessWeb field value if set, zero value otherwise.
func (o *DynamicSecretUpdateEks) GetSecureAccessWeb() bool {
	if o == nil || o.SecureAccessWeb == nil {
		var ret bool
		return ret
	}
	return *o.SecureAccessWeb
}

// GetSecureAccessWebOk returns a tuple with the SecureAccessWeb field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateEks) GetSecureAccessWebOk() (*bool, bool) {
	if o == nil || o.SecureAccessWeb == nil {
		return nil, false
	}
	return o.SecureAccessWeb, true
}

// HasSecureAccessWeb returns a boolean if a field has been set.
func (o *DynamicSecretUpdateEks) HasSecureAccessWeb() bool {
	if o != nil && o.SecureAccessWeb != nil {
		return true
	}

	return false
}

// SetSecureAccessWeb gets a reference to the given bool and assigns it to the SecureAccessWeb field.
func (o *DynamicSecretUpdateEks) SetSecureAccessWeb(v bool) {
	o.SecureAccessWeb = &v
}

// GetTags returns the Tags field value if set, zero value otherwise.
func (o *DynamicSecretUpdateEks) GetTags() []string {
	if o == nil || o.Tags == nil {
		var ret []string
		return ret
	}
	return *o.Tags
}

// GetTagsOk returns a tuple with the Tags field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateEks) GetTagsOk() (*[]string, bool) {
	if o == nil || o.Tags == nil {
		return nil, false
	}
	return o.Tags, true
}

// HasTags returns a boolean if a field has been set.
func (o *DynamicSecretUpdateEks) HasTags() bool {
	if o != nil && o.Tags != nil {
		return true
	}

	return false
}

// SetTags gets a reference to the given []string and assigns it to the Tags field.
func (o *DynamicSecretUpdateEks) SetTags(v []string) {
	o.Tags = &v
}

// GetTargetName returns the TargetName field value if set, zero value otherwise.
func (o *DynamicSecretUpdateEks) GetTargetName() string {
	if o == nil || o.TargetName == nil {
		var ret string
		return ret
	}
	return *o.TargetName
}

// GetTargetNameOk returns a tuple with the TargetName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateEks) GetTargetNameOk() (*string, bool) {
	if o == nil || o.TargetName == nil {
		return nil, false
	}
	return o.TargetName, true
}

// HasTargetName returns a boolean if a field has been set.
func (o *DynamicSecretUpdateEks) HasTargetName() bool {
	if o != nil && o.TargetName != nil {
		return true
	}

	return false
}

// SetTargetName gets a reference to the given string and assigns it to the TargetName field.
func (o *DynamicSecretUpdateEks) SetTargetName(v string) {
	o.TargetName = &v
}

// GetToken returns the Token field value if set, zero value otherwise.
func (o *DynamicSecretUpdateEks) GetToken() string {
	if o == nil || o.Token == nil {
		var ret string
		return ret
	}
	return *o.Token
}

// GetTokenOk returns a tuple with the Token field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateEks) GetTokenOk() (*string, bool) {
	if o == nil || o.Token == nil {
		return nil, false
	}
	return o.Token, true
}

// HasToken returns a boolean if a field has been set.
func (o *DynamicSecretUpdateEks) HasToken() bool {
	if o != nil && o.Token != nil {
		return true
	}

	return false
}

// SetToken gets a reference to the given string and assigns it to the Token field.
func (o *DynamicSecretUpdateEks) SetToken(v string) {
	o.Token = &v
}

// GetUidToken returns the UidToken field value if set, zero value otherwise.
func (o *DynamicSecretUpdateEks) GetUidToken() string {
	if o == nil || o.UidToken == nil {
		var ret string
		return ret
	}
	return *o.UidToken
}

// GetUidTokenOk returns a tuple with the UidToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateEks) GetUidTokenOk() (*string, bool) {
	if o == nil || o.UidToken == nil {
		return nil, false
	}
	return o.UidToken, true
}

// HasUidToken returns a boolean if a field has been set.
func (o *DynamicSecretUpdateEks) HasUidToken() bool {
	if o != nil && o.UidToken != nil {
		return true
	}

	return false
}

// SetUidToken gets a reference to the given string and assigns it to the UidToken field.
func (o *DynamicSecretUpdateEks) SetUidToken(v string) {
	o.UidToken = &v
}

// GetUserTtl returns the UserTtl field value if set, zero value otherwise.
func (o *DynamicSecretUpdateEks) GetUserTtl() string {
	if o == nil || o.UserTtl == nil {
		var ret string
		return ret
	}
	return *o.UserTtl
}

// GetUserTtlOk returns a tuple with the UserTtl field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateEks) GetUserTtlOk() (*string, bool) {
	if o == nil || o.UserTtl == nil {
		return nil, false
	}
	return o.UserTtl, true
}

// HasUserTtl returns a boolean if a field has been set.
func (o *DynamicSecretUpdateEks) HasUserTtl() bool {
	if o != nil && o.UserTtl != nil {
		return true
	}

	return false
}

// SetUserTtl gets a reference to the given string and assigns it to the UserTtl field.
func (o *DynamicSecretUpdateEks) SetUserTtl(v string) {
	o.UserTtl = &v
}

func (o DynamicSecretUpdateEks) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.DeleteProtection != nil {
		toSerialize["delete_protection"] = o.DeleteProtection
	}
	if o.Description != nil {
		toSerialize["description"] = o.Description
	}
	if o.EksAccessKeyId != nil {
		toSerialize["eks-access-key-id"] = o.EksAccessKeyId
	}
	if o.EksAssumeRole != nil {
		toSerialize["eks-assume-role"] = o.EksAssumeRole
	}
	if o.EksClusterCaCert != nil {
		toSerialize["eks-cluster-ca-cert"] = o.EksClusterCaCert
	}
	if o.EksClusterEndpoint != nil {
		toSerialize["eks-cluster-endpoint"] = o.EksClusterEndpoint
	}
	if o.EksClusterName != nil {
		toSerialize["eks-cluster-name"] = o.EksClusterName
	}
	if o.EksRegion != nil {
		toSerialize["eks-region"] = o.EksRegion
	}
	if o.EksSecretAccessKey != nil {
		toSerialize["eks-secret-access-key"] = o.EksSecretAccessKey
	}
	if o.Json != nil {
		toSerialize["json"] = o.Json
	}
	if true {
		toSerialize["name"] = o.Name
	}
	if o.NewName != nil {
		toSerialize["new-name"] = o.NewName
	}
	if o.ProducerEncryptionKeyName != nil {
		toSerialize["producer-encryption-key-name"] = o.ProducerEncryptionKeyName
	}
	if o.SecureAccessAllowPortForwading != nil {
		toSerialize["secure-access-allow-port-forwading"] = o.SecureAccessAllowPortForwading
	}
	if o.SecureAccessBastionIssuer != nil {
		toSerialize["secure-access-bastion-issuer"] = o.SecureAccessBastionIssuer
	}
	if o.SecureAccessClusterEndpoint != nil {
		toSerialize["secure-access-cluster-endpoint"] = o.SecureAccessClusterEndpoint
	}
	if o.SecureAccessEnable != nil {
		toSerialize["secure-access-enable"] = o.SecureAccessEnable
	}
	if o.SecureAccessWeb != nil {
		toSerialize["secure-access-web"] = o.SecureAccessWeb
	}
	if o.Tags != nil {
		toSerialize["tags"] = o.Tags
	}
	if o.TargetName != nil {
		toSerialize["target-name"] = o.TargetName
	}
	if o.Token != nil {
		toSerialize["token"] = o.Token
	}
	if o.UidToken != nil {
		toSerialize["uid-token"] = o.UidToken
	}
	if o.UserTtl != nil {
		toSerialize["user-ttl"] = o.UserTtl
	}
	return json.Marshal(toSerialize)
}

type NullableDynamicSecretUpdateEks struct {
	value *DynamicSecretUpdateEks
	isSet bool
}

func (v NullableDynamicSecretUpdateEks) Get() *DynamicSecretUpdateEks {
	return v.value
}

func (v *NullableDynamicSecretUpdateEks) Set(val *DynamicSecretUpdateEks) {
	v.value = val
	v.isSet = true
}

func (v NullableDynamicSecretUpdateEks) IsSet() bool {
	return v.isSet
}

func (v *NullableDynamicSecretUpdateEks) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableDynamicSecretUpdateEks(val *DynamicSecretUpdateEks) *NullableDynamicSecretUpdateEks {
	return &NullableDynamicSecretUpdateEks{value: val, isSet: true}
}

func (v NullableDynamicSecretUpdateEks) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableDynamicSecretUpdateEks) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


