#ifndef _WAVEENCODER_H_
#define _WAVEENCODER_H_

/***************************************************************************
 *   Copyright (C) 2007 by Sergio Pistone                                  *
 *   sergio_pistone@yahoo.com.ar                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
	#include <config.h>
#endif

#include "output.h"

class WaveEncoder : public Output
{
	public:
		WaveEncoder( std::string path, bool verbose=false );
		~WaveEncoder();

		std::string getPath();
		void setPath( std::string path );
		bool stdoutMode();

		void setVerbose( bool verbose );
		bool isVerbose();

		virtual bool play( Input& input );

	protected:

		virtual bool open( Input& input );
		virtual bool close( Input& input );

		void writeHeader( Input& input );
		void writeNumber( unsigned long number, unsigned long writeSize, bool littleEndian=true );

		unsigned char* m_buffer;

		std::string m_path;
		bool m_verbose;

		FILE* m_file;
		unsigned long m_bytesWritten;
};

#endif
