/********************************************************************
 FileName:      HardwareProfile - 16F1 LPC USB Development Kit.h
 Dependencies:  See INCLUDES section
 Processor:     PIC16F145x USB Microcontrollers
 Hardware:      Low Pin Count USB Development Kit
 Compiler:      Microchip XC8
 Company:       Microchip Technology, Inc.

 Software License Agreement:

 The software supplied herewith by Microchip Technology Incorporated
 (the "Company") for its PIC(R) Microcontroller is intended and
 supplied to you, the Company's customer, for use solely and
 exclusively on Microchip PIC Microcontroller products. The
 software is owned by the Company and/or its supplier, and is
 protected under applicable copyright laws. All rights are reserved.
 Any use in violation of the foregoing restrictions may subject the
 user to criminal sanctions under applicable laws, as well as to
 civil liability for the breach of the terms and conditions of this
 license.

 THIS SOFTWARE IS PROVIDED IN AN "AS IS" CONDITION. NO WARRANTIES,
 WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT NOT LIMITED
 TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. THE COMPANY SHALL NOT,
 IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL OR
 CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.

********************************************************************
 File Description:

 Change History:
  Rev   Date         Description
  1.0   11/19/2004   Initial release
  2.1   02/26/2007   Updated for simplicity and to use common
                     coding style
  2.3   09/15/2008   Broke out each hardware platform into its own
                     "HardwareProfile - xxx.h" file
********************************************************************/

#ifndef HARDWARE_PROFILE_LOW_PIN_COUNT_USB_DEVELOPMENT_KIT_H
#define HARDWARE_PROFILE_LOW_PIN_COUNT_USB_DEVELOPMENT_KIT_H

    //The PIC16F145x devices have an internal oscillator that can be used with USB.
    //However, if this feature is used when the PIC16F1459 is plugged into
    //the original Low Pin Count Development Kit demo board (originally intended
    //for use with the PIC18F14K50 microcontroller), an additional
    //capacitor (of recommended value 1uF to 8uF, ceramic perferred) needs to be
    //soldered onto the PCB, directly on top of/in parallel with the existing
    //capacitor C1 (which is 0.1uF).  Without this modification, the original
    //Low Pin Count Development Kit board has very little total capacitance on
    //the VBUS/VDD net, consisting of only two 0.1uF caps.  For some
    //applications, this amount of capacitance can be sufficient, provided that
    //there are no noise generating sources on the PCB.  In practice, the
    //Low Pin Count Development Kit board has a RS-232 level translator chip (U3)
    //used for UART communication.  This circuit uses a capacitive charge pump for
    //generating positive and negative voltages associated with RS-232 signaling.
    //However, this charge pumping action generates strong noise on the VDD rail,
    //which the 0.1uF capacitors are not large enough to fully suppress.
    //As a result, strong ripple/noise (exceeding 600mV peak to peak, with fast
    //slew rate at times in excess of 2V/us) is present on the VDD net supplying
    //the microcontroller.  When operated in HS+PLL mode with the crystal, the
    //microcontroller is quite tolerant of this VDD ripple/noise, and is able
    //to communicate reliably over the USB connection.  However, when operated in
    //HFINTOSC + PLL mode, the strong VDD rail ripple/noise can inject noise into
    //the oscillator circuit, resulting in higher than normal jitter levels.
    //Therefore, this VDD noise can potentially result in USB packet corruption.
    //This PCB design flaw can be fully avoided by adding additional capacitance
    //(of at least 1uF) in parallel with the existing capacitor C1, thereby
    //smoothing/suppressing the VDD rail ripple/noise generated by the charge
    //pump circuit U3.  When the VDD rail is smooth, the HFINTOSC + PLL with
    //active clock tuning can be used for reliable USB communication.

    #define USE_INTERNAL_OSC  //Make sure to add 1+uF capacitance to VDD net
                                //before uncommenting this option.  See comments
                                //above.

    #if (__XC8_VERSION == 1000)
        #define ACTCON  CRCON   //Compiler workaround, definition was missing in 1.0 release header
    #endif
    /*******************************************************************/
    /******** USB stack hardware selection options *********************/
    /*******************************************************************/
    //This section is the set of definitions required by the MCHPFSUSB
    //  framework.  These definitions tell the firmware what mode it is
    //  running in, and where it can find the results to some information
    //  that the stack needs.
    //These definitions are required by every application developed with
    //  this revision of the MCHPFSUSB framework.  Please review each
    //  option carefully and determine which options are desired/required
    //  for your application.

    //#define USE_SELF_POWER_SENSE_IO	
    #define tris_self_power     TRISAbits.TRISA2    // Input
    #if defined(USE_SELF_POWER_SENSE_IO)
    #define self_power          PORTAbits.RA2
    #else
    #define self_power          1
    #endif

    //#define USE_USB_BUS_SENSE_IO
    #define tris_usb_bus_sense  TRISAbits.TRISA1    // Input
    #if defined(USE_USB_BUS_SENSE_IO)
    #define USB_BUS_SENSE       PORTAbits.RA1
    #else
    #define USB_BUS_SENSE       1
    #endif

    /*******************************************************************/
    /*******************************************************************/
    /*******************************************************************/
    /******** Application specific definitions *************************/
    /*******************************************************************/
    /*******************************************************************/
    /*******************************************************************/


    /** Board definition ***********************************************/
    //These defintions will tell the main() function which board is
    //  currently selected.  This will allow the application to add
    //  the correct configuration bits as wells use the correct
    //  initialization functions for the board.  These defitions are only
    //  required in the stack provided demos.  They are not required in
    //  final application design.

    #define DEMO_BOARD PIC16F1_LPC_USB_DEVELOPMENT_KIT
    #define PIC16F1_LPC_USB_DEVELOPMENT_KIT
    #define CLOCK_FREQ 48000000
    
    /** LED ************************************************************/
    #define mInitAllLEDs()      LATC &= 0xF0; TRISC &= 0xF0;
    
    #define mLED_1              LATCbits.LATC0
    #define mLED_2              LATCbits.LATC1
    #define mLED_3              LATCbits.LATC2
    #define mLED_4              LATCbits.LATC3

    //#define mLED_1              LATCbits.LATC2
    //#define mLED_2              LATCbits.LATC3
    //#define mLED_3              LATCbits.LATC0
    //#define mLED_4              LATCbits.LATC1
    
    #define mGetLED_1()         mLED_1
    #define mGetLED_2()         mLED_2
    #define mGetLED_3()         mLED_3
    #define mGetLED_4()         mLED_4

    #define mLED_1_On()         mLED_1 = 1;
    #define mLED_2_On()         mLED_2 = 1;
    #define mLED_3_On()         mLED_3 = 1;
    #define mLED_4_On()         mLED_4 = 1;
    
    #define mLED_1_Off()        mLED_1 = 0;
    #define mLED_2_Off()        mLED_2 = 0;
    #define mLED_3_Off()        mLED_3 = 0;
    #define mLED_4_Off()        mLED_4 = 0;
    
    #define mLED_1_Toggle()     mLED_1 = !mLED_1;
    #define mLED_2_Toggle()     mLED_2 = !mLED_2;
    #define mLED_3_Toggle()     mLED_3 = !mLED_3;
    #define mLED_4_Toggle()     mLED_4 = !mLED_4;
    
    /** SWITCH *********************************************************/
    #define mInitSwitch2()      //TRISAbits.TRISA3=1
        //only one switch available so double duty
    #define mInitSwitch3()      //TRISAbits.TRISA3=1
    #define sw2                 PORTAbits.RA3
    #define sw3                 PORTAbits.RA3
    #define mInitAllSwitches()  mInitSwitch2();


    /** POT ************************************************************/
    //#define mInitPOT()          {TRISBbits.TRISB4=1;ADCON0=0x29;ADCON1=0xE0;ADCON2=0x00;}
    #define mInitPOT()          { }

    /** I/O pin definitions ********************************************/
    #define INPUT_PIN 1
    #define OUTPUT_PIN 0




#define  UART_PIN   LATBbits.LATB7
#define  TRIS_UART  TRISBbits.TRISB7
#define _XTAL_FREQ   48000000
#endif  //HARDWARE_PROFILE_LOW_PIN_COUNT_USB_DEVELOPMENT_KIT_H
