/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.download.permanentToken;

import com.intellij.indexing.shared.download.permanentToken.PermanentTokenConnectionTestKt;
import com.intellij.indexing.shared.download.permanentToken.PermanentTokenEnsureParams;
import com.intellij.indexing.shared.download.permanentToken.PermanentTokenWrapper;
import com.intellij.indexing.shared.message.SharedIndexesBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0006\u0010\u0011\u001a\u00020\u0010J\u000e\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u000eJ\u0010\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u000eH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/indexing/shared/download/permanentToken/SharedIndexAuthPermanentNotifications;", "Lcom/intellij/openapi/Disposable;", "wrapper", "Lcom/intellij/indexing/shared/download/permanentToken/PermanentTokenWrapper;", "<init>", "(Lcom/intellij/indexing/shared/download/permanentToken/PermanentTokenWrapper;)V", "getWrapper", "()Lcom/intellij/indexing/shared/download/permanentToken/PermanentTokenWrapper;", "myAllowToAsk", "Ljava/util/concurrent/atomic/AtomicBoolean;", "myPendingNotification", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/notification/Notification;", "myLatestCallback", "Lcom/intellij/indexing/shared/download/permanentToken/PermanentTokenEnsureParams;", "dispose", "", "ensureNotificationPossible", "showNotification", "request", "askForToken", "intellij.indexing.shared"})
public final class SharedIndexAuthPermanentNotifications
implements Disposable {
    @NotNull
    private final PermanentTokenWrapper wrapper;
    @NotNull
    private final AtomicBoolean myAllowToAsk;
    @NotNull
    private final AtomicReference<Notification> myPendingNotification;
    @NotNull
    private final AtomicReference<PermanentTokenEnsureParams> myLatestCallback;

    public SharedIndexAuthPermanentNotifications(@NotNull PermanentTokenWrapper wrapper) {
        Intrinsics.checkNotNullParameter((Object)wrapper, (String)"wrapper");
        this.wrapper = wrapper;
        this.myAllowToAsk = new AtomicBoolean(true);
        this.myPendingNotification = new AtomicReference<Object>(null);
        this.myLatestCallback = new AtomicReference<Object>(null);
    }

    @NotNull
    public final PermanentTokenWrapper getWrapper() {
        return this.wrapper;
    }

    public void dispose() {
        Notification notification = this.myPendingNotification.getAndSet(null);
        if (notification != null) {
            notification.expire();
        }
        this.myLatestCallback.set(null);
    }

    public final void ensureNotificationPossible() {
        this.myAllowToAsk.set(true);
    }

    public final void showNotification(@NotNull PermanentTokenEnsureParams request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (Disposer.isDisposed((Disposable)request.getLifetime())) {
            return;
        }
        NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("Shared Indexes User Action Response or Request");
        String string = SharedIndexesBundle.message("notification.title.permanent.auth", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Object[] objectArray = new Object[]{request.getPresentableUrl()};
        String string2 = SharedIndexesBundle.message("notification.content.permanent.auth", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        Notification notification = notificationGroup.createNotification(string, string2, NotificationType.INFORMATION).addAction((AnAction)NotificationAction.createExpiring((String)SharedIndexesBundle.message("notification.action.permanent.enter", new Object[0]), (arg_0, arg_1) -> SharedIndexAuthPermanentNotifications.showNotification$lambda$1((arg_0, arg_1) -> SharedIndexAuthPermanentNotifications.showNotification$lambda$0(this, request, arg_0, arg_1), arg_0, arg_1)));
        Intrinsics.checkNotNullExpressionValue((Object)notification, (String)"addAction(...)");
        Notification notification2 = notification;
        notification2.whenExpired(() -> SharedIndexAuthPermanentNotifications.showNotification$lambda$2(this, notification2));
        if (!this.myPendingNotification.compareAndSet(null, notification2)) {
            return;
        }
        if (!this.myAllowToAsk.compareAndSet(true, false)) {
            return;
        }
        this.myLatestCallback.set(request);
        Disposer.register((Disposable)request.getLifetime(), () -> SharedIndexAuthPermanentNotifications.showNotification$lambda$3(this, request));
        notification2.notify(null);
    }

    private final void askForToken(PermanentTokenEnsureParams request) {
        Object object;
        block5: {
            block4: {
                if (this.myLatestCallback.get() == null) {
                    return;
                }
                object = new Object[]{request.getPresentableUrl()};
                String string = Messages.showInputDialog((String)SharedIndexesBundle.message("message.text.permanent.enter", object), (String)SharedIndexesBundle.message("message.title.permanent.enter", new Object[0]), null);
                if (string == null) break block4;
                object = ((Object)StringsKt.trim((CharSequence)string)).toString();
                if (object != null) break block5;
            }
            return;
        }
        Object text = object;
        this.wrapper.resetToken();
        PermanentTokenConnectionTestKt.testConnectionUnderProgress(request, (String)text, (Function1<? super Boolean, Unit>)((Function1)arg_0 -> SharedIndexAuthPermanentNotifications.askForToken$lambda$5(request, this, (String)text, arg_0)));
    }

    private static final Unit showNotification$lambda$0(SharedIndexAuthPermanentNotifications this$0, PermanentTokenEnsureParams $request, AnActionEvent anActionEvent, Notification notification) {
        this$0.askForToken($request);
        return Unit.INSTANCE;
    }

    private static final void showNotification$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final void showNotification$lambda$2(SharedIndexAuthPermanentNotifications this$0, Notification $notification) {
        this$0.myPendingNotification.compareAndSet($notification, null);
    }

    private static final void showNotification$lambda$3(SharedIndexAuthPermanentNotifications this$0, PermanentTokenEnsureParams $request) {
        this$0.myLatestCallback.compareAndSet($request, null);
    }

    private static final Unit askForToken$lambda$5$lambda$4(SharedIndexAuthPermanentNotifications this$0, PermanentTokenEnsureParams $request) {
        this$0.askForToken($request);
        return Unit.INSTANCE;
    }

    private static final Unit askForToken$lambda$5(PermanentTokenEnsureParams $request, SharedIndexAuthPermanentNotifications this$0, String $text, boolean result) {
        block2: {
            block1: {
                if (result) break block1;
                Object[] objectArray = new Object[]{$request.getPresentableUrl()};
                int retry = Messages.showYesNoDialog((String)SharedIndexesBundle.message("message.text.permanent.enter.error", objectArray), (String)SharedIndexesBundle.message("message.title.permanent.enter", new Object[0]), null);
                if (retry == 0) {
                    ActionsKt.invokeLater$default(null, () -> SharedIndexAuthPermanentNotifications.askForToken$lambda$5$lambda$4(this$0, $request), (int)1, null);
                    return Unit.INSTANCE;
                }
                break block2;
            }
            this$0.myAllowToAsk.set(true);
            this$0.wrapper.setToken($text);
            PermanentTokenEnsureParams permanentTokenEnsureParams = this$0.myLatestCallback.getAndSet(null);
            if (permanentTokenEnsureParams == null) break block2;
            permanentTokenEnsureParams.notifyTokenUpdated();
        }
        return Unit.INSTANCE;
    }
}

