/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.client.ClientKind;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.client.ClientSessionsUtil;
import com.intellij.openapi.client.ClientSystemInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.Strings;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.FontComboBox;
import com.intellij.ui.FontInfoRenderer;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.ui.TextFieldWithHistoryWithBrowseButton;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.TextFieldWithHistoryWithBrowseButtonKt;
import com.intellij.ui.layout.ComponentPredicate;
import com.intellij.util.ui.UiScopeKt;
import java.awt.Color;
import java.awt.Component;
import java.lang.invoke.LambdaMetafactory;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.TerminalBundle;
import org.jetbrains.plugins.terminal.TerminalOptionsConfigurable;
import org.jetbrains.plugins.terminal.TerminalProjectOptionsProvider;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000r\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001a\u0010\u0002\u001a\u00020\u0003*\u00020\u00042\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002\u001aE\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\t0\b\"\b\b\u0000\u0010\t*\u00020\n*\b\u0012\u0004\u0012\u0002H\t0\b2\u0017\u0010\u000b\u001a\u0013\u0012\u0004\u0012\u0002H\t\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0002\b\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u0002\u001a \u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\b*\b\u0012\u0004\u0012\u00020\u00110\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u001a\b\u0010\u0014\u001a\u00020\u0015H\u0002\u001a\b\u0010\u0016\u001a\u00020\u0017H\u0002\u001a\b\u0010\u0018\u001a\u00020\u0017H\u0002\u001a!\u0010\u0019\u001a\u00020\u00172\u0012\u0010\u001a\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u001b\"\u00020\u0001H\u0002\u00a2\u0006\u0002\u0010\u001c\u001a\b\u0010\u001d\u001a\u00020\u001eH\u0002\u001a\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u001a\u0010\u0010!\u001a\u00020 2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u001a\u0012\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\"\u0010\u0010\u0000\u001a\u00020\u00018\u0006X\u0087T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"TERMINAL_CONFIGURABLE_ID", "", "configurables", "", "Lcom/intellij/ui/dsl/builder/Panel;", "", "Lcom/intellij/openapi/options/UnnamedConfigurable;", "setupDefaultValue", "Lcom/intellij/ui/dsl/builder/Cell;", "T", "Ljavax/swing/JComponent;", "textComponent", "Lkotlin/Function1;", "Ljavax/swing/JTextField;", "Lkotlin/ExtensionFunctionType;", "defaultValue", "setupShellField", "Lcom/intellij/ui/TextFieldWithHistoryWithBrowseButton;", "project", "Lcom/intellij/openapi/project/Project;", "newUiPredicate", "Lcom/intellij/ui/layout/ComponentPredicate;", "getDefaultValueColor", "Ljava/awt/Color;", "getChangedValueColor", "findColorByKey", "colorKeys", "", "([Ljava/lang/String;)Ljava/awt/Color;", "fontComboBox", "Lcom/intellij/ui/FontComboBox;", "isMac", "", "isWindows", "getClientSystemInfo", "Lcom/intellij/openapi/client/ClientSystemInfo;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.terminal"})
@SourceDebugExtension(value={"SMAP\nTerminalOptionsConfigurable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalOptionsConfigurable.kt\norg/jetbrains/plugins/terminal/TerminalOptionsConfigurableKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,474:1\n1#2:475\n14#3:476\n*S KotlinDebug\n*F\n+ 1 TerminalOptionsConfigurable.kt\norg/jetbrains/plugins/terminal/TerminalOptionsConfigurableKt\n*L\n473#1:476\n*E\n"})
public final class TerminalOptionsConfigurableKt {
    @ApiStatus.Internal
    @NotNull
    public static final String TERMINAL_CONFIGURABLE_ID = "terminal";
    @NotNull
    private static final Logger LOG;

    private static final void configurables(Panel $this$configurables, List<? extends UnnamedConfigurable> configurables) {
        for (UnnamedConfigurable unnamedConfigurable : configurables) {
            JComponent component2;
            if (unnamedConfigurable.createComponent() == null) continue;
            Panel.row$default((Panel)$this$configurables, null, arg_0 -> TerminalOptionsConfigurableKt.configurables$lambda$3(component2, unnamedConfigurable, arg_0), (int)1, null);
        }
    }

    private static final <T extends JComponent> Cell<T> setupDefaultValue(Cell<? extends T> $this$setupDefaultValue, Function1<? super T, ? extends JTextField> textComponent, String defaultValue) {
        Cell<? extends T> cell;
        Cell<? extends T> $this$setupDefaultValue_u24lambda_u245 = cell = $this$setupDefaultValue;
        boolean bl = false;
        CharSequence charSequence = defaultValue;
        if (!(charSequence == null || charSequence.length() == 0)) {
            JTextField component2 = (JTextField)textComponent.invoke((Object)$this$setupDefaultValue_u24lambda_u245.getComponent());
            Function0 updateForeground = () -> TerminalOptionsConfigurableKt.setupDefaultValue$lambda$5$lambda$4(component2, defaultValue);
            component2.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter((Function0<Unit>)updateForeground){
                final /* synthetic */ Function0<Unit> $updateForeground;
                {
                    this.$updateForeground = $updateForeground;
                }

                protected void textChanged(DocumentEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    this.$updateForeground.invoke();
                }
            });
            updateForeground.invoke();
            if (component2 instanceof JBTextField) {
                ((JBTextField)component2).getEmptyText().setText(defaultValue);
            }
        }
        return cell;
    }

    private static final Cell<TextFieldWithHistoryWithBrowseButton> setupShellField(Cell<? extends TextFieldWithHistoryWithBrowseButton> $this$setupShellField, Project project) {
        Cell<? extends TextFieldWithHistoryWithBrowseButton> cell;
        Cell<? extends TextFieldWithHistoryWithBrowseButton> $this$setupShellField_u24lambda_u248 = cell = $this$setupShellField;
        boolean bl = false;
        Cell<? extends TextFieldWithHistoryWithBrowseButton> cell2 = $this$setupShellField_u24lambda_u248;
        JTextField jTextField = ((TextFieldWithHistory)((TextFieldWithHistoryWithBrowseButton)$this$setupShellField_u24lambda_u248.getComponent()).getChildComponent()).getTextEditor();
        Intrinsics.checkNotNullExpressionValue((Object)jTextField, (String)"getTextEditor(...)");
        JTextField textEditor = jTextField;
        if (textEditor instanceof JBTextField) {
            ((JBTextField)textEditor).getEmptyText().setText(TerminalBundle.message("settings.shell.path.detecting.default", new Object[0]));
        }
        TerminalProjectOptionsProvider projectOptionsProvider = TerminalProjectOptionsProvider.Companion.getInstance(project);
        AtomicReference<String> defaultShellPathRef = new AtomicReference<String>();
        UiScopeKt.launchOnceOnShow$default((Component)$this$setupShellField_u24lambda_u248.getComponent(), (String)"Terminal (default shell path detection)", null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(textEditor, cell2, projectOptionsProvider, defaultShellPathRef, null){
            int label;
            final /* synthetic */ JTextField $textEditor;
            final /* synthetic */ Cell<TextFieldWithHistoryWithBrowseButton> $cell;
            final /* synthetic */ TerminalProjectOptionsProvider $projectOptionsProvider;
            final /* synthetic */ AtomicReference<String> $defaultShellPathRef;
            {
                this.$textEditor = $textEditor;
                this.$cell = $cell;
                this.$projectOptionsProvider = $projectOptionsProvider;
                this.$defaultShellPathRef = $defaultShellPathRef;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        v0 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getDefault()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super String>, Object>(this.$projectOptionsProvider, this.$defaultShellPathRef, null){
                            int label;
                            final /* synthetic */ TerminalProjectOptionsProvider $projectOptionsProvider;
                            final /* synthetic */ AtomicReference<String> $defaultShellPathRef;
                            {
                                this.$projectOptionsProvider = $projectOptionsProvider;
                                this.$defaultShellPathRef = $defaultShellPathRef;
                                super(2, $completion);
                            }

                            /*
                             * Unable to fully structure code
                             */
                            public final Object invokeSuspend(Object $result) {
                                var11_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        this.label = 1;
                                        v0 = this.$projectOptionsProvider.defaultShellPath((Continuation<? super String>)((Continuation)this));
                                        ** if (v0 != var11_2) goto lbl11
lbl10:
                                        // 1 sources

                                        return var11_2;
lbl11:
                                        // 1 sources

                                        ** GOTO lbl17
                                    }
                                    case 1: {
                                        try {
                                            ResultKt.throwOnFailure((Object)$result);
                                            v0 = $result;
lbl17:
                                            // 2 sources

                                            var2_3 = v0;
                                            var3_4 = this.$defaultShellPathRef;
                                            it = (String)var2_3;
                                            $i$a$-also-TerminalOptionsConfigurableKt$setupShellField$1$1$defaultShellPath$1$1 = false;
                                            var3_4.set(it);
                                            $this$debug_u24default$iv = TerminalOptionsConfigurableKt.access$getLOG$p();
                                            e$iv = null;
                                            $i$f$debug = false;
                                            if ($this$debug_u24default$iv.isDebugEnabled()) {
                                                var9_12 = $this$debug_u24default$iv;
                                                $i$a$-debug$default-TerminalOptionsConfigurableKt$setupShellField$1$1$defaultShellPath$1$1$1 = false;
                                                var9_12.debug("Detected default shell path: " + it, e$iv);
                                            }
                                            var2_3 = (String)var2_3;
                                        }
                                        catch (Exception e) {
                                            $i$f$currentCoroutineContext = false;
                                            JobKt.ensureActive((CoroutineContext)this.getContext());
                                            TerminalOptionsConfigurableKt.access$getLOG$p().warn("Cannot determine default shell path", (Throwable)e);
                                            var2_3 = null;
                                        }
                                        return var2_3;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super String> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (v0 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        defaultShellPath = (String)v0;
                        if (this.$textEditor instanceof JBTextField) {
                            ((JBTextField)this.$textEditor).getEmptyText().clear();
                        }
                        if (defaultShellPath != null) {
                            v1 = this.$textEditor.getText();
                            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getText(...)");
                            if (((CharSequence)v1).length() == 0) {
                                this.$textEditor.setText(defaultShellPath);
                            }
                        }
                        TerminalOptionsConfigurableKt.access$setupDefaultValue(this.$cell, (Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, invokeSuspend$lambda$0(com.intellij.ui.TextFieldWithHistoryWithBrowseButton ), (Lcom/intellij/ui/TextFieldWithHistoryWithBrowseButton;)Ljavax/swing/JTextField;)(), defaultShellPath);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final JTextField invokeSuspend$lambda$0(TextFieldWithHistoryWithBrowseButton $this$setupDefaultValue) {
                JTextField jTextField = ((TextFieldWithHistory)$this$setupDefaultValue.getChildComponent()).getTextEditor();
                Intrinsics.checkNotNullExpressionValue((Object)jTextField, (String)"getTextEditor(...)");
                return jTextField;
            }
        }), (int)2, null);
        TextFieldWithHistoryWithBrowseButtonKt.bindText(cell2, () -> TerminalOptionsConfigurableKt.setupShellField$lambda$8$lambda$6(projectOptionsProvider, defaultShellPathRef), arg_0 -> TerminalOptionsConfigurableKt.setupShellField$lambda$8$lambda$7(projectOptionsProvider, defaultShellPathRef, arg_0));
        return cell;
    }

    private static final ComponentPredicate newUiPredicate() {
        return ExperimentalUI.Companion.isNewUI() ? ComponentPredicate.Companion.getTRUE() : ComponentPredicate.Companion.getFALSE();
    }

    private static final Color getDefaultValueColor() {
        String[] stringArray = new String[]{"TextField.inactiveForeground", "nimbusDisabledText"};
        return TerminalOptionsConfigurableKt.findColorByKey(stringArray);
    }

    private static final Color getChangedValueColor() {
        String[] stringArray = new String[]{"TextField.foreground"};
        return TerminalOptionsConfigurableKt.findColorByKey(stringArray);
    }

    private static final Color findColorByKey(String ... colorKeys) {
        Color color;
        block3: {
            for (String it : colorKeys) {
                boolean bl = false;
                color = UIManager.getColor(it);
                if (color == null) {
                    continue;
                }
                break block3;
            }
            color = null;
        }
        if (color == null) {
            String string = Arrays.toString(colorKeys);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            throw new IllegalStateException("Can't find color for keys " + string);
        }
        return color;
    }

    private static final FontComboBox fontComboBox() {
        FontComboBox fontComboBox2;
        FontComboBox $this$fontComboBox_u24lambda_u2410 = fontComboBox2 = new FontComboBox();
        boolean bl = false;
        $this$fontComboBox_u24lambda_u2410.setRenderer((ListCellRenderer)new FontInfoRenderer(){

            protected boolean isEditorFont() {
                return true;
            }
        });
        $this$fontComboBox_u24lambda_u2410.setMonospacedOnly(true);
        return fontComboBox2;
    }

    private static final boolean isMac(Project project) {
        Object object = TerminalOptionsConfigurableKt.getClientSystemInfo(project);
        return object != null && (object = object.getMacClient()) != null ? (Boolean)object : SystemInfo.isMac;
    }

    private static final boolean isWindows(Project project) {
        Object object = TerminalOptionsConfigurableKt.getClientSystemInfo(project);
        return object != null && (object = object.getWindowsClient()) != null ? (Boolean)object : SystemInfo.isWindows;
    }

    private static final ClientSystemInfo getClientSystemInfo(Project project) {
        ClientProjectSession clientProjectSession = (ClientProjectSession)CollectionsKt.singleOrNull((List)ClientSessionsUtil.sessions((Project)project, (ClientKind)ClientKind.CONTROLLER));
        if (clientProjectSession == null || (clientProjectSession = clientProjectSession.getClientId()) == null) {
            return null;
        }
        ClientProjectSession clientId = clientProjectSession;
        return (ClientSystemInfo)ClientId.Companion.withExplicitClientId((ClientId)clientId, TerminalOptionsConfigurableKt::getClientSystemInfo$lambda$11);
    }

    private static final Unit configurables$lambda$3$lambda$0(UnnamedConfigurable $configurable) {
        try {
            $configurable.apply();
        }
        catch (Exception e) {
            LOG.warn("Terminal configurable " + $configurable + " threw an exception on apply", (Throwable)e);
        }
        return Unit.INSTANCE;
    }

    private static final Unit configurables$lambda$3$lambda$1(UnnamedConfigurable $configurable) {
        try {
            $configurable.reset();
        }
        catch (Exception e) {
            LOG.warn("Terminal configurable " + $configurable + " threw an exception on reset", (Throwable)e);
        }
        return Unit.INSTANCE;
    }

    private static final boolean configurables$lambda$3$lambda$2(UnnamedConfigurable $configurable) {
        return $configurable.isModified();
    }

    private static final Unit configurables$lambda$3(JComponent $component, UnnamedConfigurable $configurable, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell($component).onApply(() -> TerminalOptionsConfigurableKt.configurables$lambda$3$lambda$0($configurable)).onReset(() -> TerminalOptionsConfigurableKt.configurables$lambda$3$lambda$1($configurable)).onIsModified(() -> TerminalOptionsConfigurableKt.configurables$lambda$3$lambda$2($configurable));
        return Unit.INSTANCE;
    }

    private static final Unit setupDefaultValue$lambda$5$lambda$4(JTextField $component, String $defaultValue) {
        $component.setForeground(Intrinsics.areEqual((Object)$component.getText(), (Object)$defaultValue) ? TerminalOptionsConfigurableKt.getDefaultValueColor() : TerminalOptionsConfigurableKt.getChangedValueColor());
        return Unit.INSTANCE;
    }

    private static final String setupShellField$lambda$8$lambda$6(TerminalProjectOptionsProvider $projectOptionsProvider, AtomicReference $defaultShellPathRef) {
        String string = $projectOptionsProvider.getShellPathWithoutDefault$intellij_terminal();
        if (string == null && (string = (String)$defaultShellPathRef.get()) == null) {
            string = "";
        }
        return string;
    }

    private static final Unit setupShellField$lambda$8$lambda$7(TerminalProjectOptionsProvider $projectOptionsProvider, AtomicReference $defaultShellPathRef, String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        $projectOptionsProvider.setShellPathWithoutDefault$intellij_terminal(Strings.nullize((String)value, (String)((String)$defaultShellPathRef.get())));
        return Unit.INSTANCE;
    }

    private static final ClientSystemInfo getClientSystemInfo$lambda$11() {
        return ClientSystemInfo.Companion.getInstance();
    }

    public static final /* synthetic */ void access$configurables(Panel $receiver, List configurables) {
        TerminalOptionsConfigurableKt.configurables($receiver, configurables);
    }

    public static final /* synthetic */ Cell access$setupDefaultValue(Cell $receiver, Function1 textComponent, String defaultValue) {
        return TerminalOptionsConfigurableKt.setupDefaultValue($receiver, textComponent, defaultValue);
    }

    public static final /* synthetic */ FontComboBox access$fontComboBox() {
        return TerminalOptionsConfigurableKt.fontComboBox();
    }

    public static final /* synthetic */ Cell access$setupShellField(Cell $receiver, Project project) {
        return TerminalOptionsConfigurableKt.setupShellField((Cell<? extends TextFieldWithHistoryWithBrowseButton>)$receiver, project);
    }

    public static final /* synthetic */ boolean access$isMac(Project project) {
        return TerminalOptionsConfigurableKt.isMac(project);
    }

    public static final /* synthetic */ boolean access$isWindows(Project project) {
        return TerminalOptionsConfigurableKt.isWindows(project);
    }

    public static final /* synthetic */ ComponentPredicate access$newUiPredicate() {
        return TerminalOptionsConfigurableKt.newUiPredicate();
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(TerminalOptionsConfigurable.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

