<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/src/go/collectors/go.d.plugin/modules/adaptecraid/README.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/src/go/collectors/go.d.plugin/modules/adaptecraid/metadata.yaml"
sidebar_label: "Adaptec RAID"
learn_status: "Published"
learn_rel_path: "Collecting Metrics/Storage, Mount Points and Filesystems"
most_popular: False
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# Adaptec RAID


<img src="https://netdata.cloud/img/adaptec.svg" width="150"/>


Plugin: go.d.plugin
Module: adaptec_raid

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

Monitors the health of Adaptec Hardware RAID by tracking the status of logical and physical devices in your storage system.
It relies on the `arcconf` CLI tool but avoids directly executing the binary.
Instead, it utilizes `ndsudo`, a Netdata helper specifically designed to run privileged commands securely within the Netdata environment.
This approach eliminates the need to use `sudo`, improving security and potentially simplifying permission management.

Executed commands:
-  `arcconf GETCONFIG 1 LD`
-  `arcconf GETCONFIG 1 PD`




This collector is supported on all platforms.

This collector only supports collecting metrics from a single instance of this integration.


### Default Behavior

#### Auto-Detection

This integration doesn't support auto-detection.

#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

The default configuration for this integration is not expected to impose a significant performance impact on the system.


## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.



### Per logical device

These metrics refer to the Logical Device (LD).

Labels:

| Label      | Description     |
|:-----------|:----------------|
| ld_number | Logical device index number |
| ld_name | Logical device name |
| raid_level | RAID level |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| adaptecraid.logical_device_status | ok, critical | status |

### Per physical device

These metrics refer to the Physical Device (PD).

Labels:

| Label      | Description     |
|:-----------|:----------------|
| pd_number | Physical device index number |
| location | Physical device location (e.g. Connector 0, Device 1) |
| vendor | Physical device vendor |
| model | Physical device model |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| adaptecraid.physical_device_state | ok, critical | status |
| adaptecraid.physical_device_smart_warnings | smart | warnings |
| adaptecraid.physical_device_temperature | temperature | Celsius |



## Alerts


The following alerts are available:

| Alert name  | On metric | Description |
|:------------|:----------|:------------|
| [ adaptec_raid_ld_health_status ](https://github.com/netdata/netdata/blob/master/src/health/health.d/adaptec_raid.conf) | adaptecraid.logical_device_status | Adaptec RAID logical device (number ${label:ld_number} name ${label:ld_name}) health status is critical |
| [ adaptec_raid_pd_health_state ](https://github.com/netdata/netdata/blob/master/src/health/health.d/adaptec_raid.conf) | adaptecraid.physical_device_state | Adaptec RAID physical device (number ${label:pd_number} location ${label:location}) health state is critical |


## Setup

### Prerequisites

No action required.

### Configuration

#### File

The configuration file name for this integration is `go.d/adaptec_raid.conf`.


You can edit the configuration file using the `edit-config` script from the
Netdata [config directory](/docs/netdata-agent/configuration/README.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config go.d/adaptec_raid.conf
```
#### Options

The following options can be defined globally: update_every.


<details open><summary>Config options</summary>

| Name | Description | Default | Required |
|:----|:-----------|:-------|:--------:|
| update_every | Data collection frequency. | 10 | no |
| timeout | arcconf binary execution timeout. | 2 | no |

</details>

#### Examples

##### Custom update_every

Allows you to override the default data collection interval.

<details open><summary>Config</summary>

```yaml
jobs:
  - name: adaptec_raid
    update_every: 5  # Collect Adaptec Hardware RAID statistics every 5 seconds

```
</details>



## Troubleshooting

### Debug Mode

To troubleshoot issues with the `adaptec_raid` collector, run the `go.d.plugin` with the debug option enabled. The output
should give you clues as to why the collector isn't working.

- Navigate to the `plugins.d` directory, usually at `/usr/libexec/netdata/plugins.d/`. If that's not the case on
  your system, open `netdata.conf` and look for the `plugins` setting under `[directories]`.

  ```bash
  cd /usr/libexec/netdata/plugins.d/
  ```

- Switch to the `netdata` user.

  ```bash
  sudo -u netdata -s
  ```

- Run the `go.d.plugin` to debug the collector:

  ```bash
  ./go.d.plugin -d -m adaptec_raid
  ```


