<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/src/collectors/python.d.plugin/beanstalk/README.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/src/collectors/python.d.plugin/beanstalk/metadata.yaml"
sidebar_label: "Beanstalk"
learn_status: "Published"
learn_rel_path: "Collecting Metrics/Message Brokers"
most_popular: False
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# Beanstalk


<img src="https://netdata.cloud/img/beanstalk.svg" width="150"/>


Plugin: python.d.plugin
Module: beanstalk

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

Monitor Beanstalk metrics to enhance job queueing and processing efficiency. Track job rates, processing times, and queue lengths for better task management.

The collector uses the `beanstalkc` python module to connect to a `beanstalkd` service and gather metrics.

This collector is supported on all platforms.

This collector supports collecting metrics from multiple instances of this integration, including remote instances.


### Default Behavior

#### Auto-Detection

If no configuration is given, module will attempt to connect to beanstalkd on 127.0.0.1:11300 address.

#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

The default configuration for this integration is not expected to impose a significant performance impact on the system.


## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.



### Per Beanstalk instance

These metrics refer to the entire monitored application.

This scope has no labels.

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| beanstalk.cpu_usage | user, system | cpu time |
| beanstalk.jobs_rate | total, timeouts | jobs/s |
| beanstalk.connections_rate | connections | connections/s |
| beanstalk.commands_rate | put, peek, peek-ready, peek-delayed, peek-buried, reserve, use, watch, ignore, delete, bury, kick, stats, stats-job, stats-tube, list-tubes, list-tube-used, list-tubes-watched, pause-tube | commands/s |
| beanstalk.current_tubes | tubes | tubes |
| beanstalk.current_jobs | urgent, ready, reserved, delayed, buried | jobs |
| beanstalk.current_connections | written, producers, workers, waiting | connections |
| beanstalk.binlog | written, migrated | records/s |
| beanstalk.uptime | uptime | seconds |

### Per tube

Metrics related to Beanstalk tubes. Each tube produces its own set of the following metrics.

This scope has no labels.

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| beanstalk.jobs_rate | jobs | jobs/s |
| beanstalk.jobs | urgent, ready, reserved, delayed, buried | jobs |
| beanstalk.connections | using, waiting, watching | connections |
| beanstalk.commands | deletes, pauses | commands/s |
| beanstalk.pause | since, left | seconds |



## Alerts


The following alerts are available:

| Alert name  | On metric | Description |
|:------------|:----------|:------------|
| [ beanstalk_server_buried_jobs ](https://github.com/netdata/netdata/blob/master/src/health/health.d/beanstalkd.conf) | beanstalk.current_jobs | number of buried jobs across all tubes. You need to manually kick them so they can be processed. Presence of buried jobs in a tube does not affect new jobs. |


## Setup

### Prerequisites

#### beanstalkc python module

The collector requires the `beanstalkc` python module to be installed.


### Configuration

#### File

The configuration file name for this integration is `python.d/beanstalk.conf`.


You can edit the configuration file using the `edit-config` script from the
Netdata [config directory](/docs/netdata-agent/configuration/README.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config python.d/beanstalk.conf
```
#### Options

There are 2 sections:

* Global variables
* One or more JOBS that can define multiple different instances to monitor.

The following options can be defined globally: priority, penalty, autodetection_retry, update_every, but can also be defined per JOB to override the global values.

Additionally, the following collapsed table contains all the options that can be configured inside a JOB definition.

Every configuration JOB starts with a `job_name` value which will appear in the dashboard, unless a `name` parameter is specified.


<details open><summary>Config options</summary>

| Name | Description | Default | Required |
|:----|:-----------|:-------|:--------:|
| update_every | Sets the default data collection frequency. | 5 | no |
| priority | Controls the order of charts at the netdata dashboard. | 60000 | no |
| autodetection_retry | Sets the job re-check interval in seconds. | 0 | no |
| penalty | Indicates whether to apply penalty to update_every in case of failures. | yes | no |
| name | Job name. This value will overwrite the `job_name` value. JOBS with the same name are mutually exclusive. Only one of them will be allowed running at any time. This allows autodetection to try several alternatives and pick the one that works. |  | no |
| host | IP or URL to a beanstalk service. | 127.0.0.1 | no |
| port | Port to the IP or URL to a beanstalk service. | 11300 | no |

</details>

#### Examples

##### Remote beanstalk server

A basic remote beanstalk server

```yaml
remote:
  name: 'beanstalk'
  host: '1.2.3.4'
  port: 11300

```
##### Multi-instance

> **Note**: When you define multiple jobs, their names must be unique.

Collecting metrics from local and remote instances.


<details open><summary>Config</summary>

```yaml
localhost:
  name: 'local_beanstalk'
  host: '127.0.0.1'
  port: 11300

remote_job:
  name: 'remote_beanstalk'
  host: '192.0.2.1'
  port: 113000

```
</details>



## Troubleshooting

### Debug Mode

To troubleshoot issues with the `beanstalk` collector, run the `python.d.plugin` with the debug option enabled. The output
should give you clues as to why the collector isn't working.

- Navigate to the `plugins.d` directory, usually at `/usr/libexec/netdata/plugins.d/`. If that's not the case on
  your system, open `netdata.conf` and look for the `plugins` setting under `[directories]`.

  ```bash
  cd /usr/libexec/netdata/plugins.d/
  ```

- Switch to the `netdata` user.

  ```bash
  sudo -u netdata -s
  ```

- Run the `python.d.plugin` to debug the collector:

  ```bash
  ./python.d.plugin beanstalk debug trace
  ```


