<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/src/go/collectors/go.d.plugin/modules/k8s_state/README.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/src/go/collectors/go.d.plugin/modules/k8s_state/metadata.yaml"
sidebar_label: "Kubernetes Cluster State"
learn_status: "Published"
learn_rel_path: "Collecting Metrics/Kubernetes"
most_popular: True
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# Kubernetes Cluster State


<img src="https://netdata.cloud/img/kubernetes.svg" width="150"/>


Plugin: go.d.plugin
Module: k8s_state

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

This collector monitors Kubernetes Nodes, Pods and Containers.




This collector is supported on all platforms.

This collector only supports collecting metrics from a single instance of this integration.


### Default Behavior

#### Auto-Detection

This integration doesn't support auto-detection.

#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

The default configuration for this integration is not expected to impose a significant performance impact on the system.


## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.



### Per node

These metrics refer to the Node.

Labels:

| Label      | Description     |
|:-----------|:----------------|
| k8s_cluster_id | Cluster ID. This is equal to the kube-system namespace UID. |
| k8s_cluster_name | Cluster name. Cluster name discovery only works in GKE. |
| k8s_node_name | Node name. |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| k8s_state.node_allocatable_cpu_requests_utilization | requests | % |
| k8s_state.node_allocatable_cpu_requests_used | requests | millicpu |
| k8s_state.node_allocatable_cpu_limits_utilization | limits | % |
| k8s_state.node_allocatable_cpu_limits_used | limits | millicpu |
| k8s_state.node_allocatable_mem_requests_utilization | requests | % |
| k8s_state.node_allocatable_mem_requests_used | requests | bytes |
| k8s_state.node_allocatable_mem_limits_utilization | limits | % |
| k8s_state.node_allocatable_mem_limits_used | limits | bytes |
| k8s_state.node_allocatable_pods_utilization | allocated | % |
| k8s_state.node_allocatable_pods_usage | available, allocated | pods |
| k8s_state.node_condition | a dimension per condition | status |
| k8s_state.node_schedulability | schedulable, unschedulable | state |
| k8s_state.node_pods_readiness | ready | % |
| k8s_state.node_pods_readiness_state | ready, unready | pods |
| k8s_state.node_pods_condition | pod_ready, pod_scheduled, pod_initialized, containers_ready | pods |
| k8s_state.node_pods_phase | running, failed, succeeded, pending | pods |
| k8s_state.node_containers | containers, init_containers | containers |
| k8s_state.node_containers_state | running, waiting, terminated | containers |
| k8s_state.node_init_containers_state | running, waiting, terminated | containers |
| k8s_state.node_age | age | seconds |

### Per pod

These metrics refer to the Pod.

Labels:

| Label      | Description     |
|:-----------|:----------------|
| k8s_cluster_id | Cluster ID. This is equal to the kube-system namespace UID. |
| k8s_cluster_name | Cluster name. Cluster name discovery only works in GKE. |
| k8s_node_name | Node name. |
| k8s_namespace | Namespace. |
| k8s_controller_kind | Controller kind (ReplicaSet, DaemonSet, StatefulSet, Job, etc.). |
| k8s_controller_name | Controller name. |
| k8s_pod_name | Pod name. |
| k8s_qos_class | Pod QOS class (burstable, guaranteed, besteffort). |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| k8s_state.pod_cpu_requests_used | requests | millicpu |
| k8s_state.pod_cpu_limits_used | limits | millicpu |
| k8s_state.pod_mem_requests_used | requests | bytes |
| k8s_state.pod_mem_limits_used | limits | bytes |
| k8s_state.pod_condition | pod_ready, pod_scheduled, pod_initialized, containers_ready | state |
| k8s_state.pod_phase | running, failed, succeeded, pending | state |
| k8s_state.pod_age | age | seconds |
| k8s_state.pod_containers | containers, init_containers | containers |
| k8s_state.pod_containers_state | running, waiting, terminated | containers |
| k8s_state.pod_init_containers_state | running, waiting, terminated | containers |

### Per container

These metrics refer to the Pod container.

Labels:

| Label      | Description     |
|:-----------|:----------------|
| k8s_cluster_id | Cluster ID. This is equal to the kube-system namespace UID. |
| k8s_cluster_name | Cluster name. Cluster name discovery only works in GKE. |
| k8s_node_name | Node name. |
| k8s_namespace | Namespace. |
| k8s_controller_kind | Controller kind (ReplicaSet, DaemonSet, StatefulSet, Job, etc.). |
| k8s_controller_name | Controller name. |
| k8s_pod_name | Pod name. |
| k8s_qos_class | Pod QOS class (burstable, guaranteed, besteffort). |
| k8s_container_name | Container name. |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| k8s_state.pod_container_readiness_state | ready | state |
| k8s_state.pod_container_restarts | restarts | restarts |
| k8s_state.pod_container_state | running, waiting, terminated | state |
| k8s_state.pod_container_waiting_state_reason | a dimension per reason | state |
| k8s_state.pod_container_terminated_state_reason | a dimension per reason | state |



## Alerts

There are no alerts configured by default for this integration.


## Setup

### Prerequisites

No action required.

### Configuration

#### File

The configuration file name for this integration is `go.d/k8s_state.conf`.


You can edit the configuration file using the `edit-config` script from the
Netdata [config directory](/docs/netdata-agent/configuration/README.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config go.d/k8s_state.conf
```
#### Options



There are no configuration options.

#### Examples
There are no configuration examples.



## Troubleshooting

### Debug Mode

To troubleshoot issues with the `k8s_state` collector, run the `go.d.plugin` with the debug option enabled. The output
should give you clues as to why the collector isn't working.

- Navigate to the `plugins.d` directory, usually at `/usr/libexec/netdata/plugins.d/`. If that's not the case on
  your system, open `netdata.conf` and look for the `plugins` setting under `[directories]`.

  ```bash
  cd /usr/libexec/netdata/plugins.d/
  ```

- Switch to the `netdata` user.

  ```bash
  sudo -u netdata -s
  ```

- Run the `go.d.plugin` to debug the collector:

  ```bash
  ./go.d.plugin -d -m k8s_state
  ```


