// bbppp.hh for bbppp - a ppp connection manager for Blackbox
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
// (See the included file COPYING / GPL-2.0)
//


#ifndef __MAIN_HH
#define __MAIN_HH

#include "Image.hh"
#include "Basewindow.hh"
#include "resource.hh"
#include "pppstat.hh"


#define LEFT_BUTTON 1
#define MIDDLE_BUTTON 2
#define RIGHT_BUTTON 3

class Resource;
class BaseResource;
class Basewindow;
class PPPStat;


struct PIXMAP
{
	Pixmap 	frame;
	Pixmap	pppUpLabel;
	Pixmap  thruputLabel;
	Pixmap	button;
	Pixmap  button_pressed;
};

struct GEOM
{
	int height;
	int width;
	int x;
	int y;
};


class ToolWindow :public Basewindow
{
public:
	ToolWindow(int argc,char **argv,struct CMDOPTIONS *options);
	~ToolWindow(void);

	XGCValues gcv;
	GC frameGC;
	GC switchGC;
	GC txGC;
	GC rxGC;

	Window framewin;        // the main window holding it all together
	Window pppUpLabelwin;   // displays uptime for ppp link
	Window thruputLabelwin; // displays aggregate throughput rate over link in kb/s
	Window switchwin;       // button to push that brings ppp up or takes it down
	Window txwin;           // lights up when transmitting over link
	Window rxwin;           // ditto for receiving
	Resource *resource;     // basic info on windows, textures, etc
	int hour,minute,sec;    // uptime, displayed in pppUpLabelwin
	float tpRate;           // thruput rate, displayed in thruputLabelwin

	void MakeWindow(bool);
	void CheckDate(bool);
	void EventLoop(void);
	void reconfigure(void);
	void Redraw(void);

protected:
	virtual void process_event(XEvent *);

private:
	bool raised;
	PIXMAP  pixmap;
	GEOM frame;
	GEOM pppUpLabel;
	GEOM thruputLabel;
	GEOM button;
	GEOM switchlight,txlight,rxlight;
	bool ppp_up;
	PPPStat *pppstatus;
	int numButtons;  // number of buttons in window (compact=1, normal=3)
}
;

#endif /* __MAIN_HH */
