// Autogenerated from https://www.unicode.org/Public/15.0.0/ucd/

pub fn isBasicLatin(cp: u21) bool {
    if (cp > 0x7f) return false;

    return switch (cp) {
        0x0...0x7f => true,
        else => false,
    };
}

pub fn isLatin1Supplement(cp: u21) bool {
    if (cp < 0x80 or cp > 0xff) return false;

    return switch (cp) {
        0x80...0xff => true,
        else => false,
    };
}

pub fn isLatinExtendedA(cp: u21) bool {
    if (cp < 0x100 or cp > 0x17f) return false;

    return switch (cp) {
        0x100...0x17f => true,
        else => false,
    };
}

pub fn isLatinExtendedB(cp: u21) bool {
    if (cp < 0x180 or cp > 0x24f) return false;

    return switch (cp) {
        0x180...0x24f => true,
        else => false,
    };
}

pub fn isIpaExtensions(cp: u21) bool {
    if (cp < 0x250 or cp > 0x2af) return false;

    return switch (cp) {
        0x250...0x2af => true,
        else => false,
    };
}

pub fn isSpacingModifierLetters(cp: u21) bool {
    if (cp < 0x2b0 or cp > 0x2ff) return false;

    return switch (cp) {
        0x2b0...0x2ff => true,
        else => false,
    };
}

pub fn isCombiningDiacriticalMarks(cp: u21) bool {
    if (cp < 0x300 or cp > 0x36f) return false;

    return switch (cp) {
        0x300...0x36f => true,
        else => false,
    };
}

pub fn isGreekAndCoptic(cp: u21) bool {
    if (cp < 0x370 or cp > 0x3ff) return false;

    return switch (cp) {
        0x370...0x3ff => true,
        else => false,
    };
}

pub fn isCyrillic(cp: u21) bool {
    if (cp < 0x400 or cp > 0x4ff) return false;

    return switch (cp) {
        0x400...0x4ff => true,
        else => false,
    };
}

pub fn isCyrillicSupplement(cp: u21) bool {
    if (cp < 0x500 or cp > 0x52f) return false;

    return switch (cp) {
        0x500...0x52f => true,
        else => false,
    };
}

pub fn isArmenian(cp: u21) bool {
    if (cp < 0x530 or cp > 0x58f) return false;

    return switch (cp) {
        0x530...0x58f => true,
        else => false,
    };
}

pub fn isHebrew(cp: u21) bool {
    if (cp < 0x590 or cp > 0x5ff) return false;

    return switch (cp) {
        0x590...0x5ff => true,
        else => false,
    };
}

pub fn isArabic(cp: u21) bool {
    if (cp < 0x600 or cp > 0x6ff) return false;

    return switch (cp) {
        0x600...0x6ff => true,
        else => false,
    };
}

pub fn isSyriac(cp: u21) bool {
    if (cp < 0x700 or cp > 0x74f) return false;

    return switch (cp) {
        0x700...0x74f => true,
        else => false,
    };
}

pub fn isArabicSupplement(cp: u21) bool {
    if (cp < 0x750 or cp > 0x77f) return false;

    return switch (cp) {
        0x750...0x77f => true,
        else => false,
    };
}

pub fn isThaana(cp: u21) bool {
    if (cp < 0x780 or cp > 0x7bf) return false;

    return switch (cp) {
        0x780...0x7bf => true,
        else => false,
    };
}

pub fn isNko(cp: u21) bool {
    if (cp < 0x7c0 or cp > 0x7ff) return false;

    return switch (cp) {
        0x7c0...0x7ff => true,
        else => false,
    };
}

pub fn isSamaritan(cp: u21) bool {
    if (cp < 0x800 or cp > 0x83f) return false;

    return switch (cp) {
        0x800...0x83f => true,
        else => false,
    };
}

pub fn isMandaic(cp: u21) bool {
    if (cp < 0x840 or cp > 0x85f) return false;

    return switch (cp) {
        0x840...0x85f => true,
        else => false,
    };
}

pub fn isSyriacSupplement(cp: u21) bool {
    if (cp < 0x860 or cp > 0x86f) return false;

    return switch (cp) {
        0x860...0x86f => true,
        else => false,
    };
}

pub fn isArabicExtendedB(cp: u21) bool {
    if (cp < 0x870 or cp > 0x89f) return false;

    return switch (cp) {
        0x870...0x89f => true,
        else => false,
    };
}

pub fn isArabicExtendedA(cp: u21) bool {
    if (cp < 0x8a0 or cp > 0x8ff) return false;

    return switch (cp) {
        0x8a0...0x8ff => true,
        else => false,
    };
}

pub fn isDevanagari(cp: u21) bool {
    if (cp < 0x900 or cp > 0x97f) return false;

    return switch (cp) {
        0x900...0x97f => true,
        else => false,
    };
}

pub fn isBengali(cp: u21) bool {
    if (cp < 0x980 or cp > 0x9ff) return false;

    return switch (cp) {
        0x980...0x9ff => true,
        else => false,
    };
}

pub fn isGurmukhi(cp: u21) bool {
    if (cp < 0xa00 or cp > 0xa7f) return false;

    return switch (cp) {
        0xa00...0xa7f => true,
        else => false,
    };
}

pub fn isGujarati(cp: u21) bool {
    if (cp < 0xa80 or cp > 0xaff) return false;

    return switch (cp) {
        0xa80...0xaff => true,
        else => false,
    };
}

pub fn isOriya(cp: u21) bool {
    if (cp < 0xb00 or cp > 0xb7f) return false;

    return switch (cp) {
        0xb00...0xb7f => true,
        else => false,
    };
}

pub fn isTamil(cp: u21) bool {
    if (cp < 0xb80 or cp > 0xbff) return false;

    return switch (cp) {
        0xb80...0xbff => true,
        else => false,
    };
}

pub fn isTelugu(cp: u21) bool {
    if (cp < 0xc00 or cp > 0xc7f) return false;

    return switch (cp) {
        0xc00...0xc7f => true,
        else => false,
    };
}

pub fn isKannada(cp: u21) bool {
    if (cp < 0xc80 or cp > 0xcff) return false;

    return switch (cp) {
        0xc80...0xcff => true,
        else => false,
    };
}

pub fn isMalayalam(cp: u21) bool {
    if (cp < 0xd00 or cp > 0xd7f) return false;

    return switch (cp) {
        0xd00...0xd7f => true,
        else => false,
    };
}

pub fn isSinhala(cp: u21) bool {
    if (cp < 0xd80 or cp > 0xdff) return false;

    return switch (cp) {
        0xd80...0xdff => true,
        else => false,
    };
}

pub fn isThai(cp: u21) bool {
    if (cp < 0xe00 or cp > 0xe7f) return false;

    return switch (cp) {
        0xe00...0xe7f => true,
        else => false,
    };
}

pub fn isLao(cp: u21) bool {
    if (cp < 0xe80 or cp > 0xeff) return false;

    return switch (cp) {
        0xe80...0xeff => true,
        else => false,
    };
}

pub fn isTibetan(cp: u21) bool {
    if (cp < 0xf00 or cp > 0xfff) return false;

    return switch (cp) {
        0xf00...0xfff => true,
        else => false,
    };
}

pub fn isMyanmar(cp: u21) bool {
    if (cp < 0x1000 or cp > 0x109f) return false;

    return switch (cp) {
        0x1000...0x109f => true,
        else => false,
    };
}

pub fn isGeorgian(cp: u21) bool {
    if (cp < 0x10a0 or cp > 0x10ff) return false;

    return switch (cp) {
        0x10a0...0x10ff => true,
        else => false,
    };
}

pub fn isHangulJamo(cp: u21) bool {
    if (cp < 0x1100 or cp > 0x11ff) return false;

    return switch (cp) {
        0x1100...0x11ff => true,
        else => false,
    };
}

pub fn isEthiopic(cp: u21) bool {
    if (cp < 0x1200 or cp > 0x137f) return false;

    return switch (cp) {
        0x1200...0x137f => true,
        else => false,
    };
}

pub fn isEthiopicSupplement(cp: u21) bool {
    if (cp < 0x1380 or cp > 0x139f) return false;

    return switch (cp) {
        0x1380...0x139f => true,
        else => false,
    };
}

pub fn isCherokee(cp: u21) bool {
    if (cp < 0x13a0 or cp > 0x13ff) return false;

    return switch (cp) {
        0x13a0...0x13ff => true,
        else => false,
    };
}

pub fn isUnifiedCanadianAboriginalSyllabics(cp: u21) bool {
    if (cp < 0x1400 or cp > 0x167f) return false;

    return switch (cp) {
        0x1400...0x167f => true,
        else => false,
    };
}

pub fn isOgham(cp: u21) bool {
    if (cp < 0x1680 or cp > 0x169f) return false;

    return switch (cp) {
        0x1680...0x169f => true,
        else => false,
    };
}

pub fn isRunic(cp: u21) bool {
    if (cp < 0x16a0 or cp > 0x16ff) return false;

    return switch (cp) {
        0x16a0...0x16ff => true,
        else => false,
    };
}

pub fn isTagalog(cp: u21) bool {
    if (cp < 0x1700 or cp > 0x171f) return false;

    return switch (cp) {
        0x1700...0x171f => true,
        else => false,
    };
}

pub fn isHanunoo(cp: u21) bool {
    if (cp < 0x1720 or cp > 0x173f) return false;

    return switch (cp) {
        0x1720...0x173f => true,
        else => false,
    };
}

pub fn isBuhid(cp: u21) bool {
    if (cp < 0x1740 or cp > 0x175f) return false;

    return switch (cp) {
        0x1740...0x175f => true,
        else => false,
    };
}

pub fn isTagbanwa(cp: u21) bool {
    if (cp < 0x1760 or cp > 0x177f) return false;

    return switch (cp) {
        0x1760...0x177f => true,
        else => false,
    };
}

pub fn isKhmer(cp: u21) bool {
    if (cp < 0x1780 or cp > 0x17ff) return false;

    return switch (cp) {
        0x1780...0x17ff => true,
        else => false,
    };
}

pub fn isMongolian(cp: u21) bool {
    if (cp < 0x1800 or cp > 0x18af) return false;

    return switch (cp) {
        0x1800...0x18af => true,
        else => false,
    };
}

pub fn isUnifiedCanadianAboriginalSyllabicsExtended(cp: u21) bool {
    if (cp < 0x18b0 or cp > 0x18ff) return false;

    return switch (cp) {
        0x18b0...0x18ff => true,
        else => false,
    };
}

pub fn isLimbu(cp: u21) bool {
    if (cp < 0x1900 or cp > 0x194f) return false;

    return switch (cp) {
        0x1900...0x194f => true,
        else => false,
    };
}

pub fn isTaiLe(cp: u21) bool {
    if (cp < 0x1950 or cp > 0x197f) return false;

    return switch (cp) {
        0x1950...0x197f => true,
        else => false,
    };
}

pub fn isNewTaiLue(cp: u21) bool {
    if (cp < 0x1980 or cp > 0x19df) return false;

    return switch (cp) {
        0x1980...0x19df => true,
        else => false,
    };
}

pub fn isKhmerSymbols(cp: u21) bool {
    if (cp < 0x19e0 or cp > 0x19ff) return false;

    return switch (cp) {
        0x19e0...0x19ff => true,
        else => false,
    };
}

pub fn isBuginese(cp: u21) bool {
    if (cp < 0x1a00 or cp > 0x1a1f) return false;

    return switch (cp) {
        0x1a00...0x1a1f => true,
        else => false,
    };
}

pub fn isTaiTham(cp: u21) bool {
    if (cp < 0x1a20 or cp > 0x1aaf) return false;

    return switch (cp) {
        0x1a20...0x1aaf => true,
        else => false,
    };
}

pub fn isCombiningDiacriticalMarksExtended(cp: u21) bool {
    if (cp < 0x1ab0 or cp > 0x1aff) return false;

    return switch (cp) {
        0x1ab0...0x1aff => true,
        else => false,
    };
}

pub fn isBalinese(cp: u21) bool {
    if (cp < 0x1b00 or cp > 0x1b7f) return false;

    return switch (cp) {
        0x1b00...0x1b7f => true,
        else => false,
    };
}

pub fn isSundanese(cp: u21) bool {
    if (cp < 0x1b80 or cp > 0x1bbf) return false;

    return switch (cp) {
        0x1b80...0x1bbf => true,
        else => false,
    };
}

pub fn isBatak(cp: u21) bool {
    if (cp < 0x1bc0 or cp > 0x1bff) return false;

    return switch (cp) {
        0x1bc0...0x1bff => true,
        else => false,
    };
}

pub fn isLepcha(cp: u21) bool {
    if (cp < 0x1c00 or cp > 0x1c4f) return false;

    return switch (cp) {
        0x1c00...0x1c4f => true,
        else => false,
    };
}

pub fn isOlChiki(cp: u21) bool {
    if (cp < 0x1c50 or cp > 0x1c7f) return false;

    return switch (cp) {
        0x1c50...0x1c7f => true,
        else => false,
    };
}

pub fn isCyrillicExtendedC(cp: u21) bool {
    if (cp < 0x1c80 or cp > 0x1c8f) return false;

    return switch (cp) {
        0x1c80...0x1c8f => true,
        else => false,
    };
}

pub fn isGeorgianExtended(cp: u21) bool {
    if (cp < 0x1c90 or cp > 0x1cbf) return false;

    return switch (cp) {
        0x1c90...0x1cbf => true,
        else => false,
    };
}

pub fn isSundaneseSupplement(cp: u21) bool {
    if (cp < 0x1cc0 or cp > 0x1ccf) return false;

    return switch (cp) {
        0x1cc0...0x1ccf => true,
        else => false,
    };
}

pub fn isVedicExtensions(cp: u21) bool {
    if (cp < 0x1cd0 or cp > 0x1cff) return false;

    return switch (cp) {
        0x1cd0...0x1cff => true,
        else => false,
    };
}

pub fn isPhoneticExtensions(cp: u21) bool {
    if (cp < 0x1d00 or cp > 0x1d7f) return false;

    return switch (cp) {
        0x1d00...0x1d7f => true,
        else => false,
    };
}

pub fn isPhoneticExtensionsSupplement(cp: u21) bool {
    if (cp < 0x1d80 or cp > 0x1dbf) return false;

    return switch (cp) {
        0x1d80...0x1dbf => true,
        else => false,
    };
}

pub fn isCombiningDiacriticalMarksSupplement(cp: u21) bool {
    if (cp < 0x1dc0 or cp > 0x1dff) return false;

    return switch (cp) {
        0x1dc0...0x1dff => true,
        else => false,
    };
}

pub fn isLatinExtendedAdditional(cp: u21) bool {
    if (cp < 0x1e00 or cp > 0x1eff) return false;

    return switch (cp) {
        0x1e00...0x1eff => true,
        else => false,
    };
}

pub fn isGreekExtended(cp: u21) bool {
    if (cp < 0x1f00 or cp > 0x1fff) return false;

    return switch (cp) {
        0x1f00...0x1fff => true,
        else => false,
    };
}

pub fn isGeneralPunctuation(cp: u21) bool {
    if (cp < 0x2000 or cp > 0x206f) return false;

    return switch (cp) {
        0x2000...0x206f => true,
        else => false,
    };
}

pub fn isSuperscriptsAndSubscripts(cp: u21) bool {
    if (cp < 0x2070 or cp > 0x209f) return false;

    return switch (cp) {
        0x2070...0x209f => true,
        else => false,
    };
}

pub fn isCurrencySymbols(cp: u21) bool {
    if (cp < 0x20a0 or cp > 0x20cf) return false;

    return switch (cp) {
        0x20a0...0x20cf => true,
        else => false,
    };
}

pub fn isCombiningDiacriticalMarksForSymbols(cp: u21) bool {
    if (cp < 0x20d0 or cp > 0x20ff) return false;

    return switch (cp) {
        0x20d0...0x20ff => true,
        else => false,
    };
}

pub fn isLetterlikeSymbols(cp: u21) bool {
    if (cp < 0x2100 or cp > 0x214f) return false;

    return switch (cp) {
        0x2100...0x214f => true,
        else => false,
    };
}

pub fn isNumberForms(cp: u21) bool {
    if (cp < 0x2150 or cp > 0x218f) return false;

    return switch (cp) {
        0x2150...0x218f => true,
        else => false,
    };
}

pub fn isArrows(cp: u21) bool {
    if (cp < 0x2190 or cp > 0x21ff) return false;

    return switch (cp) {
        0x2190...0x21ff => true,
        else => false,
    };
}

pub fn isMathematicalOperators(cp: u21) bool {
    if (cp < 0x2200 or cp > 0x22ff) return false;

    return switch (cp) {
        0x2200...0x22ff => true,
        else => false,
    };
}

pub fn isMiscellaneousTechnical(cp: u21) bool {
    if (cp < 0x2300 or cp > 0x23ff) return false;

    return switch (cp) {
        0x2300...0x23ff => true,
        else => false,
    };
}

pub fn isControlPictures(cp: u21) bool {
    if (cp < 0x2400 or cp > 0x243f) return false;

    return switch (cp) {
        0x2400...0x243f => true,
        else => false,
    };
}

pub fn isOpticalCharacterRecognition(cp: u21) bool {
    if (cp < 0x2440 or cp > 0x245f) return false;

    return switch (cp) {
        0x2440...0x245f => true,
        else => false,
    };
}

pub fn isEnclosedAlphanumerics(cp: u21) bool {
    if (cp < 0x2460 or cp > 0x24ff) return false;

    return switch (cp) {
        0x2460...0x24ff => true,
        else => false,
    };
}

pub fn isBoxDrawing(cp: u21) bool {
    if (cp < 0x2500 or cp > 0x257f) return false;

    return switch (cp) {
        0x2500...0x257f => true,
        else => false,
    };
}

pub fn isBlockElements(cp: u21) bool {
    if (cp < 0x2580 or cp > 0x259f) return false;

    return switch (cp) {
        0x2580...0x259f => true,
        else => false,
    };
}

pub fn isGeometricShapes(cp: u21) bool {
    if (cp < 0x25a0 or cp > 0x25ff) return false;

    return switch (cp) {
        0x25a0...0x25ff => true,
        else => false,
    };
}

pub fn isMiscellaneousSymbols(cp: u21) bool {
    if (cp < 0x2600 or cp > 0x26ff) return false;

    return switch (cp) {
        0x2600...0x26ff => true,
        else => false,
    };
}

pub fn isDingbats(cp: u21) bool {
    if (cp < 0x2700 or cp > 0x27bf) return false;

    return switch (cp) {
        0x2700...0x27bf => true,
        else => false,
    };
}

pub fn isMiscellaneousMathematicalSymbolsA(cp: u21) bool {
    if (cp < 0x27c0 or cp > 0x27ef) return false;

    return switch (cp) {
        0x27c0...0x27ef => true,
        else => false,
    };
}

pub fn isSupplementalArrowsA(cp: u21) bool {
    if (cp < 0x27f0 or cp > 0x27ff) return false;

    return switch (cp) {
        0x27f0...0x27ff => true,
        else => false,
    };
}

pub fn isBraillePatterns(cp: u21) bool {
    if (cp < 0x2800 or cp > 0x28ff) return false;

    return switch (cp) {
        0x2800...0x28ff => true,
        else => false,
    };
}

pub fn isSupplementalArrowsB(cp: u21) bool {
    if (cp < 0x2900 or cp > 0x297f) return false;

    return switch (cp) {
        0x2900...0x297f => true,
        else => false,
    };
}

pub fn isMiscellaneousMathematicalSymbolsB(cp: u21) bool {
    if (cp < 0x2980 or cp > 0x29ff) return false;

    return switch (cp) {
        0x2980...0x29ff => true,
        else => false,
    };
}

pub fn isSupplementalMathematicalOperators(cp: u21) bool {
    if (cp < 0x2a00 or cp > 0x2aff) return false;

    return switch (cp) {
        0x2a00...0x2aff => true,
        else => false,
    };
}

pub fn isMiscellaneousSymbolsAndArrows(cp: u21) bool {
    if (cp < 0x2b00 or cp > 0x2bff) return false;

    return switch (cp) {
        0x2b00...0x2bff => true,
        else => false,
    };
}

pub fn isGlagolitic(cp: u21) bool {
    if (cp < 0x2c00 or cp > 0x2c5f) return false;

    return switch (cp) {
        0x2c00...0x2c5f => true,
        else => false,
    };
}

pub fn isLatinExtendedC(cp: u21) bool {
    if (cp < 0x2c60 or cp > 0x2c7f) return false;

    return switch (cp) {
        0x2c60...0x2c7f => true,
        else => false,
    };
}

pub fn isCoptic(cp: u21) bool {
    if (cp < 0x2c80 or cp > 0x2cff) return false;

    return switch (cp) {
        0x2c80...0x2cff => true,
        else => false,
    };
}

pub fn isGeorgianSupplement(cp: u21) bool {
    if (cp < 0x2d00 or cp > 0x2d2f) return false;

    return switch (cp) {
        0x2d00...0x2d2f => true,
        else => false,
    };
}

pub fn isTifinagh(cp: u21) bool {
    if (cp < 0x2d30 or cp > 0x2d7f) return false;

    return switch (cp) {
        0x2d30...0x2d7f => true,
        else => false,
    };
}

pub fn isEthiopicExtended(cp: u21) bool {
    if (cp < 0x2d80 or cp > 0x2ddf) return false;

    return switch (cp) {
        0x2d80...0x2ddf => true,
        else => false,
    };
}

pub fn isCyrillicExtendedA(cp: u21) bool {
    if (cp < 0x2de0 or cp > 0x2dff) return false;

    return switch (cp) {
        0x2de0...0x2dff => true,
        else => false,
    };
}

pub fn isSupplementalPunctuation(cp: u21) bool {
    if (cp < 0x2e00 or cp > 0x2e7f) return false;

    return switch (cp) {
        0x2e00...0x2e7f => true,
        else => false,
    };
}

pub fn isCjkRadicalsSupplement(cp: u21) bool {
    if (cp < 0x2e80 or cp > 0x2eff) return false;

    return switch (cp) {
        0x2e80...0x2eff => true,
        else => false,
    };
}

pub fn isKangxiRadicals(cp: u21) bool {
    if (cp < 0x2f00 or cp > 0x2fdf) return false;

    return switch (cp) {
        0x2f00...0x2fdf => true,
        else => false,
    };
}

pub fn isIdeographicDescriptionCharacters(cp: u21) bool {
    if (cp < 0x2ff0 or cp > 0x2fff) return false;

    return switch (cp) {
        0x2ff0...0x2fff => true,
        else => false,
    };
}

pub fn isCjkSymbolsAndPunctuation(cp: u21) bool {
    if (cp < 0x3000 or cp > 0x303f) return false;

    return switch (cp) {
        0x3000...0x303f => true,
        else => false,
    };
}

pub fn isHiragana(cp: u21) bool {
    if (cp < 0x3040 or cp > 0x309f) return false;

    return switch (cp) {
        0x3040...0x309f => true,
        else => false,
    };
}

pub fn isKatakana(cp: u21) bool {
    if (cp < 0x30a0 or cp > 0x30ff) return false;

    return switch (cp) {
        0x30a0...0x30ff => true,
        else => false,
    };
}

pub fn isBopomofo(cp: u21) bool {
    if (cp < 0x3100 or cp > 0x312f) return false;

    return switch (cp) {
        0x3100...0x312f => true,
        else => false,
    };
}

pub fn isHangulCompatibilityJamo(cp: u21) bool {
    if (cp < 0x3130 or cp > 0x318f) return false;

    return switch (cp) {
        0x3130...0x318f => true,
        else => false,
    };
}

pub fn isKanbun(cp: u21) bool {
    if (cp < 0x3190 or cp > 0x319f) return false;

    return switch (cp) {
        0x3190...0x319f => true,
        else => false,
    };
}

pub fn isBopomofoExtended(cp: u21) bool {
    if (cp < 0x31a0 or cp > 0x31bf) return false;

    return switch (cp) {
        0x31a0...0x31bf => true,
        else => false,
    };
}

pub fn isCjkStrokes(cp: u21) bool {
    if (cp < 0x31c0 or cp > 0x31ef) return false;

    return switch (cp) {
        0x31c0...0x31ef => true,
        else => false,
    };
}

pub fn isKatakanaPhoneticExtensions(cp: u21) bool {
    if (cp < 0x31f0 or cp > 0x31ff) return false;

    return switch (cp) {
        0x31f0...0x31ff => true,
        else => false,
    };
}

pub fn isEnclosedCjkLettersAndMonths(cp: u21) bool {
    if (cp < 0x3200 or cp > 0x32ff) return false;

    return switch (cp) {
        0x3200...0x32ff => true,
        else => false,
    };
}

pub fn isCjkCompatibility(cp: u21) bool {
    if (cp < 0x3300 or cp > 0x33ff) return false;

    return switch (cp) {
        0x3300...0x33ff => true,
        else => false,
    };
}

pub fn isCjkUnifiedIdeographsExtensionA(cp: u21) bool {
    if (cp < 0x3400 or cp > 0x4dbf) return false;

    return switch (cp) {
        0x3400...0x4dbf => true,
        else => false,
    };
}

pub fn isYijingHexagramSymbols(cp: u21) bool {
    if (cp < 0x4dc0 or cp > 0x4dff) return false;

    return switch (cp) {
        0x4dc0...0x4dff => true,
        else => false,
    };
}

pub fn isCjkUnifiedIdeographs(cp: u21) bool {
    if (cp < 0x4e00 or cp > 0x9fff) return false;

    return switch (cp) {
        0x4e00...0x9fff => true,
        else => false,
    };
}

pub fn isYiSyllables(cp: u21) bool {
    if (cp < 0xa000 or cp > 0xa48f) return false;

    return switch (cp) {
        0xa000...0xa48f => true,
        else => false,
    };
}

pub fn isYiRadicals(cp: u21) bool {
    if (cp < 0xa490 or cp > 0xa4cf) return false;

    return switch (cp) {
        0xa490...0xa4cf => true,
        else => false,
    };
}

pub fn isLisu(cp: u21) bool {
    if (cp < 0xa4d0 or cp > 0xa4ff) return false;

    return switch (cp) {
        0xa4d0...0xa4ff => true,
        else => false,
    };
}

pub fn isVai(cp: u21) bool {
    if (cp < 0xa500 or cp > 0xa63f) return false;

    return switch (cp) {
        0xa500...0xa63f => true,
        else => false,
    };
}

pub fn isCyrillicExtendedB(cp: u21) bool {
    if (cp < 0xa640 or cp > 0xa69f) return false;

    return switch (cp) {
        0xa640...0xa69f => true,
        else => false,
    };
}

pub fn isBamum(cp: u21) bool {
    if (cp < 0xa6a0 or cp > 0xa6ff) return false;

    return switch (cp) {
        0xa6a0...0xa6ff => true,
        else => false,
    };
}

pub fn isModifierToneLetters(cp: u21) bool {
    if (cp < 0xa700 or cp > 0xa71f) return false;

    return switch (cp) {
        0xa700...0xa71f => true,
        else => false,
    };
}

pub fn isLatinExtendedD(cp: u21) bool {
    if (cp < 0xa720 or cp > 0xa7ff) return false;

    return switch (cp) {
        0xa720...0xa7ff => true,
        else => false,
    };
}

pub fn isSylotiNagri(cp: u21) bool {
    if (cp < 0xa800 or cp > 0xa82f) return false;

    return switch (cp) {
        0xa800...0xa82f => true,
        else => false,
    };
}

pub fn isCommonIndicNumberForms(cp: u21) bool {
    if (cp < 0xa830 or cp > 0xa83f) return false;

    return switch (cp) {
        0xa830...0xa83f => true,
        else => false,
    };
}

pub fn isPhagsPa(cp: u21) bool {
    if (cp < 0xa840 or cp > 0xa87f) return false;

    return switch (cp) {
        0xa840...0xa87f => true,
        else => false,
    };
}

pub fn isSaurashtra(cp: u21) bool {
    if (cp < 0xa880 or cp > 0xa8df) return false;

    return switch (cp) {
        0xa880...0xa8df => true,
        else => false,
    };
}

pub fn isDevanagariExtended(cp: u21) bool {
    if (cp < 0xa8e0 or cp > 0xa8ff) return false;

    return switch (cp) {
        0xa8e0...0xa8ff => true,
        else => false,
    };
}

pub fn isKayahLi(cp: u21) bool {
    if (cp < 0xa900 or cp > 0xa92f) return false;

    return switch (cp) {
        0xa900...0xa92f => true,
        else => false,
    };
}

pub fn isRejang(cp: u21) bool {
    if (cp < 0xa930 or cp > 0xa95f) return false;

    return switch (cp) {
        0xa930...0xa95f => true,
        else => false,
    };
}

pub fn isHangulJamoExtendedA(cp: u21) bool {
    if (cp < 0xa960 or cp > 0xa97f) return false;

    return switch (cp) {
        0xa960...0xa97f => true,
        else => false,
    };
}

pub fn isJavanese(cp: u21) bool {
    if (cp < 0xa980 or cp > 0xa9df) return false;

    return switch (cp) {
        0xa980...0xa9df => true,
        else => false,
    };
}

pub fn isMyanmarExtendedB(cp: u21) bool {
    if (cp < 0xa9e0 or cp > 0xa9ff) return false;

    return switch (cp) {
        0xa9e0...0xa9ff => true,
        else => false,
    };
}

pub fn isCham(cp: u21) bool {
    if (cp < 0xaa00 or cp > 0xaa5f) return false;

    return switch (cp) {
        0xaa00...0xaa5f => true,
        else => false,
    };
}

pub fn isMyanmarExtendedA(cp: u21) bool {
    if (cp < 0xaa60 or cp > 0xaa7f) return false;

    return switch (cp) {
        0xaa60...0xaa7f => true,
        else => false,
    };
}

pub fn isTaiViet(cp: u21) bool {
    if (cp < 0xaa80 or cp > 0xaadf) return false;

    return switch (cp) {
        0xaa80...0xaadf => true,
        else => false,
    };
}

pub fn isMeeteiMayekExtensions(cp: u21) bool {
    if (cp < 0xaae0 or cp > 0xaaff) return false;

    return switch (cp) {
        0xaae0...0xaaff => true,
        else => false,
    };
}

pub fn isEthiopicExtendedA(cp: u21) bool {
    if (cp < 0xab00 or cp > 0xab2f) return false;

    return switch (cp) {
        0xab00...0xab2f => true,
        else => false,
    };
}

pub fn isLatinExtendedE(cp: u21) bool {
    if (cp < 0xab30 or cp > 0xab6f) return false;

    return switch (cp) {
        0xab30...0xab6f => true,
        else => false,
    };
}

pub fn isCherokeeSupplement(cp: u21) bool {
    if (cp < 0xab70 or cp > 0xabbf) return false;

    return switch (cp) {
        0xab70...0xabbf => true,
        else => false,
    };
}

pub fn isMeeteiMayek(cp: u21) bool {
    if (cp < 0xabc0 or cp > 0xabff) return false;

    return switch (cp) {
        0xabc0...0xabff => true,
        else => false,
    };
}

pub fn isHangulSyllables(cp: u21) bool {
    if (cp < 0xac00 or cp > 0xd7af) return false;

    return switch (cp) {
        0xac00...0xd7af => true,
        else => false,
    };
}

pub fn isHangulJamoExtendedB(cp: u21) bool {
    if (cp < 0xd7b0 or cp > 0xd7ff) return false;

    return switch (cp) {
        0xd7b0...0xd7ff => true,
        else => false,
    };
}

pub fn isHighSurrogates(cp: u21) bool {
    if (cp < 0xd800 or cp > 0xdb7f) return false;

    return switch (cp) {
        0xd800...0xdb7f => true,
        else => false,
    };
}

pub fn isHighPrivateUseSurrogates(cp: u21) bool {
    if (cp < 0xdb80 or cp > 0xdbff) return false;

    return switch (cp) {
        0xdb80...0xdbff => true,
        else => false,
    };
}

pub fn isLowSurrogates(cp: u21) bool {
    if (cp < 0xdc00 or cp > 0xdfff) return false;

    return switch (cp) {
        0xdc00...0xdfff => true,
        else => false,
    };
}

pub fn isPrivateUseArea(cp: u21) bool {
    if (cp < 0xe000 or cp > 0xf8ff) return false;

    return switch (cp) {
        0xe000...0xf8ff => true,
        else => false,
    };
}

pub fn isCjkCompatibilityIdeographs(cp: u21) bool {
    if (cp < 0xf900 or cp > 0xfaff) return false;

    return switch (cp) {
        0xf900...0xfaff => true,
        else => false,
    };
}

pub fn isAlphabeticPresentationForms(cp: u21) bool {
    if (cp < 0xfb00 or cp > 0xfb4f) return false;

    return switch (cp) {
        0xfb00...0xfb4f => true,
        else => false,
    };
}

pub fn isArabicPresentationFormsA(cp: u21) bool {
    if (cp < 0xfb50 or cp > 0xfdff) return false;

    return switch (cp) {
        0xfb50...0xfdff => true,
        else => false,
    };
}

pub fn isVariationSelectors(cp: u21) bool {
    if (cp < 0xfe00 or cp > 0xfe0f) return false;

    return switch (cp) {
        0xfe00...0xfe0f => true,
        else => false,
    };
}

pub fn isVerticalForms(cp: u21) bool {
    if (cp < 0xfe10 or cp > 0xfe1f) return false;

    return switch (cp) {
        0xfe10...0xfe1f => true,
        else => false,
    };
}

pub fn isCombiningHalfMarks(cp: u21) bool {
    if (cp < 0xfe20 or cp > 0xfe2f) return false;

    return switch (cp) {
        0xfe20...0xfe2f => true,
        else => false,
    };
}

pub fn isCjkCompatibilityForms(cp: u21) bool {
    if (cp < 0xfe30 or cp > 0xfe4f) return false;

    return switch (cp) {
        0xfe30...0xfe4f => true,
        else => false,
    };
}

pub fn isSmallFormVariants(cp: u21) bool {
    if (cp < 0xfe50 or cp > 0xfe6f) return false;

    return switch (cp) {
        0xfe50...0xfe6f => true,
        else => false,
    };
}

pub fn isArabicPresentationFormsB(cp: u21) bool {
    if (cp < 0xfe70 or cp > 0xfeff) return false;

    return switch (cp) {
        0xfe70...0xfeff => true,
        else => false,
    };
}

pub fn isHalfwidthAndFullwidthForms(cp: u21) bool {
    if (cp < 0xff00 or cp > 0xffef) return false;

    return switch (cp) {
        0xff00...0xffef => true,
        else => false,
    };
}

pub fn isSpecials(cp: u21) bool {
    if (cp < 0xfff0 or cp > 0xffff) return false;

    return switch (cp) {
        0xfff0...0xffff => true,
        else => false,
    };
}

pub fn isLinearBSyllabary(cp: u21) bool {
    if (cp < 0x10000 or cp > 0x1007f) return false;

    return switch (cp) {
        0x10000...0x1007f => true,
        else => false,
    };
}

pub fn isLinearBIdeograms(cp: u21) bool {
    if (cp < 0x10080 or cp > 0x100ff) return false;

    return switch (cp) {
        0x10080...0x100ff => true,
        else => false,
    };
}

pub fn isAegeanNumbers(cp: u21) bool {
    if (cp < 0x10100 or cp > 0x1013f) return false;

    return switch (cp) {
        0x10100...0x1013f => true,
        else => false,
    };
}

pub fn isAncientGreekNumbers(cp: u21) bool {
    if (cp < 0x10140 or cp > 0x1018f) return false;

    return switch (cp) {
        0x10140...0x1018f => true,
        else => false,
    };
}

pub fn isAncientSymbols(cp: u21) bool {
    if (cp < 0x10190 or cp > 0x101cf) return false;

    return switch (cp) {
        0x10190...0x101cf => true,
        else => false,
    };
}

pub fn isPhaistosDisc(cp: u21) bool {
    if (cp < 0x101d0 or cp > 0x101ff) return false;

    return switch (cp) {
        0x101d0...0x101ff => true,
        else => false,
    };
}

pub fn isLycian(cp: u21) bool {
    if (cp < 0x10280 or cp > 0x1029f) return false;

    return switch (cp) {
        0x10280...0x1029f => true,
        else => false,
    };
}

pub fn isCarian(cp: u21) bool {
    if (cp < 0x102a0 or cp > 0x102df) return false;

    return switch (cp) {
        0x102a0...0x102df => true,
        else => false,
    };
}

pub fn isCopticEpactNumbers(cp: u21) bool {
    if (cp < 0x102e0 or cp > 0x102ff) return false;

    return switch (cp) {
        0x102e0...0x102ff => true,
        else => false,
    };
}

pub fn isOldItalic(cp: u21) bool {
    if (cp < 0x10300 or cp > 0x1032f) return false;

    return switch (cp) {
        0x10300...0x1032f => true,
        else => false,
    };
}

pub fn isGothic(cp: u21) bool {
    if (cp < 0x10330 or cp > 0x1034f) return false;

    return switch (cp) {
        0x10330...0x1034f => true,
        else => false,
    };
}

pub fn isOldPermic(cp: u21) bool {
    if (cp < 0x10350 or cp > 0x1037f) return false;

    return switch (cp) {
        0x10350...0x1037f => true,
        else => false,
    };
}

pub fn isUgaritic(cp: u21) bool {
    if (cp < 0x10380 or cp > 0x1039f) return false;

    return switch (cp) {
        0x10380...0x1039f => true,
        else => false,
    };
}

pub fn isOldPersian(cp: u21) bool {
    if (cp < 0x103a0 or cp > 0x103df) return false;

    return switch (cp) {
        0x103a0...0x103df => true,
        else => false,
    };
}

pub fn isDeseret(cp: u21) bool {
    if (cp < 0x10400 or cp > 0x1044f) return false;

    return switch (cp) {
        0x10400...0x1044f => true,
        else => false,
    };
}

pub fn isShavian(cp: u21) bool {
    if (cp < 0x10450 or cp > 0x1047f) return false;

    return switch (cp) {
        0x10450...0x1047f => true,
        else => false,
    };
}

pub fn isOsmanya(cp: u21) bool {
    if (cp < 0x10480 or cp > 0x104af) return false;

    return switch (cp) {
        0x10480...0x104af => true,
        else => false,
    };
}

pub fn isOsage(cp: u21) bool {
    if (cp < 0x104b0 or cp > 0x104ff) return false;

    return switch (cp) {
        0x104b0...0x104ff => true,
        else => false,
    };
}

pub fn isElbasan(cp: u21) bool {
    if (cp < 0x10500 or cp > 0x1052f) return false;

    return switch (cp) {
        0x10500...0x1052f => true,
        else => false,
    };
}

pub fn isCaucasianAlbanian(cp: u21) bool {
    if (cp < 0x10530 or cp > 0x1056f) return false;

    return switch (cp) {
        0x10530...0x1056f => true,
        else => false,
    };
}

pub fn isVithkuqi(cp: u21) bool {
    if (cp < 0x10570 or cp > 0x105bf) return false;

    return switch (cp) {
        0x10570...0x105bf => true,
        else => false,
    };
}

pub fn isLinearA(cp: u21) bool {
    if (cp < 0x10600 or cp > 0x1077f) return false;

    return switch (cp) {
        0x10600...0x1077f => true,
        else => false,
    };
}

pub fn isLatinExtendedF(cp: u21) bool {
    if (cp < 0x10780 or cp > 0x107bf) return false;

    return switch (cp) {
        0x10780...0x107bf => true,
        else => false,
    };
}

pub fn isCypriotSyllabary(cp: u21) bool {
    if (cp < 0x10800 or cp > 0x1083f) return false;

    return switch (cp) {
        0x10800...0x1083f => true,
        else => false,
    };
}

pub fn isImperialAramaic(cp: u21) bool {
    if (cp < 0x10840 or cp > 0x1085f) return false;

    return switch (cp) {
        0x10840...0x1085f => true,
        else => false,
    };
}

pub fn isPalmyrene(cp: u21) bool {
    if (cp < 0x10860 or cp > 0x1087f) return false;

    return switch (cp) {
        0x10860...0x1087f => true,
        else => false,
    };
}

pub fn isNabataean(cp: u21) bool {
    if (cp < 0x10880 or cp > 0x108af) return false;

    return switch (cp) {
        0x10880...0x108af => true,
        else => false,
    };
}

pub fn isHatran(cp: u21) bool {
    if (cp < 0x108e0 or cp > 0x108ff) return false;

    return switch (cp) {
        0x108e0...0x108ff => true,
        else => false,
    };
}

pub fn isPhoenician(cp: u21) bool {
    if (cp < 0x10900 or cp > 0x1091f) return false;

    return switch (cp) {
        0x10900...0x1091f => true,
        else => false,
    };
}

pub fn isLydian(cp: u21) bool {
    if (cp < 0x10920 or cp > 0x1093f) return false;

    return switch (cp) {
        0x10920...0x1093f => true,
        else => false,
    };
}

pub fn isMeroiticHieroglyphs(cp: u21) bool {
    if (cp < 0x10980 or cp > 0x1099f) return false;

    return switch (cp) {
        0x10980...0x1099f => true,
        else => false,
    };
}

pub fn isMeroiticCursive(cp: u21) bool {
    if (cp < 0x109a0 or cp > 0x109ff) return false;

    return switch (cp) {
        0x109a0...0x109ff => true,
        else => false,
    };
}

pub fn isKharoshthi(cp: u21) bool {
    if (cp < 0x10a00 or cp > 0x10a5f) return false;

    return switch (cp) {
        0x10a00...0x10a5f => true,
        else => false,
    };
}

pub fn isOldSouthArabian(cp: u21) bool {
    if (cp < 0x10a60 or cp > 0x10a7f) return false;

    return switch (cp) {
        0x10a60...0x10a7f => true,
        else => false,
    };
}

pub fn isOldNorthArabian(cp: u21) bool {
    if (cp < 0x10a80 or cp > 0x10a9f) return false;

    return switch (cp) {
        0x10a80...0x10a9f => true,
        else => false,
    };
}

pub fn isManichaean(cp: u21) bool {
    if (cp < 0x10ac0 or cp > 0x10aff) return false;

    return switch (cp) {
        0x10ac0...0x10aff => true,
        else => false,
    };
}

pub fn isAvestan(cp: u21) bool {
    if (cp < 0x10b00 or cp > 0x10b3f) return false;

    return switch (cp) {
        0x10b00...0x10b3f => true,
        else => false,
    };
}

pub fn isInscriptionalParthian(cp: u21) bool {
    if (cp < 0x10b40 or cp > 0x10b5f) return false;

    return switch (cp) {
        0x10b40...0x10b5f => true,
        else => false,
    };
}

pub fn isInscriptionalPahlavi(cp: u21) bool {
    if (cp < 0x10b60 or cp > 0x10b7f) return false;

    return switch (cp) {
        0x10b60...0x10b7f => true,
        else => false,
    };
}

pub fn isPsalterPahlavi(cp: u21) bool {
    if (cp < 0x10b80 or cp > 0x10baf) return false;

    return switch (cp) {
        0x10b80...0x10baf => true,
        else => false,
    };
}

pub fn isOldTurkic(cp: u21) bool {
    if (cp < 0x10c00 or cp > 0x10c4f) return false;

    return switch (cp) {
        0x10c00...0x10c4f => true,
        else => false,
    };
}

pub fn isOldHungarian(cp: u21) bool {
    if (cp < 0x10c80 or cp > 0x10cff) return false;

    return switch (cp) {
        0x10c80...0x10cff => true,
        else => false,
    };
}

pub fn isHanifiRohingya(cp: u21) bool {
    if (cp < 0x10d00 or cp > 0x10d3f) return false;

    return switch (cp) {
        0x10d00...0x10d3f => true,
        else => false,
    };
}

pub fn isRumiNumeralSymbols(cp: u21) bool {
    if (cp < 0x10e60 or cp > 0x10e7f) return false;

    return switch (cp) {
        0x10e60...0x10e7f => true,
        else => false,
    };
}

pub fn isYezidi(cp: u21) bool {
    if (cp < 0x10e80 or cp > 0x10ebf) return false;

    return switch (cp) {
        0x10e80...0x10ebf => true,
        else => false,
    };
}

pub fn isArabicExtendedC(cp: u21) bool {
    if (cp < 0x10ec0 or cp > 0x10eff) return false;

    return switch (cp) {
        0x10ec0...0x10eff => true,
        else => false,
    };
}

pub fn isOldSogdian(cp: u21) bool {
    if (cp < 0x10f00 or cp > 0x10f2f) return false;

    return switch (cp) {
        0x10f00...0x10f2f => true,
        else => false,
    };
}

pub fn isSogdian(cp: u21) bool {
    if (cp < 0x10f30 or cp > 0x10f6f) return false;

    return switch (cp) {
        0x10f30...0x10f6f => true,
        else => false,
    };
}

pub fn isOldUyghur(cp: u21) bool {
    if (cp < 0x10f70 or cp > 0x10faf) return false;

    return switch (cp) {
        0x10f70...0x10faf => true,
        else => false,
    };
}

pub fn isChorasmian(cp: u21) bool {
    if (cp < 0x10fb0 or cp > 0x10fdf) return false;

    return switch (cp) {
        0x10fb0...0x10fdf => true,
        else => false,
    };
}

pub fn isElymaic(cp: u21) bool {
    if (cp < 0x10fe0 or cp > 0x10fff) return false;

    return switch (cp) {
        0x10fe0...0x10fff => true,
        else => false,
    };
}

pub fn isBrahmi(cp: u21) bool {
    if (cp < 0x11000 or cp > 0x1107f) return false;

    return switch (cp) {
        0x11000...0x1107f => true,
        else => false,
    };
}

pub fn isKaithi(cp: u21) bool {
    if (cp < 0x11080 or cp > 0x110cf) return false;

    return switch (cp) {
        0x11080...0x110cf => true,
        else => false,
    };
}

pub fn isSoraSompeng(cp: u21) bool {
    if (cp < 0x110d0 or cp > 0x110ff) return false;

    return switch (cp) {
        0x110d0...0x110ff => true,
        else => false,
    };
}

pub fn isChakma(cp: u21) bool {
    if (cp < 0x11100 or cp > 0x1114f) return false;

    return switch (cp) {
        0x11100...0x1114f => true,
        else => false,
    };
}

pub fn isMahajani(cp: u21) bool {
    if (cp < 0x11150 or cp > 0x1117f) return false;

    return switch (cp) {
        0x11150...0x1117f => true,
        else => false,
    };
}

pub fn isSharada(cp: u21) bool {
    if (cp < 0x11180 or cp > 0x111df) return false;

    return switch (cp) {
        0x11180...0x111df => true,
        else => false,
    };
}

pub fn isSinhalaArchaicNumbers(cp: u21) bool {
    if (cp < 0x111e0 or cp > 0x111ff) return false;

    return switch (cp) {
        0x111e0...0x111ff => true,
        else => false,
    };
}

pub fn isKhojki(cp: u21) bool {
    if (cp < 0x11200 or cp > 0x1124f) return false;

    return switch (cp) {
        0x11200...0x1124f => true,
        else => false,
    };
}

pub fn isMultani(cp: u21) bool {
    if (cp < 0x11280 or cp > 0x112af) return false;

    return switch (cp) {
        0x11280...0x112af => true,
        else => false,
    };
}

pub fn isKhudawadi(cp: u21) bool {
    if (cp < 0x112b0 or cp > 0x112ff) return false;

    return switch (cp) {
        0x112b0...0x112ff => true,
        else => false,
    };
}

pub fn isGrantha(cp: u21) bool {
    if (cp < 0x11300 or cp > 0x1137f) return false;

    return switch (cp) {
        0x11300...0x1137f => true,
        else => false,
    };
}

pub fn isNewa(cp: u21) bool {
    if (cp < 0x11400 or cp > 0x1147f) return false;

    return switch (cp) {
        0x11400...0x1147f => true,
        else => false,
    };
}

pub fn isTirhuta(cp: u21) bool {
    if (cp < 0x11480 or cp > 0x114df) return false;

    return switch (cp) {
        0x11480...0x114df => true,
        else => false,
    };
}

pub fn isSiddham(cp: u21) bool {
    if (cp < 0x11580 or cp > 0x115ff) return false;

    return switch (cp) {
        0x11580...0x115ff => true,
        else => false,
    };
}

pub fn isModi(cp: u21) bool {
    if (cp < 0x11600 or cp > 0x1165f) return false;

    return switch (cp) {
        0x11600...0x1165f => true,
        else => false,
    };
}

pub fn isMongolianSupplement(cp: u21) bool {
    if (cp < 0x11660 or cp > 0x1167f) return false;

    return switch (cp) {
        0x11660...0x1167f => true,
        else => false,
    };
}

pub fn isTakri(cp: u21) bool {
    if (cp < 0x11680 or cp > 0x116cf) return false;

    return switch (cp) {
        0x11680...0x116cf => true,
        else => false,
    };
}

pub fn isAhom(cp: u21) bool {
    if (cp < 0x11700 or cp > 0x1174f) return false;

    return switch (cp) {
        0x11700...0x1174f => true,
        else => false,
    };
}

pub fn isDogra(cp: u21) bool {
    if (cp < 0x11800 or cp > 0x1184f) return false;

    return switch (cp) {
        0x11800...0x1184f => true,
        else => false,
    };
}

pub fn isWarangCiti(cp: u21) bool {
    if (cp < 0x118a0 or cp > 0x118ff) return false;

    return switch (cp) {
        0x118a0...0x118ff => true,
        else => false,
    };
}

pub fn isDivesAkuru(cp: u21) bool {
    if (cp < 0x11900 or cp > 0x1195f) return false;

    return switch (cp) {
        0x11900...0x1195f => true,
        else => false,
    };
}

pub fn isNandinagari(cp: u21) bool {
    if (cp < 0x119a0 or cp > 0x119ff) return false;

    return switch (cp) {
        0x119a0...0x119ff => true,
        else => false,
    };
}

pub fn isZanabazarSquare(cp: u21) bool {
    if (cp < 0x11a00 or cp > 0x11a4f) return false;

    return switch (cp) {
        0x11a00...0x11a4f => true,
        else => false,
    };
}

pub fn isSoyombo(cp: u21) bool {
    if (cp < 0x11a50 or cp > 0x11aaf) return false;

    return switch (cp) {
        0x11a50...0x11aaf => true,
        else => false,
    };
}

pub fn isUnifiedCanadianAboriginalSyllabicsExtendedA(cp: u21) bool {
    if (cp < 0x11ab0 or cp > 0x11abf) return false;

    return switch (cp) {
        0x11ab0...0x11abf => true,
        else => false,
    };
}

pub fn isPauCinHau(cp: u21) bool {
    if (cp < 0x11ac0 or cp > 0x11aff) return false;

    return switch (cp) {
        0x11ac0...0x11aff => true,
        else => false,
    };
}

pub fn isDevanagariExtendedA(cp: u21) bool {
    if (cp < 0x11b00 or cp > 0x11b5f) return false;

    return switch (cp) {
        0x11b00...0x11b5f => true,
        else => false,
    };
}

pub fn isBhaiksuki(cp: u21) bool {
    if (cp < 0x11c00 or cp > 0x11c6f) return false;

    return switch (cp) {
        0x11c00...0x11c6f => true,
        else => false,
    };
}

pub fn isMarchen(cp: u21) bool {
    if (cp < 0x11c70 or cp > 0x11cbf) return false;

    return switch (cp) {
        0x11c70...0x11cbf => true,
        else => false,
    };
}

pub fn isMasaramGondi(cp: u21) bool {
    if (cp < 0x11d00 or cp > 0x11d5f) return false;

    return switch (cp) {
        0x11d00...0x11d5f => true,
        else => false,
    };
}

pub fn isGunjalaGondi(cp: u21) bool {
    if (cp < 0x11d60 or cp > 0x11daf) return false;

    return switch (cp) {
        0x11d60...0x11daf => true,
        else => false,
    };
}

pub fn isMakasar(cp: u21) bool {
    if (cp < 0x11ee0 or cp > 0x11eff) return false;

    return switch (cp) {
        0x11ee0...0x11eff => true,
        else => false,
    };
}

pub fn isKawi(cp: u21) bool {
    if (cp < 0x11f00 or cp > 0x11f5f) return false;

    return switch (cp) {
        0x11f00...0x11f5f => true,
        else => false,
    };
}

pub fn isLisuSupplement(cp: u21) bool {
    if (cp < 0x11fb0 or cp > 0x11fbf) return false;

    return switch (cp) {
        0x11fb0...0x11fbf => true,
        else => false,
    };
}

pub fn isTamilSupplement(cp: u21) bool {
    if (cp < 0x11fc0 or cp > 0x11fff) return false;

    return switch (cp) {
        0x11fc0...0x11fff => true,
        else => false,
    };
}

pub fn isCuneiform(cp: u21) bool {
    if (cp < 0x12000 or cp > 0x123ff) return false;

    return switch (cp) {
        0x12000...0x123ff => true,
        else => false,
    };
}

pub fn isCuneiformNumbersAndPunctuation(cp: u21) bool {
    if (cp < 0x12400 or cp > 0x1247f) return false;

    return switch (cp) {
        0x12400...0x1247f => true,
        else => false,
    };
}

pub fn isEarlyDynasticCuneiform(cp: u21) bool {
    if (cp < 0x12480 or cp > 0x1254f) return false;

    return switch (cp) {
        0x12480...0x1254f => true,
        else => false,
    };
}

pub fn isCyproMinoan(cp: u21) bool {
    if (cp < 0x12f90 or cp > 0x12fff) return false;

    return switch (cp) {
        0x12f90...0x12fff => true,
        else => false,
    };
}

pub fn isEgyptianHieroglyphs(cp: u21) bool {
    if (cp < 0x13000 or cp > 0x1342f) return false;

    return switch (cp) {
        0x13000...0x1342f => true,
        else => false,
    };
}

pub fn isEgyptianHieroglyphFormatControls(cp: u21) bool {
    if (cp < 0x13430 or cp > 0x1345f) return false;

    return switch (cp) {
        0x13430...0x1345f => true,
        else => false,
    };
}

pub fn isAnatolianHieroglyphs(cp: u21) bool {
    if (cp < 0x14400 or cp > 0x1467f) return false;

    return switch (cp) {
        0x14400...0x1467f => true,
        else => false,
    };
}

pub fn isBamumSupplement(cp: u21) bool {
    if (cp < 0x16800 or cp > 0x16a3f) return false;

    return switch (cp) {
        0x16800...0x16a3f => true,
        else => false,
    };
}

pub fn isMro(cp: u21) bool {
    if (cp < 0x16a40 or cp > 0x16a6f) return false;

    return switch (cp) {
        0x16a40...0x16a6f => true,
        else => false,
    };
}

pub fn isTangsa(cp: u21) bool {
    if (cp < 0x16a70 or cp > 0x16acf) return false;

    return switch (cp) {
        0x16a70...0x16acf => true,
        else => false,
    };
}

pub fn isBassaVah(cp: u21) bool {
    if (cp < 0x16ad0 or cp > 0x16aff) return false;

    return switch (cp) {
        0x16ad0...0x16aff => true,
        else => false,
    };
}

pub fn isPahawhHmong(cp: u21) bool {
    if (cp < 0x16b00 or cp > 0x16b8f) return false;

    return switch (cp) {
        0x16b00...0x16b8f => true,
        else => false,
    };
}

pub fn isMedefaidrin(cp: u21) bool {
    if (cp < 0x16e40 or cp > 0x16e9f) return false;

    return switch (cp) {
        0x16e40...0x16e9f => true,
        else => false,
    };
}

pub fn isMiao(cp: u21) bool {
    if (cp < 0x16f00 or cp > 0x16f9f) return false;

    return switch (cp) {
        0x16f00...0x16f9f => true,
        else => false,
    };
}

pub fn isIdeographicSymbolsAndPunctuation(cp: u21) bool {
    if (cp < 0x16fe0 or cp > 0x16fff) return false;

    return switch (cp) {
        0x16fe0...0x16fff => true,
        else => false,
    };
}

pub fn isTangut(cp: u21) bool {
    if (cp < 0x17000 or cp > 0x187ff) return false;

    return switch (cp) {
        0x17000...0x187ff => true,
        else => false,
    };
}

pub fn isTangutComponents(cp: u21) bool {
    if (cp < 0x18800 or cp > 0x18aff) return false;

    return switch (cp) {
        0x18800...0x18aff => true,
        else => false,
    };
}

pub fn isKhitanSmallScript(cp: u21) bool {
    if (cp < 0x18b00 or cp > 0x18cff) return false;

    return switch (cp) {
        0x18b00...0x18cff => true,
        else => false,
    };
}

pub fn isTangutSupplement(cp: u21) bool {
    if (cp < 0x18d00 or cp > 0x18d7f) return false;

    return switch (cp) {
        0x18d00...0x18d7f => true,
        else => false,
    };
}

pub fn isKanaExtendedB(cp: u21) bool {
    if (cp < 0x1aff0 or cp > 0x1afff) return false;

    return switch (cp) {
        0x1aff0...0x1afff => true,
        else => false,
    };
}

pub fn isKanaSupplement(cp: u21) bool {
    if (cp < 0x1b000 or cp > 0x1b0ff) return false;

    return switch (cp) {
        0x1b000...0x1b0ff => true,
        else => false,
    };
}

pub fn isKanaExtendedA(cp: u21) bool {
    if (cp < 0x1b100 or cp > 0x1b12f) return false;

    return switch (cp) {
        0x1b100...0x1b12f => true,
        else => false,
    };
}

pub fn isSmallKanaExtension(cp: u21) bool {
    if (cp < 0x1b130 or cp > 0x1b16f) return false;

    return switch (cp) {
        0x1b130...0x1b16f => true,
        else => false,
    };
}

pub fn isNushu(cp: u21) bool {
    if (cp < 0x1b170 or cp > 0x1b2ff) return false;

    return switch (cp) {
        0x1b170...0x1b2ff => true,
        else => false,
    };
}

pub fn isDuployan(cp: u21) bool {
    if (cp < 0x1bc00 or cp > 0x1bc9f) return false;

    return switch (cp) {
        0x1bc00...0x1bc9f => true,
        else => false,
    };
}

pub fn isShorthandFormatControls(cp: u21) bool {
    if (cp < 0x1bca0 or cp > 0x1bcaf) return false;

    return switch (cp) {
        0x1bca0...0x1bcaf => true,
        else => false,
    };
}

pub fn isZnamennyMusicalNotation(cp: u21) bool {
    if (cp < 0x1cf00 or cp > 0x1cfcf) return false;

    return switch (cp) {
        0x1cf00...0x1cfcf => true,
        else => false,
    };
}

pub fn isByzantineMusicalSymbols(cp: u21) bool {
    if (cp < 0x1d000 or cp > 0x1d0ff) return false;

    return switch (cp) {
        0x1d000...0x1d0ff => true,
        else => false,
    };
}

pub fn isMusicalSymbols(cp: u21) bool {
    if (cp < 0x1d100 or cp > 0x1d1ff) return false;

    return switch (cp) {
        0x1d100...0x1d1ff => true,
        else => false,
    };
}

pub fn isAncientGreekMusicalNotation(cp: u21) bool {
    if (cp < 0x1d200 or cp > 0x1d24f) return false;

    return switch (cp) {
        0x1d200...0x1d24f => true,
        else => false,
    };
}

pub fn isKaktovikNumerals(cp: u21) bool {
    if (cp < 0x1d2c0 or cp > 0x1d2df) return false;

    return switch (cp) {
        0x1d2c0...0x1d2df => true,
        else => false,
    };
}

pub fn isMayanNumerals(cp: u21) bool {
    if (cp < 0x1d2e0 or cp > 0x1d2ff) return false;

    return switch (cp) {
        0x1d2e0...0x1d2ff => true,
        else => false,
    };
}

pub fn isTaiXuanJingSymbols(cp: u21) bool {
    if (cp < 0x1d300 or cp > 0x1d35f) return false;

    return switch (cp) {
        0x1d300...0x1d35f => true,
        else => false,
    };
}

pub fn isCountingRodNumerals(cp: u21) bool {
    if (cp < 0x1d360 or cp > 0x1d37f) return false;

    return switch (cp) {
        0x1d360...0x1d37f => true,
        else => false,
    };
}

pub fn isMathematicalAlphanumericSymbols(cp: u21) bool {
    if (cp < 0x1d400 or cp > 0x1d7ff) return false;

    return switch (cp) {
        0x1d400...0x1d7ff => true,
        else => false,
    };
}

pub fn isSuttonSignwriting(cp: u21) bool {
    if (cp < 0x1d800 or cp > 0x1daaf) return false;

    return switch (cp) {
        0x1d800...0x1daaf => true,
        else => false,
    };
}

pub fn isLatinExtendedG(cp: u21) bool {
    if (cp < 0x1df00 or cp > 0x1dfff) return false;

    return switch (cp) {
        0x1df00...0x1dfff => true,
        else => false,
    };
}

pub fn isGlagoliticSupplement(cp: u21) bool {
    if (cp < 0x1e000 or cp > 0x1e02f) return false;

    return switch (cp) {
        0x1e000...0x1e02f => true,
        else => false,
    };
}

pub fn isCyrillicExtendedD(cp: u21) bool {
    if (cp < 0x1e030 or cp > 0x1e08f) return false;

    return switch (cp) {
        0x1e030...0x1e08f => true,
        else => false,
    };
}

pub fn isNyiakengPuachueHmong(cp: u21) bool {
    if (cp < 0x1e100 or cp > 0x1e14f) return false;

    return switch (cp) {
        0x1e100...0x1e14f => true,
        else => false,
    };
}

pub fn isToto(cp: u21) bool {
    if (cp < 0x1e290 or cp > 0x1e2bf) return false;

    return switch (cp) {
        0x1e290...0x1e2bf => true,
        else => false,
    };
}

pub fn isWancho(cp: u21) bool {
    if (cp < 0x1e2c0 or cp > 0x1e2ff) return false;

    return switch (cp) {
        0x1e2c0...0x1e2ff => true,
        else => false,
    };
}

pub fn isNagMundari(cp: u21) bool {
    if (cp < 0x1e4d0 or cp > 0x1e4ff) return false;

    return switch (cp) {
        0x1e4d0...0x1e4ff => true,
        else => false,
    };
}

pub fn isEthiopicExtendedB(cp: u21) bool {
    if (cp < 0x1e7e0 or cp > 0x1e7ff) return false;

    return switch (cp) {
        0x1e7e0...0x1e7ff => true,
        else => false,
    };
}

pub fn isMendeKikakui(cp: u21) bool {
    if (cp < 0x1e800 or cp > 0x1e8df) return false;

    return switch (cp) {
        0x1e800...0x1e8df => true,
        else => false,
    };
}

pub fn isAdlam(cp: u21) bool {
    if (cp < 0x1e900 or cp > 0x1e95f) return false;

    return switch (cp) {
        0x1e900...0x1e95f => true,
        else => false,
    };
}

pub fn isIndicSiyaqNumbers(cp: u21) bool {
    if (cp < 0x1ec70 or cp > 0x1ecbf) return false;

    return switch (cp) {
        0x1ec70...0x1ecbf => true,
        else => false,
    };
}

pub fn isOttomanSiyaqNumbers(cp: u21) bool {
    if (cp < 0x1ed00 or cp > 0x1ed4f) return false;

    return switch (cp) {
        0x1ed00...0x1ed4f => true,
        else => false,
    };
}

pub fn isArabicMathematicalAlphabeticSymbols(cp: u21) bool {
    if (cp < 0x1ee00 or cp > 0x1eeff) return false;

    return switch (cp) {
        0x1ee00...0x1eeff => true,
        else => false,
    };
}

pub fn isMahjongTiles(cp: u21) bool {
    if (cp < 0x1f000 or cp > 0x1f02f) return false;

    return switch (cp) {
        0x1f000...0x1f02f => true,
        else => false,
    };
}

pub fn isDominoTiles(cp: u21) bool {
    if (cp < 0x1f030 or cp > 0x1f09f) return false;

    return switch (cp) {
        0x1f030...0x1f09f => true,
        else => false,
    };
}

pub fn isPlayingCards(cp: u21) bool {
    if (cp < 0x1f0a0 or cp > 0x1f0ff) return false;

    return switch (cp) {
        0x1f0a0...0x1f0ff => true,
        else => false,
    };
}

pub fn isEnclosedAlphanumericSupplement(cp: u21) bool {
    if (cp < 0x1f100 or cp > 0x1f1ff) return false;

    return switch (cp) {
        0x1f100...0x1f1ff => true,
        else => false,
    };
}

pub fn isEnclosedIdeographicSupplement(cp: u21) bool {
    if (cp < 0x1f200 or cp > 0x1f2ff) return false;

    return switch (cp) {
        0x1f200...0x1f2ff => true,
        else => false,
    };
}

pub fn isMiscellaneousSymbolsAndPictographs(cp: u21) bool {
    if (cp < 0x1f300 or cp > 0x1f5ff) return false;

    return switch (cp) {
        0x1f300...0x1f5ff => true,
        else => false,
    };
}

pub fn isEmoticons(cp: u21) bool {
    if (cp < 0x1f600 or cp > 0x1f64f) return false;

    return switch (cp) {
        0x1f600...0x1f64f => true,
        else => false,
    };
}

pub fn isOrnamentalDingbats(cp: u21) bool {
    if (cp < 0x1f650 or cp > 0x1f67f) return false;

    return switch (cp) {
        0x1f650...0x1f67f => true,
        else => false,
    };
}

pub fn isTransportAndMapSymbols(cp: u21) bool {
    if (cp < 0x1f680 or cp > 0x1f6ff) return false;

    return switch (cp) {
        0x1f680...0x1f6ff => true,
        else => false,
    };
}

pub fn isAlchemicalSymbols(cp: u21) bool {
    if (cp < 0x1f700 or cp > 0x1f77f) return false;

    return switch (cp) {
        0x1f700...0x1f77f => true,
        else => false,
    };
}

pub fn isGeometricShapesExtended(cp: u21) bool {
    if (cp < 0x1f780 or cp > 0x1f7ff) return false;

    return switch (cp) {
        0x1f780...0x1f7ff => true,
        else => false,
    };
}

pub fn isSupplementalArrowsC(cp: u21) bool {
    if (cp < 0x1f800 or cp > 0x1f8ff) return false;

    return switch (cp) {
        0x1f800...0x1f8ff => true,
        else => false,
    };
}

pub fn isSupplementalSymbolsAndPictographs(cp: u21) bool {
    if (cp < 0x1f900 or cp > 0x1f9ff) return false;

    return switch (cp) {
        0x1f900...0x1f9ff => true,
        else => false,
    };
}

pub fn isChessSymbols(cp: u21) bool {
    if (cp < 0x1fa00 or cp > 0x1fa6f) return false;

    return switch (cp) {
        0x1fa00...0x1fa6f => true,
        else => false,
    };
}

pub fn isSymbolsAndPictographsExtendedA(cp: u21) bool {
    if (cp < 0x1fa70 or cp > 0x1faff) return false;

    return switch (cp) {
        0x1fa70...0x1faff => true,
        else => false,
    };
}

pub fn isSymbolsForLegacyComputing(cp: u21) bool {
    if (cp < 0x1fb00 or cp > 0x1fbff) return false;

    return switch (cp) {
        0x1fb00...0x1fbff => true,
        else => false,
    };
}

pub fn isCjkUnifiedIdeographsExtensionB(cp: u21) bool {
    if (cp < 0x20000 or cp > 0x2a6df) return false;

    return switch (cp) {
        0x20000...0x2a6df => true,
        else => false,
    };
}

pub fn isCjkUnifiedIdeographsExtensionC(cp: u21) bool {
    if (cp < 0x2a700 or cp > 0x2b73f) return false;

    return switch (cp) {
        0x2a700...0x2b73f => true,
        else => false,
    };
}

pub fn isCjkUnifiedIdeographsExtensionD(cp: u21) bool {
    if (cp < 0x2b740 or cp > 0x2b81f) return false;

    return switch (cp) {
        0x2b740...0x2b81f => true,
        else => false,
    };
}

pub fn isCjkUnifiedIdeographsExtensionE(cp: u21) bool {
    if (cp < 0x2b820 or cp > 0x2ceaf) return false;

    return switch (cp) {
        0x2b820...0x2ceaf => true,
        else => false,
    };
}

pub fn isCjkUnifiedIdeographsExtensionF(cp: u21) bool {
    if (cp < 0x2ceb0 or cp > 0x2ebef) return false;

    return switch (cp) {
        0x2ceb0...0x2ebef => true,
        else => false,
    };
}

pub fn isCjkCompatibilityIdeographsSupplement(cp: u21) bool {
    if (cp < 0x2f800 or cp > 0x2fa1f) return false;

    return switch (cp) {
        0x2f800...0x2fa1f => true,
        else => false,
    };
}

pub fn isCjkUnifiedIdeographsExtensionG(cp: u21) bool {
    if (cp < 0x30000 or cp > 0x3134f) return false;

    return switch (cp) {
        0x30000...0x3134f => true,
        else => false,
    };
}

pub fn isCjkUnifiedIdeographsExtensionH(cp: u21) bool {
    if (cp < 0x31350 or cp > 0x323af) return false;

    return switch (cp) {
        0x31350...0x323af => true,
        else => false,
    };
}

pub fn isTags(cp: u21) bool {
    if (cp < 0xe0000 or cp > 0xe007f) return false;

    return switch (cp) {
        0xe0000...0xe007f => true,
        else => false,
    };
}

pub fn isVariationSelectorsSupplement(cp: u21) bool {
    if (cp < 0xe0100 or cp > 0xe01ef) return false;

    return switch (cp) {
        0xe0100...0xe01ef => true,
        else => false,
    };
}

pub fn isSupplementaryPrivateUseAreaA(cp: u21) bool {
    if (cp < 0xf0000 or cp > 0xfffff) return false;

    return switch (cp) {
        0xf0000...0xfffff => true,
        else => false,
    };
}

pub fn isSupplementaryPrivateUseAreaB(cp: u21) bool {
    if (cp < 0x100000 or cp > 0x10ffff) return false;

    return switch (cp) {
        0x100000...0x10ffff => true,
        else => false,
    };
}
