/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.virtual;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPAdaptable;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPQualifiedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDAttributeValue;
import org.jkiss.dbeaver.model.data.DBDLabelValuePair;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.model.exec.DBCLogicalOperator;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDictionary;
import org.jkiss.dbeaver.model.struct.DBSDictionaryAccessor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.DBSEntityType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.virtual.DBVColorOverride;
import org.jkiss.dbeaver.model.virtual.DBVContainer;
import org.jkiss.dbeaver.model.virtual.DBVEntityAttribute;
import org.jkiss.dbeaver.model.virtual.DBVEntityConstraint;
import org.jkiss.dbeaver.model.virtual.DBVEntityForeignKey;
import org.jkiss.dbeaver.model.virtual.DBVEntityForeignKeyColumn;
import org.jkiss.dbeaver.model.virtual.DBVModel;
import org.jkiss.dbeaver.model.virtual.DBVObject;
import org.jkiss.utils.CommonUtils;

public class DBVEntity
extends DBVObject
implements DBSEntity,
DBPQualifiedObject,
DBSDictionary,
DBPAdaptable {
    public static final String[] DEFAULT_DESCRIPTION_COLUMN_PATTERNS = new String[]{"title", "name", "label", "display", "displayname", "description", "comment", "remark", "information", "email"};
    private static final int MIN_DESC_COLUMN_LENGTH = 4;
    private static final int MAX_DESC_COLUMN_LENGTH = 1000;
    @NotNull
    private final DBVContainer container;
    @NotNull
    private String name;
    private String description;
    private String descriptionColumnNames;
    private List<DBVEntityConstraint> entityConstraints;
    private List<DBVEntityForeignKey> entityForeignKeys;
    private List<DBVEntityAttribute> entityAttributes;
    private List<DBVColorOverride> colorOverrides;
    private static final DBSDictionaryAccessor emptyDictionaryAccessor = new DBSDictionaryAccessor(){

        @Override
        @NotNull
        public DBRProgressMonitor getProgressMonitor() {
            return new VoidProgressMonitor();
        }

        @Override
        public boolean isKeyComparable() {
            return false;
        }

        @Override
        @NotNull
        public List<DBDLabelValuePair> getValueEntry(@NotNull Object keyValue) {
            return Collections.emptyList();
        }

        @NotNull
        public List<DBDLabelValuePair> getValues(long offset, long maxResults) {
            return Collections.emptyList();
        }

        @Override
        @NotNull
        public List<DBDLabelValuePair> getSimilarValues(@NotNull Object pattern, boolean caseInsensitive, boolean byDesc, long offset, long maxResults) {
            return Collections.emptyList();
        }

        @Override
        @NotNull
        public List<DBDLabelValuePair> getValuesNear(@NotNull Object value, boolean isPreceeding, long offset, long maxResults) {
            return Collections.emptyList();
        }

        @Override
        @NotNull
        public List<DBDLabelValuePair> getSimilarValuesNear(@NotNull Object pattern, boolean caseInsensitive, boolean byDesc, Object value, boolean isPreceeding, long offset, long maxResults) {
            return Collections.emptyList();
        }

        @Override
        public void close() {
        }

        @Override
        @NotNull
        public List<DBDLabelValuePair> getValues(long offset, int pageSize) {
            return Collections.emptyList();
        }
    };

    public DBVEntity(@NotNull DBVContainer container, @NotNull String name, String descriptionColumnNames) {
        this.container = container;
        this.name = name;
        this.descriptionColumnNames = descriptionColumnNames;
    }

    public DBVEntity(@NotNull DBVContainer container, @NotNull DBVEntity copy, @NotNull DBVModel targetModel) {
        this.container = container;
        this.copyFrom(copy, targetModel);
    }

    public synchronized void dispose() {
        if (this.entityForeignKeys != null) {
            for (DBVEntityForeignKey fk : this.entityForeignKeys) {
                fk.dispose();
            }
            this.entityForeignKeys.clear();
        }
    }

    public void copyFrom(@NotNull DBVEntity src, @NotNull DBVModel targetModel) {
        this.name = src.name;
        this.descriptionColumnNames = src.descriptionColumnNames;
        if (!CommonUtils.isEmpty(src.entityConstraints)) {
            this.entityConstraints = new ArrayList<DBVEntityConstraint>(src.entityConstraints.size());
            for (DBVEntityConstraint c : src.entityConstraints) {
                this.entityConstraints.add(new DBVEntityConstraint(this, c));
            }
        } else {
            this.entityConstraints = null;
        }
        if (this.entityForeignKeys != null) {
            for (DBVEntityForeignKey fk : this.entityForeignKeys) {
                fk.dispose();
            }
        }
        this.entityForeignKeys = null;
        if (!CommonUtils.isEmpty(src.entityForeignKeys)) {
            this.entityForeignKeys = new ArrayList<DBVEntityForeignKey>(src.entityForeignKeys.size());
            for (DBVEntityForeignKey fk : src.entityForeignKeys) {
                DBVEntityForeignKey fkCopy = new DBVEntityForeignKey(this, fk, targetModel);
                if (fkCopy.getRefEntityId() == null) {
                    fkCopy.dispose();
                    log.debug("Can't copy virtual foreign key '" + fk.getName() + "' - target entity cannot be resolved");
                    continue;
                }
                this.entityForeignKeys.add(fkCopy);
            }
        }
        if (!CommonUtils.isEmpty(src.entityAttributes)) {
            this.entityAttributes = new ArrayList<DBVEntityAttribute>(src.entityAttributes.size());
            for (DBVEntityAttribute attribute : src.entityAttributes) {
                this.entityAttributes.add(new DBVEntityAttribute(this, null, attribute));
            }
        } else {
            this.entityAttributes = null;
        }
        if (!CommonUtils.isEmpty(src.colorOverrides)) {
            this.colorOverrides = new ArrayList<DBVColorOverride>(src.colorOverrides.size());
            for (DBVColorOverride co : src.colorOverrides) {
                this.colorOverrides.add(new DBVColorOverride(co));
            }
        } else {
            this.colorOverrides = null;
        }
        super.copyFrom(src);
    }

    DBVEntity(@NotNull DBVContainer container, @NotNull String name, @NotNull Map<String, Object> map) {
        this.container = container;
        this.name = name;
        this.descriptionColumnNames = (String)map.get("description");
        for (Map.Entry<String, Map<String, Object>> entry : JSONUtils.getNestedObjects(map, "attributes")) {
            String attrName = entry.getKey();
            Map<String, Object> attrMap = entry.getValue();
            DBVEntityAttribute attr = new DBVEntityAttribute(this, null, attrName, attrMap);
            if (this.entityAttributes == null) {
                this.entityAttributes = new ArrayList<DBVEntityAttribute>();
            }
            this.entityAttributes.add(attr);
        }
        for (Map.Entry<String, Map<String, Object>> entry : JSONUtils.getNestedObjects(map, "constraints")) {
            String consName = entry.getKey();
            Map<String, Object> consMap = entry.getValue();
            DBVEntityConstraint constraint = new DBVEntityConstraint(this, DBSEntityConstraintType.VIRTUAL_KEY, consName);
            boolean useAllColumns = JSONUtils.getBoolean(consMap, "useAllColumns");
            constraint.setUseAllColumns(useAllColumns);
            if (!useAllColumns) {
                for (String attrName : JSONUtils.deserializeStringList(consMap, "attributes")) {
                    constraint.addAttribute(attrName);
                }
            }
            if (this.entityConstraints == null) {
                this.entityConstraints = new ArrayList<DBVEntityConstraint>();
            }
            this.entityConstraints.add(constraint);
        }
        for (Map map2 : JSONUtils.getObjectList(map, "foreign-keys")) {
            String entityId = JSONUtils.getString(map2, "entity");
            if (CommonUtils.isEmpty((String)entityId)) continue;
            String refConsId = JSONUtils.getString(map2, "constraint");
            DBVEntityForeignKey fk = new DBVEntityForeignKey(this);
            fk.setReferencedConstraint(entityId, refConsId);
            Map<String, Object> attrMap = JSONUtils.getObject(map2, "attributes");
            ArrayList<DBVEntityForeignKeyColumn> attrs = new ArrayList<DBVEntityForeignKeyColumn>();
            for (Map.Entry<String, Object> attr : attrMap.entrySet()) {
                attrs.add(new DBVEntityForeignKeyColumn(fk, attr.getKey(), (String)attr.getValue()));
            }
            fk.setAttributes(attrs);
            if (this.entityForeignKeys == null) {
                this.entityForeignKeys = new ArrayList<DBVEntityForeignKey>();
            }
            this.entityForeignKeys.add(fk);
        }
        for (Map map3 : JSONUtils.getObjectList(map, "colors")) {
            DBVColorOverride curColor = new DBVColorOverride(JSONUtils.getString(map3, "name"), DBCLogicalOperator.valueOf(JSONUtils.getString(map3, "operator")), null, JSONUtils.getString(map3, "foreground"), JSONUtils.getString(map3, "background"));
            curColor.setRange(JSONUtils.getBoolean(map3, "range"));
            curColor.setSingleColumn(JSONUtils.getBoolean(map3, "single-column"));
            curColor.setColorForeground2(JSONUtils.getString(map3, "foreground2"));
            curColor.setColorBackground2(JSONUtils.getString(map3, "background2"));
            for (String strValue : JSONUtils.deserializeStringList(map3, "values")) {
                curColor.addAttributeValue(strValue);
            }
            this.addColorOverride(curColor);
        }
        this.loadPropertiesFrom(map, "properties");
    }

    @NotNull
    public DBVContainer getContainer() {
        return this.container;
    }

    @Nullable
    public DBSEntity getRealEntity(@NotNull DBRProgressMonitor monitor) throws DBException {
        DBSObjectContainer realContainer = this.container.getRealContainer(monitor);
        if (realContainer == null) {
            return null;
        }
        DBSObject realObject = realContainer.getChild(monitor, this.name);
        if (realObject instanceof DBSEntity) {
            DBSEntity entity = (DBSEntity)realObject;
            return entity;
        }
        log.warn("Entity '" + this.name + "' not found in '" + realContainer.getName() + "'");
        return null;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Override
    public DBVContainer getParentObject() {
        return this.container;
    }

    @Override
    @NotNull
    public DBPDataSource getDataSource() {
        return this.container.getDataSource();
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    @NotNull
    public DBSEntityType getEntityType() {
        return DBSEntityType.VIRTUAL_ENTITY;
    }

    public List<DBVEntityAttribute> getEntityAttributes() {
        return this.entityAttributes;
    }

    public List<DBVEntityAttribute> getCustomAttributes() {
        if (!CommonUtils.isEmpty(this.entityAttributes)) {
            ArrayList<DBVEntityAttribute> result = null;
            for (DBVEntityAttribute attr : this.entityAttributes) {
                if (!attr.isCustom()) continue;
                if (result == null) {
                    result = new ArrayList<DBVEntityAttribute>();
                }
                result.add(attr);
            }
            if (result != null) {
                return result;
            }
        }
        return Collections.emptyList();
    }

    public DBVEntityAttribute getVirtualAttribute(String name) {
        if (!CommonUtils.isEmpty(this.entityAttributes)) {
            for (DBVEntityAttribute attr : this.entityAttributes) {
                if (!CommonUtils.equalObjects((Object)name, (Object)attr.getName())) continue;
                return attr;
            }
        }
        return null;
    }

    @Override
    @NotNull
    public List<? extends DBSEntityAttribute> getAttributes(@NotNull DBRProgressMonitor monitor) throws DBException {
        List<? extends DBSEntityAttribute> realAttributes;
        DBSEntity realEntity = this.getRealEntity(monitor);
        if (realEntity != null && !CommonUtils.isEmpty(realAttributes = realEntity.getAttributes(monitor))) {
            List<DBVEntityAttribute> customAttributes = this.getCustomAttributes();
            if (!CommonUtils.isEmpty(customAttributes)) {
                ArrayList<? extends DBSEntityAttribute> allAttrs = new ArrayList<DBSEntityAttribute>();
                allAttrs.addAll(realAttributes);
                allAttrs.addAll(customAttributes);
                return allAttrs;
            }
            return realAttributes;
        }
        return this.getCustomAttributes();
    }

    @Override
    @Nullable
    public DBSEntityAttribute getAttribute(@NotNull DBRProgressMonitor monitor, @NotNull String attributeName) {
        try {
            return DBUtils.findObject(this.getAttributes(monitor), attributeName);
        }
        catch (DBException e) {
            log.error("Can't obtain real entity's attributes", e);
            return null;
        }
    }

    @Nullable
    public DBVEntityAttribute getVirtualAttribute(DBDAttributeBinding binding, boolean create) {
        if (this.entityAttributes != null || create) {
            DBSObject[] path;
            DBVEntityAttribute topAttribute;
            if (this.entityAttributes == null) {
                this.entityAttributes = new ArrayList<DBVEntityAttribute>();
            }
            if ((topAttribute = DBUtils.findObject(this.entityAttributes, (path = DBUtils.getObjectPath(binding, true))[0].getName())) == null && create) {
                topAttribute = new DBVEntityAttribute(this, null, path[0].getName());
                this.entityAttributes.add(topAttribute);
            }
            if (topAttribute != null) {
                int i = 1;
                while (i < path.length) {
                    DBVEntityAttribute nextAttribute = topAttribute.getChild(path[i].getName());
                    if (nextAttribute == null) {
                        if (create) {
                            nextAttribute = new DBVEntityAttribute(this, topAttribute, path[i].getName());
                            topAttribute.addChild(nextAttribute);
                        } else {
                            log.debug("Can't find nested attribute '" + String.valueOf(binding) + "' in '" + topAttribute.getName());
                            return null;
                        }
                    }
                    topAttribute = nextAttribute;
                    ++i;
                }
            }
            return topAttribute;
        }
        return null;
    }

    public void addVirtualAttribute(DBVEntityAttribute attribute) {
        this.addVirtualAttribute(attribute, true);
    }

    void addVirtualAttribute(DBVEntityAttribute attribute, boolean reflect) {
        if (this.entityAttributes == null) {
            this.entityAttributes = new ArrayList<DBVEntityAttribute>();
        }
        this.entityAttributes.add(attribute);
        if (reflect) {
            DBUtils.fireObjectUpdate(this);
        }
    }

    public void removeVirtualAttribute(DBVEntityAttribute attribute) {
        this.entityAttributes.remove(attribute);
        DBUtils.fireObjectUpdate((DBSObject)this, attribute);
    }

    @Nullable
    public Collection<? extends DBVEntityConstraint> getConstraints(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.entityConstraints;
    }

    @NotNull
    public List<DBVEntityConstraint> getConstraints() {
        return this.entityConstraints == null ? Collections.emptyList() : this.entityConstraints;
    }

    @NotNull
    public DBVEntityConstraint getBestIdentifier() {
        if (this.entityConstraints == null) {
            this.entityConstraints = new ArrayList<DBVEntityConstraint>();
        }
        for (DBVEntityConstraint constraint : this.entityConstraints) {
            if (!DBVEntity.isComplete(constraint)) continue;
            return constraint;
        }
        if (this.entityConstraints.isEmpty()) {
            this.entityConstraints.add(new DBVEntityConstraint(this, DBSEntityConstraintType.VIRTUAL_KEY, "VIRTUAL_PK"));
        }
        return this.entityConstraints.getFirst();
    }

    public static boolean isComplete(@NotNull DBVEntityConstraint constraint) {
        return constraint.getConstraintType().isUnique() && (!CommonUtils.isEmpty(constraint.getAttributes()) || constraint.isUseAllColumns());
    }

    public boolean addConstraint(@NotNull DBVEntityConstraint constraint) {
        return this.addConstraint(constraint, true);
    }

    public boolean addConstraint(@NotNull DBVEntityConstraint constraint, boolean reflect) {
        if (this.entityConstraints == null) {
            this.entityConstraints = new ArrayList<DBVEntityConstraint>();
        }
        String constraintName = constraint.getName();
        Iterator<DBVEntityConstraint> iterator = this.entityConstraints.iterator();
        while (iterator.hasNext()) {
            DBVEntityConstraint existing = iterator.next();
            if (!Objects.equals(existing.getName(), constraintName)) continue;
            if (DBVEntity.isComplete(existing)) {
                return false;
            }
            iterator.remove();
            break;
        }
        this.entityConstraints.add(constraint);
        if (reflect) {
            DBUtils.fireObjectUpdate((DBSObject)this, constraint);
        }
        return true;
    }

    public void removeConstraint(DBVEntityConstraint constraint) {
        if (this.entityConstraints != null) {
            this.entityConstraints.remove(constraint);
            DBUtils.fireObjectUpdate((DBSObject)this, constraint);
        }
    }

    @Nullable
    public synchronized List<DBVEntityForeignKey> getAssociations(@NotNull DBRProgressMonitor monitor) throws DBException {
        if (this.entityForeignKeys != null && monitor != null) {
            for (DBVEntityForeignKey fk : this.entityForeignKeys) {
                fk.getRealReferenceConstraint(monitor);
            }
        }
        return this.entityForeignKeys;
    }

    @NotNull
    public synchronized List<DBVEntityForeignKey> getForeignKeys() {
        return this.entityForeignKeys != null ? this.entityForeignKeys : Collections.emptyList();
    }

    public synchronized void addForeignKey(@NotNull DBVEntityForeignKey foreignKey) {
        if (this.entityForeignKeys == null) {
            this.entityForeignKeys = new ArrayList<DBVEntityForeignKey>();
        }
        this.entityForeignKeys.add(foreignKey);
        DBUtils.fireObjectUpdate((DBSObject)this, foreignKey);
    }

    public synchronized void removeForeignKey(@NotNull DBVEntityForeignKey foreignKey) {
        if (this.entityForeignKeys != null) {
            this.entityForeignKeys.remove(foreignKey);
            DBUtils.fireObjectUpdate((DBSObject)this, foreignKey);
            foreignKey.dispose();
        }
    }

    @Override
    @Nullable
    public Collection<? extends DBSEntityAssociation> getReferences(@NotNull DBRProgressMonitor monitor) throws DBException {
        return null;
    }

    public String getDescriptionColumnNames() {
        return this.descriptionColumnNames;
    }

    public void setDescriptionColumnNames(String descriptionColumnNames) {
        this.descriptionColumnNames = descriptionColumnNames;
    }

    public Collection<DBSEntityAttribute> getDescriptionColumns(DBRProgressMonitor monitor, DBSEntity entity) throws DBException {
        return DBVEntity.getDescriptionColumns(monitor, entity, this.descriptionColumnNames);
    }

    @NotNull
    public <T extends DBSAttributeBase> Collection<T> getDescriptionColumns(@NotNull Collection<? extends T> attributes) {
        return DBVEntity.getDescriptionColumns(attributes, this.descriptionColumnNames);
    }

    public static Collection<DBSEntityAttribute> getDescriptionColumns(@NotNull DBRProgressMonitor monitor, @NotNull DBSEntity entity, @NotNull String descColumns) throws DBException {
        return DBVEntity.getDescriptionColumns(entity.getAttributes(monitor), descColumns);
    }

    @NotNull
    public static <T extends DBSAttributeBase> Collection<T> getDescriptionColumns(@Nullable Collection<? extends T> attributes, @NotNull String descColumns) {
        if (CommonUtils.isEmpty((String)descColumns) || CommonUtils.isEmpty(attributes)) {
            return Collections.emptyList();
        }
        ArrayList<DBSAttributeBase> result = new ArrayList<DBSAttributeBase>();
        StringTokenizer st = new StringTokenizer(descColumns, ",");
        block0: while (st.hasMoreTokens()) {
            String colName = st.nextToken();
            for (DBSAttributeBase attr : attributes) {
                if (!DBVEntity.matchesName(attr, colName)) continue;
                result.add(attr);
                continue block0;
            }
        }
        return result;
    }

    private static boolean matchesName(@NotNull DBSAttributeBase attribute, @NotNull String name) {
        DBPDataSource dataSource;
        if (attribute instanceof DBSObject && (dataSource = ((DBSObject)((Object)attribute)).getDataSource()) != null) {
            name = DBUtils.getUnQuotedIdentifier(dataSource, name);
        }
        return attribute.getName().equalsIgnoreCase(name);
    }

    public static String getDefaultDescriptionColumn(DBRProgressMonitor monitor, DBSEntityAttribute keyColumn) throws DBException {
        List<? extends DBSEntityAttribute> allColumns = keyColumn.getParentObject().getAttributes(monitor);
        if (allColumns == null || allColumns.isEmpty()) {
            return null;
        }
        if (allColumns.size() == 1) {
            return DBUtils.getQuotedIdentifier(keyColumn);
        }
        TreeMap<String, DBSEntityAttribute> stringColumns = new TreeMap<String, DBSEntityAttribute>();
        for (DBSEntityAttribute dBSEntityAttribute : allColumns) {
            if (dBSEntityAttribute == keyColumn || dBSEntityAttribute.getDataKind() != DBPDataKind.STRING || dBSEntityAttribute.getMaxLength() > 0L && (dBSEntityAttribute.getMaxLength() >= 1000L || dBSEntityAttribute.getMaxLength() < 4L)) continue;
            stringColumns.put(dBSEntityAttribute.getName(), dBSEntityAttribute);
        }
        if (stringColumns.isEmpty()) {
            return DBUtils.getQuotedIdentifier(keyColumn);
        }
        if (stringColumns.size() > 1) {
            for (String string : DBVEntity.getDescriptionColumnPatterns(keyColumn.getDataSource().getContainer().getPreferenceStore())) {
                for (String columnName : stringColumns.keySet()) {
                    if (!columnName.toLowerCase(Locale.ENGLISH).contains(string)) continue;
                    return DBUtils.getQuotedIdentifier((DBSObject)stringColumns.get(columnName));
                }
            }
        }
        return DBUtils.getQuotedIdentifier((DBSObject)stringColumns.values().iterator().next());
    }

    @NotNull
    public static List<String> getDescriptionColumnPatterns(@NotNull DBPPreferenceStore store) {
        return CommonUtils.splitString((String)store.getString("resultset.reference.value.description.column.patterns"), (char)'|');
    }

    @NotNull
    public List<DBVColorOverride> getColorOverrides() {
        return this.colorOverrides == null ? Collections.emptyList() : this.colorOverrides;
    }

    public List<DBVColorOverride> getColorOverrides(String attrName) {
        ArrayList<DBVColorOverride> result = new ArrayList<DBVColorOverride>();
        if (this.colorOverrides != null) {
            for (DBVColorOverride co : this.colorOverrides) {
                if (!CommonUtils.equalObjects((Object)attrName, (Object)co.getAttributeName())) continue;
                result.add(co);
            }
        }
        return result;
    }

    public void setColorOverrides(List<DBVColorOverride> colorOverrides) {
        this.colorOverrides = colorOverrides;
    }

    public void setColorOverride(DBDAttributeBinding attribute, Object value, String foreground, String background) {
        String attrName = attribute.getName();
        DBVColorOverride co = new DBVColorOverride(attrName, DBCLogicalOperator.EQUALS, new Object[]{value}, foreground, background);
        if (this.colorOverrides == null) {
            this.colorOverrides = new ArrayList<DBVColorOverride>();
        } else {
            this.colorOverrides.removeIf(c -> c.matches(attrName, DBCLogicalOperator.EQUALS, co.getAttributeValues()));
        }
        this.colorOverrides.add(co);
    }

    public void addColorOverride(DBVColorOverride color) {
        if (this.colorOverrides == null) {
            this.colorOverrides = new ArrayList<DBVColorOverride>();
        }
        this.colorOverrides.add(color);
    }

    public void removeColorOverride(DBDAttributeBinding attribute) {
        if (this.colorOverrides == null) {
            return;
        }
        String attrName = attribute.getName();
        this.colorOverrides.removeIf(c -> c.getAttributeName().equals(attrName));
    }

    public void removeColorOverride(DBVColorOverride co) {
        if (this.colorOverrides == null) {
            return;
        }
        this.colorOverrides.remove(co);
    }

    public void removeAllColorOverride() {
        if (this.colorOverrides == null) {
            return;
        }
        this.colorOverrides.clear();
    }

    @Override
    public boolean hasValuableData() {
        if (!(CommonUtils.isEmpty((String)this.descriptionColumnNames) && CommonUtils.isEmpty(this.getProperties()) && CommonUtils.isEmpty(this.entityForeignKeys) && CommonUtils.isEmpty(this.colorOverrides))) {
            return true;
        }
        if (!CommonUtils.isEmpty(this.entityConstraints)) {
            for (DBVEntityConstraint c : this.entityConstraints) {
                if (!c.hasAttributes()) continue;
                return true;
            }
        }
        if (!CommonUtils.isEmpty(this.entityAttributes)) {
            for (DBVEntityAttribute attr : this.entityAttributes) {
                if (!attr.hasValuableData()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    @NotNull
    public String getFullyQualifiedName(@NotNull DBPEvaluationContext context) {
        return DBUtils.getFullQualifiedName(this.getDataSource(), this.container instanceof DBVModel ? null : this.container, this);
    }

    public String toString() {
        return this.name;
    }

    public void bindEntity(DBRProgressMonitor monitor) throws DBException {
        if (!CommonUtils.isEmpty(this.entityForeignKeys)) {
            for (DBVEntityForeignKey fk : this.entityForeignKeys) {
                fk.getRealReferenceConstraint(monitor);
            }
        }
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        return null;
    }

    @Override
    public boolean supportsDictionaryEnumeration() {
        return true;
    }

    @Override
    @NotNull
    public DBSDictionaryAccessor getDictionaryAccessor(@NotNull DBRProgressMonitor monitor, List<DBDAttributeValue> precedingKeys, @NotNull DBSEntityAttribute keyColumn, boolean sortAsc, boolean sortByDesc) throws DBException {
        DBSEntity realEntity = this.getRealEntity(monitor);
        if (realEntity instanceof DBSDictionary) {
            return ((DBSDictionary)((Object)realEntity)).getDictionaryAccessor(monitor, precedingKeys, keyColumn, sortAsc, sortByDesc);
        }
        return emptyDictionaryAccessor;
    }

    @Override
    @NotNull
    public List<DBDLabelValuePair> getDictionaryEnumeration(@NotNull DBRProgressMonitor monitor, @NotNull DBSEntityAttribute keyColumn, @Nullable Object keyPattern, @Nullable String searchText, @Nullable List<DBDAttributeValue> preceedingKeys, boolean caseInsensitiveSearch, boolean sortAsc, boolean sortByValue, int offset, int maxResults) throws DBException {
        DBSEntity realEntity = this.getRealEntity(monitor);
        if (realEntity instanceof DBSDictionary) {
            return ((DBSDictionary)((Object)realEntity)).getDictionaryEnumeration(monitor, keyColumn, keyPattern, searchText, preceedingKeys, caseInsensitiveSearch, sortAsc, sortByValue, offset, maxResults);
        }
        return Collections.emptyList();
    }

    @Override
    @NotNull
    public List<DBDLabelValuePair> getDictionaryValues(@NotNull DBRProgressMonitor monitor, @NotNull List<DBSEntityAttribute> keyColumns, @NotNull List<Object[]> keyValues, @Nullable List<DBDAttributeValue[]> preceedingKeys, boolean sortByValue, boolean sortAsc, boolean omitNonDescriptive) throws DBException {
        List<DBDLabelValuePair> list;
        DBSEntity realEntity = this.getRealEntity(monitor);
        if (realEntity instanceof DBSDictionary) {
            DBSDictionary dictionary = (DBSDictionary)((Object)realEntity);
            list = dictionary.getDictionaryValues(monitor, keyColumns, keyValues, preceedingKeys, sortByValue, sortAsc, false);
        } else {
            list = Collections.emptyList();
        }
        return list;
    }

    public DBVModel getModel() {
        DBVContainer container = this.getContainer();
        while (container != null) {
            if (container instanceof DBVModel) {
                return (DBVModel)container;
            }
            container = container.getParentObject();
        }
        throw new IllegalStateException("Root container must be model");
    }

    void handleRename(String oldName, String newName) {
        this.name = newName;
        this.container.renameEntity(this, oldName, newName);
    }
}

