/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.ai.engine;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.ai.AIDatabaseScope;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionContextDefaults;
import org.jkiss.dbeaver.model.logical.DBSLogicalDataSource;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.rdb.DBSCatalog;
import org.jkiss.dbeaver.model.struct.rdb.DBSSchema;

public class AIDatabaseContext {
    private final DBSLogicalDataSource dataSource;
    private final AIDatabaseScope scope;
    private final List<DBSObject> customEntities;
    private final DBCExecutionContext executionContext;

    private AIDatabaseContext(@NotNull DBSLogicalDataSource dataSource, @NotNull AIDatabaseScope scope, @Nullable List<DBSObject> customEntities, @NotNull DBCExecutionContext executionContext) {
        this.dataSource = dataSource;
        this.scope = scope;
        this.customEntities = customEntities;
        this.executionContext = executionContext;
    }

    @NotNull
    public DBSLogicalDataSource getDataSource() {
        return this.dataSource;
    }

    @NotNull
    public AIDatabaseScope getScope() {
        return this.scope;
    }

    @NotNull
    public List<DBSObject> getCustomEntities() {
        return Collections.unmodifiableList(Objects.requireNonNull(this.customEntities, "Scope is not custom"));
    }

    @NotNull
    public DBCExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    public DBSObjectContainer getScopeObject() {
        DBCExecutionContextDefaults contextDefaults = this.executionContext.getContextDefaults();
        if (contextDefaults == null) {
            return (DBSObjectContainer)this.executionContext.getDataSource();
        }
        DBSCatalog scoped = switch (this.getScope()) {
            case AIDatabaseScope.CURRENT_SCHEMA -> {
                if (contextDefaults.getDefaultSchema() != null) {
                    yield contextDefaults.getDefaultSchema();
                }
                yield contextDefaults.getDefaultCatalog();
            }
            case AIDatabaseScope.CURRENT_DATABASE -> contextDefaults.getDefaultCatalog();
            default -> null;
        };
        return scoped != null ? scoped : (DBSObjectContainer)this.executionContext.getDataSource();
    }

    public static class Builder {
        private DBSLogicalDataSource dataSource;
        private AIDatabaseScope scope;
        private List<DBSObject> customEntities;
        private DBCExecutionContext executionContext;

        public Builder(@NotNull DBSLogicalDataSource dataSource) {
            this.dataSource = dataSource;
        }

        @NotNull
        public Builder setScope(@NotNull AIDatabaseScope scope) {
            this.scope = scope;
            return this;
        }

        @NotNull
        public Builder setCustomEntities(@NotNull List<DBSObject> customEntities) {
            this.customEntities = customEntities;
            return this;
        }

        @NotNull
        public Builder setExecutionContext(@NotNull DBCExecutionContext executionContext) {
            this.executionContext = executionContext;
            return this;
        }

        @NotNull
        public AIDatabaseContext build() throws DBException {
            if (this.scope == null) {
                throw new DBException("Scope must be specified");
            }
            if (this.scope == AIDatabaseScope.CUSTOM && this.customEntities == null) {
                throw new DBException("Custom entities must be specified when using custom scope");
            }
            if (this.executionContext == null) {
                throw new DBException("Execution context must be specified");
            }
            DBCExecutionContextDefaults contextDefaults = this.executionContext.getContextDefaults();
            if (this.dataSource.getCurrentCatalog() == null && contextDefaults != null) {
                DBSCatalog defaultCatalog = contextDefaults.getDefaultCatalog();
                this.dataSource.setCurrentCatalog(defaultCatalog == null ? null : defaultCatalog.getName());
            }
            if (this.dataSource.getCurrentSchema() == null && contextDefaults != null) {
                DBSSchema defaultSchema = contextDefaults.getDefaultSchema();
                this.dataSource.setCurrentSchema(defaultSchema == null ? null : defaultSchema.getName());
            }
            return new AIDatabaseContext(this.dataSource, this.scope, this.customEntities, this.executionContext);
        }
    }
}

