/*
 *  Copyright (C) 1999 Ken Lierman
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of *the
 *  License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 *  02111-1307 USA 
 */
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <sys/time.h>
#include <string.h>
#include "demo.h"
#include "log.h"

/* 
** demo filename... obviously need to have more that one allowed
*/
#define DEMO_FILE "demo.dmo"

DemoMode demoMode = OFF;
FILE *demo_fp;
ObserveSpeed observeSpeed = NORMAL;

/*
** start recording a demo
*/
void demoRecordDemo(void)
{
    /* open the file */
    logPrintf(INTERESTING, "open\n");
    demo_fp = fopen(DEMO_FILE, "w");
    if(demo_fp != NULL)
    {
	/* start recording */
	demoMode = RECORD;
    }
    else
    {
	logPrintf(CRITICAL, "Can't open file... exiting\n");
	exit(1);
    }
}


/*
** stop all demo work
*/
void demoStopDemo(void)
{
    /* close the file */
    fclose(demo_fp);

    /* stop recording */
    demoMode = OFF;
}

/*
** start playing a demo
*/
void demoPlayDemo(int speed)
{
    observeSpeed = speed;

    /* open the file for reading */
    demo_fp = fopen(DEMO_FILE, "r");

    /* if ok, set mode to PLAY */
    if(demo_fp != NULL)
    {
	demoMode = PLAY;
    }
    else
    {
	fprintf(stderr, "Can't open file... exiting\n");
	exit(1);
    }
}

/*
** add the current packet (w/ timestamp) to the demo file 
*/
void demoRecordPkt(unsigned char *pkt, int size)
{
    int curChar;
    static int initTime = 0;

    if(demoMode == RECORD)
    {
	/* get our 'base' time */
	if(initTime == 0)
	{
	    initTime = time(NULL);
	}

	/* save the timestamp */
	fprintf(demo_fp, "%ld\n", (time(NULL) - initTime));

	/* save the packet */
	for(curChar = 0; curChar < size; curChar++)
	{
	    fprintf(demo_fp, "%2.2x", pkt[curChar]);
	}
	fprintf(demo_fp, "\n");

	fflush(demo_fp);
    }
}

/* 
** feel relay the packets from the demo file instead of the
** network
*/
int demoPlayPkt(unsigned char *input, struct timeval *tv)
{
    int i = 0;
    int save;
    static int delayNextPkt = 0;
    static char tmpstr[32768];
    static int skipTS = 0;
    static clock_t dtime;
    static int initTime = 0;
    static int demoInitTime = 0;
    static int asTime = 0;

    if(demoMode == PLAY)
    {
	/* skip the timestamp line if we already read it */
	if(skipTS == 0)
	{
	    /* read the timestamp */
	    fgets(tmpstr, 32768, demo_fp);
	    sscanf(tmpstr, "%ld", &dtime);
	    /* 
	     ** if this is the first time though, save the 
	     ** current time (initTime) and the first time in
	     ** the demo file (demoInitTime)
	     */
	    if(initTime == 0)
	    {
		initTime = time(NULL);
		demoInitTime = dtime;
	    }

	    /* read the line */
	    fgets(tmpstr, 32768, demo_fp);
	}

	switch (observeSpeed)
	{
	    case NORMAL:
		/* if we need to wait before sending this packet */
		if((time(NULL) - initTime) < (dtime - demoInitTime))
		{
		    /* remember NOT to read the time stamp next time */
		    skipTS = 1;
		    return (-1);
		}
		break;

	    case FAST:
		/* if we're delaying the next packet, check how long
		 ** it's been */
		if(delayNextPkt == 1)
		{
		    if(time(NULL) < asTime)
		    {
			/* remember NOT to read the time stamp next time */
			skipTS = 1;
			return (-1);
		    }
		    else
		    {
			delayNextPkt = 0;
		    }
		}
		/* if this is an activate shots message, delay the
		 ** NEXT packet some to allow the shots to draw. */
		if(strncmp(tmpstr, "4153", 4) == 0)
		{
		    asTime = time(NULL) + 5;
		    delayNextPkt = 1;
		}
		break;
	}

	/* read the TS next time through */
	skipTS = 0;

	/* copy the string to the buffer */
	for(i = 0; i < strlen(tmpstr) - 1; i = i + 2)
	{
	    sscanf(&tmpstr[i], "%2x", &save);
	    *input = save;
	    input++;
	}

    }

    /* since the file contains 2 bytes for each actualy byte, divide by 2 */
    return (i / 2);
}

/*
** return whether or not we're playing a demo
*/
int demoObserving()
{
    if(demoMode == PLAY)
    {
	return (1);
    }
    else
    {
	return (0);
    }
}
