/*
 *  Copyright (C) 1999 Peter Amstutz
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of *the
 *  License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 *  02111-1307 USA 
 */

#include <ggi/ggi.h>
#include <time.h>
#include <stdlib.h>
#include "terrain.h"
#include "gfx.h"

int main()
{
    int seed;
    gfxInit();

    seed=42;
    srandom(seed);

    do {
	terGenerate(0, 750, 2000, 750, 8, ter_table, ter_data);

	terDelSpan(&ter_data[100], 900, 500);

	gfxDrawTerrain(0, 0, 640, 480, 0, 0, 2000, 1500, ter_data);
	
	ggiFlush(gfx_vis);	
    } while(ggiGetc(gfx_vis)!=GIIUC_q);

    gfxShutdown();
}
