// Copyright 2024 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package documentai provides access to the Cloud Document AI API.
//
// For product documentation, see: https://cloud.google.com/document-ai/docs/
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/documentai/v1beta2"
//	...
//	ctx := context.Background()
//	documentaiService, err := documentai.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	documentaiService, err := documentai.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	documentaiService, err := documentai.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package documentai // import "google.golang.org/api/documentai/v1beta2"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"log/slog"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	"github.com/googleapis/gax-go/v2/internallog"
	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version
var _ = internallog.New

const apiId = "documentai:v1beta2"
const apiName = "documentai"
const apiVersion = "v1beta2"
const basePath = "https://documentai.googleapis.com/"
const basePathTemplate = "https://documentai.UNIVERSE_DOMAIN/"
const mtlsBasePath = "https://documentai.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// See, edit, configure, and delete your Google Cloud data and see the email
	// address for your Google Account.
	CloudPlatformScope = "https://www.googleapis.com/auth/cloud-platform"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/cloud-platform",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultEndpointTemplate(basePathTemplate))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	opts = append(opts, internaloption.EnableNewAuthLibrary())
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s := &Service{client: client, BasePath: basePath, logger: internaloption.GetLogger(opts)}
	s.Projects = NewProjectsService(s)
	if err != nil {
		return nil, err
	}
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	return NewService(context.Background(), option.WithHTTPClient(client))
}

type Service struct {
	client    *http.Client
	logger    *slog.Logger
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Projects *ProjectsService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewProjectsService(s *Service) *ProjectsService {
	rs := &ProjectsService{s: s}
	rs.Documents = NewProjectsDocumentsService(s)
	rs.Locations = NewProjectsLocationsService(s)
	rs.Operations = NewProjectsOperationsService(s)
	return rs
}

type ProjectsService struct {
	s *Service

	Documents *ProjectsDocumentsService

	Locations *ProjectsLocationsService

	Operations *ProjectsOperationsService
}

func NewProjectsDocumentsService(s *Service) *ProjectsDocumentsService {
	rs := &ProjectsDocumentsService{s: s}
	return rs
}

type ProjectsDocumentsService struct {
	s *Service
}

func NewProjectsLocationsService(s *Service) *ProjectsLocationsService {
	rs := &ProjectsLocationsService{s: s}
	rs.Documents = NewProjectsLocationsDocumentsService(s)
	rs.Operations = NewProjectsLocationsOperationsService(s)
	return rs
}

type ProjectsLocationsService struct {
	s *Service

	Documents *ProjectsLocationsDocumentsService

	Operations *ProjectsLocationsOperationsService
}

func NewProjectsLocationsDocumentsService(s *Service) *ProjectsLocationsDocumentsService {
	rs := &ProjectsLocationsDocumentsService{s: s}
	return rs
}

type ProjectsLocationsDocumentsService struct {
	s *Service
}

func NewProjectsLocationsOperationsService(s *Service) *ProjectsLocationsOperationsService {
	rs := &ProjectsLocationsOperationsService{s: s}
	return rs
}

type ProjectsLocationsOperationsService struct {
	s *Service
}

func NewProjectsOperationsService(s *Service) *ProjectsOperationsService {
	rs := &ProjectsOperationsService{s: s}
	return rs
}

type ProjectsOperationsService struct {
	s *Service
}

// GoogleCloudDocumentaiUiv1beta3AutoLabelDocumentsMetadata: Metadata of the
// auto-labeling documents operation.
type GoogleCloudDocumentaiUiv1beta3AutoLabelDocumentsMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiUiv1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`
	// IndividualAutoLabelStatuses: The list of individual auto-labeling statuses
	// of the dataset documents.
	IndividualAutoLabelStatuses []*GoogleCloudDocumentaiUiv1beta3AutoLabelDocumentsMetadataIndividualAutoLabelStatus `json:"individualAutoLabelStatuses,omitempty"`
	// TotalDocumentCount: Total number of the auto-labeling documents.
	TotalDocumentCount int64 `json:"totalDocumentCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommonMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiUiv1beta3AutoLabelDocumentsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3AutoLabelDocumentsMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3AutoLabelDocumentsMetadataIndividualAutoLabelSt
// atus: The status of individual documents in the auto-labeling process.
type GoogleCloudDocumentaiUiv1beta3AutoLabelDocumentsMetadataIndividualAutoLabelStatus struct {
	// DocumentId: The document id of the auto-labeled document. This will replace
	// the gcs_uri.
	DocumentId *GoogleCloudDocumentaiUiv1beta3DocumentId `json:"documentId,omitempty"`
	// Status: The status of the document auto-labeling.
	Status *GoogleRpcStatus `json:"status,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DocumentId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DocumentId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiUiv1beta3AutoLabelDocumentsMetadataIndividualAutoLabelStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3AutoLabelDocumentsMetadataIndividualAutoLabelStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3AutoLabelDocumentsResponse: The response proto
// of AutoLabelDocuments method.
type GoogleCloudDocumentaiUiv1beta3AutoLabelDocumentsResponse struct {
}

type GoogleCloudDocumentaiUiv1beta3BatchDeleteDocumentsMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiUiv1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`
	// ErrorDocumentCount: Total number of documents that failed to be deleted in
	// storage.
	ErrorDocumentCount int64 `json:"errorDocumentCount,omitempty"`
	// IndividualBatchDeleteStatuses: The list of response details of each
	// document.
	IndividualBatchDeleteStatuses []*GoogleCloudDocumentaiUiv1beta3BatchDeleteDocumentsMetadataIndividualBatchDeleteStatus `json:"individualBatchDeleteStatuses,omitempty"`
	// TotalDocumentCount: Total number of documents deleting from dataset.
	TotalDocumentCount int64 `json:"totalDocumentCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommonMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiUiv1beta3BatchDeleteDocumentsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3BatchDeleteDocumentsMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3BatchDeleteDocumentsMetadataIndividualBatchDele
// teStatus: The status of each individual document in the batch delete
// process.
type GoogleCloudDocumentaiUiv1beta3BatchDeleteDocumentsMetadataIndividualBatchDeleteStatus struct {
	// DocumentId: The document id of the document.
	DocumentId *GoogleCloudDocumentaiUiv1beta3DocumentId `json:"documentId,omitempty"`
	// Status: The status of deleting the document in storage.
	Status *GoogleRpcStatus `json:"status,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DocumentId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DocumentId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiUiv1beta3BatchDeleteDocumentsMetadataIndividualBatchDeleteStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3BatchDeleteDocumentsMetadataIndividualBatchDeleteStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3BatchDeleteDocumentsResponse: Response of the
// delete documents operation.
type GoogleCloudDocumentaiUiv1beta3BatchDeleteDocumentsResponse struct {
}

type GoogleCloudDocumentaiUiv1beta3BatchMoveDocumentsMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiUiv1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`
	// DestDatasetType: The destination dataset split type.
	//
	// Possible values:
	//   "DATASET_SPLIT_TYPE_UNSPECIFIED" - Default value if the enum is not set.
	//   "DATASET_SPLIT_TRAIN" - Identifies the train documents.
	//   "DATASET_SPLIT_TEST" - Identifies the test documents.
	//   "DATASET_SPLIT_UNASSIGNED" - Identifies the unassigned documents.
	DestDatasetType string `json:"destDatasetType,omitempty"`
	// DestSplitType: The destination dataset split type.
	//
	// Possible values:
	//   "DATASET_SPLIT_TYPE_UNSPECIFIED" - Default value if the enum is not set.
	//   "DATASET_SPLIT_TRAIN" - Identifies the train documents.
	//   "DATASET_SPLIT_TEST" - Identifies the test documents.
	//   "DATASET_SPLIT_UNASSIGNED" - Identifies the unassigned documents.
	DestSplitType string `json:"destSplitType,omitempty"`
	// IndividualBatchMoveStatuses: The list of response details of each document.
	IndividualBatchMoveStatuses []*GoogleCloudDocumentaiUiv1beta3BatchMoveDocumentsMetadataIndividualBatchMoveStatus `json:"individualBatchMoveStatuses,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommonMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiUiv1beta3BatchMoveDocumentsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3BatchMoveDocumentsMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3BatchMoveDocumentsMetadataIndividualBatchMoveSt
// atus: The status of each individual document in the batch move process.
type GoogleCloudDocumentaiUiv1beta3BatchMoveDocumentsMetadataIndividualBatchMoveStatus struct {
	// DocumentId: The document id of the document.
	DocumentId *GoogleCloudDocumentaiUiv1beta3DocumentId `json:"documentId,omitempty"`
	// Status: The status of moving the document.
	Status *GoogleRpcStatus `json:"status,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DocumentId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DocumentId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiUiv1beta3BatchMoveDocumentsMetadataIndividualBatchMoveStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3BatchMoveDocumentsMetadataIndividualBatchMoveStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3BatchMoveDocumentsResponse: Response of the
// batch move documents operation.
type GoogleCloudDocumentaiUiv1beta3BatchMoveDocumentsResponse struct {
}

type GoogleCloudDocumentaiUiv1beta3BatchUpdateDocumentsMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiUiv1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`
	// IndividualBatchUpdateStatuses: The list of response details of each
	// document.
	IndividualBatchUpdateStatuses []*GoogleCloudDocumentaiUiv1beta3BatchUpdateDocumentsMetadataIndividualBatchUpdateStatus `json:"individualBatchUpdateStatuses,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommonMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiUiv1beta3BatchUpdateDocumentsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3BatchUpdateDocumentsMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3BatchUpdateDocumentsMetadataIndividualBatchUpda
// teStatus: The status of each individual document in the batch update
// process.
type GoogleCloudDocumentaiUiv1beta3BatchUpdateDocumentsMetadataIndividualBatchUpdateStatus struct {
	// DocumentId: The document id of the document.
	DocumentId *GoogleCloudDocumentaiUiv1beta3DocumentId `json:"documentId,omitempty"`
	// Status: The status of updating the document in storage.
	Status *GoogleRpcStatus `json:"status,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DocumentId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DocumentId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiUiv1beta3BatchUpdateDocumentsMetadataIndividualBatchUpdateStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3BatchUpdateDocumentsMetadataIndividualBatchUpdateStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3BatchUpdateDocumentsResponse: Response of the
// batch update documents operation.
type GoogleCloudDocumentaiUiv1beta3BatchUpdateDocumentsResponse struct {
}

// GoogleCloudDocumentaiUiv1beta3CommonOperationMetadata: The common metadata
// for long running operations.
type GoogleCloudDocumentaiUiv1beta3CommonOperationMetadata struct {
	// CreateTime: The creation time of the operation.
	CreateTime string `json:"createTime,omitempty"`
	// Resource: A related resource to this operation.
	Resource string `json:"resource,omitempty"`
	// State: The state of the operation.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Unspecified state.
	//   "RUNNING" - Operation is still running.
	//   "CANCELLING" - Operation is being cancelled.
	//   "SUCCEEDED" - Operation succeeded.
	//   "FAILED" - Operation failed.
	//   "CANCELLED" - Operation is cancelled.
	State string `json:"state,omitempty"`
	// StateMessage: A message providing more details about the current state of
	// processing.
	StateMessage string `json:"stateMessage,omitempty"`
	// UpdateTime: The last update time of the operation.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiUiv1beta3CommonOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3CommonOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3CreateLabelerPoolOperationMetadata: The
// long-running operation metadata for the CreateLabelerPool method.
type GoogleCloudDocumentaiUiv1beta3CreateLabelerPoolOperationMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiUiv1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommonMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiUiv1beta3CreateLabelerPoolOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3CreateLabelerPoolOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3DeleteLabelerPoolOperationMetadata: The
// long-running operation metadata for DeleteLabelerPool.
type GoogleCloudDocumentaiUiv1beta3DeleteLabelerPoolOperationMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiUiv1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommonMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiUiv1beta3DeleteLabelerPoolOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3DeleteLabelerPoolOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3DeleteProcessorMetadata: The long-running
// operation metadata for the DeleteProcessor method.
type GoogleCloudDocumentaiUiv1beta3DeleteProcessorMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiUiv1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommonMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiUiv1beta3DeleteProcessorMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3DeleteProcessorMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3DeleteProcessorVersionMetadata: The
// long-running operation metadata for the DeleteProcessorVersion method.
type GoogleCloudDocumentaiUiv1beta3DeleteProcessorVersionMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiUiv1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommonMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiUiv1beta3DeleteProcessorVersionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3DeleteProcessorVersionMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3DeployProcessorVersionMetadata: The
// long-running operation metadata for the DeployProcessorVersion method.
type GoogleCloudDocumentaiUiv1beta3DeployProcessorVersionMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiUiv1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommonMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiUiv1beta3DeployProcessorVersionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3DeployProcessorVersionMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3DeployProcessorVersionResponse: Response
// message for the DeployProcessorVersion method.
type GoogleCloudDocumentaiUiv1beta3DeployProcessorVersionResponse struct {
}

// GoogleCloudDocumentaiUiv1beta3DisableProcessorMetadata: The long-running
// operation metadata for the DisableProcessor method.
type GoogleCloudDocumentaiUiv1beta3DisableProcessorMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiUiv1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommonMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiUiv1beta3DisableProcessorMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3DisableProcessorMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3DisableProcessorResponse: Response message for
// the DisableProcessor method. Intentionally empty proto for adding fields in
// future.
type GoogleCloudDocumentaiUiv1beta3DisableProcessorResponse struct {
}

// GoogleCloudDocumentaiUiv1beta3DocumentId: Document Identifier.
type GoogleCloudDocumentaiUiv1beta3DocumentId struct {
	// GcsManagedDocId: A document id within user-managed Cloud Storage.
	GcsManagedDocId *GoogleCloudDocumentaiUiv1beta3DocumentIdGCSManagedDocumentId `json:"gcsManagedDocId,omitempty"`
	// RevisionRef: Points to a specific revision of the document if set.
	RevisionRef *GoogleCloudDocumentaiUiv1beta3RevisionRef `json:"revisionRef,omitempty"`
	// UnmanagedDocId: A document id within unmanaged dataset.
	UnmanagedDocId *GoogleCloudDocumentaiUiv1beta3DocumentIdUnmanagedDocumentId `json:"unmanagedDocId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GcsManagedDocId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GcsManagedDocId") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiUiv1beta3DocumentId) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3DocumentId
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3DocumentIdGCSManagedDocumentId: Identifies a
// document uniquely within the scope of a dataset in the user-managed Cloud
// Storage option.
type GoogleCloudDocumentaiUiv1beta3DocumentIdGCSManagedDocumentId struct {
	// CwDocId: Id of the document (indexed) managed by Content Warehouse.
	CwDocId string `json:"cwDocId,omitempty"`
	// GcsUri: Required. The Cloud Storage URI where the actual document is stored.
	GcsUri string `json:"gcsUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CwDocId") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CwDocId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiUiv1beta3DocumentIdGCSManagedDocumentId) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3DocumentIdGCSManagedDocumentId
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3DocumentIdUnmanagedDocumentId: Identifies a
// document uniquely within the scope of a dataset in unmanaged option.
type GoogleCloudDocumentaiUiv1beta3DocumentIdUnmanagedDocumentId struct {
	// DocId: Required. The id of the document.
	DocId string `json:"docId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DocId") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DocId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiUiv1beta3DocumentIdUnmanagedDocumentId) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3DocumentIdUnmanagedDocumentId
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3EnableProcessorMetadata: The long-running
// operation metadata for the EnableProcessor method.
type GoogleCloudDocumentaiUiv1beta3EnableProcessorMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiUiv1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommonMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiUiv1beta3EnableProcessorMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3EnableProcessorMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3EnableProcessorResponse: Response message for
// the EnableProcessor method. Intentionally empty proto for adding fields in
// future.
type GoogleCloudDocumentaiUiv1beta3EnableProcessorResponse struct {
}

// GoogleCloudDocumentaiUiv1beta3EvaluateProcessorVersionMetadata: Metadata of
// the EvaluateProcessorVersion method.
type GoogleCloudDocumentaiUiv1beta3EvaluateProcessorVersionMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiUiv1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommonMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiUiv1beta3EvaluateProcessorVersionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3EvaluateProcessorVersionMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3EvaluateProcessorVersionResponse: Response of
// the EvaluateProcessorVersion method.
type GoogleCloudDocumentaiUiv1beta3EvaluateProcessorVersionResponse struct {
	// Evaluation: The resource name of the created evaluation.
	Evaluation string `json:"evaluation,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Evaluation") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Evaluation") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiUiv1beta3EvaluateProcessorVersionResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3EvaluateProcessorVersionResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3ExportDocumentsMetadata: Metadata of the batch
// export documents operation.
type GoogleCloudDocumentaiUiv1beta3ExportDocumentsMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiUiv1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`
	// IndividualExportStatuses: The list of response details of each document.
	IndividualExportStatuses []*GoogleCloudDocumentaiUiv1beta3ExportDocumentsMetadataIndividualExportStatus `json:"individualExportStatuses,omitempty"`
	// SplitExportStats: The list of statistics for each dataset split type.
	SplitExportStats []*GoogleCloudDocumentaiUiv1beta3ExportDocumentsMetadataSplitExportStat `json:"splitExportStats,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommonMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiUiv1beta3ExportDocumentsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3ExportDocumentsMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3ExportDocumentsMetadataIndividualExportStatus:
// The status of each individual document in the export process.
type GoogleCloudDocumentaiUiv1beta3ExportDocumentsMetadataIndividualExportStatus struct {
	// DocumentId: The path to source docproto of the document.
	DocumentId *GoogleCloudDocumentaiUiv1beta3DocumentId `json:"documentId,omitempty"`
	// OutputGcsDestination: The output_gcs_destination of the exported document if
	// it was successful, otherwise empty.
	OutputGcsDestination string `json:"outputGcsDestination,omitempty"`
	// Status: The status of the exporting of the document.
	Status *GoogleRpcStatus `json:"status,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DocumentId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DocumentId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiUiv1beta3ExportDocumentsMetadataIndividualExportStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3ExportDocumentsMetadataIndividualExportStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3ExportDocumentsMetadataSplitExportStat: The
// statistic representing a dataset split type for this export.
type GoogleCloudDocumentaiUiv1beta3ExportDocumentsMetadataSplitExportStat struct {
	// SplitType: The dataset split type.
	//
	// Possible values:
	//   "DATASET_SPLIT_TYPE_UNSPECIFIED" - Default value if the enum is not set.
	//   "DATASET_SPLIT_TRAIN" - Identifies the train documents.
	//   "DATASET_SPLIT_TEST" - Identifies the test documents.
	//   "DATASET_SPLIT_UNASSIGNED" - Identifies the unassigned documents.
	SplitType string `json:"splitType,omitempty"`
	// TotalDocumentCount: Total number of documents with the given dataset split
	// type to be exported.
	TotalDocumentCount int64 `json:"totalDocumentCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SplitType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SplitType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiUiv1beta3ExportDocumentsMetadataSplitExportStat) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3ExportDocumentsMetadataSplitExportStat
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3ExportDocumentsResponse: The response proto of
// ExportDocuments method.
type GoogleCloudDocumentaiUiv1beta3ExportDocumentsResponse struct {
}

// GoogleCloudDocumentaiUiv1beta3ExportProcessorVersionMetadata: Metadata
// message associated with the ExportProcessorVersion operation.
type GoogleCloudDocumentaiUiv1beta3ExportProcessorVersionMetadata struct {
	// CommonMetadata: The common metadata about the operation.
	CommonMetadata *GoogleCloudDocumentaiUiv1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommonMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiUiv1beta3ExportProcessorVersionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3ExportProcessorVersionMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3ExportProcessorVersionResponse: Response
// message associated with the ExportProcessorVersion operation.
type GoogleCloudDocumentaiUiv1beta3ExportProcessorVersionResponse struct {
	// GcsUri: The Cloud Storage URI containing the output artifacts.
	GcsUri string `json:"gcsUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GcsUri") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GcsUri") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiUiv1beta3ExportProcessorVersionResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3ExportProcessorVersionResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3ImportDocumentsMetadata: Metadata of the
// import document operation.
type GoogleCloudDocumentaiUiv1beta3ImportDocumentsMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiUiv1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`
	// ImportConfigValidationResults: Validation statuses of the batch documents
	// import config.
	ImportConfigValidationResults []*GoogleCloudDocumentaiUiv1beta3ImportDocumentsMetadataImportConfigValidationResult `json:"importConfigValidationResults,omitempty"`
	// IndividualImportStatuses: The list of response details of each document.
	IndividualImportStatuses []*GoogleCloudDocumentaiUiv1beta3ImportDocumentsMetadataIndividualImportStatus `json:"individualImportStatuses,omitempty"`
	// TotalDocumentCount: Total number of the documents that are qualified for
	// importing.
	TotalDocumentCount int64 `json:"totalDocumentCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommonMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiUiv1beta3ImportDocumentsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3ImportDocumentsMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3ImportDocumentsMetadataImportConfigValidationRe
// sult: The validation status of each import config. Status is set to an error
// if there are no documents to import in the `import_config`, or `OK` if the
// operation will try to proceed with at least one document.
type GoogleCloudDocumentaiUiv1beta3ImportDocumentsMetadataImportConfigValidationResult struct {
	// InputGcsSource: The source Cloud Storage URI specified in the import config.
	InputGcsSource string `json:"inputGcsSource,omitempty"`
	// Status: The validation status of import config.
	Status *GoogleRpcStatus `json:"status,omitempty"`
	// ForceSendFields is a list of field names (e.g. "InputGcsSource") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InputGcsSource") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiUiv1beta3ImportDocumentsMetadataImportConfigValidationResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3ImportDocumentsMetadataImportConfigValidationResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3ImportDocumentsMetadataIndividualImportStatus:
// The status of each individual document in the import process.
type GoogleCloudDocumentaiUiv1beta3ImportDocumentsMetadataIndividualImportStatus struct {
	// InputGcsSource: The source Cloud Storage URI of the document.
	InputGcsSource string `json:"inputGcsSource,omitempty"`
	// OutputDocumentId: The document id of imported document if it was successful,
	// otherwise empty.
	OutputDocumentId *GoogleCloudDocumentaiUiv1beta3DocumentId `json:"outputDocumentId,omitempty"`
	// OutputGcsDestination: The output_gcs_destination of the processed document
	// if it was successful, otherwise empty.
	OutputGcsDestination string `json:"outputGcsDestination,omitempty"`
	// Status: The status of the importing of the document.
	Status *GoogleRpcStatus `json:"status,omitempty"`
	// ForceSendFields is a list of field names (e.g. "InputGcsSource") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InputGcsSource") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiUiv1beta3ImportDocumentsMetadataIndividualImportStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3ImportDocumentsMetadataIndividualImportStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3ImportDocumentsResponse: Response of the
// import document operation.
type GoogleCloudDocumentaiUiv1beta3ImportDocumentsResponse struct {
}

// GoogleCloudDocumentaiUiv1beta3ImportProcessorVersionMetadata: The
// long-running operation metadata for the ImportProcessorVersion method.
type GoogleCloudDocumentaiUiv1beta3ImportProcessorVersionMetadata struct {
	// CommonMetadata: The basic metadata for the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiUiv1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommonMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiUiv1beta3ImportProcessorVersionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3ImportProcessorVersionMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3ImportProcessorVersionResponse: The response
// message for the ImportProcessorVersion method.
type GoogleCloudDocumentaiUiv1beta3ImportProcessorVersionResponse struct {
	// ProcessorVersion: The destination processor version name.
	ProcessorVersion string `json:"processorVersion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ProcessorVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ProcessorVersion") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiUiv1beta3ImportProcessorVersionResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3ImportProcessorVersionResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3ResyncDatasetMetadata: The metadata proto of
// `ResyncDataset` method.
type GoogleCloudDocumentaiUiv1beta3ResyncDatasetMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiUiv1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`
	// DatasetResyncStatuses: The list of dataset resync statuses. Not checked when
	// ResyncDatasetRequest.dataset_documents is specified.
	DatasetResyncStatuses []*GoogleCloudDocumentaiUiv1beta3ResyncDatasetMetadataDatasetResyncStatus `json:"datasetResyncStatuses,omitempty"`
	// IndividualDocumentResyncStatuses: The list of document resync statuses. The
	// same document could have multiple `individual_document_resync_statuses` if
	// it has multiple inconsistencies.
	IndividualDocumentResyncStatuses []*GoogleCloudDocumentaiUiv1beta3ResyncDatasetMetadataIndividualDocumentResyncStatus `json:"individualDocumentResyncStatuses,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommonMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiUiv1beta3ResyncDatasetMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3ResyncDatasetMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3ResyncDatasetMetadataDatasetResyncStatus:
// Resync status against inconsistency types on the dataset level.
type GoogleCloudDocumentaiUiv1beta3ResyncDatasetMetadataDatasetResyncStatus struct {
	// DatasetInconsistencyType: The type of the inconsistency of the dataset.
	//
	// Possible values:
	//   "DATASET_INCONSISTENCY_TYPE_UNSPECIFIED" - Default value.
	//   "DATASET_INCONSISTENCY_TYPE_NO_STORAGE_MARKER" - The marker file under the
	// dataset folder is not found.
	DatasetInconsistencyType string `json:"datasetInconsistencyType,omitempty"`
	// Status: The status of resyncing the dataset with regards to the detected
	// inconsistency. Empty if ResyncDatasetRequest.validate_only is `true`.
	Status *GoogleRpcStatus `json:"status,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DatasetInconsistencyType")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DatasetInconsistencyType") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiUiv1beta3ResyncDatasetMetadataDatasetResyncStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3ResyncDatasetMetadataDatasetResyncStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3ResyncDatasetMetadataIndividualDocumentResyncSt
// atus: Resync status for each document per inconsistency type.
type GoogleCloudDocumentaiUiv1beta3ResyncDatasetMetadataIndividualDocumentResyncStatus struct {
	// DocumentId: The document identifier.
	DocumentId *GoogleCloudDocumentaiUiv1beta3DocumentId `json:"documentId,omitempty"`
	// DocumentInconsistencyType: The type of document inconsistency.
	//
	// Possible values:
	//   "DOCUMENT_INCONSISTENCY_TYPE_UNSPECIFIED" - Default value.
	//   "DOCUMENT_INCONSISTENCY_TYPE_INVALID_DOCPROTO" - The document proto is
	// invalid.
	//   "DOCUMENT_INCONSISTENCY_TYPE_MISMATCHED_METADATA" - Indexed docproto
	// metadata is mismatched.
	//   "DOCUMENT_INCONSISTENCY_TYPE_NO_PAGE_IMAGE" - The page image or thumbnails
	// are missing.
	DocumentInconsistencyType string `json:"documentInconsistencyType,omitempty"`
	// Status: The status of resyncing the document with regards to the detected
	// inconsistency. Empty if ResyncDatasetRequest.validate_only is `true`.
	Status *GoogleRpcStatus `json:"status,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DocumentId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DocumentId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiUiv1beta3ResyncDatasetMetadataIndividualDocumentResyncStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3ResyncDatasetMetadataIndividualDocumentResyncStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3ResyncDatasetResponse: The response proto of
// ResyncDataset method.
type GoogleCloudDocumentaiUiv1beta3ResyncDatasetResponse struct {
}

// GoogleCloudDocumentaiUiv1beta3RevisionRef: The revision reference specifies
// which revision on the document to read.
type GoogleCloudDocumentaiUiv1beta3RevisionRef struct {
	// LatestProcessorVersion: Reads the revision generated by the processor
	// version. The format takes the full resource name of processor version.
	// `projects/{project}/locations/{location}/processors/{processor}/processorVers
	// ions/{processorVersion}`
	LatestProcessorVersion string `json:"latestProcessorVersion,omitempty"`
	// RevisionCase: Reads the revision by the predefined case.
	//
	// Possible values:
	//   "REVISION_CASE_UNSPECIFIED" - Unspecified case, fall back to read the
	// `LATEST_HUMAN_REVIEW`.
	//   "LATEST_HUMAN_REVIEW" - The latest revision made by a human.
	//   "LATEST_TIMESTAMP" - The latest revision based on timestamp.
	//   "BASE_OCR_REVISION" - The first (OCR) revision.
	RevisionCase string `json:"revisionCase,omitempty"`
	// RevisionId: Reads the revision given by the id.
	RevisionId string `json:"revisionId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LatestProcessorVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LatestProcessorVersion") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiUiv1beta3RevisionRef) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3RevisionRef
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3SampleDocumentsMetadata: Metadata of the
// sample documents operation.
type GoogleCloudDocumentaiUiv1beta3SampleDocumentsMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiUiv1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommonMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiUiv1beta3SampleDocumentsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3SampleDocumentsMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3SampleDocumentsResponse: Response of the
// sample documents operation.
type GoogleCloudDocumentaiUiv1beta3SampleDocumentsResponse struct {
	// SampleTestStatus: The status of sampling documents in test split.
	SampleTestStatus *GoogleRpcStatus `json:"sampleTestStatus,omitempty"`
	// SampleTrainingStatus: The status of sampling documents in training split.
	SampleTrainingStatus *GoogleRpcStatus `json:"sampleTrainingStatus,omitempty"`
	// SelectedDocuments: The result of the sampling process.
	SelectedDocuments []*GoogleCloudDocumentaiUiv1beta3SampleDocumentsResponseSelectedDocument `json:"selectedDocuments,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SampleTestStatus") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SampleTestStatus") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiUiv1beta3SampleDocumentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3SampleDocumentsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDocumentaiUiv1beta3SampleDocumentsResponseSelectedDocument struct {
	// DocumentId: An internal identifier for document.
	DocumentId string `json:"documentId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DocumentId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DocumentId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiUiv1beta3SampleDocumentsResponseSelectedDocument) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3SampleDocumentsResponseSelectedDocument
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3SetDefaultProcessorVersionMetadata: The
// long-running operation metadata for the SetDefaultProcessorVersion method.
type GoogleCloudDocumentaiUiv1beta3SetDefaultProcessorVersionMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiUiv1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommonMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiUiv1beta3SetDefaultProcessorVersionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3SetDefaultProcessorVersionMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3SetDefaultProcessorVersionResponse: Response
// message for the SetDefaultProcessorVersion method.
type GoogleCloudDocumentaiUiv1beta3SetDefaultProcessorVersionResponse struct {
}

// GoogleCloudDocumentaiUiv1beta3TrainProcessorVersionMetadata: The metadata
// that represents a processor version being created.
type GoogleCloudDocumentaiUiv1beta3TrainProcessorVersionMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiUiv1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`
	// TestDatasetValidation: The test dataset validation information.
	TestDatasetValidation *GoogleCloudDocumentaiUiv1beta3TrainProcessorVersionMetadataDatasetValidation `json:"testDatasetValidation,omitempty"`
	// TrainingDatasetValidation: The training dataset validation information.
	TrainingDatasetValidation *GoogleCloudDocumentaiUiv1beta3TrainProcessorVersionMetadataDatasetValidation `json:"trainingDatasetValidation,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommonMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiUiv1beta3TrainProcessorVersionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3TrainProcessorVersionMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3TrainProcessorVersionMetadataDatasetValidation:
//
//	The dataset validation information. This includes any and all errors with
//
// documents and the dataset.
type GoogleCloudDocumentaiUiv1beta3TrainProcessorVersionMetadataDatasetValidation struct {
	// DatasetErrorCount: The total number of dataset errors.
	DatasetErrorCount int64 `json:"datasetErrorCount,omitempty"`
	// DatasetErrors: Error information for the dataset as a whole. A maximum of 10
	// dataset errors will be returned. A single dataset error is terminal for
	// training.
	DatasetErrors []*GoogleRpcStatus `json:"datasetErrors,omitempty"`
	// DocumentErrorCount: The total number of document errors.
	DocumentErrorCount int64 `json:"documentErrorCount,omitempty"`
	// DocumentErrors: Error information pertaining to specific documents. A
	// maximum of 10 document errors will be returned. Any document with errors
	// will not be used throughout training.
	DocumentErrors []*GoogleRpcStatus `json:"documentErrors,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DatasetErrorCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DatasetErrorCount") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiUiv1beta3TrainProcessorVersionMetadataDatasetValidation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3TrainProcessorVersionMetadataDatasetValidation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3TrainProcessorVersionResponse: The response
// for TrainProcessorVersion.
type GoogleCloudDocumentaiUiv1beta3TrainProcessorVersionResponse struct {
	// ProcessorVersion: The resource name of the processor version produced by
	// training.
	ProcessorVersion string `json:"processorVersion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ProcessorVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ProcessorVersion") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiUiv1beta3TrainProcessorVersionResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3TrainProcessorVersionResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3UndeployProcessorVersionMetadata: The
// long-running operation metadata for the UndeployProcessorVersion method.
type GoogleCloudDocumentaiUiv1beta3UndeployProcessorVersionMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiUiv1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommonMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiUiv1beta3UndeployProcessorVersionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3UndeployProcessorVersionMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3UndeployProcessorVersionResponse: Response
// message for the UndeployProcessorVersion method.
type GoogleCloudDocumentaiUiv1beta3UndeployProcessorVersionResponse struct {
}

type GoogleCloudDocumentaiUiv1beta3UpdateDatasetOperationMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiUiv1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommonMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiUiv1beta3UpdateDatasetOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3UpdateDatasetOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3UpdateHumanReviewConfigMetadata: The
// long-running operation metadata for updating the human review configuration.
type GoogleCloudDocumentaiUiv1beta3UpdateHumanReviewConfigMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiUiv1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommonMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiUiv1beta3UpdateHumanReviewConfigMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3UpdateHumanReviewConfigMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3UpdateLabelerPoolOperationMetadata: The
// long-running operation metadata for UpdateLabelerPool.
type GoogleCloudDocumentaiUiv1beta3UpdateLabelerPoolOperationMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiUiv1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommonMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiUiv1beta3UpdateLabelerPoolOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3UpdateLabelerPoolOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1BatchProcessMetadata: The long-running operation
// metadata for BatchProcessDocuments.
type GoogleCloudDocumentaiV1BatchProcessMetadata struct {
	// CreateTime: The creation time of the operation.
	CreateTime string `json:"createTime,omitempty"`
	// IndividualProcessStatuses: The list of response details of each document.
	IndividualProcessStatuses []*GoogleCloudDocumentaiV1BatchProcessMetadataIndividualProcessStatus `json:"individualProcessStatuses,omitempty"`
	// State: The state of the current batch processing.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - The default value. This value is used if the state
	// is omitted.
	//   "WAITING" - Request operation is waiting for scheduling.
	//   "RUNNING" - Request is being processed.
	//   "SUCCEEDED" - The batch processing completed successfully.
	//   "CANCELLING" - The batch processing was being cancelled.
	//   "CANCELLED" - The batch processing was cancelled.
	//   "FAILED" - The batch processing has failed.
	State string `json:"state,omitempty"`
	// StateMessage: A message providing more details about the current state of
	// processing. For example, the error message if the operation is failed.
	StateMessage string `json:"stateMessage,omitempty"`
	// UpdateTime: The last update time of the operation.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1BatchProcessMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1BatchProcessMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1BatchProcessMetadataIndividualProcessStatus: The
// status of a each individual document in the batch process.
type GoogleCloudDocumentaiV1BatchProcessMetadataIndividualProcessStatus struct {
	// HumanReviewStatus: The status of human review on the processed document.
	HumanReviewStatus *GoogleCloudDocumentaiV1HumanReviewStatus `json:"humanReviewStatus,omitempty"`
	// InputGcsSource: The source of the document, same as the input_gcs_source
	// field in the request when the batch process started.
	InputGcsSource string `json:"inputGcsSource,omitempty"`
	// OutputGcsDestination: The Cloud Storage output destination (in the request
	// as DocumentOutputConfig.GcsOutputConfig.gcs_uri) of the processed document
	// if it was successful, otherwise empty.
	OutputGcsDestination string `json:"outputGcsDestination,omitempty"`
	// Status: The status processing the document.
	Status *GoogleRpcStatus `json:"status,omitempty"`
	// ForceSendFields is a list of field names (e.g. "HumanReviewStatus") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "HumanReviewStatus") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1BatchProcessMetadataIndividualProcessStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1BatchProcessMetadataIndividualProcessStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1BatchProcessResponse: Response message for
// BatchProcessDocuments.
type GoogleCloudDocumentaiV1BatchProcessResponse struct {
}

// GoogleCloudDocumentaiV1CommonOperationMetadata: The common metadata for long
// running operations.
type GoogleCloudDocumentaiV1CommonOperationMetadata struct {
	// CreateTime: The creation time of the operation.
	CreateTime string `json:"createTime,omitempty"`
	// Resource: A related resource to this operation.
	Resource string `json:"resource,omitempty"`
	// State: The state of the operation.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Unspecified state.
	//   "RUNNING" - Operation is still running.
	//   "CANCELLING" - Operation is being cancelled.
	//   "SUCCEEDED" - Operation succeeded.
	//   "FAILED" - Operation failed.
	//   "CANCELLED" - Operation is cancelled.
	State string `json:"state,omitempty"`
	// StateMessage: A message providing more details about the current state of
	// processing.
	StateMessage string `json:"stateMessage,omitempty"`
	// UpdateTime: The last update time of the operation.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1CommonOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1CommonOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1DeleteProcessorMetadata: The long-running operation
// metadata for the DeleteProcessor method.
type GoogleCloudDocumentaiV1DeleteProcessorMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiV1CommonOperationMetadata `json:"commonMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommonMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1DeleteProcessorMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1DeleteProcessorMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1DeleteProcessorVersionMetadata: The long-running
// operation metadata for the DeleteProcessorVersion method.
type GoogleCloudDocumentaiV1DeleteProcessorVersionMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiV1CommonOperationMetadata `json:"commonMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommonMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1DeleteProcessorVersionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1DeleteProcessorVersionMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1DeployProcessorVersionMetadata: The long-running
// operation metadata for the DeployProcessorVersion method.
type GoogleCloudDocumentaiV1DeployProcessorVersionMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiV1CommonOperationMetadata `json:"commonMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommonMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1DeployProcessorVersionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1DeployProcessorVersionMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1DeployProcessorVersionResponse: Response message for
// the DeployProcessorVersion method.
type GoogleCloudDocumentaiV1DeployProcessorVersionResponse struct {
}

// GoogleCloudDocumentaiV1DisableProcessorMetadata: The long-running operation
// metadata for the DisableProcessor method.
type GoogleCloudDocumentaiV1DisableProcessorMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiV1CommonOperationMetadata `json:"commonMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommonMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1DisableProcessorMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1DisableProcessorMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1DisableProcessorResponse: Response message for the
// DisableProcessor method. Intentionally empty proto for adding fields in
// future.
type GoogleCloudDocumentaiV1DisableProcessorResponse struct {
}

// GoogleCloudDocumentaiV1EnableProcessorMetadata: The long-running operation
// metadata for the EnableProcessor method.
type GoogleCloudDocumentaiV1EnableProcessorMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiV1CommonOperationMetadata `json:"commonMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommonMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1EnableProcessorMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1EnableProcessorMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1EnableProcessorResponse: Response message for the
// EnableProcessor method. Intentionally empty proto for adding fields in
// future.
type GoogleCloudDocumentaiV1EnableProcessorResponse struct {
}

// GoogleCloudDocumentaiV1EvaluateProcessorVersionMetadata: Metadata of the
// EvaluateProcessorVersion method.
type GoogleCloudDocumentaiV1EvaluateProcessorVersionMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiV1CommonOperationMetadata `json:"commonMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommonMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1EvaluateProcessorVersionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1EvaluateProcessorVersionMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1EvaluateProcessorVersionResponse: Response of the
// EvaluateProcessorVersion method.
type GoogleCloudDocumentaiV1EvaluateProcessorVersionResponse struct {
	// Evaluation: The resource name of the created evaluation.
	Evaluation string `json:"evaluation,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Evaluation") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Evaluation") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1EvaluateProcessorVersionResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1EvaluateProcessorVersionResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1HumanReviewStatus: The status of human review on a
// processed document.
type GoogleCloudDocumentaiV1HumanReviewStatus struct {
	// HumanReviewOperation: The name of the operation triggered by the processed
	// document. This field is populated only when the state is
	// `HUMAN_REVIEW_IN_PROGRESS`. It has the same response type and metadata as
	// the long-running operation returned by ReviewDocument.
	HumanReviewOperation string `json:"humanReviewOperation,omitempty"`
	// State: The state of human review on the processing request.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Human review state is unspecified. Most likely due
	// to an internal error.
	//   "SKIPPED" - Human review is skipped for the document. This can happen
	// because human review isn't enabled on the processor or the processing
	// request has been set to skip this document.
	//   "VALIDATION_PASSED" - Human review validation is triggered and passed, so
	// no review is needed.
	//   "IN_PROGRESS" - Human review validation is triggered and the document is
	// under review.
	//   "ERROR" - Some error happened during triggering human review, see the
	// state_message for details.
	State string `json:"state,omitempty"`
	// StateMessage: A message providing more details about the human review state.
	StateMessage string `json:"stateMessage,omitempty"`
	// ForceSendFields is a list of field names (e.g. "HumanReviewOperation") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "HumanReviewOperation") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1HumanReviewStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1HumanReviewStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1ReviewDocumentOperationMetadata: The long-running
// operation metadata for the ReviewDocument method.
type GoogleCloudDocumentaiV1ReviewDocumentOperationMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiV1CommonOperationMetadata `json:"commonMetadata,omitempty"`
	// QuestionId: The Crowd Compute question ID.
	QuestionId string `json:"questionId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommonMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1ReviewDocumentOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1ReviewDocumentOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1ReviewDocumentResponse: Response message for the
// ReviewDocument method.
type GoogleCloudDocumentaiV1ReviewDocumentResponse struct {
	// GcsDestination: The Cloud Storage uri for the human reviewed document if the
	// review is succeeded.
	GcsDestination string `json:"gcsDestination,omitempty"`
	// RejectionReason: The reason why the review is rejected by reviewer.
	RejectionReason string `json:"rejectionReason,omitempty"`
	// State: The state of the review operation.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - The default value. This value is used if the state
	// is omitted.
	//   "REJECTED" - The review operation is rejected by the reviewer.
	//   "SUCCEEDED" - The review operation is succeeded.
	State string `json:"state,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GcsDestination") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GcsDestination") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1ReviewDocumentResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1ReviewDocumentResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1SetDefaultProcessorVersionMetadata: The long-running
// operation metadata for the SetDefaultProcessorVersion method.
type GoogleCloudDocumentaiV1SetDefaultProcessorVersionMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiV1CommonOperationMetadata `json:"commonMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommonMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1SetDefaultProcessorVersionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1SetDefaultProcessorVersionMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1SetDefaultProcessorVersionResponse: Response message
// for the SetDefaultProcessorVersion method.
type GoogleCloudDocumentaiV1SetDefaultProcessorVersionResponse struct {
}

// GoogleCloudDocumentaiV1TrainProcessorVersionMetadata: The metadata that
// represents a processor version being created.
type GoogleCloudDocumentaiV1TrainProcessorVersionMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiV1CommonOperationMetadata `json:"commonMetadata,omitempty"`
	// TestDatasetValidation: The test dataset validation information.
	TestDatasetValidation *GoogleCloudDocumentaiV1TrainProcessorVersionMetadataDatasetValidation `json:"testDatasetValidation,omitempty"`
	// TrainingDatasetValidation: The training dataset validation information.
	TrainingDatasetValidation *GoogleCloudDocumentaiV1TrainProcessorVersionMetadataDatasetValidation `json:"trainingDatasetValidation,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommonMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1TrainProcessorVersionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1TrainProcessorVersionMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1TrainProcessorVersionMetadataDatasetValidation: The
// dataset validation information. This includes any and all errors with
// documents and the dataset.
type GoogleCloudDocumentaiV1TrainProcessorVersionMetadataDatasetValidation struct {
	// DatasetErrorCount: The total number of dataset errors.
	DatasetErrorCount int64 `json:"datasetErrorCount,omitempty"`
	// DatasetErrors: Error information for the dataset as a whole. A maximum of 10
	// dataset errors will be returned. A single dataset error is terminal for
	// training.
	DatasetErrors []*GoogleRpcStatus `json:"datasetErrors,omitempty"`
	// DocumentErrorCount: The total number of document errors.
	DocumentErrorCount int64 `json:"documentErrorCount,omitempty"`
	// DocumentErrors: Error information pertaining to specific documents. A
	// maximum of 10 document errors will be returned. Any document with errors
	// will not be used throughout training.
	DocumentErrors []*GoogleRpcStatus `json:"documentErrors,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DatasetErrorCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DatasetErrorCount") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1TrainProcessorVersionMetadataDatasetValidation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1TrainProcessorVersionMetadataDatasetValidation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1TrainProcessorVersionResponse: The response for
// TrainProcessorVersion.
type GoogleCloudDocumentaiV1TrainProcessorVersionResponse struct {
	// ProcessorVersion: The resource name of the processor version produced by
	// training.
	ProcessorVersion string `json:"processorVersion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ProcessorVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ProcessorVersion") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1TrainProcessorVersionResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1TrainProcessorVersionResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1UndeployProcessorVersionMetadata: The long-running
// operation metadata for the UndeployProcessorVersion method.
type GoogleCloudDocumentaiV1UndeployProcessorVersionMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiV1CommonOperationMetadata `json:"commonMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommonMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1UndeployProcessorVersionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1UndeployProcessorVersionMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1UndeployProcessorVersionResponse: Response message
// for the UndeployProcessorVersion method.
type GoogleCloudDocumentaiV1UndeployProcessorVersionResponse struct {
}

// GoogleCloudDocumentaiV1beta1Barcode: Encodes the detailed information of a
// barcode.
type GoogleCloudDocumentaiV1beta1Barcode struct {
	// Format: Format of a barcode. The supported formats are: - `CODE_128`: Code
	// 128 type. - `CODE_39`: Code 39 type. - `CODE_93`: Code 93 type. - `CODABAR`:
	// Codabar type. - `DATA_MATRIX`: 2D Data Matrix type. - `ITF`: ITF type. -
	// `EAN_13`: EAN-13 type. - `EAN_8`: EAN-8 type. - `QR_CODE`: 2D QR code type.
	// - `UPC_A`: UPC-A type. - `UPC_E`: UPC-E type. - `PDF417`: PDF417 type. -
	// `AZTEC`: 2D Aztec code type. - `DATABAR`: GS1 DataBar code type.
	Format string `json:"format,omitempty"`
	// RawValue: Raw value encoded in the barcode. For example:
	// `'MEBKM:TITLE:Google;URL:https://www.google.com;;'`.
	RawValue string `json:"rawValue,omitempty"`
	// ValueFormat: Value format describes the format of the value that a barcode
	// encodes. The supported formats are: - `CONTACT_INFO`: Contact information. -
	// `EMAIL`: Email address. - `ISBN`: ISBN identifier. - `PHONE`: Phone number.
	// - `PRODUCT`: Product. - `SMS`: SMS message. - `TEXT`: Text string. - `URL`:
	// URL address. - `WIFI`: Wifi information. - `GEO`: Geo-localization. -
	// `CALENDAR_EVENT`: Calendar event. - `DRIVER_LICENSE`: Driver's license.
	ValueFormat string `json:"valueFormat,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Format") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Format") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta1Barcode) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta1Barcode
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta1BatchProcessDocumentsResponse: Response to an
// batch document processing request. This is returned in the LRO Operation
// after the operation is complete.
type GoogleCloudDocumentaiV1beta1BatchProcessDocumentsResponse struct {
	// Responses: Responses for each individual document.
	Responses []*GoogleCloudDocumentaiV1beta1ProcessDocumentResponse `json:"responses,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Responses") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Responses") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta1BatchProcessDocumentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta1BatchProcessDocumentsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta1BoundingPoly: A bounding polygon for the
// detected image annotation.
type GoogleCloudDocumentaiV1beta1BoundingPoly struct {
	// NormalizedVertices: The bounding polygon normalized vertices.
	NormalizedVertices []*GoogleCloudDocumentaiV1beta1NormalizedVertex `json:"normalizedVertices,omitempty"`
	// Vertices: The bounding polygon vertices.
	Vertices []*GoogleCloudDocumentaiV1beta1Vertex `json:"vertices,omitempty"`
	// ForceSendFields is a list of field names (e.g. "NormalizedVertices") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NormalizedVertices") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta1BoundingPoly) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta1BoundingPoly
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta1Document: Document represents the canonical
// document resource in Document AI. It is an interchange format that provides
// insights into documents and allows for collaboration between users and
// Document AI to iterate and optimize for quality.
type GoogleCloudDocumentaiV1beta1Document struct {
	// ChunkedDocument: Document chunked based on chunking config.
	ChunkedDocument *GoogleCloudDocumentaiV1beta1DocumentChunkedDocument `json:"chunkedDocument,omitempty"`
	// Content: Optional. Inline document content, represented as a stream of
	// bytes. Note: As with all `bytes` fields, protobuffers use a pure binary
	// representation, whereas JSON representations use base64.
	Content string `json:"content,omitempty"`
	// DocumentLayout: Parsed layout of the document.
	DocumentLayout *GoogleCloudDocumentaiV1beta1DocumentDocumentLayout `json:"documentLayout,omitempty"`
	// Entities: A list of entities detected on Document.text. For document shards,
	// entities in this list may cross shard boundaries.
	Entities []*GoogleCloudDocumentaiV1beta1DocumentEntity `json:"entities,omitempty"`
	// EntityRelations: Placeholder. Relationship among Document.entities.
	EntityRelations []*GoogleCloudDocumentaiV1beta1DocumentEntityRelation `json:"entityRelations,omitempty"`
	// Error: Any error that occurred while processing this document.
	Error *GoogleRpcStatus `json:"error,omitempty"`
	// MimeType: An IANA published media type (MIME type)
	// (https://www.iana.org/assignments/media-types/media-types.xhtml).
	MimeType string `json:"mimeType,omitempty"`
	// Pages: Visual page layout for the Document.
	Pages []*GoogleCloudDocumentaiV1beta1DocumentPage `json:"pages,omitempty"`
	// Revisions: Placeholder. Revision history of this document.
	Revisions []*GoogleCloudDocumentaiV1beta1DocumentRevision `json:"revisions,omitempty"`
	// ShardInfo: Information about the sharding if this document is sharded part
	// of a larger document. If the document is not sharded, this message is not
	// specified.
	ShardInfo *GoogleCloudDocumentaiV1beta1DocumentShardInfo `json:"shardInfo,omitempty"`
	// Text: Optional. UTF-8 encoded text in reading order from the document.
	Text string `json:"text,omitempty"`
	// TextChanges: Placeholder. A list of text corrections made to Document.text.
	// This is usually used for annotating corrections to OCR mistakes. Text
	// changes for a given revision may not overlap with each other.
	TextChanges []*GoogleCloudDocumentaiV1beta1DocumentTextChange `json:"textChanges,omitempty"`
	// TextStyles: Styles for the Document.text.
	TextStyles []*GoogleCloudDocumentaiV1beta1DocumentStyle `json:"textStyles,omitempty"`
	// Uri: Optional. Currently supports Google Cloud Storage URI of the form
	// `gs://bucket_name/object_name`. Object versioning is not supported. For more
	// information, refer to Google Cloud Storage Request URIs
	// (https://cloud.google.com/storage/docs/reference-uris).
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChunkedDocument") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChunkedDocument") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta1Document) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta1Document
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta1DocumentChunkedDocument: Represents the chunks
// that the document is divided into.
type GoogleCloudDocumentaiV1beta1DocumentChunkedDocument struct {
	// Chunks: List of chunks.
	Chunks []*GoogleCloudDocumentaiV1beta1DocumentChunkedDocumentChunk `json:"chunks,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Chunks") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Chunks") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta1DocumentChunkedDocument) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta1DocumentChunkedDocument
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta1DocumentChunkedDocumentChunk: Represents a
// chunk.
type GoogleCloudDocumentaiV1beta1DocumentChunkedDocumentChunk struct {
	// ChunkId: ID of the chunk.
	ChunkId string `json:"chunkId,omitempty"`
	// Content: Text content of the chunk.
	Content string `json:"content,omitempty"`
	// PageFooters: Page footers associated with the chunk.
	PageFooters []*GoogleCloudDocumentaiV1beta1DocumentChunkedDocumentChunkChunkPageFooter `json:"pageFooters,omitempty"`
	// PageHeaders: Page headers associated with the chunk.
	PageHeaders []*GoogleCloudDocumentaiV1beta1DocumentChunkedDocumentChunkChunkPageHeader `json:"pageHeaders,omitempty"`
	// PageSpan: Page span of the chunk.
	PageSpan *GoogleCloudDocumentaiV1beta1DocumentChunkedDocumentChunkChunkPageSpan `json:"pageSpan,omitempty"`
	// SourceBlockIds: Unused.
	SourceBlockIds []string `json:"sourceBlockIds,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChunkId") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChunkId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta1DocumentChunkedDocumentChunk) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta1DocumentChunkedDocumentChunk
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta1DocumentChunkedDocumentChunkChunkPageFooter:
// Represents the page footer associated with the chunk.
type GoogleCloudDocumentaiV1beta1DocumentChunkedDocumentChunkChunkPageFooter struct {
	// PageSpan: Page span of the footer.
	PageSpan *GoogleCloudDocumentaiV1beta1DocumentChunkedDocumentChunkChunkPageSpan `json:"pageSpan,omitempty"`
	// Text: Footer in text format.
	Text string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PageSpan") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PageSpan") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta1DocumentChunkedDocumentChunkChunkPageFooter) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta1DocumentChunkedDocumentChunkChunkPageFooter
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta1DocumentChunkedDocumentChunkChunkPageHeader:
// Represents the page header associated with the chunk.
type GoogleCloudDocumentaiV1beta1DocumentChunkedDocumentChunkChunkPageHeader struct {
	// PageSpan: Page span of the header.
	PageSpan *GoogleCloudDocumentaiV1beta1DocumentChunkedDocumentChunkChunkPageSpan `json:"pageSpan,omitempty"`
	// Text: Header in text format.
	Text string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PageSpan") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PageSpan") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta1DocumentChunkedDocumentChunkChunkPageHeader) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta1DocumentChunkedDocumentChunkChunkPageHeader
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta1DocumentChunkedDocumentChunkChunkPageSpan:
// Represents where the chunk starts and ends in the document.
type GoogleCloudDocumentaiV1beta1DocumentChunkedDocumentChunkChunkPageSpan struct {
	// PageEnd: Page where chunk ends in the document.
	PageEnd int64 `json:"pageEnd,omitempty"`
	// PageStart: Page where chunk starts in the document.
	PageStart int64 `json:"pageStart,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PageEnd") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PageEnd") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta1DocumentChunkedDocumentChunkChunkPageSpan) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta1DocumentChunkedDocumentChunkChunkPageSpan
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta1DocumentDocumentLayout: Represents the parsed
// layout of a document as a collection of blocks that the document is divided
// into.
type GoogleCloudDocumentaiV1beta1DocumentDocumentLayout struct {
	// Blocks: List of blocks in the document.
	Blocks []*GoogleCloudDocumentaiV1beta1DocumentDocumentLayoutDocumentLayoutBlock `json:"blocks,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Blocks") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Blocks") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta1DocumentDocumentLayout) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta1DocumentDocumentLayout
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta1DocumentDocumentLayoutDocumentLayoutBlock:
// Represents a block. A block could be one of the various types (text, table,
// list) supported.
type GoogleCloudDocumentaiV1beta1DocumentDocumentLayoutDocumentLayoutBlock struct {
	// BlockId: ID of the block.
	BlockId string `json:"blockId,omitempty"`
	// ListBlock: Block consisting of list content/structure.
	ListBlock *GoogleCloudDocumentaiV1beta1DocumentDocumentLayoutDocumentLayoutBlockLayoutListBlock `json:"listBlock,omitempty"`
	// PageSpan: Page span of the block.
	PageSpan *GoogleCloudDocumentaiV1beta1DocumentDocumentLayoutDocumentLayoutBlockLayoutPageSpan `json:"pageSpan,omitempty"`
	// TableBlock: Block consisting of table content/structure.
	TableBlock *GoogleCloudDocumentaiV1beta1DocumentDocumentLayoutDocumentLayoutBlockLayoutTableBlock `json:"tableBlock,omitempty"`
	// TextBlock: Block consisting of text content.
	TextBlock *GoogleCloudDocumentaiV1beta1DocumentDocumentLayoutDocumentLayoutBlockLayoutTextBlock `json:"textBlock,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BlockId") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BlockId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta1DocumentDocumentLayoutDocumentLayoutBlock) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta1DocumentDocumentLayoutDocumentLayoutBlock
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta1DocumentDocumentLayoutDocumentLayoutBlockLayoutLi
// stBlock: Represents a list type block.
type GoogleCloudDocumentaiV1beta1DocumentDocumentLayoutDocumentLayoutBlockLayoutListBlock struct {
	// ListEntries: List entries that constitute a list block.
	ListEntries []*GoogleCloudDocumentaiV1beta1DocumentDocumentLayoutDocumentLayoutBlockLayoutListEntry `json:"listEntries,omitempty"`
	// Type: Type of the list_entries (if exist). Available options are `ordered`
	// and `unordered`.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ListEntries") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ListEntries") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta1DocumentDocumentLayoutDocumentLayoutBlockLayoutListBlock) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta1DocumentDocumentLayoutDocumentLayoutBlockLayoutListBlock
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta1DocumentDocumentLayoutDocumentLayoutBlockLayoutLi
// stEntry: Represents an entry in the list.
type GoogleCloudDocumentaiV1beta1DocumentDocumentLayoutDocumentLayoutBlockLayoutListEntry struct {
	// Blocks: A list entry is a list of blocks. Repeated blocks support further
	// hierarchies and nested blocks.
	Blocks []*GoogleCloudDocumentaiV1beta1DocumentDocumentLayoutDocumentLayoutBlock `json:"blocks,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Blocks") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Blocks") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta1DocumentDocumentLayoutDocumentLayoutBlockLayoutListEntry) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta1DocumentDocumentLayoutDocumentLayoutBlockLayoutListEntry
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta1DocumentDocumentLayoutDocumentLayoutBlockLayoutPa
// geSpan: Represents where the block starts and ends in the document.
type GoogleCloudDocumentaiV1beta1DocumentDocumentLayoutDocumentLayoutBlockLayoutPageSpan struct {
	// PageEnd: Page where block ends in the document.
	PageEnd int64 `json:"pageEnd,omitempty"`
	// PageStart: Page where block starts in the document.
	PageStart int64 `json:"pageStart,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PageEnd") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PageEnd") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta1DocumentDocumentLayoutDocumentLayoutBlockLayoutPageSpan) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta1DocumentDocumentLayoutDocumentLayoutBlockLayoutPageSpan
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta1DocumentDocumentLayoutDocumentLayoutBlockLayoutTa
// bleBlock: Represents a table type block.
type GoogleCloudDocumentaiV1beta1DocumentDocumentLayoutDocumentLayoutBlockLayoutTableBlock struct {
	// BodyRows: Body rows containing main table content.
	BodyRows []*GoogleCloudDocumentaiV1beta1DocumentDocumentLayoutDocumentLayoutBlockLayoutTableRow `json:"bodyRows,omitempty"`
	// Caption: Table caption/title.
	Caption string `json:"caption,omitempty"`
	// HeaderRows: Header rows at the top of the table.
	HeaderRows []*GoogleCloudDocumentaiV1beta1DocumentDocumentLayoutDocumentLayoutBlockLayoutTableRow `json:"headerRows,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BodyRows") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BodyRows") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta1DocumentDocumentLayoutDocumentLayoutBlockLayoutTableBlock) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta1DocumentDocumentLayoutDocumentLayoutBlockLayoutTableBlock
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta1DocumentDocumentLayoutDocumentLayoutBlockLayoutTa
// bleCell: Represents a cell in a table row.
type GoogleCloudDocumentaiV1beta1DocumentDocumentLayoutDocumentLayoutBlockLayoutTableCell struct {
	// Blocks: A table cell is a list of blocks. Repeated blocks support further
	// hierarchies and nested blocks.
	Blocks []*GoogleCloudDocumentaiV1beta1DocumentDocumentLayoutDocumentLayoutBlock `json:"blocks,omitempty"`
	// ColSpan: How many columns this cell spans.
	ColSpan int64 `json:"colSpan,omitempty"`
	// RowSpan: How many rows this cell spans.
	RowSpan int64 `json:"rowSpan,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Blocks") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Blocks") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta1DocumentDocumentLayoutDocumentLayoutBlockLayoutTableCell) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta1DocumentDocumentLayoutDocumentLayoutBlockLayoutTableCell
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta1DocumentDocumentLayoutDocumentLayoutBlockLayoutTa
// bleRow: Represents a row in a table.
type GoogleCloudDocumentaiV1beta1DocumentDocumentLayoutDocumentLayoutBlockLayoutTableRow struct {
	// Cells: A table row is a list of table cells.
	Cells []*GoogleCloudDocumentaiV1beta1DocumentDocumentLayoutDocumentLayoutBlockLayoutTableCell `json:"cells,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Cells") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Cells") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta1DocumentDocumentLayoutDocumentLayoutBlockLayoutTableRow) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta1DocumentDocumentLayoutDocumentLayoutBlockLayoutTableRow
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta1DocumentDocumentLayoutDocumentLayoutBlockLayoutTe
// xtBlock: Represents a text type block.
type GoogleCloudDocumentaiV1beta1DocumentDocumentLayoutDocumentLayoutBlockLayoutTextBlock struct {
	// Blocks: A text block could further have child blocks. Repeated blocks
	// support further hierarchies and nested blocks.
	Blocks []*GoogleCloudDocumentaiV1beta1DocumentDocumentLayoutDocumentLayoutBlock `json:"blocks,omitempty"`
	// Text: Text content stored in the block.
	Text string `json:"text,omitempty"`
	// Type: Type of the text in the block. Available options are: `paragraph`,
	// `subtitle`, `heading-1`, `heading-2`, `heading-3`, `heading-4`, `heading-5`,
	// `header`, `footer`.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Blocks") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Blocks") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta1DocumentDocumentLayoutDocumentLayoutBlockLayoutTextBlock) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta1DocumentDocumentLayoutDocumentLayoutBlockLayoutTextBlock
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta1DocumentEntity: An entity that could be a phrase
// in the text or a property that belongs to the document. It is a known entity
// type, such as a person, an organization, or location.
type GoogleCloudDocumentaiV1beta1DocumentEntity struct {
	// Confidence: Optional. Confidence of detected Schema entity. Range `[0, 1]`.
	Confidence float64 `json:"confidence,omitempty"`
	// Id: Optional. Canonical id. This will be a unique value in the entity list
	// for this document.
	Id string `json:"id,omitempty"`
	// MentionId: Optional. Deprecated. Use `id` field instead.
	MentionId string `json:"mentionId,omitempty"`
	// MentionText: Optional. Text value of the entity e.g. `1600 Amphitheatre
	// Pkwy`.
	MentionText string `json:"mentionText,omitempty"`
	// NormalizedValue: Optional. Normalized entity value. Absent if the extracted
	// value could not be converted or the type (e.g. address) is not supported for
	// certain parsers. This field is also only populated for certain supported
	// document types.
	NormalizedValue *GoogleCloudDocumentaiV1beta1DocumentEntityNormalizedValue `json:"normalizedValue,omitempty"`
	// PageAnchor: Optional. Represents the provenance of this entity wrt. the
	// location on the page where it was found.
	PageAnchor *GoogleCloudDocumentaiV1beta1DocumentPageAnchor `json:"pageAnchor,omitempty"`
	// Properties: Optional. Entities can be nested to form a hierarchical data
	// structure representing the content in the document.
	Properties []*GoogleCloudDocumentaiV1beta1DocumentEntity `json:"properties,omitempty"`
	// Provenance: Optional. The history of this annotation.
	Provenance *GoogleCloudDocumentaiV1beta1DocumentProvenance `json:"provenance,omitempty"`
	// Redacted: Optional. Whether the entity will be redacted for
	// de-identification purposes.
	Redacted bool `json:"redacted,omitempty"`
	// TextAnchor: Optional. Provenance of the entity. Text anchor indexing into
	// the Document.text.
	TextAnchor *GoogleCloudDocumentaiV1beta1DocumentTextAnchor `json:"textAnchor,omitempty"`
	// Type: Required. Entity type from a schema e.g. `Address`.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Confidence") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Confidence") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta1DocumentEntity) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta1DocumentEntity
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDocumentaiV1beta1DocumentEntity) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDocumentaiV1beta1DocumentEntity
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

// GoogleCloudDocumentaiV1beta1DocumentEntityNormalizedValue: Parsed and
// normalized entity value.
type GoogleCloudDocumentaiV1beta1DocumentEntityNormalizedValue struct {
	// AddressValue: Postal address. See also:
	// https://github.com/googleapis/googleapis/blob/master/google/type/postal_address.proto
	AddressValue *GoogleTypePostalAddress `json:"addressValue,omitempty"`
	// BooleanValue: Boolean value. Can be used for entities with binary values, or
	// for checkboxes.
	BooleanValue bool `json:"booleanValue,omitempty"`
	// DateValue: Date value. Includes year, month, day. See also:
	// https://github.com/googleapis/googleapis/blob/master/google/type/date.proto
	DateValue *GoogleTypeDate `json:"dateValue,omitempty"`
	// DatetimeValue: DateTime value. Includes date, time, and timezone. See also:
	// https://github.com/googleapis/googleapis/blob/master/google/type/datetime.proto
	DatetimeValue *GoogleTypeDateTime `json:"datetimeValue,omitempty"`
	// FloatValue: Float value.
	FloatValue float64 `json:"floatValue,omitempty"`
	// IntegerValue: Integer value.
	IntegerValue int64 `json:"integerValue,omitempty"`
	// MoneyValue: Money value. See also:
	// https://github.com/googleapis/googleapis/blob/master/google/type/money.proto
	MoneyValue *GoogleTypeMoney `json:"moneyValue,omitempty"`
	// Text: Optional. An optional field to store a normalized string. For some
	// entity types, one of respective `structured_value` fields may also be
	// populated. Also not all the types of `structured_value` will be normalized.
	// For example, some processors may not generate `float` or `integer`
	// normalized text by default. Below are sample formats mapped to structured
	// values. - Money/Currency type (`money_value`) is in the ISO 4217 text
	// format. - Date type (`date_value`) is in the ISO 8601 text format. -
	// Datetime type (`datetime_value`) is in the ISO 8601 text format.
	Text string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AddressValue") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AddressValue") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta1DocumentEntityNormalizedValue) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta1DocumentEntityNormalizedValue
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDocumentaiV1beta1DocumentEntityNormalizedValue) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDocumentaiV1beta1DocumentEntityNormalizedValue
	var s1 struct {
		FloatValue gensupport.JSONFloat64 `json:"floatValue"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.FloatValue = float64(s1.FloatValue)
	return nil
}

// GoogleCloudDocumentaiV1beta1DocumentEntityRelation: Relationship between
// Entities.
type GoogleCloudDocumentaiV1beta1DocumentEntityRelation struct {
	// ObjectId: Object entity id.
	ObjectId string `json:"objectId,omitempty"`
	// Relation: Relationship description.
	Relation string `json:"relation,omitempty"`
	// SubjectId: Subject entity id.
	SubjectId string `json:"subjectId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ObjectId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ObjectId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta1DocumentEntityRelation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta1DocumentEntityRelation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta1DocumentPage: A page in a Document.
type GoogleCloudDocumentaiV1beta1DocumentPage struct {
	// Blocks: A list of visually detected text blocks on the page. A block has a
	// set of lines (collected into paragraphs) that have a common line-spacing and
	// orientation.
	Blocks []*GoogleCloudDocumentaiV1beta1DocumentPageBlock `json:"blocks,omitempty"`
	// DetectedBarcodes: A list of detected barcodes.
	DetectedBarcodes []*GoogleCloudDocumentaiV1beta1DocumentPageDetectedBarcode `json:"detectedBarcodes,omitempty"`
	// DetectedLanguages: A list of detected languages together with confidence.
	DetectedLanguages []*GoogleCloudDocumentaiV1beta1DocumentPageDetectedLanguage `json:"detectedLanguages,omitempty"`
	// Dimension: Physical dimension of the page.
	Dimension *GoogleCloudDocumentaiV1beta1DocumentPageDimension `json:"dimension,omitempty"`
	// FormFields: A list of visually detected form fields on the page.
	FormFields []*GoogleCloudDocumentaiV1beta1DocumentPageFormField `json:"formFields,omitempty"`
	// Image: Rendered image for this page. This image is preprocessed to remove
	// any skew, rotation, and distortions such that the annotation bounding boxes
	// can be upright and axis-aligned.
	Image *GoogleCloudDocumentaiV1beta1DocumentPageImage `json:"image,omitempty"`
	// ImageQualityScores: Image quality scores.
	ImageQualityScores *GoogleCloudDocumentaiV1beta1DocumentPageImageQualityScores `json:"imageQualityScores,omitempty"`
	// Layout: Layout for the page.
	Layout *GoogleCloudDocumentaiV1beta1DocumentPageLayout `json:"layout,omitempty"`
	// Lines: A list of visually detected text lines on the page. A collection of
	// tokens that a human would perceive as a line.
	Lines []*GoogleCloudDocumentaiV1beta1DocumentPageLine `json:"lines,omitempty"`
	// PageNumber: 1-based index for current Page in a parent Document. Useful when
	// a page is taken out of a Document for individual processing.
	PageNumber int64 `json:"pageNumber,omitempty"`
	// Paragraphs: A list of visually detected text paragraphs on the page. A
	// collection of lines that a human would perceive as a paragraph.
	Paragraphs []*GoogleCloudDocumentaiV1beta1DocumentPageParagraph `json:"paragraphs,omitempty"`
	// Provenance: The history of this page.
	Provenance *GoogleCloudDocumentaiV1beta1DocumentProvenance `json:"provenance,omitempty"`
	// Symbols: A list of visually detected symbols on the page.
	Symbols []*GoogleCloudDocumentaiV1beta1DocumentPageSymbol `json:"symbols,omitempty"`
	// Tables: A list of visually detected tables on the page.
	Tables []*GoogleCloudDocumentaiV1beta1DocumentPageTable `json:"tables,omitempty"`
	// Tokens: A list of visually detected tokens on the page.
	Tokens []*GoogleCloudDocumentaiV1beta1DocumentPageToken `json:"tokens,omitempty"`
	// Transforms: Transformation matrices that were applied to the original
	// document image to produce Page.image.
	Transforms []*GoogleCloudDocumentaiV1beta1DocumentPageMatrix `json:"transforms,omitempty"`
	// VisualElements: A list of detected non-text visual elements e.g. checkbox,
	// signature etc. on the page.
	VisualElements []*GoogleCloudDocumentaiV1beta1DocumentPageVisualElement `json:"visualElements,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Blocks") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Blocks") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta1DocumentPage) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta1DocumentPage
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta1DocumentPageAnchor: Referencing the visual
// context of the entity in the Document.pages. Page anchors can be cross-page,
// consist of multiple bounding polygons and optionally reference specific
// layout element types.
type GoogleCloudDocumentaiV1beta1DocumentPageAnchor struct {
	// PageRefs: One or more references to visual page elements
	PageRefs []*GoogleCloudDocumentaiV1beta1DocumentPageAnchorPageRef `json:"pageRefs,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PageRefs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PageRefs") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta1DocumentPageAnchor) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta1DocumentPageAnchor
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta1DocumentPageAnchorPageRef: Represents a weak
// reference to a page element within a document.
type GoogleCloudDocumentaiV1beta1DocumentPageAnchorPageRef struct {
	// BoundingPoly: Optional. Identifies the bounding polygon of a layout element
	// on the page. If `layout_type` is set, the bounding polygon must be exactly
	// the same to the layout element it's referring to.
	BoundingPoly *GoogleCloudDocumentaiV1beta1BoundingPoly `json:"boundingPoly,omitempty"`
	// Confidence: Optional. Confidence of detected page element, if applicable.
	// Range `[0, 1]`.
	Confidence float64 `json:"confidence,omitempty"`
	// LayoutId: Optional. Deprecated. Use PageRef.bounding_poly instead.
	LayoutId string `json:"layoutId,omitempty"`
	// LayoutType: Optional. The type of the layout element that is being
	// referenced if any.
	//
	// Possible values:
	//   "LAYOUT_TYPE_UNSPECIFIED" - Layout Unspecified.
	//   "BLOCK" - References a Page.blocks element.
	//   "PARAGRAPH" - References a Page.paragraphs element.
	//   "LINE" - References a Page.lines element.
	//   "TOKEN" - References a Page.tokens element.
	//   "VISUAL_ELEMENT" - References a Page.visual_elements element.
	//   "TABLE" - Refrrences a Page.tables element.
	//   "FORM_FIELD" - References a Page.form_fields element.
	LayoutType string `json:"layoutType,omitempty"`
	// Page: Required. Index into the Document.pages element, for example using
	// `Document.pages` to locate the related page element. This field is skipped
	// when its value is the default `0`. See
	// https://developers.google.com/protocol-buffers/docs/proto3#json.
	Page int64 `json:"page,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "BoundingPoly") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BoundingPoly") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta1DocumentPageAnchorPageRef) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta1DocumentPageAnchorPageRef
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDocumentaiV1beta1DocumentPageAnchorPageRef) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDocumentaiV1beta1DocumentPageAnchorPageRef
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

// GoogleCloudDocumentaiV1beta1DocumentPageBlock: A block has a set of lines
// (collected into paragraphs) that have a common line-spacing and orientation.
type GoogleCloudDocumentaiV1beta1DocumentPageBlock struct {
	// DetectedLanguages: A list of detected languages together with confidence.
	DetectedLanguages []*GoogleCloudDocumentaiV1beta1DocumentPageDetectedLanguage `json:"detectedLanguages,omitempty"`
	// Layout: Layout for Block.
	Layout *GoogleCloudDocumentaiV1beta1DocumentPageLayout `json:"layout,omitempty"`
	// Provenance: The history of this annotation.
	Provenance *GoogleCloudDocumentaiV1beta1DocumentProvenance `json:"provenance,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DetectedLanguages") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DetectedLanguages") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta1DocumentPageBlock) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta1DocumentPageBlock
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta1DocumentPageDetectedBarcode: A detected barcode.
type GoogleCloudDocumentaiV1beta1DocumentPageDetectedBarcode struct {
	// Barcode: Detailed barcode information of the DetectedBarcode.
	Barcode *GoogleCloudDocumentaiV1beta1Barcode `json:"barcode,omitempty"`
	// Layout: Layout for DetectedBarcode.
	Layout *GoogleCloudDocumentaiV1beta1DocumentPageLayout `json:"layout,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Barcode") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Barcode") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta1DocumentPageDetectedBarcode) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta1DocumentPageDetectedBarcode
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta1DocumentPageDetectedLanguage: Detected language
// for a structural component.
type GoogleCloudDocumentaiV1beta1DocumentPageDetectedLanguage struct {
	// Confidence: Confidence of detected language. Range `[0, 1]`.
	Confidence float64 `json:"confidence,omitempty"`
	// LanguageCode: The BCP-47 language code
	// (https://www.unicode.org/reports/tr35/#Unicode_locale_identifier), such as
	// `en-US` or `sr-Latn`.
	LanguageCode string `json:"languageCode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Confidence") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Confidence") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta1DocumentPageDetectedLanguage) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta1DocumentPageDetectedLanguage
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDocumentaiV1beta1DocumentPageDetectedLanguage) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDocumentaiV1beta1DocumentPageDetectedLanguage
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

// GoogleCloudDocumentaiV1beta1DocumentPageDimension: Dimension for the page.
type GoogleCloudDocumentaiV1beta1DocumentPageDimension struct {
	// Height: Page height.
	Height float64 `json:"height,omitempty"`
	// Unit: Dimension unit.
	Unit string `json:"unit,omitempty"`
	// Width: Page width.
	Width float64 `json:"width,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Height") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Height") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta1DocumentPageDimension) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta1DocumentPageDimension
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDocumentaiV1beta1DocumentPageDimension) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDocumentaiV1beta1DocumentPageDimension
	var s1 struct {
		Height gensupport.JSONFloat64 `json:"height"`
		Width  gensupport.JSONFloat64 `json:"width"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Height = float64(s1.Height)
	s.Width = float64(s1.Width)
	return nil
}

// GoogleCloudDocumentaiV1beta1DocumentPageFormField: A form field detected on
// the page.
type GoogleCloudDocumentaiV1beta1DocumentPageFormField struct {
	// CorrectedKeyText: Created for Labeling UI to export key text. If corrections
	// were made to the text identified by the `field_name.text_anchor`, this field
	// will contain the correction.
	CorrectedKeyText string `json:"correctedKeyText,omitempty"`
	// CorrectedValueText: Created for Labeling UI to export value text. If
	// corrections were made to the text identified by the
	// `field_value.text_anchor`, this field will contain the correction.
	CorrectedValueText string `json:"correctedValueText,omitempty"`
	// FieldName: Layout for the FormField name. e.g. `Address`, `Email`, `Grand
	// total`, `Phone number`, etc.
	FieldName *GoogleCloudDocumentaiV1beta1DocumentPageLayout `json:"fieldName,omitempty"`
	// FieldValue: Layout for the FormField value.
	FieldValue *GoogleCloudDocumentaiV1beta1DocumentPageLayout `json:"fieldValue,omitempty"`
	// NameDetectedLanguages: A list of detected languages for name together with
	// confidence.
	NameDetectedLanguages []*GoogleCloudDocumentaiV1beta1DocumentPageDetectedLanguage `json:"nameDetectedLanguages,omitempty"`
	// Provenance: The history of this annotation.
	Provenance *GoogleCloudDocumentaiV1beta1DocumentProvenance `json:"provenance,omitempty"`
	// ValueDetectedLanguages: A list of detected languages for value together with
	// confidence.
	ValueDetectedLanguages []*GoogleCloudDocumentaiV1beta1DocumentPageDetectedLanguage `json:"valueDetectedLanguages,omitempty"`
	// ValueType: If the value is non-textual, this field represents the type.
	// Current valid values are: - blank (this indicates the `field_value` is
	// normal text) - `unfilled_checkbox` - `filled_checkbox`
	ValueType string `json:"valueType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CorrectedKeyText") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CorrectedKeyText") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta1DocumentPageFormField) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta1DocumentPageFormField
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta1DocumentPageImage: Rendered image contents for
// this page.
type GoogleCloudDocumentaiV1beta1DocumentPageImage struct {
	// Content: Raw byte content of the image.
	Content string `json:"content,omitempty"`
	// Height: Height of the image in pixels.
	Height int64 `json:"height,omitempty"`
	// MimeType: Encoding media type (MIME type)
	// (https://www.iana.org/assignments/media-types/media-types.xhtml) for the
	// image.
	MimeType string `json:"mimeType,omitempty"`
	// Width: Width of the image in pixels.
	Width int64 `json:"width,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Content") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Content") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta1DocumentPageImage) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta1DocumentPageImage
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta1DocumentPageImageQualityScores: Image quality
// scores for the page image.
type GoogleCloudDocumentaiV1beta1DocumentPageImageQualityScores struct {
	// DetectedDefects: A list of detected defects.
	DetectedDefects []*GoogleCloudDocumentaiV1beta1DocumentPageImageQualityScoresDetectedDefect `json:"detectedDefects,omitempty"`
	// QualityScore: The overall quality score. Range `[0, 1]` where `1` is perfect
	// quality.
	QualityScore float64 `json:"qualityScore,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DetectedDefects") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DetectedDefects") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta1DocumentPageImageQualityScores) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta1DocumentPageImageQualityScores
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDocumentaiV1beta1DocumentPageImageQualityScores) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDocumentaiV1beta1DocumentPageImageQualityScores
	var s1 struct {
		QualityScore gensupport.JSONFloat64 `json:"qualityScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.QualityScore = float64(s1.QualityScore)
	return nil
}

// GoogleCloudDocumentaiV1beta1DocumentPageImageQualityScoresDetectedDefect:
// Image Quality Defects
type GoogleCloudDocumentaiV1beta1DocumentPageImageQualityScoresDetectedDefect struct {
	// Confidence: Confidence of detected defect. Range `[0, 1]` where `1`
	// indicates strong confidence that the defect exists.
	Confidence float64 `json:"confidence,omitempty"`
	// Type: Name of the defect type. Supported values are: -
	// `quality/defect_blurry` - `quality/defect_noisy` - `quality/defect_dark` -
	// `quality/defect_faint` - `quality/defect_text_too_small` -
	// `quality/defect_document_cutoff` - `quality/defect_text_cutoff` -
	// `quality/defect_glare`
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Confidence") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Confidence") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta1DocumentPageImageQualityScoresDetectedDefect) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta1DocumentPageImageQualityScoresDetectedDefect
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDocumentaiV1beta1DocumentPageImageQualityScoresDetectedDefect) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDocumentaiV1beta1DocumentPageImageQualityScoresDetectedDefect
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

// GoogleCloudDocumentaiV1beta1DocumentPageLayout: Visual element describing a
// layout unit on a page.
type GoogleCloudDocumentaiV1beta1DocumentPageLayout struct {
	// BoundingPoly: The bounding polygon for the Layout.
	BoundingPoly *GoogleCloudDocumentaiV1beta1BoundingPoly `json:"boundingPoly,omitempty"`
	// Confidence: Confidence of the current Layout within context of the object
	// this layout is for. e.g. confidence can be for a single token, a table, a
	// visual element, etc. depending on context. Range `[0, 1]`.
	Confidence float64 `json:"confidence,omitempty"`
	// Orientation: Detected orientation for the Layout.
	//
	// Possible values:
	//   "ORIENTATION_UNSPECIFIED" - Unspecified orientation.
	//   "PAGE_UP" - Orientation is aligned with page up.
	//   "PAGE_RIGHT" - Orientation is aligned with page right. Turn the head 90
	// degrees clockwise from upright to read.
	//   "PAGE_DOWN" - Orientation is aligned with page down. Turn the head 180
	// degrees from upright to read.
	//   "PAGE_LEFT" - Orientation is aligned with page left. Turn the head 90
	// degrees counterclockwise from upright to read.
	Orientation string `json:"orientation,omitempty"`
	// TextAnchor: Text anchor indexing into the Document.text.
	TextAnchor *GoogleCloudDocumentaiV1beta1DocumentTextAnchor `json:"textAnchor,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BoundingPoly") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BoundingPoly") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta1DocumentPageLayout) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta1DocumentPageLayout
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDocumentaiV1beta1DocumentPageLayout) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDocumentaiV1beta1DocumentPageLayout
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

// GoogleCloudDocumentaiV1beta1DocumentPageLine: A collection of tokens that a
// human would perceive as a line. Does not cross column boundaries, can be
// horizontal, vertical, etc.
type GoogleCloudDocumentaiV1beta1DocumentPageLine struct {
	// DetectedLanguages: A list of detected languages together with confidence.
	DetectedLanguages []*GoogleCloudDocumentaiV1beta1DocumentPageDetectedLanguage `json:"detectedLanguages,omitempty"`
	// Layout: Layout for Line.
	Layout *GoogleCloudDocumentaiV1beta1DocumentPageLayout `json:"layout,omitempty"`
	// Provenance: The history of this annotation.
	Provenance *GoogleCloudDocumentaiV1beta1DocumentProvenance `json:"provenance,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DetectedLanguages") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DetectedLanguages") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta1DocumentPageLine) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta1DocumentPageLine
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta1DocumentPageMatrix: Representation for
// transformation matrix, intended to be compatible and used with OpenCV format
// for image manipulation.
type GoogleCloudDocumentaiV1beta1DocumentPageMatrix struct {
	// Cols: Number of columns in the matrix.
	Cols int64 `json:"cols,omitempty"`
	// Data: The matrix data.
	Data string `json:"data,omitempty"`
	// Rows: Number of rows in the matrix.
	Rows int64 `json:"rows,omitempty"`
	// Type: This encodes information about what data type the matrix uses. For
	// example, 0 (CV_8U) is an unsigned 8-bit image. For the full list of OpenCV
	// primitive data types, please refer to
	// https://docs.opencv.org/4.3.0/d1/d1b/group__core__hal__interface.html
	Type int64 `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Cols") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Cols") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta1DocumentPageMatrix) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta1DocumentPageMatrix
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta1DocumentPageParagraph: A collection of lines
// that a human would perceive as a paragraph.
type GoogleCloudDocumentaiV1beta1DocumentPageParagraph struct {
	// DetectedLanguages: A list of detected languages together with confidence.
	DetectedLanguages []*GoogleCloudDocumentaiV1beta1DocumentPageDetectedLanguage `json:"detectedLanguages,omitempty"`
	// Layout: Layout for Paragraph.
	Layout *GoogleCloudDocumentaiV1beta1DocumentPageLayout `json:"layout,omitempty"`
	// Provenance: The history of this annotation.
	Provenance *GoogleCloudDocumentaiV1beta1DocumentProvenance `json:"provenance,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DetectedLanguages") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DetectedLanguages") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta1DocumentPageParagraph) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta1DocumentPageParagraph
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta1DocumentPageSymbol: A detected symbol.
type GoogleCloudDocumentaiV1beta1DocumentPageSymbol struct {
	// DetectedLanguages: A list of detected languages together with confidence.
	DetectedLanguages []*GoogleCloudDocumentaiV1beta1DocumentPageDetectedLanguage `json:"detectedLanguages,omitempty"`
	// Layout: Layout for Symbol.
	Layout *GoogleCloudDocumentaiV1beta1DocumentPageLayout `json:"layout,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DetectedLanguages") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DetectedLanguages") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta1DocumentPageSymbol) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta1DocumentPageSymbol
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta1DocumentPageTable: A table representation
// similar to HTML table structure.
type GoogleCloudDocumentaiV1beta1DocumentPageTable struct {
	// BodyRows: Body rows of the table.
	BodyRows []*GoogleCloudDocumentaiV1beta1DocumentPageTableTableRow `json:"bodyRows,omitempty"`
	// DetectedLanguages: A list of detected languages together with confidence.
	DetectedLanguages []*GoogleCloudDocumentaiV1beta1DocumentPageDetectedLanguage `json:"detectedLanguages,omitempty"`
	// HeaderRows: Header rows of the table.
	HeaderRows []*GoogleCloudDocumentaiV1beta1DocumentPageTableTableRow `json:"headerRows,omitempty"`
	// Layout: Layout for Table.
	Layout *GoogleCloudDocumentaiV1beta1DocumentPageLayout `json:"layout,omitempty"`
	// Provenance: The history of this table.
	Provenance *GoogleCloudDocumentaiV1beta1DocumentProvenance `json:"provenance,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BodyRows") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BodyRows") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta1DocumentPageTable) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta1DocumentPageTable
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta1DocumentPageTableTableCell: A cell
// representation inside the table.
type GoogleCloudDocumentaiV1beta1DocumentPageTableTableCell struct {
	// ColSpan: How many columns this cell spans.
	ColSpan int64 `json:"colSpan,omitempty"`
	// DetectedLanguages: A list of detected languages together with confidence.
	DetectedLanguages []*GoogleCloudDocumentaiV1beta1DocumentPageDetectedLanguage `json:"detectedLanguages,omitempty"`
	// Layout: Layout for TableCell.
	Layout *GoogleCloudDocumentaiV1beta1DocumentPageLayout `json:"layout,omitempty"`
	// RowSpan: How many rows this cell spans.
	RowSpan int64 `json:"rowSpan,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ColSpan") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ColSpan") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta1DocumentPageTableTableCell) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta1DocumentPageTableTableCell
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta1DocumentPageTableTableRow: A row of table cells.
type GoogleCloudDocumentaiV1beta1DocumentPageTableTableRow struct {
	// Cells: Cells that make up this row.
	Cells []*GoogleCloudDocumentaiV1beta1DocumentPageTableTableCell `json:"cells,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Cells") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Cells") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta1DocumentPageTableTableRow) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta1DocumentPageTableTableRow
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta1DocumentPageToken: A detected token.
type GoogleCloudDocumentaiV1beta1DocumentPageToken struct {
	// DetectedBreak: Detected break at the end of a Token.
	DetectedBreak *GoogleCloudDocumentaiV1beta1DocumentPageTokenDetectedBreak `json:"detectedBreak,omitempty"`
	// DetectedLanguages: A list of detected languages together with confidence.
	DetectedLanguages []*GoogleCloudDocumentaiV1beta1DocumentPageDetectedLanguage `json:"detectedLanguages,omitempty"`
	// Layout: Layout for Token.
	Layout *GoogleCloudDocumentaiV1beta1DocumentPageLayout `json:"layout,omitempty"`
	// Provenance: The history of this annotation.
	Provenance *GoogleCloudDocumentaiV1beta1DocumentProvenance `json:"provenance,omitempty"`
	// StyleInfo: Text style attributes.
	StyleInfo *GoogleCloudDocumentaiV1beta1DocumentPageTokenStyleInfo `json:"styleInfo,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DetectedBreak") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DetectedBreak") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta1DocumentPageToken) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta1DocumentPageToken
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta1DocumentPageTokenDetectedBreak: Detected break
// at the end of a Token.
type GoogleCloudDocumentaiV1beta1DocumentPageTokenDetectedBreak struct {
	// Type: Detected break type.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - Unspecified break type.
	//   "SPACE" - A single whitespace.
	//   "WIDE_SPACE" - A wider whitespace.
	//   "HYPHEN" - A hyphen that indicates that a token has been split across
	// lines.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Type") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Type") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta1DocumentPageTokenDetectedBreak) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta1DocumentPageTokenDetectedBreak
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta1DocumentPageTokenStyleInfo: Font and other text
// style attributes.
type GoogleCloudDocumentaiV1beta1DocumentPageTokenStyleInfo struct {
	// BackgroundColor: Color of the background.
	BackgroundColor *GoogleTypeColor `json:"backgroundColor,omitempty"`
	// Bold: Whether the text is bold (equivalent to font_weight is at least
	// `700`).
	Bold bool `json:"bold,omitempty"`
	// FontSize: Font size in points (`1` point is `¹⁄₇₂` inches).
	FontSize int64 `json:"fontSize,omitempty"`
	// FontType: Name or style of the font.
	FontType string `json:"fontType,omitempty"`
	// FontWeight: TrueType weight on a scale `100` (thin) to `1000` (ultra-heavy).
	// Normal is `400`, bold is `700`.
	FontWeight int64 `json:"fontWeight,omitempty"`
	// Handwritten: Whether the text is handwritten.
	Handwritten bool `json:"handwritten,omitempty"`
	// Italic: Whether the text is italic.
	Italic bool `json:"italic,omitempty"`
	// LetterSpacing: Letter spacing in points.
	LetterSpacing float64 `json:"letterSpacing,omitempty"`
	// PixelFontSize: Font size in pixels, equal to _unrounded font_size_ *
	// _resolution_ ÷ `72.0`.
	PixelFontSize float64 `json:"pixelFontSize,omitempty"`
	// Smallcaps: Whether the text is in small caps. This feature is not supported
	// yet.
	Smallcaps bool `json:"smallcaps,omitempty"`
	// Strikeout: Whether the text is strikethrough. This feature is not supported
	// yet.
	Strikeout bool `json:"strikeout,omitempty"`
	// Subscript: Whether the text is a subscript. This feature is not supported
	// yet.
	Subscript bool `json:"subscript,omitempty"`
	// Superscript: Whether the text is a superscript. This feature is not
	// supported yet.
	Superscript bool `json:"superscript,omitempty"`
	// TextColor: Color of the text.
	TextColor *GoogleTypeColor `json:"textColor,omitempty"`
	// Underlined: Whether the text is underlined.
	Underlined bool `json:"underlined,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BackgroundColor") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BackgroundColor") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta1DocumentPageTokenStyleInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta1DocumentPageTokenStyleInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDocumentaiV1beta1DocumentPageTokenStyleInfo) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDocumentaiV1beta1DocumentPageTokenStyleInfo
	var s1 struct {
		LetterSpacing gensupport.JSONFloat64 `json:"letterSpacing"`
		PixelFontSize gensupport.JSONFloat64 `json:"pixelFontSize"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.LetterSpacing = float64(s1.LetterSpacing)
	s.PixelFontSize = float64(s1.PixelFontSize)
	return nil
}

// GoogleCloudDocumentaiV1beta1DocumentPageVisualElement: Detected non-text
// visual elements e.g. checkbox, signature etc. on the page.
type GoogleCloudDocumentaiV1beta1DocumentPageVisualElement struct {
	// DetectedLanguages: A list of detected languages together with confidence.
	DetectedLanguages []*GoogleCloudDocumentaiV1beta1DocumentPageDetectedLanguage `json:"detectedLanguages,omitempty"`
	// Layout: Layout for VisualElement.
	Layout *GoogleCloudDocumentaiV1beta1DocumentPageLayout `json:"layout,omitempty"`
	// Type: Type of the VisualElement.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DetectedLanguages") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DetectedLanguages") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta1DocumentPageVisualElement) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta1DocumentPageVisualElement
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta1DocumentProvenance: Structure to identify
// provenance relationships between annotations in different revisions.
type GoogleCloudDocumentaiV1beta1DocumentProvenance struct {
	// Id: The Id of this operation. Needs to be unique within the scope of the
	// revision.
	Id int64 `json:"id,omitempty"`
	// Parents: References to the original elements that are replaced.
	Parents []*GoogleCloudDocumentaiV1beta1DocumentProvenanceParent `json:"parents,omitempty"`
	// Revision: The index of the revision that produced this element.
	Revision int64 `json:"revision,omitempty"`
	// Type: The type of provenance operation.
	//
	// Possible values:
	//   "OPERATION_TYPE_UNSPECIFIED" - Operation type unspecified. If no operation
	// is specified a provenance entry is simply used to match against a `parent`.
	//   "ADD" - Add an element.
	//   "REMOVE" - Remove an element identified by `parent`.
	//   "UPDATE" - Updates any fields within the given provenance scope of the
	// message. It overwrites the fields rather than replacing them. Use this when
	// you want to update a field value of an entity without also updating all the
	// child properties.
	//   "REPLACE" - Currently unused. Replace an element identified by `parent`.
	//   "EVAL_REQUESTED" - Deprecated. Request human review for the element
	// identified by `parent`.
	//   "EVAL_APPROVED" - Deprecated. Element is reviewed and approved at human
	// review, confidence will be set to 1.0.
	//   "EVAL_SKIPPED" - Deprecated. Element is skipped in the validation process.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Id") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Id") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta1DocumentProvenance) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta1DocumentProvenance
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta1DocumentProvenanceParent: The parent element the
// current element is based on. Used for referencing/aligning, removal and
// replacement operations.
type GoogleCloudDocumentaiV1beta1DocumentProvenanceParent struct {
	// Id: The id of the parent provenance.
	Id int64 `json:"id,omitempty"`
	// Index: The index of the parent item in the corresponding item list (eg. list
	// of entities, properties within entities, etc.) in the parent revision.
	Index int64 `json:"index,omitempty"`
	// Revision: The index of the index into current revision's parent_ids list.
	Revision int64 `json:"revision,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Id") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Id") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta1DocumentProvenanceParent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta1DocumentProvenanceParent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta1DocumentRevision: Contains past or forward
// revisions of this document.
type GoogleCloudDocumentaiV1beta1DocumentRevision struct {
	// Agent: If the change was made by a person specify the name or id of that
	// person.
	Agent string `json:"agent,omitempty"`
	// CreateTime: The time that the revision was created, internally generated by
	// doc proto storage at the time of create.
	CreateTime string `json:"createTime,omitempty"`
	// HumanReview: Human Review information of this revision.
	HumanReview *GoogleCloudDocumentaiV1beta1DocumentRevisionHumanReview `json:"humanReview,omitempty"`
	// Id: Id of the revision, internally generated by doc proto storage. Unique
	// within the context of the document.
	Id string `json:"id,omitempty"`
	// Parent: The revisions that this revision is based on. This can include one
	// or more parent (when documents are merged.) This field represents the index
	// into the `revisions` field.
	Parent []int64 `json:"parent,omitempty"`
	// ParentIds: The revisions that this revision is based on. Must include all
	// the ids that have anything to do with this revision - eg. there are
	// `provenance.parent.revision` fields that index into this field.
	ParentIds []string `json:"parentIds,omitempty"`
	// Processor: If the annotation was made by processor identify the processor by
	// its resource name.
	Processor string `json:"processor,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Agent") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Agent") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta1DocumentRevision) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta1DocumentRevision
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta1DocumentRevisionHumanReview: Human Review
// information of the document.
type GoogleCloudDocumentaiV1beta1DocumentRevisionHumanReview struct {
	// State: Human review state. e.g. `requested`, `succeeded`, `rejected`.
	State string `json:"state,omitempty"`
	// StateMessage: A message providing more details about the current state of
	// processing. For example, the rejection reason when the state is `rejected`.
	StateMessage string `json:"stateMessage,omitempty"`
	// ForceSendFields is a list of field names (e.g. "State") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "State") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta1DocumentRevisionHumanReview) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta1DocumentRevisionHumanReview
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta1DocumentShardInfo: For a large document,
// sharding may be performed to produce several document shards. Each document
// shard contains this field to detail which shard it is.
type GoogleCloudDocumentaiV1beta1DocumentShardInfo struct {
	// ShardCount: Total number of shards.
	ShardCount int64 `json:"shardCount,omitempty,string"`
	// ShardIndex: The 0-based index of this shard.
	ShardIndex int64 `json:"shardIndex,omitempty,string"`
	// TextOffset: The index of the first character in Document.text in the overall
	// document global text.
	TextOffset int64 `json:"textOffset,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "ShardCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ShardCount") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta1DocumentShardInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta1DocumentShardInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta1DocumentStyle: Annotation for common text style
// attributes. This adheres to CSS conventions as much as possible.
type GoogleCloudDocumentaiV1beta1DocumentStyle struct {
	// BackgroundColor: Text background color.
	BackgroundColor *GoogleTypeColor `json:"backgroundColor,omitempty"`
	// Color: Text color.
	Color *GoogleTypeColor `json:"color,omitempty"`
	// FontFamily: Font family such as `Arial`, `Times New Roman`.
	// https://www.w3schools.com/cssref/pr_font_font-family.asp
	FontFamily string `json:"fontFamily,omitempty"`
	// FontSize: Font size.
	FontSize *GoogleCloudDocumentaiV1beta1DocumentStyleFontSize `json:"fontSize,omitempty"`
	// FontWeight: Font weight
	// (https://www.w3schools.com/cssref/pr_font_weight.asp). Possible values are
	// `normal`, `bold`, `bolder`, and `lighter`.
	FontWeight string `json:"fontWeight,omitempty"`
	// TextAnchor: Text anchor indexing into the Document.text.
	TextAnchor *GoogleCloudDocumentaiV1beta1DocumentTextAnchor `json:"textAnchor,omitempty"`
	// TextDecoration: Text decoration
	// (https://www.w3schools.com/cssref/pr_text_text-decoration.asp). Follows CSS
	// standard.
	TextDecoration string `json:"textDecoration,omitempty"`
	// TextStyle: Text style
	// (https://www.w3schools.com/cssref/pr_font_font-style.asp). Possible values
	// are `normal`, `italic`, and `oblique`.
	TextStyle string `json:"textStyle,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BackgroundColor") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BackgroundColor") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta1DocumentStyle) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta1DocumentStyle
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta1DocumentStyleFontSize: Font size with unit.
type GoogleCloudDocumentaiV1beta1DocumentStyleFontSize struct {
	// Size: Font size for the text.
	Size float64 `json:"size,omitempty"`
	// Unit: Unit for the font size. Follows CSS naming (such as `in`, `px`, and
	// `pt`).
	Unit string `json:"unit,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Size") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Size") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta1DocumentStyleFontSize) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta1DocumentStyleFontSize
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDocumentaiV1beta1DocumentStyleFontSize) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDocumentaiV1beta1DocumentStyleFontSize
	var s1 struct {
		Size gensupport.JSONFloat64 `json:"size"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Size = float64(s1.Size)
	return nil
}

// GoogleCloudDocumentaiV1beta1DocumentTextAnchor: Text reference indexing into
// the Document.text.
type GoogleCloudDocumentaiV1beta1DocumentTextAnchor struct {
	// Content: Contains the content of the text span so that users do not have to
	// look it up in the text_segments. It is always populated for formFields.
	Content string `json:"content,omitempty"`
	// TextSegments: The text segments from the Document.text.
	TextSegments []*GoogleCloudDocumentaiV1beta1DocumentTextAnchorTextSegment `json:"textSegments,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Content") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Content") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta1DocumentTextAnchor) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta1DocumentTextAnchor
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta1DocumentTextAnchorTextSegment: A text segment in
// the Document.text. The indices may be out of bounds which indicate that the
// text extends into another document shard for large sharded documents. See
// ShardInfo.text_offset
type GoogleCloudDocumentaiV1beta1DocumentTextAnchorTextSegment struct {
	// EndIndex: TextSegment half open end UTF-8 char index in the Document.text.
	EndIndex int64 `json:"endIndex,omitempty,string"`
	// StartIndex: TextSegment start UTF-8 char index in the Document.text.
	StartIndex int64 `json:"startIndex,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "EndIndex") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndIndex") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta1DocumentTextAnchorTextSegment) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta1DocumentTextAnchorTextSegment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta1DocumentTextChange: This message is used for
// text changes aka. OCR corrections.
type GoogleCloudDocumentaiV1beta1DocumentTextChange struct {
	// ChangedText: The text that replaces the text identified in the
	// `text_anchor`.
	ChangedText string `json:"changedText,omitempty"`
	// Provenance: The history of this annotation.
	Provenance []*GoogleCloudDocumentaiV1beta1DocumentProvenance `json:"provenance,omitempty"`
	// TextAnchor: Provenance of the correction. Text anchor indexing into the
	// Document.text. There can only be a single `TextAnchor.text_segments`
	// element. If the start and end index of the text segment are the same, the
	// text change is inserted before that index.
	TextAnchor *GoogleCloudDocumentaiV1beta1DocumentTextAnchor `json:"textAnchor,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChangedText") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChangedText") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta1DocumentTextChange) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta1DocumentTextChange
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta1GcsDestination: The Google Cloud Storage
// location where the output file will be written to.
type GoogleCloudDocumentaiV1beta1GcsDestination struct {
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Uri") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Uri") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta1GcsDestination) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta1GcsDestination
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta1GcsSource: The Google Cloud Storage location
// where the input file will be read from.
type GoogleCloudDocumentaiV1beta1GcsSource struct {
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Uri") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Uri") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta1GcsSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta1GcsSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta1InputConfig: The desired input location and
// metadata.
type GoogleCloudDocumentaiV1beta1InputConfig struct {
	// GcsSource: The Google Cloud Storage location to read the input from. This
	// must be a single file.
	GcsSource *GoogleCloudDocumentaiV1beta1GcsSource `json:"gcsSource,omitempty"`
	// MimeType: Required. Mimetype of the input. Current supported mimetypes are
	// application/pdf, image/tiff, and image/gif. In addition, application/json
	// type is supported for requests with ProcessDocumentRequest.automl_params
	// field set. The JSON file needs to be in Document format.
	MimeType string `json:"mimeType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GcsSource") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GcsSource") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta1InputConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta1InputConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta1NormalizedVertex: A vertex represents a 2D point
// in the image. NOTE: the normalized vertex coordinates are relative to the
// original image and range from 0 to 1.
type GoogleCloudDocumentaiV1beta1NormalizedVertex struct {
	// X: X coordinate.
	X float64 `json:"x,omitempty"`
	// Y: Y coordinate (starts from the top of the image).
	Y float64 `json:"y,omitempty"`
	// ForceSendFields is a list of field names (e.g. "X") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "X") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta1NormalizedVertex) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta1NormalizedVertex
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDocumentaiV1beta1NormalizedVertex) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDocumentaiV1beta1NormalizedVertex
	var s1 struct {
		X gensupport.JSONFloat64 `json:"x"`
		Y gensupport.JSONFloat64 `json:"y"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.X = float64(s1.X)
	s.Y = float64(s1.Y)
	return nil
}

// GoogleCloudDocumentaiV1beta1OperationMetadata: Contains metadata for the
// BatchProcessDocuments operation.
type GoogleCloudDocumentaiV1beta1OperationMetadata struct {
	// CreateTime: The creation time of the operation.
	CreateTime string `json:"createTime,omitempty"`
	// State: The state of the current batch processing.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - The default value. This value is used if the state
	// is omitted.
	//   "ACCEPTED" - Request is received.
	//   "WAITING" - Request operation is waiting for scheduling.
	//   "RUNNING" - Request is being processed.
	//   "SUCCEEDED" - The batch processing completed successfully.
	//   "CANCELLED" - The batch processing was cancelled.
	//   "FAILED" - The batch processing has failed.
	State string `json:"state,omitempty"`
	// StateMessage: A message providing more details about the current state of
	// processing.
	StateMessage string `json:"stateMessage,omitempty"`
	// UpdateTime: The last update time of the operation.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta1OperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta1OperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta1OutputConfig: The desired output location and
// metadata.
type GoogleCloudDocumentaiV1beta1OutputConfig struct {
	// GcsDestination: The Google Cloud Storage location to write the output to.
	GcsDestination *GoogleCloudDocumentaiV1beta1GcsDestination `json:"gcsDestination,omitempty"`
	// PagesPerShard: The max number of pages to include into each output Document
	// shard JSON on Google Cloud Storage. The valid range is [1, 100]. If not
	// specified, the default value is 20. For example, for one pdf file with 100
	// pages, 100 parsed pages will be produced. If `pages_per_shard` = 20, then 5
	// Document shard JSON files each containing 20 parsed pages will be written
	// under the prefix OutputConfig.gcs_destination.uri and suffix
	// pages-x-to-y.json where x and y are 1-indexed page numbers. Example GCS
	// outputs with 157 pages and pages_per_shard = 50: pages-001-to-050.json
	// pages-051-to-100.json pages-101-to-150.json pages-151-to-157.json
	PagesPerShard int64 `json:"pagesPerShard,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GcsDestination") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GcsDestination") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta1OutputConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta1OutputConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta1ProcessDocumentResponse: Response to a single
// document processing request.
type GoogleCloudDocumentaiV1beta1ProcessDocumentResponse struct {
	// InputConfig: Information about the input file. This is the same as the
	// corresponding input config in the request.
	InputConfig *GoogleCloudDocumentaiV1beta1InputConfig `json:"inputConfig,omitempty"`
	// OutputConfig: The output location of the parsed responses. The responses are
	// written to this location as JSON-serialized `Document` objects.
	OutputConfig *GoogleCloudDocumentaiV1beta1OutputConfig `json:"outputConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "InputConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InputConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta1ProcessDocumentResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta1ProcessDocumentResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta1Vertex: A vertex represents a 2D point in the
// image. NOTE: the vertex coordinates are in the same scale as the original
// image.
type GoogleCloudDocumentaiV1beta1Vertex struct {
	// X: X coordinate.
	X int64 `json:"x,omitempty"`
	// Y: Y coordinate (starts from the top of the image).
	Y int64 `json:"y,omitempty"`
	// ForceSendFields is a list of field names (e.g. "X") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "X") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta1Vertex) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta1Vertex
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta2AutoMlParams: Parameters to control AutoML model
// prediction behavior.
type GoogleCloudDocumentaiV1beta2AutoMlParams struct {
	// Model: Resource name of the AutoML model. Format:
	// `projects/{project-id}/locations/{location-id}/models/{model-id}`.
	Model string `json:"model,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Model") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Model") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta2AutoMlParams) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2AutoMlParams
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta2Barcode: Encodes the detailed information of a
// barcode.
type GoogleCloudDocumentaiV1beta2Barcode struct {
	// Format: Format of a barcode. The supported formats are: - `CODE_128`: Code
	// 128 type. - `CODE_39`: Code 39 type. - `CODE_93`: Code 93 type. - `CODABAR`:
	// Codabar type. - `DATA_MATRIX`: 2D Data Matrix type. - `ITF`: ITF type. -
	// `EAN_13`: EAN-13 type. - `EAN_8`: EAN-8 type. - `QR_CODE`: 2D QR code type.
	// - `UPC_A`: UPC-A type. - `UPC_E`: UPC-E type. - `PDF417`: PDF417 type. -
	// `AZTEC`: 2D Aztec code type. - `DATABAR`: GS1 DataBar code type.
	Format string `json:"format,omitempty"`
	// RawValue: Raw value encoded in the barcode. For example:
	// `'MEBKM:TITLE:Google;URL:https://www.google.com;;'`.
	RawValue string `json:"rawValue,omitempty"`
	// ValueFormat: Value format describes the format of the value that a barcode
	// encodes. The supported formats are: - `CONTACT_INFO`: Contact information. -
	// `EMAIL`: Email address. - `ISBN`: ISBN identifier. - `PHONE`: Phone number.
	// - `PRODUCT`: Product. - `SMS`: SMS message. - `TEXT`: Text string. - `URL`:
	// URL address. - `WIFI`: Wifi information. - `GEO`: Geo-localization. -
	// `CALENDAR_EVENT`: Calendar event. - `DRIVER_LICENSE`: Driver's license.
	ValueFormat string `json:"valueFormat,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Format") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Format") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta2Barcode) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2Barcode
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta2BatchProcessDocumentsRequest: Request to batch
// process documents as an asynchronous operation. The output is written to
// Cloud Storage as JSON in the [Document] format.
type GoogleCloudDocumentaiV1beta2BatchProcessDocumentsRequest struct {
	// Requests: Required. Individual requests for each document.
	Requests []*GoogleCloudDocumentaiV1beta2ProcessDocumentRequest `json:"requests,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Requests") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Requests") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta2BatchProcessDocumentsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2BatchProcessDocumentsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta2BatchProcessDocumentsResponse: Response to an
// batch document processing request. This is returned in the LRO Operation
// after the operation is complete.
type GoogleCloudDocumentaiV1beta2BatchProcessDocumentsResponse struct {
	// Responses: Responses for each individual document.
	Responses []*GoogleCloudDocumentaiV1beta2ProcessDocumentResponse `json:"responses,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Responses") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Responses") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta2BatchProcessDocumentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2BatchProcessDocumentsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta2BoundingPoly: A bounding polygon for the
// detected image annotation.
type GoogleCloudDocumentaiV1beta2BoundingPoly struct {
	// NormalizedVertices: The bounding polygon normalized vertices.
	NormalizedVertices []*GoogleCloudDocumentaiV1beta2NormalizedVertex `json:"normalizedVertices,omitempty"`
	// Vertices: The bounding polygon vertices.
	Vertices []*GoogleCloudDocumentaiV1beta2Vertex `json:"vertices,omitempty"`
	// ForceSendFields is a list of field names (e.g. "NormalizedVertices") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NormalizedVertices") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta2BoundingPoly) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2BoundingPoly
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta2Document: Document represents the canonical
// document resource in Document AI. It is an interchange format that provides
// insights into documents and allows for collaboration between users and
// Document AI to iterate and optimize for quality.
type GoogleCloudDocumentaiV1beta2Document struct {
	// ChunkedDocument: Document chunked based on chunking config.
	ChunkedDocument *GoogleCloudDocumentaiV1beta2DocumentChunkedDocument `json:"chunkedDocument,omitempty"`
	// Content: Optional. Inline document content, represented as a stream of
	// bytes. Note: As with all `bytes` fields, protobuffers use a pure binary
	// representation, whereas JSON representations use base64.
	Content string `json:"content,omitempty"`
	// DocumentLayout: Parsed layout of the document.
	DocumentLayout *GoogleCloudDocumentaiV1beta2DocumentDocumentLayout `json:"documentLayout,omitempty"`
	// Entities: A list of entities detected on Document.text. For document shards,
	// entities in this list may cross shard boundaries.
	Entities []*GoogleCloudDocumentaiV1beta2DocumentEntity `json:"entities,omitempty"`
	// EntityRelations: Placeholder. Relationship among Document.entities.
	EntityRelations []*GoogleCloudDocumentaiV1beta2DocumentEntityRelation `json:"entityRelations,omitempty"`
	// Error: Any error that occurred while processing this document.
	Error *GoogleRpcStatus `json:"error,omitempty"`
	// Labels: Labels for this document.
	Labels []*GoogleCloudDocumentaiV1beta2DocumentLabel `json:"labels,omitempty"`
	// MimeType: An IANA published media type (MIME type)
	// (https://www.iana.org/assignments/media-types/media-types.xhtml).
	MimeType string `json:"mimeType,omitempty"`
	// Pages: Visual page layout for the Document.
	Pages []*GoogleCloudDocumentaiV1beta2DocumentPage `json:"pages,omitempty"`
	// Revisions: Placeholder. Revision history of this document.
	Revisions []*GoogleCloudDocumentaiV1beta2DocumentRevision `json:"revisions,omitempty"`
	// ShardInfo: Information about the sharding if this document is sharded part
	// of a larger document. If the document is not sharded, this message is not
	// specified.
	ShardInfo *GoogleCloudDocumentaiV1beta2DocumentShardInfo `json:"shardInfo,omitempty"`
	// Text: Optional. UTF-8 encoded text in reading order from the document.
	Text string `json:"text,omitempty"`
	// TextChanges: Placeholder. A list of text corrections made to Document.text.
	// This is usually used for annotating corrections to OCR mistakes. Text
	// changes for a given revision may not overlap with each other.
	TextChanges []*GoogleCloudDocumentaiV1beta2DocumentTextChange `json:"textChanges,omitempty"`
	// TextStyles: Styles for the Document.text.
	TextStyles []*GoogleCloudDocumentaiV1beta2DocumentStyle `json:"textStyles,omitempty"`
	// Uri: Optional. Currently supports Google Cloud Storage URI of the form
	// `gs://bucket_name/object_name`. Object versioning is not supported. For more
	// information, refer to Google Cloud Storage Request URIs
	// (https://cloud.google.com/storage/docs/reference-uris).
	Uri string `json:"uri,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ChunkedDocument") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChunkedDocument") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta2Document) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2Document
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta2DocumentChunkedDocument: Represents the chunks
// that the document is divided into.
type GoogleCloudDocumentaiV1beta2DocumentChunkedDocument struct {
	// Chunks: List of chunks.
	Chunks []*GoogleCloudDocumentaiV1beta2DocumentChunkedDocumentChunk `json:"chunks,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Chunks") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Chunks") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta2DocumentChunkedDocument) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2DocumentChunkedDocument
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta2DocumentChunkedDocumentChunk: Represents a
// chunk.
type GoogleCloudDocumentaiV1beta2DocumentChunkedDocumentChunk struct {
	// ChunkId: ID of the chunk.
	ChunkId string `json:"chunkId,omitempty"`
	// Content: Text content of the chunk.
	Content string `json:"content,omitempty"`
	// PageFooters: Page footers associated with the chunk.
	PageFooters []*GoogleCloudDocumentaiV1beta2DocumentChunkedDocumentChunkChunkPageFooter `json:"pageFooters,omitempty"`
	// PageHeaders: Page headers associated with the chunk.
	PageHeaders []*GoogleCloudDocumentaiV1beta2DocumentChunkedDocumentChunkChunkPageHeader `json:"pageHeaders,omitempty"`
	// PageSpan: Page span of the chunk.
	PageSpan *GoogleCloudDocumentaiV1beta2DocumentChunkedDocumentChunkChunkPageSpan `json:"pageSpan,omitempty"`
	// SourceBlockIds: Unused.
	SourceBlockIds []string `json:"sourceBlockIds,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChunkId") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChunkId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta2DocumentChunkedDocumentChunk) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2DocumentChunkedDocumentChunk
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta2DocumentChunkedDocumentChunkChunkPageFooter:
// Represents the page footer associated with the chunk.
type GoogleCloudDocumentaiV1beta2DocumentChunkedDocumentChunkChunkPageFooter struct {
	// PageSpan: Page span of the footer.
	PageSpan *GoogleCloudDocumentaiV1beta2DocumentChunkedDocumentChunkChunkPageSpan `json:"pageSpan,omitempty"`
	// Text: Footer in text format.
	Text string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PageSpan") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PageSpan") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta2DocumentChunkedDocumentChunkChunkPageFooter) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2DocumentChunkedDocumentChunkChunkPageFooter
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta2DocumentChunkedDocumentChunkChunkPageHeader:
// Represents the page header associated with the chunk.
type GoogleCloudDocumentaiV1beta2DocumentChunkedDocumentChunkChunkPageHeader struct {
	// PageSpan: Page span of the header.
	PageSpan *GoogleCloudDocumentaiV1beta2DocumentChunkedDocumentChunkChunkPageSpan `json:"pageSpan,omitempty"`
	// Text: Header in text format.
	Text string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PageSpan") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PageSpan") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta2DocumentChunkedDocumentChunkChunkPageHeader) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2DocumentChunkedDocumentChunkChunkPageHeader
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta2DocumentChunkedDocumentChunkChunkPageSpan:
// Represents where the chunk starts and ends in the document.
type GoogleCloudDocumentaiV1beta2DocumentChunkedDocumentChunkChunkPageSpan struct {
	// PageEnd: Page where chunk ends in the document.
	PageEnd int64 `json:"pageEnd,omitempty"`
	// PageStart: Page where chunk starts in the document.
	PageStart int64 `json:"pageStart,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PageEnd") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PageEnd") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta2DocumentChunkedDocumentChunkChunkPageSpan) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2DocumentChunkedDocumentChunkChunkPageSpan
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta2DocumentDocumentLayout: Represents the parsed
// layout of a document as a collection of blocks that the document is divided
// into.
type GoogleCloudDocumentaiV1beta2DocumentDocumentLayout struct {
	// Blocks: List of blocks in the document.
	Blocks []*GoogleCloudDocumentaiV1beta2DocumentDocumentLayoutDocumentLayoutBlock `json:"blocks,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Blocks") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Blocks") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta2DocumentDocumentLayout) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2DocumentDocumentLayout
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta2DocumentDocumentLayoutDocumentLayoutBlock:
// Represents a block. A block could be one of the various types (text, table,
// list) supported.
type GoogleCloudDocumentaiV1beta2DocumentDocumentLayoutDocumentLayoutBlock struct {
	// BlockId: ID of the block.
	BlockId string `json:"blockId,omitempty"`
	// ListBlock: Block consisting of list content/structure.
	ListBlock *GoogleCloudDocumentaiV1beta2DocumentDocumentLayoutDocumentLayoutBlockLayoutListBlock `json:"listBlock,omitempty"`
	// PageSpan: Page span of the block.
	PageSpan *GoogleCloudDocumentaiV1beta2DocumentDocumentLayoutDocumentLayoutBlockLayoutPageSpan `json:"pageSpan,omitempty"`
	// TableBlock: Block consisting of table content/structure.
	TableBlock *GoogleCloudDocumentaiV1beta2DocumentDocumentLayoutDocumentLayoutBlockLayoutTableBlock `json:"tableBlock,omitempty"`
	// TextBlock: Block consisting of text content.
	TextBlock *GoogleCloudDocumentaiV1beta2DocumentDocumentLayoutDocumentLayoutBlockLayoutTextBlock `json:"textBlock,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BlockId") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BlockId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta2DocumentDocumentLayoutDocumentLayoutBlock) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2DocumentDocumentLayoutDocumentLayoutBlock
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta2DocumentDocumentLayoutDocumentLayoutBlockLayoutLi
// stBlock: Represents a list type block.
type GoogleCloudDocumentaiV1beta2DocumentDocumentLayoutDocumentLayoutBlockLayoutListBlock struct {
	// ListEntries: List entries that constitute a list block.
	ListEntries []*GoogleCloudDocumentaiV1beta2DocumentDocumentLayoutDocumentLayoutBlockLayoutListEntry `json:"listEntries,omitempty"`
	// Type: Type of the list_entries (if exist). Available options are `ordered`
	// and `unordered`.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ListEntries") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ListEntries") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta2DocumentDocumentLayoutDocumentLayoutBlockLayoutListBlock) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2DocumentDocumentLayoutDocumentLayoutBlockLayoutListBlock
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta2DocumentDocumentLayoutDocumentLayoutBlockLayoutLi
// stEntry: Represents an entry in the list.
type GoogleCloudDocumentaiV1beta2DocumentDocumentLayoutDocumentLayoutBlockLayoutListEntry struct {
	// Blocks: A list entry is a list of blocks. Repeated blocks support further
	// hierarchies and nested blocks.
	Blocks []*GoogleCloudDocumentaiV1beta2DocumentDocumentLayoutDocumentLayoutBlock `json:"blocks,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Blocks") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Blocks") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta2DocumentDocumentLayoutDocumentLayoutBlockLayoutListEntry) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2DocumentDocumentLayoutDocumentLayoutBlockLayoutListEntry
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta2DocumentDocumentLayoutDocumentLayoutBlockLayoutPa
// geSpan: Represents where the block starts and ends in the document.
type GoogleCloudDocumentaiV1beta2DocumentDocumentLayoutDocumentLayoutBlockLayoutPageSpan struct {
	// PageEnd: Page where block ends in the document.
	PageEnd int64 `json:"pageEnd,omitempty"`
	// PageStart: Page where block starts in the document.
	PageStart int64 `json:"pageStart,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PageEnd") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PageEnd") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta2DocumentDocumentLayoutDocumentLayoutBlockLayoutPageSpan) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2DocumentDocumentLayoutDocumentLayoutBlockLayoutPageSpan
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta2DocumentDocumentLayoutDocumentLayoutBlockLayoutTa
// bleBlock: Represents a table type block.
type GoogleCloudDocumentaiV1beta2DocumentDocumentLayoutDocumentLayoutBlockLayoutTableBlock struct {
	// BodyRows: Body rows containing main table content.
	BodyRows []*GoogleCloudDocumentaiV1beta2DocumentDocumentLayoutDocumentLayoutBlockLayoutTableRow `json:"bodyRows,omitempty"`
	// Caption: Table caption/title.
	Caption string `json:"caption,omitempty"`
	// HeaderRows: Header rows at the top of the table.
	HeaderRows []*GoogleCloudDocumentaiV1beta2DocumentDocumentLayoutDocumentLayoutBlockLayoutTableRow `json:"headerRows,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BodyRows") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BodyRows") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta2DocumentDocumentLayoutDocumentLayoutBlockLayoutTableBlock) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2DocumentDocumentLayoutDocumentLayoutBlockLayoutTableBlock
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta2DocumentDocumentLayoutDocumentLayoutBlockLayoutTa
// bleCell: Represents a cell in a table row.
type GoogleCloudDocumentaiV1beta2DocumentDocumentLayoutDocumentLayoutBlockLayoutTableCell struct {
	// Blocks: A table cell is a list of blocks. Repeated blocks support further
	// hierarchies and nested blocks.
	Blocks []*GoogleCloudDocumentaiV1beta2DocumentDocumentLayoutDocumentLayoutBlock `json:"blocks,omitempty"`
	// ColSpan: How many columns this cell spans.
	ColSpan int64 `json:"colSpan,omitempty"`
	// RowSpan: How many rows this cell spans.
	RowSpan int64 `json:"rowSpan,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Blocks") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Blocks") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta2DocumentDocumentLayoutDocumentLayoutBlockLayoutTableCell) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2DocumentDocumentLayoutDocumentLayoutBlockLayoutTableCell
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta2DocumentDocumentLayoutDocumentLayoutBlockLayoutTa
// bleRow: Represents a row in a table.
type GoogleCloudDocumentaiV1beta2DocumentDocumentLayoutDocumentLayoutBlockLayoutTableRow struct {
	// Cells: A table row is a list of table cells.
	Cells []*GoogleCloudDocumentaiV1beta2DocumentDocumentLayoutDocumentLayoutBlockLayoutTableCell `json:"cells,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Cells") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Cells") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta2DocumentDocumentLayoutDocumentLayoutBlockLayoutTableRow) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2DocumentDocumentLayoutDocumentLayoutBlockLayoutTableRow
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta2DocumentDocumentLayoutDocumentLayoutBlockLayoutTe
// xtBlock: Represents a text type block.
type GoogleCloudDocumentaiV1beta2DocumentDocumentLayoutDocumentLayoutBlockLayoutTextBlock struct {
	// Blocks: A text block could further have child blocks. Repeated blocks
	// support further hierarchies and nested blocks.
	Blocks []*GoogleCloudDocumentaiV1beta2DocumentDocumentLayoutDocumentLayoutBlock `json:"blocks,omitempty"`
	// Text: Text content stored in the block.
	Text string `json:"text,omitempty"`
	// Type: Type of the text in the block. Available options are: `paragraph`,
	// `subtitle`, `heading-1`, `heading-2`, `heading-3`, `heading-4`, `heading-5`,
	// `header`, `footer`.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Blocks") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Blocks") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta2DocumentDocumentLayoutDocumentLayoutBlockLayoutTextBlock) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2DocumentDocumentLayoutDocumentLayoutBlockLayoutTextBlock
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta2DocumentEntity: An entity that could be a phrase
// in the text or a property that belongs to the document. It is a known entity
// type, such as a person, an organization, or location.
type GoogleCloudDocumentaiV1beta2DocumentEntity struct {
	// Confidence: Optional. Confidence of detected Schema entity. Range `[0, 1]`.
	Confidence float64 `json:"confidence,omitempty"`
	// Id: Optional. Canonical id. This will be a unique value in the entity list
	// for this document.
	Id string `json:"id,omitempty"`
	// MentionId: Optional. Deprecated. Use `id` field instead.
	MentionId string `json:"mentionId,omitempty"`
	// MentionText: Optional. Text value of the entity e.g. `1600 Amphitheatre
	// Pkwy`.
	MentionText string `json:"mentionText,omitempty"`
	// NormalizedValue: Optional. Normalized entity value. Absent if the extracted
	// value could not be converted or the type (e.g. address) is not supported for
	// certain parsers. This field is also only populated for certain supported
	// document types.
	NormalizedValue *GoogleCloudDocumentaiV1beta2DocumentEntityNormalizedValue `json:"normalizedValue,omitempty"`
	// PageAnchor: Optional. Represents the provenance of this entity wrt. the
	// location on the page where it was found.
	PageAnchor *GoogleCloudDocumentaiV1beta2DocumentPageAnchor `json:"pageAnchor,omitempty"`
	// Properties: Optional. Entities can be nested to form a hierarchical data
	// structure representing the content in the document.
	Properties []*GoogleCloudDocumentaiV1beta2DocumentEntity `json:"properties,omitempty"`
	// Provenance: Optional. The history of this annotation.
	Provenance *GoogleCloudDocumentaiV1beta2DocumentProvenance `json:"provenance,omitempty"`
	// Redacted: Optional. Whether the entity will be redacted for
	// de-identification purposes.
	Redacted bool `json:"redacted,omitempty"`
	// TextAnchor: Optional. Provenance of the entity. Text anchor indexing into
	// the Document.text.
	TextAnchor *GoogleCloudDocumentaiV1beta2DocumentTextAnchor `json:"textAnchor,omitempty"`
	// Type: Required. Entity type from a schema e.g. `Address`.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Confidence") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Confidence") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta2DocumentEntity) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2DocumentEntity
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDocumentaiV1beta2DocumentEntity) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDocumentaiV1beta2DocumentEntity
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

// GoogleCloudDocumentaiV1beta2DocumentEntityNormalizedValue: Parsed and
// normalized entity value.
type GoogleCloudDocumentaiV1beta2DocumentEntityNormalizedValue struct {
	// AddressValue: Postal address. See also:
	// https://github.com/googleapis/googleapis/blob/master/google/type/postal_address.proto
	AddressValue *GoogleTypePostalAddress `json:"addressValue,omitempty"`
	// BooleanValue: Boolean value. Can be used for entities with binary values, or
	// for checkboxes.
	BooleanValue bool `json:"booleanValue,omitempty"`
	// DateValue: Date value. Includes year, month, day. See also:
	// https://github.com/googleapis/googleapis/blob/master/google/type/date.proto
	DateValue *GoogleTypeDate `json:"dateValue,omitempty"`
	// DatetimeValue: DateTime value. Includes date, time, and timezone. See also:
	// https://github.com/googleapis/googleapis/blob/master/google/type/datetime.proto
	DatetimeValue *GoogleTypeDateTime `json:"datetimeValue,omitempty"`
	// FloatValue: Float value.
	FloatValue float64 `json:"floatValue,omitempty"`
	// IntegerValue: Integer value.
	IntegerValue int64 `json:"integerValue,omitempty"`
	// MoneyValue: Money value. See also:
	// https://github.com/googleapis/googleapis/blob/master/google/type/money.proto
	MoneyValue *GoogleTypeMoney `json:"moneyValue,omitempty"`
	// Text: Optional. An optional field to store a normalized string. For some
	// entity types, one of respective `structured_value` fields may also be
	// populated. Also not all the types of `structured_value` will be normalized.
	// For example, some processors may not generate `float` or `integer`
	// normalized text by default. Below are sample formats mapped to structured
	// values. - Money/Currency type (`money_value`) is in the ISO 4217 text
	// format. - Date type (`date_value`) is in the ISO 8601 text format. -
	// Datetime type (`datetime_value`) is in the ISO 8601 text format.
	Text string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AddressValue") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AddressValue") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta2DocumentEntityNormalizedValue) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2DocumentEntityNormalizedValue
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDocumentaiV1beta2DocumentEntityNormalizedValue) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDocumentaiV1beta2DocumentEntityNormalizedValue
	var s1 struct {
		FloatValue gensupport.JSONFloat64 `json:"floatValue"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.FloatValue = float64(s1.FloatValue)
	return nil
}

// GoogleCloudDocumentaiV1beta2DocumentEntityRelation: Relationship between
// Entities.
type GoogleCloudDocumentaiV1beta2DocumentEntityRelation struct {
	// ObjectId: Object entity id.
	ObjectId string `json:"objectId,omitempty"`
	// Relation: Relationship description.
	Relation string `json:"relation,omitempty"`
	// SubjectId: Subject entity id.
	SubjectId string `json:"subjectId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ObjectId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ObjectId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta2DocumentEntityRelation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2DocumentEntityRelation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta2DocumentLabel: Label attaches schema information
// and/or other metadata to segments within a Document. Multiple Labels on a
// single field can denote either different labels, different instances of the
// same label created at different times, or some combination of both.
type GoogleCloudDocumentaiV1beta2DocumentLabel struct {
	// AutomlModel: Label is generated AutoML model. This field stores the full
	// resource name of the AutoML model. Format:
	// `projects/{project-id}/locations/{location-id}/models/{model-id}`
	AutomlModel string `json:"automlModel,omitempty"`
	// Confidence: Confidence score between 0 and 1 for label assignment.
	Confidence float64 `json:"confidence,omitempty"`
	// Name: Name of the label. When the label is generated from AutoML Text
	// Classification model, this field represents the name of the category.
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AutomlModel") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AutomlModel") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta2DocumentLabel) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2DocumentLabel
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDocumentaiV1beta2DocumentLabel) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDocumentaiV1beta2DocumentLabel
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

// GoogleCloudDocumentaiV1beta2DocumentPage: A page in a Document.
type GoogleCloudDocumentaiV1beta2DocumentPage struct {
	// Blocks: A list of visually detected text blocks on the page. A block has a
	// set of lines (collected into paragraphs) that have a common line-spacing and
	// orientation.
	Blocks []*GoogleCloudDocumentaiV1beta2DocumentPageBlock `json:"blocks,omitempty"`
	// DetectedBarcodes: A list of detected barcodes.
	DetectedBarcodes []*GoogleCloudDocumentaiV1beta2DocumentPageDetectedBarcode `json:"detectedBarcodes,omitempty"`
	// DetectedLanguages: A list of detected languages together with confidence.
	DetectedLanguages []*GoogleCloudDocumentaiV1beta2DocumentPageDetectedLanguage `json:"detectedLanguages,omitempty"`
	// Dimension: Physical dimension of the page.
	Dimension *GoogleCloudDocumentaiV1beta2DocumentPageDimension `json:"dimension,omitempty"`
	// FormFields: A list of visually detected form fields on the page.
	FormFields []*GoogleCloudDocumentaiV1beta2DocumentPageFormField `json:"formFields,omitempty"`
	// Image: Rendered image for this page. This image is preprocessed to remove
	// any skew, rotation, and distortions such that the annotation bounding boxes
	// can be upright and axis-aligned.
	Image *GoogleCloudDocumentaiV1beta2DocumentPageImage `json:"image,omitempty"`
	// ImageQualityScores: Image quality scores.
	ImageQualityScores *GoogleCloudDocumentaiV1beta2DocumentPageImageQualityScores `json:"imageQualityScores,omitempty"`
	// Layout: Layout for the page.
	Layout *GoogleCloudDocumentaiV1beta2DocumentPageLayout `json:"layout,omitempty"`
	// Lines: A list of visually detected text lines on the page. A collection of
	// tokens that a human would perceive as a line.
	Lines []*GoogleCloudDocumentaiV1beta2DocumentPageLine `json:"lines,omitempty"`
	// PageNumber: 1-based index for current Page in a parent Document. Useful when
	// a page is taken out of a Document for individual processing.
	PageNumber int64 `json:"pageNumber,omitempty"`
	// Paragraphs: A list of visually detected text paragraphs on the page. A
	// collection of lines that a human would perceive as a paragraph.
	Paragraphs []*GoogleCloudDocumentaiV1beta2DocumentPageParagraph `json:"paragraphs,omitempty"`
	// Provenance: The history of this page.
	Provenance *GoogleCloudDocumentaiV1beta2DocumentProvenance `json:"provenance,omitempty"`
	// Symbols: A list of visually detected symbols on the page.
	Symbols []*GoogleCloudDocumentaiV1beta2DocumentPageSymbol `json:"symbols,omitempty"`
	// Tables: A list of visually detected tables on the page.
	Tables []*GoogleCloudDocumentaiV1beta2DocumentPageTable `json:"tables,omitempty"`
	// Tokens: A list of visually detected tokens on the page.
	Tokens []*GoogleCloudDocumentaiV1beta2DocumentPageToken `json:"tokens,omitempty"`
	// Transforms: Transformation matrices that were applied to the original
	// document image to produce Page.image.
	Transforms []*GoogleCloudDocumentaiV1beta2DocumentPageMatrix `json:"transforms,omitempty"`
	// VisualElements: A list of detected non-text visual elements e.g. checkbox,
	// signature etc. on the page.
	VisualElements []*GoogleCloudDocumentaiV1beta2DocumentPageVisualElement `json:"visualElements,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Blocks") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Blocks") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta2DocumentPage) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2DocumentPage
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta2DocumentPageAnchor: Referencing the visual
// context of the entity in the Document.pages. Page anchors can be cross-page,
// consist of multiple bounding polygons and optionally reference specific
// layout element types.
type GoogleCloudDocumentaiV1beta2DocumentPageAnchor struct {
	// PageRefs: One or more references to visual page elements
	PageRefs []*GoogleCloudDocumentaiV1beta2DocumentPageAnchorPageRef `json:"pageRefs,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PageRefs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PageRefs") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta2DocumentPageAnchor) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2DocumentPageAnchor
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta2DocumentPageAnchorPageRef: Represents a weak
// reference to a page element within a document.
type GoogleCloudDocumentaiV1beta2DocumentPageAnchorPageRef struct {
	// BoundingPoly: Optional. Identifies the bounding polygon of a layout element
	// on the page. If `layout_type` is set, the bounding polygon must be exactly
	// the same to the layout element it's referring to.
	BoundingPoly *GoogleCloudDocumentaiV1beta2BoundingPoly `json:"boundingPoly,omitempty"`
	// Confidence: Optional. Confidence of detected page element, if applicable.
	// Range `[0, 1]`.
	Confidence float64 `json:"confidence,omitempty"`
	// LayoutId: Optional. Deprecated. Use PageRef.bounding_poly instead.
	LayoutId string `json:"layoutId,omitempty"`
	// LayoutType: Optional. The type of the layout element that is being
	// referenced if any.
	//
	// Possible values:
	//   "LAYOUT_TYPE_UNSPECIFIED" - Layout Unspecified.
	//   "BLOCK" - References a Page.blocks element.
	//   "PARAGRAPH" - References a Page.paragraphs element.
	//   "LINE" - References a Page.lines element.
	//   "TOKEN" - References a Page.tokens element.
	//   "VISUAL_ELEMENT" - References a Page.visual_elements element.
	//   "TABLE" - Refrrences a Page.tables element.
	//   "FORM_FIELD" - References a Page.form_fields element.
	LayoutType string `json:"layoutType,omitempty"`
	// Page: Required. Index into the Document.pages element, for example using
	// `Document.pages` to locate the related page element. This field is skipped
	// when its value is the default `0`. See
	// https://developers.google.com/protocol-buffers/docs/proto3#json.
	Page int64 `json:"page,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "BoundingPoly") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BoundingPoly") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta2DocumentPageAnchorPageRef) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2DocumentPageAnchorPageRef
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDocumentaiV1beta2DocumentPageAnchorPageRef) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDocumentaiV1beta2DocumentPageAnchorPageRef
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

// GoogleCloudDocumentaiV1beta2DocumentPageBlock: A block has a set of lines
// (collected into paragraphs) that have a common line-spacing and orientation.
type GoogleCloudDocumentaiV1beta2DocumentPageBlock struct {
	// DetectedLanguages: A list of detected languages together with confidence.
	DetectedLanguages []*GoogleCloudDocumentaiV1beta2DocumentPageDetectedLanguage `json:"detectedLanguages,omitempty"`
	// Layout: Layout for Block.
	Layout *GoogleCloudDocumentaiV1beta2DocumentPageLayout `json:"layout,omitempty"`
	// Provenance: The history of this annotation.
	Provenance *GoogleCloudDocumentaiV1beta2DocumentProvenance `json:"provenance,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DetectedLanguages") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DetectedLanguages") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta2DocumentPageBlock) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2DocumentPageBlock
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta2DocumentPageDetectedBarcode: A detected barcode.
type GoogleCloudDocumentaiV1beta2DocumentPageDetectedBarcode struct {
	// Barcode: Detailed barcode information of the DetectedBarcode.
	Barcode *GoogleCloudDocumentaiV1beta2Barcode `json:"barcode,omitempty"`
	// Layout: Layout for DetectedBarcode.
	Layout *GoogleCloudDocumentaiV1beta2DocumentPageLayout `json:"layout,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Barcode") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Barcode") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta2DocumentPageDetectedBarcode) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2DocumentPageDetectedBarcode
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta2DocumentPageDetectedLanguage: Detected language
// for a structural component.
type GoogleCloudDocumentaiV1beta2DocumentPageDetectedLanguage struct {
	// Confidence: Confidence of detected language. Range `[0, 1]`.
	Confidence float64 `json:"confidence,omitempty"`
	// LanguageCode: The BCP-47 language code
	// (https://www.unicode.org/reports/tr35/#Unicode_locale_identifier), such as
	// `en-US` or `sr-Latn`.
	LanguageCode string `json:"languageCode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Confidence") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Confidence") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta2DocumentPageDetectedLanguage) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2DocumentPageDetectedLanguage
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDocumentaiV1beta2DocumentPageDetectedLanguage) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDocumentaiV1beta2DocumentPageDetectedLanguage
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

// GoogleCloudDocumentaiV1beta2DocumentPageDimension: Dimension for the page.
type GoogleCloudDocumentaiV1beta2DocumentPageDimension struct {
	// Height: Page height.
	Height float64 `json:"height,omitempty"`
	// Unit: Dimension unit.
	Unit string `json:"unit,omitempty"`
	// Width: Page width.
	Width float64 `json:"width,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Height") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Height") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta2DocumentPageDimension) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2DocumentPageDimension
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDocumentaiV1beta2DocumentPageDimension) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDocumentaiV1beta2DocumentPageDimension
	var s1 struct {
		Height gensupport.JSONFloat64 `json:"height"`
		Width  gensupport.JSONFloat64 `json:"width"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Height = float64(s1.Height)
	s.Width = float64(s1.Width)
	return nil
}

// GoogleCloudDocumentaiV1beta2DocumentPageFormField: A form field detected on
// the page.
type GoogleCloudDocumentaiV1beta2DocumentPageFormField struct {
	// CorrectedKeyText: Created for Labeling UI to export key text. If corrections
	// were made to the text identified by the `field_name.text_anchor`, this field
	// will contain the correction.
	CorrectedKeyText string `json:"correctedKeyText,omitempty"`
	// CorrectedValueText: Created for Labeling UI to export value text. If
	// corrections were made to the text identified by the
	// `field_value.text_anchor`, this field will contain the correction.
	CorrectedValueText string `json:"correctedValueText,omitempty"`
	// FieldName: Layout for the FormField name. e.g. `Address`, `Email`, `Grand
	// total`, `Phone number`, etc.
	FieldName *GoogleCloudDocumentaiV1beta2DocumentPageLayout `json:"fieldName,omitempty"`
	// FieldValue: Layout for the FormField value.
	FieldValue *GoogleCloudDocumentaiV1beta2DocumentPageLayout `json:"fieldValue,omitempty"`
	// NameDetectedLanguages: A list of detected languages for name together with
	// confidence.
	NameDetectedLanguages []*GoogleCloudDocumentaiV1beta2DocumentPageDetectedLanguage `json:"nameDetectedLanguages,omitempty"`
	// Provenance: The history of this annotation.
	Provenance *GoogleCloudDocumentaiV1beta2DocumentProvenance `json:"provenance,omitempty"`
	// ValueDetectedLanguages: A list of detected languages for value together with
	// confidence.
	ValueDetectedLanguages []*GoogleCloudDocumentaiV1beta2DocumentPageDetectedLanguage `json:"valueDetectedLanguages,omitempty"`
	// ValueType: If the value is non-textual, this field represents the type.
	// Current valid values are: - blank (this indicates the `field_value` is
	// normal text) - `unfilled_checkbox` - `filled_checkbox`
	ValueType string `json:"valueType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CorrectedKeyText") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CorrectedKeyText") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta2DocumentPageFormField) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2DocumentPageFormField
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta2DocumentPageImage: Rendered image contents for
// this page.
type GoogleCloudDocumentaiV1beta2DocumentPageImage struct {
	// Content: Raw byte content of the image.
	Content string `json:"content,omitempty"`
	// Height: Height of the image in pixels.
	Height int64 `json:"height,omitempty"`
	// MimeType: Encoding media type (MIME type)
	// (https://www.iana.org/assignments/media-types/media-types.xhtml) for the
	// image.
	MimeType string `json:"mimeType,omitempty"`
	// Width: Width of the image in pixels.
	Width int64 `json:"width,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Content") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Content") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta2DocumentPageImage) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2DocumentPageImage
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta2DocumentPageImageQualityScores: Image quality
// scores for the page image.
type GoogleCloudDocumentaiV1beta2DocumentPageImageQualityScores struct {
	// DetectedDefects: A list of detected defects.
	DetectedDefects []*GoogleCloudDocumentaiV1beta2DocumentPageImageQualityScoresDetectedDefect `json:"detectedDefects,omitempty"`
	// QualityScore: The overall quality score. Range `[0, 1]` where `1` is perfect
	// quality.
	QualityScore float64 `json:"qualityScore,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DetectedDefects") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DetectedDefects") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta2DocumentPageImageQualityScores) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2DocumentPageImageQualityScores
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDocumentaiV1beta2DocumentPageImageQualityScores) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDocumentaiV1beta2DocumentPageImageQualityScores
	var s1 struct {
		QualityScore gensupport.JSONFloat64 `json:"qualityScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.QualityScore = float64(s1.QualityScore)
	return nil
}

// GoogleCloudDocumentaiV1beta2DocumentPageImageQualityScoresDetectedDefect:
// Image Quality Defects
type GoogleCloudDocumentaiV1beta2DocumentPageImageQualityScoresDetectedDefect struct {
	// Confidence: Confidence of detected defect. Range `[0, 1]` where `1`
	// indicates strong confidence that the defect exists.
	Confidence float64 `json:"confidence,omitempty"`
	// Type: Name of the defect type. Supported values are: -
	// `quality/defect_blurry` - `quality/defect_noisy` - `quality/defect_dark` -
	// `quality/defect_faint` - `quality/defect_text_too_small` -
	// `quality/defect_document_cutoff` - `quality/defect_text_cutoff` -
	// `quality/defect_glare`
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Confidence") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Confidence") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta2DocumentPageImageQualityScoresDetectedDefect) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2DocumentPageImageQualityScoresDetectedDefect
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDocumentaiV1beta2DocumentPageImageQualityScoresDetectedDefect) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDocumentaiV1beta2DocumentPageImageQualityScoresDetectedDefect
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

// GoogleCloudDocumentaiV1beta2DocumentPageLayout: Visual element describing a
// layout unit on a page.
type GoogleCloudDocumentaiV1beta2DocumentPageLayout struct {
	// BoundingPoly: The bounding polygon for the Layout.
	BoundingPoly *GoogleCloudDocumentaiV1beta2BoundingPoly `json:"boundingPoly,omitempty"`
	// Confidence: Confidence of the current Layout within context of the object
	// this layout is for. e.g. confidence can be for a single token, a table, a
	// visual element, etc. depending on context. Range `[0, 1]`.
	Confidence float64 `json:"confidence,omitempty"`
	// Orientation: Detected orientation for the Layout.
	//
	// Possible values:
	//   "ORIENTATION_UNSPECIFIED" - Unspecified orientation.
	//   "PAGE_UP" - Orientation is aligned with page up.
	//   "PAGE_RIGHT" - Orientation is aligned with page right. Turn the head 90
	// degrees clockwise from upright to read.
	//   "PAGE_DOWN" - Orientation is aligned with page down. Turn the head 180
	// degrees from upright to read.
	//   "PAGE_LEFT" - Orientation is aligned with page left. Turn the head 90
	// degrees counterclockwise from upright to read.
	Orientation string `json:"orientation,omitempty"`
	// TextAnchor: Text anchor indexing into the Document.text.
	TextAnchor *GoogleCloudDocumentaiV1beta2DocumentTextAnchor `json:"textAnchor,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BoundingPoly") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BoundingPoly") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta2DocumentPageLayout) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2DocumentPageLayout
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDocumentaiV1beta2DocumentPageLayout) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDocumentaiV1beta2DocumentPageLayout
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

// GoogleCloudDocumentaiV1beta2DocumentPageLine: A collection of tokens that a
// human would perceive as a line. Does not cross column boundaries, can be
// horizontal, vertical, etc.
type GoogleCloudDocumentaiV1beta2DocumentPageLine struct {
	// DetectedLanguages: A list of detected languages together with confidence.
	DetectedLanguages []*GoogleCloudDocumentaiV1beta2DocumentPageDetectedLanguage `json:"detectedLanguages,omitempty"`
	// Layout: Layout for Line.
	Layout *GoogleCloudDocumentaiV1beta2DocumentPageLayout `json:"layout,omitempty"`
	// Provenance: The history of this annotation.
	Provenance *GoogleCloudDocumentaiV1beta2DocumentProvenance `json:"provenance,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DetectedLanguages") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DetectedLanguages") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta2DocumentPageLine) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2DocumentPageLine
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta2DocumentPageMatrix: Representation for
// transformation matrix, intended to be compatible and used with OpenCV format
// for image manipulation.
type GoogleCloudDocumentaiV1beta2DocumentPageMatrix struct {
	// Cols: Number of columns in the matrix.
	Cols int64 `json:"cols,omitempty"`
	// Data: The matrix data.
	Data string `json:"data,omitempty"`
	// Rows: Number of rows in the matrix.
	Rows int64 `json:"rows,omitempty"`
	// Type: This encodes information about what data type the matrix uses. For
	// example, 0 (CV_8U) is an unsigned 8-bit image. For the full list of OpenCV
	// primitive data types, please refer to
	// https://docs.opencv.org/4.3.0/d1/d1b/group__core__hal__interface.html
	Type int64 `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Cols") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Cols") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta2DocumentPageMatrix) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2DocumentPageMatrix
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta2DocumentPageParagraph: A collection of lines
// that a human would perceive as a paragraph.
type GoogleCloudDocumentaiV1beta2DocumentPageParagraph struct {
	// DetectedLanguages: A list of detected languages together with confidence.
	DetectedLanguages []*GoogleCloudDocumentaiV1beta2DocumentPageDetectedLanguage `json:"detectedLanguages,omitempty"`
	// Layout: Layout for Paragraph.
	Layout *GoogleCloudDocumentaiV1beta2DocumentPageLayout `json:"layout,omitempty"`
	// Provenance: The history of this annotation.
	Provenance *GoogleCloudDocumentaiV1beta2DocumentProvenance `json:"provenance,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DetectedLanguages") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DetectedLanguages") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta2DocumentPageParagraph) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2DocumentPageParagraph
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta2DocumentPageSymbol: A detected symbol.
type GoogleCloudDocumentaiV1beta2DocumentPageSymbol struct {
	// DetectedLanguages: A list of detected languages together with confidence.
	DetectedLanguages []*GoogleCloudDocumentaiV1beta2DocumentPageDetectedLanguage `json:"detectedLanguages,omitempty"`
	// Layout: Layout for Symbol.
	Layout *GoogleCloudDocumentaiV1beta2DocumentPageLayout `json:"layout,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DetectedLanguages") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DetectedLanguages") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta2DocumentPageSymbol) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2DocumentPageSymbol
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta2DocumentPageTable: A table representation
// similar to HTML table structure.
type GoogleCloudDocumentaiV1beta2DocumentPageTable struct {
	// BodyRows: Body rows of the table.
	BodyRows []*GoogleCloudDocumentaiV1beta2DocumentPageTableTableRow `json:"bodyRows,omitempty"`
	// DetectedLanguages: A list of detected languages together with confidence.
	DetectedLanguages []*GoogleCloudDocumentaiV1beta2DocumentPageDetectedLanguage `json:"detectedLanguages,omitempty"`
	// HeaderRows: Header rows of the table.
	HeaderRows []*GoogleCloudDocumentaiV1beta2DocumentPageTableTableRow `json:"headerRows,omitempty"`
	// Layout: Layout for Table.
	Layout *GoogleCloudDocumentaiV1beta2DocumentPageLayout `json:"layout,omitempty"`
	// Provenance: The history of this table.
	Provenance *GoogleCloudDocumentaiV1beta2DocumentProvenance `json:"provenance,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BodyRows") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BodyRows") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta2DocumentPageTable) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2DocumentPageTable
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta2DocumentPageTableTableCell: A cell
// representation inside the table.
type GoogleCloudDocumentaiV1beta2DocumentPageTableTableCell struct {
	// ColSpan: How many columns this cell spans.
	ColSpan int64 `json:"colSpan,omitempty"`
	// DetectedLanguages: A list of detected languages together with confidence.
	DetectedLanguages []*GoogleCloudDocumentaiV1beta2DocumentPageDetectedLanguage `json:"detectedLanguages,omitempty"`
	// Layout: Layout for TableCell.
	Layout *GoogleCloudDocumentaiV1beta2DocumentPageLayout `json:"layout,omitempty"`
	// RowSpan: How many rows this cell spans.
	RowSpan int64 `json:"rowSpan,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ColSpan") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ColSpan") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta2DocumentPageTableTableCell) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2DocumentPageTableTableCell
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta2DocumentPageTableTableRow: A row of table cells.
type GoogleCloudDocumentaiV1beta2DocumentPageTableTableRow struct {
	// Cells: Cells that make up this row.
	Cells []*GoogleCloudDocumentaiV1beta2DocumentPageTableTableCell `json:"cells,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Cells") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Cells") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta2DocumentPageTableTableRow) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2DocumentPageTableTableRow
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta2DocumentPageToken: A detected token.
type GoogleCloudDocumentaiV1beta2DocumentPageToken struct {
	// DetectedBreak: Detected break at the end of a Token.
	DetectedBreak *GoogleCloudDocumentaiV1beta2DocumentPageTokenDetectedBreak `json:"detectedBreak,omitempty"`
	// DetectedLanguages: A list of detected languages together with confidence.
	DetectedLanguages []*GoogleCloudDocumentaiV1beta2DocumentPageDetectedLanguage `json:"detectedLanguages,omitempty"`
	// Layout: Layout for Token.
	Layout *GoogleCloudDocumentaiV1beta2DocumentPageLayout `json:"layout,omitempty"`
	// Provenance: The history of this annotation.
	Provenance *GoogleCloudDocumentaiV1beta2DocumentProvenance `json:"provenance,omitempty"`
	// StyleInfo: Text style attributes.
	StyleInfo *GoogleCloudDocumentaiV1beta2DocumentPageTokenStyleInfo `json:"styleInfo,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DetectedBreak") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DetectedBreak") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta2DocumentPageToken) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2DocumentPageToken
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta2DocumentPageTokenDetectedBreak: Detected break
// at the end of a Token.
type GoogleCloudDocumentaiV1beta2DocumentPageTokenDetectedBreak struct {
	// Type: Detected break type.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - Unspecified break type.
	//   "SPACE" - A single whitespace.
	//   "WIDE_SPACE" - A wider whitespace.
	//   "HYPHEN" - A hyphen that indicates that a token has been split across
	// lines.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Type") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Type") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta2DocumentPageTokenDetectedBreak) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2DocumentPageTokenDetectedBreak
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta2DocumentPageTokenStyleInfo: Font and other text
// style attributes.
type GoogleCloudDocumentaiV1beta2DocumentPageTokenStyleInfo struct {
	// BackgroundColor: Color of the background.
	BackgroundColor *GoogleTypeColor `json:"backgroundColor,omitempty"`
	// Bold: Whether the text is bold (equivalent to font_weight is at least
	// `700`).
	Bold bool `json:"bold,omitempty"`
	// FontSize: Font size in points (`1` point is `¹⁄₇₂` inches).
	FontSize int64 `json:"fontSize,omitempty"`
	// FontType: Name or style of the font.
	FontType string `json:"fontType,omitempty"`
	// FontWeight: TrueType weight on a scale `100` (thin) to `1000` (ultra-heavy).
	// Normal is `400`, bold is `700`.
	FontWeight int64 `json:"fontWeight,omitempty"`
	// Handwritten: Whether the text is handwritten.
	Handwritten bool `json:"handwritten,omitempty"`
	// Italic: Whether the text is italic.
	Italic bool `json:"italic,omitempty"`
	// LetterSpacing: Letter spacing in points.
	LetterSpacing float64 `json:"letterSpacing,omitempty"`
	// PixelFontSize: Font size in pixels, equal to _unrounded font_size_ *
	// _resolution_ ÷ `72.0`.
	PixelFontSize float64 `json:"pixelFontSize,omitempty"`
	// Smallcaps: Whether the text is in small caps. This feature is not supported
	// yet.
	Smallcaps bool `json:"smallcaps,omitempty"`
	// Strikeout: Whether the text is strikethrough. This feature is not supported
	// yet.
	Strikeout bool `json:"strikeout,omitempty"`
	// Subscript: Whether the text is a subscript. This feature is not supported
	// yet.
	Subscript bool `json:"subscript,omitempty"`
	// Superscript: Whether the text is a superscript. This feature is not
	// supported yet.
	Superscript bool `json:"superscript,omitempty"`
	// TextColor: Color of the text.
	TextColor *GoogleTypeColor `json:"textColor,omitempty"`
	// Underlined: Whether the text is underlined.
	Underlined bool `json:"underlined,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BackgroundColor") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BackgroundColor") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta2DocumentPageTokenStyleInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2DocumentPageTokenStyleInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDocumentaiV1beta2DocumentPageTokenStyleInfo) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDocumentaiV1beta2DocumentPageTokenStyleInfo
	var s1 struct {
		LetterSpacing gensupport.JSONFloat64 `json:"letterSpacing"`
		PixelFontSize gensupport.JSONFloat64 `json:"pixelFontSize"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.LetterSpacing = float64(s1.LetterSpacing)
	s.PixelFontSize = float64(s1.PixelFontSize)
	return nil
}

// GoogleCloudDocumentaiV1beta2DocumentPageVisualElement: Detected non-text
// visual elements e.g. checkbox, signature etc. on the page.
type GoogleCloudDocumentaiV1beta2DocumentPageVisualElement struct {
	// DetectedLanguages: A list of detected languages together with confidence.
	DetectedLanguages []*GoogleCloudDocumentaiV1beta2DocumentPageDetectedLanguage `json:"detectedLanguages,omitempty"`
	// Layout: Layout for VisualElement.
	Layout *GoogleCloudDocumentaiV1beta2DocumentPageLayout `json:"layout,omitempty"`
	// Type: Type of the VisualElement.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DetectedLanguages") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DetectedLanguages") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta2DocumentPageVisualElement) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2DocumentPageVisualElement
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta2DocumentProvenance: Structure to identify
// provenance relationships between annotations in different revisions.
type GoogleCloudDocumentaiV1beta2DocumentProvenance struct {
	// Id: The Id of this operation. Needs to be unique within the scope of the
	// revision.
	Id int64 `json:"id,omitempty"`
	// Parents: References to the original elements that are replaced.
	Parents []*GoogleCloudDocumentaiV1beta2DocumentProvenanceParent `json:"parents,omitempty"`
	// Revision: The index of the revision that produced this element.
	Revision int64 `json:"revision,omitempty"`
	// Type: The type of provenance operation.
	//
	// Possible values:
	//   "OPERATION_TYPE_UNSPECIFIED" - Operation type unspecified. If no operation
	// is specified a provenance entry is simply used to match against a `parent`.
	//   "ADD" - Add an element.
	//   "REMOVE" - Remove an element identified by `parent`.
	//   "UPDATE" - Updates any fields within the given provenance scope of the
	// message. It overwrites the fields rather than replacing them. Use this when
	// you want to update a field value of an entity without also updating all the
	// child properties.
	//   "REPLACE" - Currently unused. Replace an element identified by `parent`.
	//   "EVAL_REQUESTED" - Deprecated. Request human review for the element
	// identified by `parent`.
	//   "EVAL_APPROVED" - Deprecated. Element is reviewed and approved at human
	// review, confidence will be set to 1.0.
	//   "EVAL_SKIPPED" - Deprecated. Element is skipped in the validation process.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Id") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Id") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta2DocumentProvenance) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2DocumentProvenance
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta2DocumentProvenanceParent: The parent element the
// current element is based on. Used for referencing/aligning, removal and
// replacement operations.
type GoogleCloudDocumentaiV1beta2DocumentProvenanceParent struct {
	// Id: The id of the parent provenance.
	Id int64 `json:"id,omitempty"`
	// Index: The index of the parent item in the corresponding item list (eg. list
	// of entities, properties within entities, etc.) in the parent revision.
	Index int64 `json:"index,omitempty"`
	// Revision: The index of the index into current revision's parent_ids list.
	Revision int64 `json:"revision,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Id") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Id") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta2DocumentProvenanceParent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2DocumentProvenanceParent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta2DocumentRevision: Contains past or forward
// revisions of this document.
type GoogleCloudDocumentaiV1beta2DocumentRevision struct {
	// Agent: If the change was made by a person specify the name or id of that
	// person.
	Agent string `json:"agent,omitempty"`
	// CreateTime: The time that the revision was created, internally generated by
	// doc proto storage at the time of create.
	CreateTime string `json:"createTime,omitempty"`
	// HumanReview: Human Review information of this revision.
	HumanReview *GoogleCloudDocumentaiV1beta2DocumentRevisionHumanReview `json:"humanReview,omitempty"`
	// Id: Id of the revision, internally generated by doc proto storage. Unique
	// within the context of the document.
	Id string `json:"id,omitempty"`
	// Parent: The revisions that this revision is based on. This can include one
	// or more parent (when documents are merged.) This field represents the index
	// into the `revisions` field.
	Parent []int64 `json:"parent,omitempty"`
	// ParentIds: The revisions that this revision is based on. Must include all
	// the ids that have anything to do with this revision - eg. there are
	// `provenance.parent.revision` fields that index into this field.
	ParentIds []string `json:"parentIds,omitempty"`
	// Processor: If the annotation was made by processor identify the processor by
	// its resource name.
	Processor string `json:"processor,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Agent") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Agent") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta2DocumentRevision) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2DocumentRevision
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta2DocumentRevisionHumanReview: Human Review
// information of the document.
type GoogleCloudDocumentaiV1beta2DocumentRevisionHumanReview struct {
	// State: Human review state. e.g. `requested`, `succeeded`, `rejected`.
	State string `json:"state,omitempty"`
	// StateMessage: A message providing more details about the current state of
	// processing. For example, the rejection reason when the state is `rejected`.
	StateMessage string `json:"stateMessage,omitempty"`
	// ForceSendFields is a list of field names (e.g. "State") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "State") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta2DocumentRevisionHumanReview) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2DocumentRevisionHumanReview
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta2DocumentShardInfo: For a large document,
// sharding may be performed to produce several document shards. Each document
// shard contains this field to detail which shard it is.
type GoogleCloudDocumentaiV1beta2DocumentShardInfo struct {
	// ShardCount: Total number of shards.
	ShardCount int64 `json:"shardCount,omitempty,string"`
	// ShardIndex: The 0-based index of this shard.
	ShardIndex int64 `json:"shardIndex,omitempty,string"`
	// TextOffset: The index of the first character in Document.text in the overall
	// document global text.
	TextOffset int64 `json:"textOffset,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "ShardCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ShardCount") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta2DocumentShardInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2DocumentShardInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta2DocumentStyle: Annotation for common text style
// attributes. This adheres to CSS conventions as much as possible.
type GoogleCloudDocumentaiV1beta2DocumentStyle struct {
	// BackgroundColor: Text background color.
	BackgroundColor *GoogleTypeColor `json:"backgroundColor,omitempty"`
	// Color: Text color.
	Color *GoogleTypeColor `json:"color,omitempty"`
	// FontFamily: Font family such as `Arial`, `Times New Roman`.
	// https://www.w3schools.com/cssref/pr_font_font-family.asp
	FontFamily string `json:"fontFamily,omitempty"`
	// FontSize: Font size.
	FontSize *GoogleCloudDocumentaiV1beta2DocumentStyleFontSize `json:"fontSize,omitempty"`
	// FontWeight: Font weight
	// (https://www.w3schools.com/cssref/pr_font_weight.asp). Possible values are
	// `normal`, `bold`, `bolder`, and `lighter`.
	FontWeight string `json:"fontWeight,omitempty"`
	// TextAnchor: Text anchor indexing into the Document.text.
	TextAnchor *GoogleCloudDocumentaiV1beta2DocumentTextAnchor `json:"textAnchor,omitempty"`
	// TextDecoration: Text decoration
	// (https://www.w3schools.com/cssref/pr_text_text-decoration.asp). Follows CSS
	// standard.
	TextDecoration string `json:"textDecoration,omitempty"`
	// TextStyle: Text style
	// (https://www.w3schools.com/cssref/pr_font_font-style.asp). Possible values
	// are `normal`, `italic`, and `oblique`.
	TextStyle string `json:"textStyle,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BackgroundColor") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BackgroundColor") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta2DocumentStyle) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2DocumentStyle
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta2DocumentStyleFontSize: Font size with unit.
type GoogleCloudDocumentaiV1beta2DocumentStyleFontSize struct {
	// Size: Font size for the text.
	Size float64 `json:"size,omitempty"`
	// Unit: Unit for the font size. Follows CSS naming (such as `in`, `px`, and
	// `pt`).
	Unit string `json:"unit,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Size") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Size") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta2DocumentStyleFontSize) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2DocumentStyleFontSize
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDocumentaiV1beta2DocumentStyleFontSize) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDocumentaiV1beta2DocumentStyleFontSize
	var s1 struct {
		Size gensupport.JSONFloat64 `json:"size"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Size = float64(s1.Size)
	return nil
}

// GoogleCloudDocumentaiV1beta2DocumentTextAnchor: Text reference indexing into
// the Document.text.
type GoogleCloudDocumentaiV1beta2DocumentTextAnchor struct {
	// Content: Contains the content of the text span so that users do not have to
	// look it up in the text_segments. It is always populated for formFields.
	Content string `json:"content,omitempty"`
	// TextSegments: The text segments from the Document.text.
	TextSegments []*GoogleCloudDocumentaiV1beta2DocumentTextAnchorTextSegment `json:"textSegments,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Content") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Content") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta2DocumentTextAnchor) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2DocumentTextAnchor
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta2DocumentTextAnchorTextSegment: A text segment in
// the Document.text. The indices may be out of bounds which indicate that the
// text extends into another document shard for large sharded documents. See
// ShardInfo.text_offset
type GoogleCloudDocumentaiV1beta2DocumentTextAnchorTextSegment struct {
	// EndIndex: TextSegment half open end UTF-8 char index in the Document.text.
	EndIndex int64 `json:"endIndex,omitempty,string"`
	// StartIndex: TextSegment start UTF-8 char index in the Document.text.
	StartIndex int64 `json:"startIndex,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "EndIndex") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndIndex") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta2DocumentTextAnchorTextSegment) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2DocumentTextAnchorTextSegment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta2DocumentTextChange: This message is used for
// text changes aka. OCR corrections.
type GoogleCloudDocumentaiV1beta2DocumentTextChange struct {
	// ChangedText: The text that replaces the text identified in the
	// `text_anchor`.
	ChangedText string `json:"changedText,omitempty"`
	// Provenance: The history of this annotation.
	Provenance []*GoogleCloudDocumentaiV1beta2DocumentProvenance `json:"provenance,omitempty"`
	// TextAnchor: Provenance of the correction. Text anchor indexing into the
	// Document.text. There can only be a single `TextAnchor.text_segments`
	// element. If the start and end index of the text segment are the same, the
	// text change is inserted before that index.
	TextAnchor *GoogleCloudDocumentaiV1beta2DocumentTextAnchor `json:"textAnchor,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChangedText") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChangedText") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta2DocumentTextChange) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2DocumentTextChange
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta2EntityExtractionParams: Parameters to control
// entity extraction behavior.
type GoogleCloudDocumentaiV1beta2EntityExtractionParams struct {
	// Enabled: Whether to enable entity extraction.
	Enabled bool `json:"enabled,omitempty"`
	// ModelVersion: Model version of the entity extraction. Default is
	// "builtin/stable". Specify "builtin/latest" for the latest model.
	ModelVersion string `json:"modelVersion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Enabled") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Enabled") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta2EntityExtractionParams) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2EntityExtractionParams
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta2FormExtractionParams: Parameters to control form
// extraction behavior.
type GoogleCloudDocumentaiV1beta2FormExtractionParams struct {
	// Enabled: Whether to enable form extraction.
	Enabled bool `json:"enabled,omitempty"`
	// KeyValuePairHints: Reserved for future use.
	KeyValuePairHints []*GoogleCloudDocumentaiV1beta2KeyValuePairHint `json:"keyValuePairHints,omitempty"`
	// ModelVersion: Model version of the form extraction system. Default is
	// "builtin/stable". Specify "builtin/latest" for the latest model. For custom
	// form models, specify: "custom/{model_name}". Model name format is
	// "bucket_name/path/to/modeldir" corresponding to
	// "gs://bucket_name/path/to/modeldir" where annotated examples are stored.
	ModelVersion string `json:"modelVersion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Enabled") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Enabled") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta2FormExtractionParams) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2FormExtractionParams
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta2GcsDestination: The Google Cloud Storage
// location where the output file will be written to.
type GoogleCloudDocumentaiV1beta2GcsDestination struct {
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Uri") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Uri") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta2GcsDestination) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2GcsDestination
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta2GcsSource: The Google Cloud Storage location
// where the input file will be read from.
type GoogleCloudDocumentaiV1beta2GcsSource struct {
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Uri") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Uri") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta2GcsSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2GcsSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta2InputConfig: The desired input location and
// metadata.
type GoogleCloudDocumentaiV1beta2InputConfig struct {
	// Contents: Content in bytes, represented as a stream of bytes. Note: As with
	// all `bytes` fields, proto buffer messages use a pure binary representation,
	// whereas JSON representations use base64. This field only works for
	// synchronous ProcessDocument method.
	Contents string `json:"contents,omitempty"`
	// GcsSource: The Google Cloud Storage location to read the input from. This
	// must be a single file.
	GcsSource *GoogleCloudDocumentaiV1beta2GcsSource `json:"gcsSource,omitempty"`
	// MimeType: Required. Mimetype of the input. Current supported mimetypes are
	// application/pdf, image/tiff, and image/gif. In addition, application/json
	// type is supported for requests with ProcessDocumentRequest.automl_params
	// field set. The JSON file needs to be in Document format.
	MimeType string `json:"mimeType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Contents") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Contents") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta2InputConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2InputConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta2KeyValuePairHint: Reserved for future use.
type GoogleCloudDocumentaiV1beta2KeyValuePairHint struct {
	// Key: The key text for the hint.
	Key string `json:"key,omitempty"`
	// ValueTypes: Type of the value. This is case-insensitive, and could be one
	// of: ADDRESS, LOCATION, ORGANIZATION, PERSON, PHONE_NUMBER, ID, NUMBER,
	// EMAIL, PRICE, TERMS, DATE, NAME. Types not in this list will be ignored.
	ValueTypes []string `json:"valueTypes,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Key") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Key") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta2KeyValuePairHint) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2KeyValuePairHint
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta2NormalizedVertex: A vertex represents a 2D point
// in the image. NOTE: the normalized vertex coordinates are relative to the
// original image and range from 0 to 1.
type GoogleCloudDocumentaiV1beta2NormalizedVertex struct {
	// X: X coordinate.
	X float64 `json:"x,omitempty"`
	// Y: Y coordinate (starts from the top of the image).
	Y float64 `json:"y,omitempty"`
	// ForceSendFields is a list of field names (e.g. "X") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "X") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta2NormalizedVertex) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2NormalizedVertex
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDocumentaiV1beta2NormalizedVertex) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDocumentaiV1beta2NormalizedVertex
	var s1 struct {
		X gensupport.JSONFloat64 `json:"x"`
		Y gensupport.JSONFloat64 `json:"y"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.X = float64(s1.X)
	s.Y = float64(s1.Y)
	return nil
}

// GoogleCloudDocumentaiV1beta2OcrParams: Parameters to control Optical
// Character Recognition (OCR) behavior.
type GoogleCloudDocumentaiV1beta2OcrParams struct {
	// LanguageHints: List of languages to use for OCR. In most cases, an empty
	// value yields the best results since it enables automatic language detection.
	// For languages based on the Latin alphabet, setting `language_hints` is not
	// needed. In rare cases, when the language of the text in the image is known,
	// setting a hint will help get better results (although it will be a
	// significant hindrance if the hint is wrong). Document processing returns an
	// error if one or more of the specified languages is not one of the supported
	// languages.
	LanguageHints []string `json:"languageHints,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LanguageHints") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LanguageHints") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta2OcrParams) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2OcrParams
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta2OperationMetadata: Contains metadata for the
// BatchProcessDocuments operation.
type GoogleCloudDocumentaiV1beta2OperationMetadata struct {
	// CreateTime: The creation time of the operation.
	CreateTime string `json:"createTime,omitempty"`
	// State: The state of the current batch processing.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - The default value. This value is used if the state
	// is omitted.
	//   "ACCEPTED" - Request is received.
	//   "WAITING" - Request operation is waiting for scheduling.
	//   "RUNNING" - Request is being processed.
	//   "SUCCEEDED" - The batch processing completed successfully.
	//   "CANCELLED" - The batch processing was cancelled.
	//   "FAILED" - The batch processing has failed.
	State string `json:"state,omitempty"`
	// StateMessage: A message providing more details about the current state of
	// processing.
	StateMessage string `json:"stateMessage,omitempty"`
	// UpdateTime: The last update time of the operation.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta2OperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2OperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta2OutputConfig: The desired output location and
// metadata.
type GoogleCloudDocumentaiV1beta2OutputConfig struct {
	// GcsDestination: The Google Cloud Storage location to write the output to.
	GcsDestination *GoogleCloudDocumentaiV1beta2GcsDestination `json:"gcsDestination,omitempty"`
	// PagesPerShard: The max number of pages to include into each output Document
	// shard JSON on Google Cloud Storage. The valid range is [1, 100]. If not
	// specified, the default value is 20. For example, for one pdf file with 100
	// pages, 100 parsed pages will be produced. If `pages_per_shard` = 20, then 5
	// Document shard JSON files each containing 20 parsed pages will be written
	// under the prefix OutputConfig.gcs_destination.uri and suffix
	// pages-x-to-y.json where x and y are 1-indexed page numbers. Example GCS
	// outputs with 157 pages and pages_per_shard = 50: pages-001-to-050.json
	// pages-051-to-100.json pages-101-to-150.json pages-151-to-157.json
	PagesPerShard int64 `json:"pagesPerShard,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GcsDestination") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GcsDestination") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta2OutputConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2OutputConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta2ProcessDocumentRequest: Request to process one
// document.
type GoogleCloudDocumentaiV1beta2ProcessDocumentRequest struct {
	// AutomlParams: Controls AutoML model prediction behavior. AutoMlParams cannot
	// be used together with other Params.
	AutomlParams *GoogleCloudDocumentaiV1beta2AutoMlParams `json:"automlParams,omitempty"`
	// DocumentType: Specifies a known document type for deeper structure
	// detection. Valid values are currently "general" and "invoice". If not
	// provided, "general"\ is used as default. If any other value is given, the
	// request is rejected.
	DocumentType string `json:"documentType,omitempty"`
	// EntityExtractionParams: Controls entity extraction behavior. If not
	// specified, the system will decide reasonable defaults.
	EntityExtractionParams *GoogleCloudDocumentaiV1beta2EntityExtractionParams `json:"entityExtractionParams,omitempty"`
	// FormExtractionParams: Controls form extraction behavior. If not specified,
	// the system will decide reasonable defaults.
	FormExtractionParams *GoogleCloudDocumentaiV1beta2FormExtractionParams `json:"formExtractionParams,omitempty"`
	// InputConfig: Required. Information about the input file.
	InputConfig *GoogleCloudDocumentaiV1beta2InputConfig `json:"inputConfig,omitempty"`
	// OcrParams: Controls OCR behavior. If not specified, the system will decide
	// reasonable defaults.
	OcrParams *GoogleCloudDocumentaiV1beta2OcrParams `json:"ocrParams,omitempty"`
	// OutputConfig: The desired output location. This field is only needed in
	// BatchProcessDocumentsRequest.
	OutputConfig *GoogleCloudDocumentaiV1beta2OutputConfig `json:"outputConfig,omitempty"`
	// Parent: Target project and location to make a call. Format:
	// `projects/{project-id}/locations/{location-id}`. If no location is
	// specified, a region will be chosen automatically. This field is only
	// populated when used in ProcessDocument method.
	Parent string `json:"parent,omitempty"`
	// TableExtractionParams: Controls table extraction behavior. If not specified,
	// the system will decide reasonable defaults.
	TableExtractionParams *GoogleCloudDocumentaiV1beta2TableExtractionParams `json:"tableExtractionParams,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AutomlParams") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AutomlParams") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta2ProcessDocumentRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2ProcessDocumentRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta2ProcessDocumentResponse: Response to a single
// document processing request.
type GoogleCloudDocumentaiV1beta2ProcessDocumentResponse struct {
	// InputConfig: Information about the input file. This is the same as the
	// corresponding input config in the request.
	InputConfig *GoogleCloudDocumentaiV1beta2InputConfig `json:"inputConfig,omitempty"`
	// OutputConfig: The output location of the parsed responses. The responses are
	// written to this location as JSON-serialized `Document` objects.
	OutputConfig *GoogleCloudDocumentaiV1beta2OutputConfig `json:"outputConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "InputConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InputConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta2ProcessDocumentResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2ProcessDocumentResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta2TableBoundHint: A hint for a table bounding box
// on the page for table parsing.
type GoogleCloudDocumentaiV1beta2TableBoundHint struct {
	// BoundingBox: Bounding box hint for a table on this page. The coordinates
	// must be normalized to [0,1] and the bounding box must be an axis-aligned
	// rectangle.
	BoundingBox *GoogleCloudDocumentaiV1beta2BoundingPoly `json:"boundingBox,omitempty"`
	// PageNumber: Optional. Page number for multi-paged inputs this hint applies
	// to. If not provided, this hint will apply to all pages by default. This
	// value is 1-based.
	PageNumber int64 `json:"pageNumber,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BoundingBox") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BoundingBox") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta2TableBoundHint) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2TableBoundHint
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta2TableExtractionParams: Parameters to control
// table extraction behavior.
type GoogleCloudDocumentaiV1beta2TableExtractionParams struct {
	// Enabled: Whether to enable table extraction.
	Enabled bool `json:"enabled,omitempty"`
	// HeaderHints: Optional. Reserved for future use.
	HeaderHints []string `json:"headerHints,omitempty"`
	// ModelVersion: Model version of the table extraction system. Default is
	// "builtin/stable". Specify "builtin/latest" for the latest model.
	ModelVersion string `json:"modelVersion,omitempty"`
	// TableBoundHints: Optional. Table bounding box hints that can be provided to
	// complex cases which our algorithm cannot locate the table(s) in.
	TableBoundHints []*GoogleCloudDocumentaiV1beta2TableBoundHint `json:"tableBoundHints,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Enabled") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Enabled") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta2TableExtractionParams) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2TableExtractionParams
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta2Vertex: A vertex represents a 2D point in the
// image. NOTE: the vertex coordinates are in the same scale as the original
// image.
type GoogleCloudDocumentaiV1beta2Vertex struct {
	// X: X coordinate.
	X int64 `json:"x,omitempty"`
	// Y: Y coordinate (starts from the top of the image).
	Y int64 `json:"y,omitempty"`
	// ForceSendFields is a list of field names (e.g. "X") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "X") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta2Vertex) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2Vertex
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDocumentaiV1beta3BatchDeleteDocumentsMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiV1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`
	// ErrorDocumentCount: Total number of documents that failed to be deleted in
	// storage.
	ErrorDocumentCount int64 `json:"errorDocumentCount,omitempty"`
	// IndividualBatchDeleteStatuses: The list of response details of each
	// document.
	IndividualBatchDeleteStatuses []*GoogleCloudDocumentaiV1beta3BatchDeleteDocumentsMetadataIndividualBatchDeleteStatus `json:"individualBatchDeleteStatuses,omitempty"`
	// TotalDocumentCount: Total number of documents deleting from dataset.
	TotalDocumentCount int64 `json:"totalDocumentCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommonMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta3BatchDeleteDocumentsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3BatchDeleteDocumentsMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3BatchDeleteDocumentsMetadataIndividualBatchDelete
// Status: The status of each individual document in the batch delete process.
type GoogleCloudDocumentaiV1beta3BatchDeleteDocumentsMetadataIndividualBatchDeleteStatus struct {
	// DocumentId: The document id of the document.
	DocumentId *GoogleCloudDocumentaiV1beta3DocumentId `json:"documentId,omitempty"`
	// Status: The status of deleting the document in storage.
	Status *GoogleRpcStatus `json:"status,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DocumentId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DocumentId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta3BatchDeleteDocumentsMetadataIndividualBatchDeleteStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3BatchDeleteDocumentsMetadataIndividualBatchDeleteStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3BatchDeleteDocumentsResponse: Response of the
// delete documents operation.
type GoogleCloudDocumentaiV1beta3BatchDeleteDocumentsResponse struct {
}

// GoogleCloudDocumentaiV1beta3BatchProcessMetadata: The long-running operation
// metadata for BatchProcessDocuments.
type GoogleCloudDocumentaiV1beta3BatchProcessMetadata struct {
	// CreateTime: The creation time of the operation.
	CreateTime string `json:"createTime,omitempty"`
	// IndividualProcessStatuses: The list of response details of each document.
	IndividualProcessStatuses []*GoogleCloudDocumentaiV1beta3BatchProcessMetadataIndividualProcessStatus `json:"individualProcessStatuses,omitempty"`
	// State: The state of the current batch processing.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - The default value. This value is used if the state
	// is omitted.
	//   "WAITING" - Request operation is waiting for scheduling.
	//   "RUNNING" - Request is being processed.
	//   "SUCCEEDED" - The batch processing completed successfully.
	//   "CANCELLING" - The batch processing was being cancelled.
	//   "CANCELLED" - The batch processing was cancelled.
	//   "FAILED" - The batch processing has failed.
	State string `json:"state,omitempty"`
	// StateMessage: A message providing more details about the current state of
	// processing. For example, the error message if the operation is failed.
	StateMessage string `json:"stateMessage,omitempty"`
	// UpdateTime: The last update time of the operation.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta3BatchProcessMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3BatchProcessMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3BatchProcessMetadataIndividualProcessStatus: The
// status of a each individual document in the batch process.
type GoogleCloudDocumentaiV1beta3BatchProcessMetadataIndividualProcessStatus struct {
	// HumanReviewOperation: The name of the operation triggered by the processed
	// document. If the human review process isn't triggered, this field will be
	// empty. It has the same response type and metadata as the long-running
	// operation returned by the ReviewDocument method.
	HumanReviewOperation string `json:"humanReviewOperation,omitempty"`
	// HumanReviewStatus: The status of human review on the processed document.
	HumanReviewStatus *GoogleCloudDocumentaiV1beta3HumanReviewStatus `json:"humanReviewStatus,omitempty"`
	// InputGcsSource: The source of the document, same as the input_gcs_source
	// field in the request when the batch process started.
	InputGcsSource string `json:"inputGcsSource,omitempty"`
	// OutputGcsDestination: The Cloud Storage output destination (in the request
	// as DocumentOutputConfig.GcsOutputConfig.gcs_uri) of the processed document
	// if it was successful, otherwise empty.
	OutputGcsDestination string `json:"outputGcsDestination,omitempty"`
	// Status: The status processing the document.
	Status *GoogleRpcStatus `json:"status,omitempty"`
	// ForceSendFields is a list of field names (e.g. "HumanReviewOperation") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "HumanReviewOperation") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta3BatchProcessMetadataIndividualProcessStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3BatchProcessMetadataIndividualProcessStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3BatchProcessResponse: Response message for
// BatchProcessDocuments.
type GoogleCloudDocumentaiV1beta3BatchProcessResponse struct {
}

// GoogleCloudDocumentaiV1beta3CommonOperationMetadata: The common metadata for
// long running operations.
type GoogleCloudDocumentaiV1beta3CommonOperationMetadata struct {
	// CreateTime: The creation time of the operation.
	CreateTime string `json:"createTime,omitempty"`
	// Resource: A related resource to this operation.
	Resource string `json:"resource,omitempty"`
	// State: The state of the operation.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Unspecified state.
	//   "RUNNING" - Operation is still running.
	//   "CANCELLING" - Operation is being cancelled.
	//   "SUCCEEDED" - Operation succeeded.
	//   "FAILED" - Operation failed.
	//   "CANCELLED" - Operation is cancelled.
	State string `json:"state,omitempty"`
	// StateMessage: A message providing more details about the current state of
	// processing.
	StateMessage string `json:"stateMessage,omitempty"`
	// UpdateTime: The last update time of the operation.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta3CommonOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3CommonOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3Dataset: A singleton resource under a Processor
// which configures a collection of documents.
type GoogleCloudDocumentaiV1beta3Dataset struct {
	// DocumentWarehouseConfig: Optional. Deprecated. Warehouse-based dataset
	// configuration is not supported.
	DocumentWarehouseConfig *GoogleCloudDocumentaiV1beta3DatasetDocumentWarehouseConfig `json:"documentWarehouseConfig,omitempty"`
	// GcsManagedConfig: Optional. User-managed Cloud Storage dataset
	// configuration. Use this configuration if the dataset documents are stored
	// under a user-managed Cloud Storage location.
	GcsManagedConfig *GoogleCloudDocumentaiV1beta3DatasetGCSManagedConfig `json:"gcsManagedConfig,omitempty"`
	// Name: Dataset resource name. Format:
	// `projects/{project}/locations/{location}/processors/{processor}/dataset`
	Name string `json:"name,omitempty"`
	// SatisfiesPzi: Output only. Reserved for future use.
	SatisfiesPzi bool `json:"satisfiesPzi,omitempty"`
	// SatisfiesPzs: Output only. Reserved for future use.
	SatisfiesPzs bool `json:"satisfiesPzs,omitempty"`
	// SpannerIndexingConfig: Optional. A lightweight indexing source with low
	// latency and high reliability, but lacking advanced features like CMEK and
	// content-based search.
	SpannerIndexingConfig *GoogleCloudDocumentaiV1beta3DatasetSpannerIndexingConfig `json:"spannerIndexingConfig,omitempty"`
	// State: Required. State of the dataset. Ignored when updating dataset.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Default unspecified enum, should not be used.
	//   "UNINITIALIZED" - Dataset has not been initialized.
	//   "INITIALIZING" - Dataset is being initialized.
	//   "INITIALIZED" - Dataset has been initialized.
	State string `json:"state,omitempty"`
	// UnmanagedDatasetConfig: Optional. Unmanaged dataset configuration. Use this
	// configuration if the dataset documents are managed by the document service
	// internally (not user-managed).
	UnmanagedDatasetConfig *GoogleCloudDocumentaiV1beta3DatasetUnmanagedDatasetConfig `json:"unmanagedDatasetConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DocumentWarehouseConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DocumentWarehouseConfig") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta3Dataset) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3Dataset
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3DatasetDocumentWarehouseConfig: Configuration
// specific to the Document AI Warehouse-based implementation.
type GoogleCloudDocumentaiV1beta3DatasetDocumentWarehouseConfig struct {
	// Collection: Output only. The collection in Document AI Warehouse associated
	// with the dataset.
	Collection string `json:"collection,omitempty"`
	// Schema: Output only. The schema in Document AI Warehouse associated with the
	// dataset.
	Schema string `json:"schema,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Collection") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Collection") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta3DatasetDocumentWarehouseConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3DatasetDocumentWarehouseConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3DatasetGCSManagedConfig: Configuration specific
// to the Cloud Storage-based implementation.
type GoogleCloudDocumentaiV1beta3DatasetGCSManagedConfig struct {
	// GcsPrefix: Required. The Cloud Storage URI (a directory) where the documents
	// belonging to the dataset must be stored.
	GcsPrefix *GoogleCloudDocumentaiV1beta3GcsPrefix `json:"gcsPrefix,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GcsPrefix") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GcsPrefix") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta3DatasetGCSManagedConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3DatasetGCSManagedConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3DatasetSpannerIndexingConfig: Configuration
// specific to spanner-based indexing.
type GoogleCloudDocumentaiV1beta3DatasetSpannerIndexingConfig struct {
}

// GoogleCloudDocumentaiV1beta3DatasetUnmanagedDatasetConfig: Configuration
// specific to an unmanaged dataset.
type GoogleCloudDocumentaiV1beta3DatasetUnmanagedDatasetConfig struct {
}

// GoogleCloudDocumentaiV1beta3DeleteProcessorMetadata: The long-running
// operation metadata for the DeleteProcessor method.
type GoogleCloudDocumentaiV1beta3DeleteProcessorMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiV1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommonMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta3DeleteProcessorMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3DeleteProcessorMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3DeleteProcessorVersionMetadata: The long-running
// operation metadata for the DeleteProcessorVersion method.
type GoogleCloudDocumentaiV1beta3DeleteProcessorVersionMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiV1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommonMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta3DeleteProcessorVersionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3DeleteProcessorVersionMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3DeployProcessorVersionMetadata: The long-running
// operation metadata for the DeployProcessorVersion method.
type GoogleCloudDocumentaiV1beta3DeployProcessorVersionMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiV1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommonMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta3DeployProcessorVersionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3DeployProcessorVersionMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3DeployProcessorVersionResponse: Response message
// for the DeployProcessorVersion method.
type GoogleCloudDocumentaiV1beta3DeployProcessorVersionResponse struct {
}

// GoogleCloudDocumentaiV1beta3DisableProcessorMetadata: The long-running
// operation metadata for the DisableProcessor method.
type GoogleCloudDocumentaiV1beta3DisableProcessorMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiV1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommonMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta3DisableProcessorMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3DisableProcessorMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3DisableProcessorResponse: Response message for
// the DisableProcessor method. Intentionally empty proto for adding fields in
// future.
type GoogleCloudDocumentaiV1beta3DisableProcessorResponse struct {
}

// GoogleCloudDocumentaiV1beta3DocumentId: Document Identifier.
type GoogleCloudDocumentaiV1beta3DocumentId struct {
	// GcsManagedDocId: A document id within user-managed Cloud Storage.
	GcsManagedDocId *GoogleCloudDocumentaiV1beta3DocumentIdGCSManagedDocumentId `json:"gcsManagedDocId,omitempty"`
	// RevisionRef: Points to a specific revision of the document if set.
	RevisionRef *GoogleCloudDocumentaiV1beta3RevisionRef `json:"revisionRef,omitempty"`
	// UnmanagedDocId: A document id within unmanaged dataset.
	UnmanagedDocId *GoogleCloudDocumentaiV1beta3DocumentIdUnmanagedDocumentId `json:"unmanagedDocId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GcsManagedDocId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GcsManagedDocId") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta3DocumentId) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3DocumentId
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3DocumentIdGCSManagedDocumentId: Identifies a
// document uniquely within the scope of a dataset in the user-managed Cloud
// Storage option.
type GoogleCloudDocumentaiV1beta3DocumentIdGCSManagedDocumentId struct {
	// CwDocId: Id of the document (indexed) managed by Content Warehouse.
	CwDocId string `json:"cwDocId,omitempty"`
	// GcsUri: Required. The Cloud Storage URI where the actual document is stored.
	GcsUri string `json:"gcsUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CwDocId") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CwDocId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta3DocumentIdGCSManagedDocumentId) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3DocumentIdGCSManagedDocumentId
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3DocumentIdUnmanagedDocumentId: Identifies a
// document uniquely within the scope of a dataset in unmanaged option.
type GoogleCloudDocumentaiV1beta3DocumentIdUnmanagedDocumentId struct {
	// DocId: Required. The id of the document.
	DocId string `json:"docId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DocId") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DocId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta3DocumentIdUnmanagedDocumentId) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3DocumentIdUnmanagedDocumentId
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3EnableProcessorMetadata: The long-running
// operation metadata for the EnableProcessor method.
type GoogleCloudDocumentaiV1beta3EnableProcessorMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiV1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommonMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta3EnableProcessorMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3EnableProcessorMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3EnableProcessorResponse: Response message for
// the EnableProcessor method. Intentionally empty proto for adding fields in
// future.
type GoogleCloudDocumentaiV1beta3EnableProcessorResponse struct {
}

// GoogleCloudDocumentaiV1beta3EvaluateProcessorVersionMetadata: Metadata of
// the EvaluateProcessorVersion method.
type GoogleCloudDocumentaiV1beta3EvaluateProcessorVersionMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiV1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommonMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta3EvaluateProcessorVersionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3EvaluateProcessorVersionMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3EvaluateProcessorVersionResponse: Response of
// the EvaluateProcessorVersion method.
type GoogleCloudDocumentaiV1beta3EvaluateProcessorVersionResponse struct {
	// Evaluation: The resource name of the created evaluation.
	Evaluation string `json:"evaluation,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Evaluation") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Evaluation") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta3EvaluateProcessorVersionResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3EvaluateProcessorVersionResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3GcsPrefix: Specifies all documents on Cloud
// Storage with a common prefix.
type GoogleCloudDocumentaiV1beta3GcsPrefix struct {
	// GcsUriPrefix: The URI prefix.
	GcsUriPrefix string `json:"gcsUriPrefix,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GcsUriPrefix") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GcsUriPrefix") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta3GcsPrefix) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3GcsPrefix
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3HumanReviewStatus: The status of human review on
// a processed document.
type GoogleCloudDocumentaiV1beta3HumanReviewStatus struct {
	// HumanReviewOperation: The name of the operation triggered by the processed
	// document. This field is populated only when the state is
	// `HUMAN_REVIEW_IN_PROGRESS`. It has the same response type and metadata as
	// the long-running operation returned by ReviewDocument.
	HumanReviewOperation string `json:"humanReviewOperation,omitempty"`
	// State: The state of human review on the processing request.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Human review state is unspecified. Most likely due
	// to an internal error.
	//   "SKIPPED" - Human review is skipped for the document. This can happen
	// because human review isn't enabled on the processor or the processing
	// request has been set to skip this document.
	//   "VALIDATION_PASSED" - Human review validation is triggered and passed, so
	// no review is needed.
	//   "IN_PROGRESS" - Human review validation is triggered and the document is
	// under review.
	//   "ERROR" - Some error happened during triggering human review, see the
	// state_message for details.
	State string `json:"state,omitempty"`
	// StateMessage: A message providing more details about the human review state.
	StateMessage string `json:"stateMessage,omitempty"`
	// ForceSendFields is a list of field names (e.g. "HumanReviewOperation") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "HumanReviewOperation") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta3HumanReviewStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3HumanReviewStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3ImportDocumentsMetadata: Metadata of the import
// document operation.
type GoogleCloudDocumentaiV1beta3ImportDocumentsMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiV1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`
	// ImportConfigValidationResults: Validation statuses of the batch documents
	// import config.
	ImportConfigValidationResults []*GoogleCloudDocumentaiV1beta3ImportDocumentsMetadataImportConfigValidationResult `json:"importConfigValidationResults,omitempty"`
	// IndividualImportStatuses: The list of response details of each document.
	IndividualImportStatuses []*GoogleCloudDocumentaiV1beta3ImportDocumentsMetadataIndividualImportStatus `json:"individualImportStatuses,omitempty"`
	// TotalDocumentCount: Total number of the documents that are qualified for
	// importing.
	TotalDocumentCount int64 `json:"totalDocumentCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommonMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta3ImportDocumentsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3ImportDocumentsMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3ImportDocumentsMetadataImportConfigValidationResu
// lt: The validation status of each import config. Status is set to an error
// if there are no documents to import in the `import_config`, or `OK` if the
// operation will try to proceed with at least one document.
type GoogleCloudDocumentaiV1beta3ImportDocumentsMetadataImportConfigValidationResult struct {
	// InputGcsSource: The source Cloud Storage URI specified in the import config.
	InputGcsSource string `json:"inputGcsSource,omitempty"`
	// Status: The validation status of import config.
	Status *GoogleRpcStatus `json:"status,omitempty"`
	// ForceSendFields is a list of field names (e.g. "InputGcsSource") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InputGcsSource") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta3ImportDocumentsMetadataImportConfigValidationResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3ImportDocumentsMetadataImportConfigValidationResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3ImportDocumentsMetadataIndividualImportStatus:
// The status of each individual document in the import process.
type GoogleCloudDocumentaiV1beta3ImportDocumentsMetadataIndividualImportStatus struct {
	// InputGcsSource: The source Cloud Storage URI of the document.
	InputGcsSource string `json:"inputGcsSource,omitempty"`
	// OutputDocumentId: The document id of imported document if it was successful,
	// otherwise empty.
	OutputDocumentId *GoogleCloudDocumentaiV1beta3DocumentId `json:"outputDocumentId,omitempty"`
	// Status: The status of the importing of the document.
	Status *GoogleRpcStatus `json:"status,omitempty"`
	// ForceSendFields is a list of field names (e.g. "InputGcsSource") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InputGcsSource") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta3ImportDocumentsMetadataIndividualImportStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3ImportDocumentsMetadataIndividualImportStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3ImportDocumentsResponse: Response of the import
// document operation.
type GoogleCloudDocumentaiV1beta3ImportDocumentsResponse struct {
}

// GoogleCloudDocumentaiV1beta3ImportProcessorVersionMetadata: The long-running
// operation metadata for the ImportProcessorVersion method.
type GoogleCloudDocumentaiV1beta3ImportProcessorVersionMetadata struct {
	// CommonMetadata: The basic metadata for the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiV1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommonMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta3ImportProcessorVersionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3ImportProcessorVersionMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3ImportProcessorVersionResponse: The response
// message for the ImportProcessorVersion method.
type GoogleCloudDocumentaiV1beta3ImportProcessorVersionResponse struct {
	// ProcessorVersion: The destination processor version name.
	ProcessorVersion string `json:"processorVersion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ProcessorVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ProcessorVersion") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta3ImportProcessorVersionResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3ImportProcessorVersionResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3ReviewDocumentOperationMetadata: The
// long-running operation metadata for the ReviewDocument method.
type GoogleCloudDocumentaiV1beta3ReviewDocumentOperationMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiV1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`
	// CreateTime: The creation time of the operation.
	CreateTime string `json:"createTime,omitempty"`
	// QuestionId: The Crowd Compute question ID.
	QuestionId string `json:"questionId,omitempty"`
	// State: Used only when Operation.done is false.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Unspecified state.
	//   "RUNNING" - Operation is still running.
	//   "CANCELLING" - Operation is being cancelled.
	//   "SUCCEEDED" - Operation succeeded.
	//   "FAILED" - Operation failed.
	//   "CANCELLED" - Operation is cancelled.
	State string `json:"state,omitempty"`
	// StateMessage: A message providing more details about the current state of
	// processing. For example, the error message if the operation is failed.
	StateMessage string `json:"stateMessage,omitempty"`
	// UpdateTime: The last update time of the operation.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommonMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta3ReviewDocumentOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3ReviewDocumentOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3ReviewDocumentResponse: Response message for the
// ReviewDocument method.
type GoogleCloudDocumentaiV1beta3ReviewDocumentResponse struct {
	// GcsDestination: The Cloud Storage uri for the human reviewed document if the
	// review is succeeded.
	GcsDestination string `json:"gcsDestination,omitempty"`
	// RejectionReason: The reason why the review is rejected by reviewer.
	RejectionReason string `json:"rejectionReason,omitempty"`
	// State: The state of the review operation.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - The default value. This value is used if the state
	// is omitted.
	//   "REJECTED" - The review operation is rejected by the reviewer.
	//   "SUCCEEDED" - The review operation is succeeded.
	State string `json:"state,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GcsDestination") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GcsDestination") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta3ReviewDocumentResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3ReviewDocumentResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3RevisionRef: The revision reference specifies
// which revision on the document to read.
type GoogleCloudDocumentaiV1beta3RevisionRef struct {
	// LatestProcessorVersion: Reads the revision generated by the processor
	// version. The format takes the full resource name of processor version.
	// `projects/{project}/locations/{location}/processors/{processor}/processorVers
	// ions/{processorVersion}`
	LatestProcessorVersion string `json:"latestProcessorVersion,omitempty"`
	// RevisionCase: Reads the revision by the predefined case.
	//
	// Possible values:
	//   "REVISION_CASE_UNSPECIFIED" - Unspecified case, fall back to read the
	// `LATEST_HUMAN_REVIEW`.
	//   "LATEST_HUMAN_REVIEW" - The latest revision made by a human.
	//   "LATEST_TIMESTAMP" - The latest revision based on timestamp.
	//   "BASE_OCR_REVISION" - The first (OCR) revision.
	RevisionCase string `json:"revisionCase,omitempty"`
	// RevisionId: Reads the revision given by the id.
	RevisionId string `json:"revisionId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LatestProcessorVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LatestProcessorVersion") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta3RevisionRef) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3RevisionRef
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3SetDefaultProcessorVersionMetadata: The
// long-running operation metadata for the SetDefaultProcessorVersion method.
type GoogleCloudDocumentaiV1beta3SetDefaultProcessorVersionMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiV1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommonMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta3SetDefaultProcessorVersionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3SetDefaultProcessorVersionMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3SetDefaultProcessorVersionResponse: Response
// message for the SetDefaultProcessorVersion method.
type GoogleCloudDocumentaiV1beta3SetDefaultProcessorVersionResponse struct {
}

// GoogleCloudDocumentaiV1beta3TrainProcessorVersionMetadata: The metadata that
// represents a processor version being created.
type GoogleCloudDocumentaiV1beta3TrainProcessorVersionMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiV1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`
	// TestDatasetValidation: The test dataset validation information.
	TestDatasetValidation *GoogleCloudDocumentaiV1beta3TrainProcessorVersionMetadataDatasetValidation `json:"testDatasetValidation,omitempty"`
	// TrainingDatasetValidation: The training dataset validation information.
	TrainingDatasetValidation *GoogleCloudDocumentaiV1beta3TrainProcessorVersionMetadataDatasetValidation `json:"trainingDatasetValidation,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommonMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta3TrainProcessorVersionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3TrainProcessorVersionMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3TrainProcessorVersionMetadataDatasetValidation:
// The dataset validation information. This includes any and all errors with
// documents and the dataset.
type GoogleCloudDocumentaiV1beta3TrainProcessorVersionMetadataDatasetValidation struct {
	// DatasetErrorCount: The total number of dataset errors.
	DatasetErrorCount int64 `json:"datasetErrorCount,omitempty"`
	// DatasetErrors: Error information for the dataset as a whole. A maximum of 10
	// dataset errors will be returned. A single dataset error is terminal for
	// training.
	DatasetErrors []*GoogleRpcStatus `json:"datasetErrors,omitempty"`
	// DocumentErrorCount: The total number of document errors.
	DocumentErrorCount int64 `json:"documentErrorCount,omitempty"`
	// DocumentErrors: Error information pertaining to specific documents. A
	// maximum of 10 document errors will be returned. Any document with errors
	// will not be used throughout training.
	DocumentErrors []*GoogleRpcStatus `json:"documentErrors,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DatasetErrorCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DatasetErrorCount") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta3TrainProcessorVersionMetadataDatasetValidation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3TrainProcessorVersionMetadataDatasetValidation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3TrainProcessorVersionResponse: The response for
// TrainProcessorVersion.
type GoogleCloudDocumentaiV1beta3TrainProcessorVersionResponse struct {
	// ProcessorVersion: The resource name of the processor version produced by
	// training.
	ProcessorVersion string `json:"processorVersion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ProcessorVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ProcessorVersion") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta3TrainProcessorVersionResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3TrainProcessorVersionResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3UndeployProcessorVersionMetadata: The
// long-running operation metadata for the UndeployProcessorVersion method.
type GoogleCloudDocumentaiV1beta3UndeployProcessorVersionMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiV1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommonMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta3UndeployProcessorVersionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3UndeployProcessorVersionMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3UndeployProcessorVersionResponse: Response
// message for the UndeployProcessorVersion method.
type GoogleCloudDocumentaiV1beta3UndeployProcessorVersionResponse struct {
}

type GoogleCloudDocumentaiV1beta3UpdateDatasetOperationMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiV1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommonMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1beta3UpdateDatasetOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3UpdateDatasetOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleLongrunningOperation: This resource represents a long-running
// operation that is the result of a network API call.
type GoogleLongrunningOperation struct {
	// Done: If the value is `false`, it means the operation is still in progress.
	// If `true`, the operation is completed, and either `error` or `response` is
	// available.
	Done bool `json:"done,omitempty"`
	// Error: The error result of the operation in case of failure or cancellation.
	Error *GoogleRpcStatus `json:"error,omitempty"`
	// Metadata: Service-specific metadata associated with the operation. It
	// typically contains progress information and common metadata such as create
	// time. Some services might not provide such metadata. Any method that returns
	// a long-running operation should document the metadata type, if any.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`
	// Name: The server-assigned name, which is only unique within the same service
	// that originally returns it. If you use the default HTTP mapping, the `name`
	// should be a resource name ending with `operations/{unique_id}`.
	Name string `json:"name,omitempty"`
	// Response: The normal, successful response of the operation. If the original
	// method returns no data on success, such as `Delete`, the response is
	// `google.protobuf.Empty`. If the original method is standard
	// `Get`/`Create`/`Update`, the response should be the resource. For other
	// methods, the response should have the type `XxxResponse`, where `Xxx` is the
	// original method name. For example, if the original method name is
	// `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
	Response googleapi.RawMessage `json:"response,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Done") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Done") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleLongrunningOperation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleLongrunningOperation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleProtobufEmpty: A generic empty message that you can re-use to avoid
// defining duplicated empty messages in your APIs. A typical example is to use
// it as the request or the response type of an API method. For instance:
// service Foo { rpc Bar(google.protobuf.Empty) returns
// (google.protobuf.Empty); }
type GoogleProtobufEmpty struct {
}

// GoogleRpcStatus: The `Status` type defines a logical error model that is
// suitable for different programming environments, including REST APIs and RPC
// APIs. It is used by gRPC (https://github.com/grpc). Each `Status` message
// contains three pieces of data: error code, error message, and error details.
// You can find out more about this error model and how to work with it in the
// API Design Guide (https://cloud.google.com/apis/design/errors).
type GoogleRpcStatus struct {
	// Code: The status code, which should be an enum value of google.rpc.Code.
	Code int64 `json:"code,omitempty"`
	// Details: A list of messages that carry the error details. There is a common
	// set of message types for APIs to use.
	Details []googleapi.RawMessage `json:"details,omitempty"`
	// Message: A developer-facing error message, which should be in English. Any
	// user-facing error message should be localized and sent in the
	// google.rpc.Status.details field, or localized by the client.
	Message string `json:"message,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Code") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Code") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleRpcStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleRpcStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleTypeColor: Represents a color in the RGBA color space. This
// representation is designed for simplicity of conversion to and from color
// representations in various languages over compactness. For example, the
// fields of this representation can be trivially provided to the constructor
// of `java.awt.Color` in Java; it can also be trivially provided to UIColor's
// `+colorWithRed:green:blue:alpha` method in iOS; and, with just a little
// work, it can be easily formatted into a CSS `rgba()` string in JavaScript.
// This reference page doesn't have information about the absolute color space
// that should be used to interpret the RGB value—for example, sRGB, Adobe
// RGB, DCI-P3, and BT.2020. By default, applications should assume the sRGB
// color space. When color equality needs to be decided, implementations,
// unless documented otherwise, treat two colors as equal if all their red,
// green, blue, and alpha values each differ by at most `1e-5`. Example (Java):
// import com.google.type.Color; // ... public static java.awt.Color
// fromProto(Color protocolor) { float alpha = protocolor.hasAlpha() ?
// protocolor.getAlpha().getValue() : 1.0; return new java.awt.Color(
// protocolor.getRed(), protocolor.getGreen(), protocolor.getBlue(), alpha); }
// public static Color toProto(java.awt.Color color) { float red = (float)
// color.getRed(); float green = (float) color.getGreen(); float blue = (float)
// color.getBlue(); float denominator = 255.0; Color.Builder resultBuilder =
// Color .newBuilder() .setRed(red / denominator) .setGreen(green /
// denominator) .setBlue(blue / denominator); int alpha = color.getAlpha(); if
// (alpha != 255) { result.setAlpha( FloatValue .newBuilder()
// .setValue(((float) alpha) / denominator) .build()); } return
// resultBuilder.build(); } // ... Example (iOS / Obj-C): // ... static
// UIColor* fromProto(Color* protocolor) { float red = [protocolor red]; float
// green = [protocolor green]; float blue = [protocolor blue]; FloatValue*
// alpha_wrapper = [protocolor alpha]; float alpha = 1.0; if (alpha_wrapper !=
// nil) { alpha = [alpha_wrapper value]; } return [UIColor colorWithRed:red
// green:green blue:blue alpha:alpha]; } static Color* toProto(UIColor* color)
// { CGFloat red, green, blue, alpha; if (![color getRed:&red green:&green
// blue:&blue alpha:&alpha]) { return nil; } Color* result = [[Color alloc]
// init]; [result setRed:red]; [result setGreen:green]; [result setBlue:blue];
// if (alpha <= 0.9999) { [result setAlpha:floatWrapperWithValue(alpha)]; }
// [result autorelease]; return result; } // ... Example (JavaScript): // ...
// var protoToCssColor = function(rgb_color) { var redFrac = rgb_color.red ||
// 0.0; var greenFrac = rgb_color.green || 0.0; var blueFrac = rgb_color.blue
// || 0.0; var red = Math.floor(redFrac * 255); var green =
// Math.floor(greenFrac * 255); var blue = Math.floor(blueFrac * 255); if
// (!('alpha' in rgb_color)) { return rgbToCssColor(red, green, blue); } var
// alphaFrac = rgb_color.alpha.value || 0.0; var rgbParams = [red, green,
// blue].join(','); return ['rgba(', rgbParams, ',', alphaFrac, ')'].join(”);
// }; var rgbToCssColor = function(red, green, blue) { var rgbNumber = new
// Number((red << 16) | (green << 8) | blue); var hexString =
// rgbNumber.toString(16); var missingZeros = 6 - hexString.length; var
// resultBuilder = ['#']; for (var i = 0; i < missingZeros; i++) {
// resultBuilder.push('0'); } resultBuilder.push(hexString); return
// resultBuilder.join(”); }; // ...
type GoogleTypeColor struct {
	// Alpha: The fraction of this color that should be applied to the pixel. That
	// is, the final pixel color is defined by the equation: `pixel color = alpha *
	// (this color) + (1.0 - alpha) * (background color)` This means that a value
	// of 1.0 corresponds to a solid color, whereas a value of 0.0 corresponds to a
	// completely transparent color. This uses a wrapper message rather than a
	// simple float scalar so that it is possible to distinguish between a default
	// value and the value being unset. If omitted, this color object is rendered
	// as a solid color (as if the alpha value had been explicitly given a value of
	// 1.0).
	Alpha float64 `json:"alpha,omitempty"`
	// Blue: The amount of blue in the color as a value in the interval [0, 1].
	Blue float64 `json:"blue,omitempty"`
	// Green: The amount of green in the color as a value in the interval [0, 1].
	Green float64 `json:"green,omitempty"`
	// Red: The amount of red in the color as a value in the interval [0, 1].
	Red float64 `json:"red,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Alpha") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Alpha") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleTypeColor) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleTypeColor
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleTypeColor) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleTypeColor
	var s1 struct {
		Alpha gensupport.JSONFloat64 `json:"alpha"`
		Blue  gensupport.JSONFloat64 `json:"blue"`
		Green gensupport.JSONFloat64 `json:"green"`
		Red   gensupport.JSONFloat64 `json:"red"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Alpha = float64(s1.Alpha)
	s.Blue = float64(s1.Blue)
	s.Green = float64(s1.Green)
	s.Red = float64(s1.Red)
	return nil
}

// GoogleTypeDate: Represents a whole or partial calendar date, such as a
// birthday. The time of day and time zone are either specified elsewhere or
// are insignificant. The date is relative to the Gregorian Calendar. This can
// represent one of the following: * A full date, with non-zero year, month,
// and day values. * A month and day, with a zero year (for example, an
// anniversary). * A year on its own, with a zero month and a zero day. * A
// year and month, with a zero day (for example, a credit card expiration
// date). Related types: * google.type.TimeOfDay * google.type.DateTime *
// google.protobuf.Timestamp
type GoogleTypeDate struct {
	// Day: Day of a month. Must be from 1 to 31 and valid for the year and month,
	// or 0 to specify a year by itself or a year and month where the day isn't
	// significant.
	Day int64 `json:"day,omitempty"`
	// Month: Month of a year. Must be from 1 to 12, or 0 to specify a year without
	// a month and day.
	Month int64 `json:"month,omitempty"`
	// Year: Year of the date. Must be from 1 to 9999, or 0 to specify a date
	// without a year.
	Year int64 `json:"year,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Day") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Day") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleTypeDate) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleTypeDate
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleTypeDateTime: Represents civil time (or occasionally physical time).
// This type can represent a civil time in one of a few possible ways: * When
// utc_offset is set and time_zone is unset: a civil time on a calendar day
// with a particular offset from UTC. * When time_zone is set and utc_offset is
// unset: a civil time on a calendar day in a particular time zone. * When
// neither time_zone nor utc_offset is set: a civil time on a calendar day in
// local time. The date is relative to the Proleptic Gregorian Calendar. If
// year, month, or day are 0, the DateTime is considered not to have a specific
// year, month, or day respectively. This type may also be used to represent a
// physical time if all the date and time fields are set and either case of the
// `time_offset` oneof is set. Consider using `Timestamp` message for physical
// time instead. If your use case also would like to store the user's timezone,
// that can be done in another field. This type is more flexible than some
// applications may want. Make sure to document and validate your application's
// limitations.
type GoogleTypeDateTime struct {
	// Day: Optional. Day of month. Must be from 1 to 31 and valid for the year and
	// month, or 0 if specifying a datetime without a day.
	Day int64 `json:"day,omitempty"`
	// Hours: Optional. Hours of day in 24 hour format. Should be from 0 to 23,
	// defaults to 0 (midnight). An API may choose to allow the value "24:00:00"
	// for scenarios like business closing time.
	Hours int64 `json:"hours,omitempty"`
	// Minutes: Optional. Minutes of hour of day. Must be from 0 to 59, defaults to
	// 0.
	Minutes int64 `json:"minutes,omitempty"`
	// Month: Optional. Month of year. Must be from 1 to 12, or 0 if specifying a
	// datetime without a month.
	Month int64 `json:"month,omitempty"`
	// Nanos: Optional. Fractions of seconds in nanoseconds. Must be from 0 to
	// 999,999,999, defaults to 0.
	Nanos int64 `json:"nanos,omitempty"`
	// Seconds: Optional. Seconds of minutes of the time. Must normally be from 0
	// to 59, defaults to 0. An API may allow the value 60 if it allows
	// leap-seconds.
	Seconds int64 `json:"seconds,omitempty"`
	// TimeZone: Time zone.
	TimeZone *GoogleTypeTimeZone `json:"timeZone,omitempty"`
	// UtcOffset: UTC offset. Must be whole seconds, between -18 hours and +18
	// hours. For example, a UTC offset of -4:00 would be represented as { seconds:
	// -14400 }.
	UtcOffset string `json:"utcOffset,omitempty"`
	// Year: Optional. Year of date. Must be from 1 to 9999, or 0 if specifying a
	// datetime without a year.
	Year int64 `json:"year,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Day") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Day") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleTypeDateTime) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleTypeDateTime
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleTypeMoney: Represents an amount of money with its currency type.
type GoogleTypeMoney struct {
	// CurrencyCode: The three-letter currency code defined in ISO 4217.
	CurrencyCode string `json:"currencyCode,omitempty"`
	// Nanos: Number of nano (10^-9) units of the amount. The value must be between
	// -999,999,999 and +999,999,999 inclusive. If `units` is positive, `nanos`
	// must be positive or zero. If `units` is zero, `nanos` can be positive, zero,
	// or negative. If `units` is negative, `nanos` must be negative or zero. For
	// example $-1.75 is represented as `units`=-1 and `nanos`=-750,000,000.
	Nanos int64 `json:"nanos,omitempty"`
	// Units: The whole units of the amount. For example if `currencyCode` is
	// "USD", then 1 unit is one US dollar.
	Units int64 `json:"units,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "CurrencyCode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CurrencyCode") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleTypeMoney) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleTypeMoney
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleTypePostalAddress: Represents a postal address, e.g. for postal
// delivery or payments addresses. Given a postal address, a postal service can
// deliver items to a premise, P.O. Box or similar. It is not intended to model
// geographical locations (roads, towns, mountains). In typical usage an
// address would be created via user input or from importing existing data,
// depending on the type of process. Advice on address input / editing: - Use
// an internationalization-ready address widget such as
// https://github.com/google/libaddressinput) - Users should not be presented
// with UI elements for input or editing of fields outside countries where that
// field is used. For more guidance on how to use this schema, please see:
// https://support.google.com/business/answer/6397478
type GoogleTypePostalAddress struct {
	// AddressLines: Unstructured address lines describing the lower levels of an
	// address. Because values in address_lines do not have type information and
	// may sometimes contain multiple values in a single field (e.g. "Austin, TX"),
	// it is important that the line order is clear. The order of address lines
	// should be "envelope order" for the country/region of the address. In places
	// where this can vary (e.g. Japan), address_language is used to make it
	// explicit (e.g. "ja" for large-to-small ordering and "ja-Latn" or "en" for
	// small-to-large). This way, the most specific line of an address can be
	// selected based on the language. The minimum permitted structural
	// representation of an address consists of a region_code with all remaining
	// information placed in the address_lines. It would be possible to format such
	// an address very approximately without geocoding, but no semantic reasoning
	// could be made about any of the address components until it was at least
	// partially resolved. Creating an address only containing a region_code and
	// address_lines, and then geocoding is the recommended way to handle
	// completely unstructured addresses (as opposed to guessing which parts of the
	// address should be localities or administrative areas).
	AddressLines []string `json:"addressLines,omitempty"`
	// AdministrativeArea: Optional. Highest administrative subdivision which is
	// used for postal addresses of a country or region. For example, this can be a
	// state, a province, an oblast, or a prefecture. Specifically, for Spain this
	// is the province and not the autonomous community (e.g. "Barcelona" and not
	// "Catalonia"). Many countries don't use an administrative area in postal
	// addresses. E.g. in Switzerland this should be left unpopulated.
	AdministrativeArea string `json:"administrativeArea,omitempty"`
	// LanguageCode: Optional. BCP-47 language code of the contents of this address
	// (if known). This is often the UI language of the input form or is expected
	// to match one of the languages used in the address' country/region, or their
	// transliterated equivalents. This can affect formatting in certain countries,
	// but is not critical to the correctness of the data and will never affect any
	// validation or other non-formatting related operations. If this value is not
	// known, it should be omitted (rather than specifying a possibly incorrect
	// default). Examples: "zh-Hant", "ja", "ja-Latn", "en".
	LanguageCode string `json:"languageCode,omitempty"`
	// Locality: Optional. Generally refers to the city/town portion of the
	// address. Examples: US city, IT comune, UK post town. In regions of the world
	// where localities are not well defined or do not fit into this structure
	// well, leave locality empty and use address_lines.
	Locality string `json:"locality,omitempty"`
	// Organization: Optional. The name of the organization at the address.
	Organization string `json:"organization,omitempty"`
	// PostalCode: Optional. Postal code of the address. Not all countries use or
	// require postal codes to be present, but where they are used, they may
	// trigger additional validation with other parts of the address (e.g.
	// state/zip validation in the U.S.A.).
	PostalCode string `json:"postalCode,omitempty"`
	// Recipients: Optional. The recipient at the address. This field may, under
	// certain circumstances, contain multiline information. For example, it might
	// contain "care of" information.
	Recipients []string `json:"recipients,omitempty"`
	// RegionCode: Required. CLDR region code of the country/region of the address.
	// This is never inferred and it is up to the user to ensure the value is
	// correct. See https://cldr.unicode.org/ and
	// https://www.unicode.org/cldr/charts/30/supplemental/territory_information.html
	// for details. Example: "CH" for Switzerland.
	RegionCode string `json:"regionCode,omitempty"`
	// Revision: The schema revision of the `PostalAddress`. This must be set to 0,
	// which is the latest revision. All new revisions **must** be backward
	// compatible with old revisions.
	Revision int64 `json:"revision,omitempty"`
	// SortingCode: Optional. Additional, country-specific, sorting code. This is
	// not used in most regions. Where it is used, the value is either a string
	// like "CEDEX", optionally followed by a number (e.g. "CEDEX 7"), or just a
	// number alone, representing the "sector code" (Jamaica), "delivery area
	// indicator" (Malawi) or "post office indicator" (e.g. Côte d'Ivoire).
	SortingCode string `json:"sortingCode,omitempty"`
	// Sublocality: Optional. Sublocality of the address. For example, this can be
	// neighborhoods, boroughs, districts.
	Sublocality string `json:"sublocality,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AddressLines") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AddressLines") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleTypePostalAddress) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleTypePostalAddress
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleTypeTimeZone: Represents a time zone from the IANA Time Zone Database
// (https://www.iana.org/time-zones).
type GoogleTypeTimeZone struct {
	// Id: IANA Time Zone Database time zone, e.g. "America/New_York".
	Id string `json:"id,omitempty"`
	// Version: Optional. IANA Time Zone Database version number, e.g. "2019a".
	Version string `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Id") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Id") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleTypeTimeZone) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleTypeTimeZone
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ProjectsDocumentsBatchProcessCall struct {
	s                                                        *Service
	parent                                                   string
	googleclouddocumentaiv1beta2batchprocessdocumentsrequest *GoogleCloudDocumentaiV1beta2BatchProcessDocumentsRequest
	urlParams_                                               gensupport.URLParams
	ctx_                                                     context.Context
	header_                                                  http.Header
}

// BatchProcess: LRO endpoint to batch process many documents. The output is
// written to Cloud Storage as JSON in the [Document] format.
//
//   - parent: Target project and location to make a call. Format:
//     `projects/{project-id}/locations/{location-id}`. If no location is
//     specified, a region will be chosen automatically.
func (r *ProjectsDocumentsService) BatchProcess(parent string, googleclouddocumentaiv1beta2batchprocessdocumentsrequest *GoogleCloudDocumentaiV1beta2BatchProcessDocumentsRequest) *ProjectsDocumentsBatchProcessCall {
	c := &ProjectsDocumentsBatchProcessCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleclouddocumentaiv1beta2batchprocessdocumentsrequest = googleclouddocumentaiv1beta2batchprocessdocumentsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsDocumentsBatchProcessCall) Fields(s ...googleapi.Field) *ProjectsDocumentsBatchProcessCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsDocumentsBatchProcessCall) Context(ctx context.Context) *ProjectsDocumentsBatchProcessCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsDocumentsBatchProcessCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsDocumentsBatchProcessCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleclouddocumentaiv1beta2batchprocessdocumentsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta2/{+parent}/documents:batchProcess")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "documentai.projects.documents.batchProcess", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "documentai.projects.documents.batchProcess" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsDocumentsBatchProcessCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "documentai.projects.documents.batchProcess", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsDocumentsProcessCall struct {
	s                                                  *Service
	parent                                             string
	googleclouddocumentaiv1beta2processdocumentrequest *GoogleCloudDocumentaiV1beta2ProcessDocumentRequest
	urlParams_                                         gensupport.URLParams
	ctx_                                               context.Context
	header_                                            http.Header
}

// Process: Processes a single document.
//
//   - parent: Target project and location to make a call. Format:
//     `projects/{project-id}/locations/{location-id}`. If no location is
//     specified, a region will be chosen automatically. This field is only
//     populated when used in ProcessDocument method.
func (r *ProjectsDocumentsService) Process(parent string, googleclouddocumentaiv1beta2processdocumentrequest *GoogleCloudDocumentaiV1beta2ProcessDocumentRequest) *ProjectsDocumentsProcessCall {
	c := &ProjectsDocumentsProcessCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleclouddocumentaiv1beta2processdocumentrequest = googleclouddocumentaiv1beta2processdocumentrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsDocumentsProcessCall) Fields(s ...googleapi.Field) *ProjectsDocumentsProcessCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsDocumentsProcessCall) Context(ctx context.Context) *ProjectsDocumentsProcessCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsDocumentsProcessCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsDocumentsProcessCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleclouddocumentaiv1beta2processdocumentrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta2/{+parent}/documents:process")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "documentai.projects.documents.process", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "documentai.projects.documents.process" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudDocumentaiV1beta2Document.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsDocumentsProcessCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDocumentaiV1beta2Document, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDocumentaiV1beta2Document{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "documentai.projects.documents.process", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDocumentsBatchProcessCall struct {
	s                                                        *Service
	parent                                                   string
	googleclouddocumentaiv1beta2batchprocessdocumentsrequest *GoogleCloudDocumentaiV1beta2BatchProcessDocumentsRequest
	urlParams_                                               gensupport.URLParams
	ctx_                                                     context.Context
	header_                                                  http.Header
}

// BatchProcess: LRO endpoint to batch process many documents. The output is
// written to Cloud Storage as JSON in the [Document] format.
//
//   - parent: Target project and location to make a call. Format:
//     `projects/{project-id}/locations/{location-id}`. If no location is
//     specified, a region will be chosen automatically.
func (r *ProjectsLocationsDocumentsService) BatchProcess(parent string, googleclouddocumentaiv1beta2batchprocessdocumentsrequest *GoogleCloudDocumentaiV1beta2BatchProcessDocumentsRequest) *ProjectsLocationsDocumentsBatchProcessCall {
	c := &ProjectsLocationsDocumentsBatchProcessCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleclouddocumentaiv1beta2batchprocessdocumentsrequest = googleclouddocumentaiv1beta2batchprocessdocumentsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDocumentsBatchProcessCall) Fields(s ...googleapi.Field) *ProjectsLocationsDocumentsBatchProcessCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDocumentsBatchProcessCall) Context(ctx context.Context) *ProjectsLocationsDocumentsBatchProcessCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDocumentsBatchProcessCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDocumentsBatchProcessCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleclouddocumentaiv1beta2batchprocessdocumentsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta2/{+parent}/documents:batchProcess")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "documentai.projects.locations.documents.batchProcess", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "documentai.projects.locations.documents.batchProcess" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsDocumentsBatchProcessCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "documentai.projects.locations.documents.batchProcess", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDocumentsProcessCall struct {
	s                                                  *Service
	parent                                             string
	googleclouddocumentaiv1beta2processdocumentrequest *GoogleCloudDocumentaiV1beta2ProcessDocumentRequest
	urlParams_                                         gensupport.URLParams
	ctx_                                               context.Context
	header_                                            http.Header
}

// Process: Processes a single document.
//
//   - parent: Target project and location to make a call. Format:
//     `projects/{project-id}/locations/{location-id}`. If no location is
//     specified, a region will be chosen automatically. This field is only
//     populated when used in ProcessDocument method.
func (r *ProjectsLocationsDocumentsService) Process(parent string, googleclouddocumentaiv1beta2processdocumentrequest *GoogleCloudDocumentaiV1beta2ProcessDocumentRequest) *ProjectsLocationsDocumentsProcessCall {
	c := &ProjectsLocationsDocumentsProcessCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleclouddocumentaiv1beta2processdocumentrequest = googleclouddocumentaiv1beta2processdocumentrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDocumentsProcessCall) Fields(s ...googleapi.Field) *ProjectsLocationsDocumentsProcessCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDocumentsProcessCall) Context(ctx context.Context) *ProjectsLocationsDocumentsProcessCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDocumentsProcessCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDocumentsProcessCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleclouddocumentaiv1beta2processdocumentrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta2/{+parent}/documents:process")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "documentai.projects.locations.documents.process", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "documentai.projects.locations.documents.process" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudDocumentaiV1beta2Document.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsDocumentsProcessCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDocumentaiV1beta2Document, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDocumentaiV1beta2Document{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "documentai.projects.locations.documents.process", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsOperationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the latest state of a long-running operation. Clients can use this
// method to poll the operation result at intervals as recommended by the API
// service.
//
// - name: The name of the operation resource.
func (r *ProjectsLocationsOperationsService) Get(name string) *ProjectsLocationsOperationsGetCall {
	c := &ProjectsLocationsOperationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsOperationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsOperationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsOperationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsOperationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsOperationsGetCall) Context(ctx context.Context) *ProjectsLocationsOperationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsOperationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOperationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "documentai.projects.locations.operations.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "documentai.projects.locations.operations.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsOperationsGetCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "documentai.projects.locations.operations.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsOperationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the latest state of a long-running operation. Clients can use this
// method to poll the operation result at intervals as recommended by the API
// service.
//
// - name: The name of the operation resource.
func (r *ProjectsOperationsService) Get(name string) *ProjectsOperationsGetCall {
	c := &ProjectsOperationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsOperationsGetCall) Fields(s ...googleapi.Field) *ProjectsOperationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsOperationsGetCall) IfNoneMatch(entityTag string) *ProjectsOperationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsOperationsGetCall) Context(ctx context.Context) *ProjectsOperationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsOperationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsOperationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "documentai.projects.operations.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "documentai.projects.operations.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsOperationsGetCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "documentai.projects.operations.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}
