// Copyright 2024 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package acmedns provides access to the ACME DNS API.
//
// For product documentation, see: https://developers.google.com/domains/acme-dns/
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/acmedns/v1"
//	...
//	ctx := context.Background()
//	acmednsService, err := acmedns.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	acmednsService, err := acmedns.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	acmednsService, err := acmedns.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package acmedns // import "google.golang.org/api/acmedns/v1"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"log/slog"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	"github.com/googleapis/gax-go/v2/internallog"
	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version
var _ = internallog.New

const apiId = "acmedns:v1"
const apiName = "acmedns"
const apiVersion = "v1"
const basePath = "https://acmedns.googleapis.com/"
const basePathTemplate = "https://acmedns.UNIVERSE_DOMAIN/"
const mtlsBasePath = "https://acmedns.mtls.googleapis.com/"

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultEndpointTemplate(basePathTemplate))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	opts = append(opts, internaloption.EnableNewAuthLibrary())
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s := &Service{client: client, BasePath: basePath, logger: internaloption.GetLogger(opts)}
	s.AcmeChallengeSets = NewAcmeChallengeSetsService(s)
	if err != nil {
		return nil, err
	}
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	return NewService(context.Background(), option.WithHTTPClient(client))
}

type Service struct {
	client    *http.Client
	logger    *slog.Logger
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	AcmeChallengeSets *AcmeChallengeSetsService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewAcmeChallengeSetsService(s *Service) *AcmeChallengeSetsService {
	rs := &AcmeChallengeSetsService{s: s}
	return rs
}

type AcmeChallengeSetsService struct {
	s *Service
}

// AcmeChallengeSet: The up-to-date ACME challenge set on a domain for an RPC.
// This contains all of the ACME TXT records that exist on the domain.
type AcmeChallengeSet struct {
	// Record: The ACME challenges on the requested domain represented as
	// individual TXT records.
	Record []*AcmeTxtRecord `json:"record,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Record") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Record") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AcmeChallengeSet) MarshalJSON() ([]byte, error) {
	type NoMethod AcmeChallengeSet
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AcmeTxtRecord: The TXT record message that represents an ACME DNS-01
// challenge.
type AcmeTxtRecord struct {
	// Digest: Holds the ACME challenge data put in the TXT record. This will be
	// checked to be a valid TXT record data entry.
	Digest string `json:"digest,omitempty"`
	// Fqdn: The domain/subdomain for the record. In a request, this MAY be Unicode
	// or Punycode. In a response, this will be in Unicode. The fqdn MUST contain
	// the root_domain field on the request.
	Fqdn string `json:"fqdn,omitempty"`
	// UpdateTime: Output only. The time when this record was last updated. This
	// will be in UTC time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Digest") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Digest") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AcmeTxtRecord) MarshalJSON() ([]byte, error) {
	type NoMethod AcmeTxtRecord
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RotateChallengesRequest: The request message for the RotateChallenges RPC.
// Requires an access token, a root domain, and either records_to_add or
// records_to_remove to be populated. Records may be set for multiple
// subdomains at once to support SAN requests for multiple subdomains in a
// single domain. By default, ACME TXT record challenges that are older than 30
// days will be removed. Set `keep_expired_records` to false if this behavior
// is undesired. There is a record maximum of 100 records per domain including
// expired records. Any request sent that would exceed this maximum will result
// in a FAILED_PRECONDITION error. NEXT ID: 6
type RotateChallengesRequest struct {
	// AccessToken: Required. ACME DNS access token. This is a base64 token secret
	// that is procured from the Google Domains website. It authorizes ACME TXT
	// record updates for a domain.
	AccessToken string `json:"accessToken,omitempty"`
	// KeepExpiredRecords: Keep records older than 30 days that were used for
	// previous requests.
	KeepExpiredRecords bool `json:"keepExpiredRecords,omitempty"`
	// RecordsToAdd: ACME TXT record challenges to add. Supports multiple
	// challenges on the same FQDN.
	RecordsToAdd []*AcmeTxtRecord `json:"recordsToAdd,omitempty"`
	// RecordsToRemove: ACME TXT record challenges to remove.
	RecordsToRemove []*AcmeTxtRecord `json:"recordsToRemove,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AccessToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AccessToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RotateChallengesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod RotateChallengesRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type AcmeChallengeSetsGetCall struct {
	s            *Service
	rootDomain   string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the ACME challenge set for a given domain name. Domain names must
// be provided in Punycode.
//
//   - rootDomain: SLD + TLD domain name to list challenges. For example, this
//     would be "google.com" for any FQDN under "google.com". That includes
//     challenges for "subdomain.google.com". This MAY be Unicode or Punycode.
func (r *AcmeChallengeSetsService) Get(rootDomain string) *AcmeChallengeSetsGetCall {
	c := &AcmeChallengeSetsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.rootDomain = rootDomain
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *AcmeChallengeSetsGetCall) Fields(s ...googleapi.Field) *AcmeChallengeSetsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *AcmeChallengeSetsGetCall) IfNoneMatch(entityTag string) *AcmeChallengeSetsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *AcmeChallengeSetsGetCall) Context(ctx context.Context) *AcmeChallengeSetsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *AcmeChallengeSetsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AcmeChallengeSetsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/acmeChallengeSets/{rootDomain}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"rootDomain": c.rootDomain,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "acmedns.acmeChallengeSets.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "acmedns.acmeChallengeSets.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *AcmeChallengeSet.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *AcmeChallengeSetsGetCall) Do(opts ...googleapi.CallOption) (*AcmeChallengeSet, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &AcmeChallengeSet{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "acmedns.acmeChallengeSets.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type AcmeChallengeSetsRotateChallengesCall struct {
	s                       *Service
	rootDomain              string
	rotatechallengesrequest *RotateChallengesRequest
	urlParams_              gensupport.URLParams
	ctx_                    context.Context
	header_                 http.Header
}

// RotateChallenges: Rotate the ACME challenges for a given domain name. By
// default, removes any challenges that are older than 30 days. Domain names
// must be provided in Punycode.
//
//   - rootDomain: SLD + TLD domain name to update records for. For example, this
//     would be "google.com" for any FQDN under "google.com". That includes
//     challenges for "subdomain.google.com". This MAY be Unicode or Punycode.
func (r *AcmeChallengeSetsService) RotateChallenges(rootDomain string, rotatechallengesrequest *RotateChallengesRequest) *AcmeChallengeSetsRotateChallengesCall {
	c := &AcmeChallengeSetsRotateChallengesCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.rootDomain = rootDomain
	c.rotatechallengesrequest = rotatechallengesrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *AcmeChallengeSetsRotateChallengesCall) Fields(s ...googleapi.Field) *AcmeChallengeSetsRotateChallengesCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *AcmeChallengeSetsRotateChallengesCall) Context(ctx context.Context) *AcmeChallengeSetsRotateChallengesCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *AcmeChallengeSetsRotateChallengesCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AcmeChallengeSetsRotateChallengesCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.rotatechallengesrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/acmeChallengeSets/{rootDomain}:rotateChallenges")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"rootDomain": c.rootDomain,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "acmedns.acmeChallengeSets.rotateChallenges", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "acmedns.acmeChallengeSets.rotateChallenges" call.
// Any non-2xx status code is an error. Response headers are in either
// *AcmeChallengeSet.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *AcmeChallengeSetsRotateChallengesCall) Do(opts ...googleapi.CallOption) (*AcmeChallengeSet, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &AcmeChallengeSet{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "acmedns.acmeChallengeSets.rotateChallenges", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}
