// Code generated by mdatagen. DO NOT EDIT.

package metadata

import (
	"context"
	"errors"

	"go.opentelemetry.io/otel/metric"
	"go.opentelemetry.io/otel/metric/noop"
	"go.opentelemetry.io/otel/trace"

	"go.opentelemetry.io/collector/component"
	"go.opentelemetry.io/collector/config/configtelemetry"
)

func Meter(settings component.TelemetrySettings) metric.Meter {
	return settings.MeterProvider.Meter("github.com/open-telemetry/opentelemetry-collector-contrib/processor/deltatocumulativeprocessor")
}

func Tracer(settings component.TelemetrySettings) trace.Tracer {
	return settings.TracerProvider.Tracer("github.com/open-telemetry/opentelemetry-collector-contrib/processor/deltatocumulativeprocessor")
}

// TelemetryBuilder provides an interface for components to report telemetry
// as defined in metadata and user config.
type TelemetryBuilder struct {
	meter                                        metric.Meter
	DeltatocumulativeDatapointsDropped           metric.Int64Counter
	DeltatocumulativeDatapointsLinear            metric.Int64Counter
	DeltatocumulativeDatapointsProcessed         metric.Int64Counter
	DeltatocumulativeGapsLength                  metric.Int64Counter
	DeltatocumulativeStreamsEvicted              metric.Int64Counter
	DeltatocumulativeStreamsLimit                metric.Int64Gauge
	DeltatocumulativeStreamsMaxStale             metric.Int64Gauge
	DeltatocumulativeStreamsTracked              metric.Int64UpDownCounter
	DeltatocumulativeStreamsTrackedLinear        metric.Int64ObservableUpDownCounter
	observeDeltatocumulativeStreamsTrackedLinear func(context.Context, metric.Observer) error
}

// TelemetryBuilderOption applies changes to default builder.
type TelemetryBuilderOption interface {
	apply(*TelemetryBuilder)
}

type telemetryBuilderOptionFunc func(mb *TelemetryBuilder)

func (tbof telemetryBuilderOptionFunc) apply(mb *TelemetryBuilder) {
	tbof(mb)
}

// WithDeltatocumulativeStreamsTrackedLinearCallback sets callback for observable DeltatocumulativeStreamsTrackedLinear metric.
func WithDeltatocumulativeStreamsTrackedLinearCallback(cb func() int64, opts ...metric.ObserveOption) TelemetryBuilderOption {
	return telemetryBuilderOptionFunc(func(builder *TelemetryBuilder) {
		builder.observeDeltatocumulativeStreamsTrackedLinear = func(_ context.Context, o metric.Observer) error {
			o.ObserveInt64(builder.DeltatocumulativeStreamsTrackedLinear, cb(), opts...)
			return nil
		}
	})
}

// NewTelemetryBuilder provides a struct with methods to update all internal telemetry
// for a component
func NewTelemetryBuilder(settings component.TelemetrySettings, options ...TelemetryBuilderOption) (*TelemetryBuilder, error) {
	builder := TelemetryBuilder{}
	for _, op := range options {
		op.apply(&builder)
	}
	builder.meter = Meter(settings)
	var err, errs error
	builder.DeltatocumulativeDatapointsDropped, err = getLeveledMeter(builder.meter, configtelemetry.LevelBasic, settings.MetricsLevel).Int64Counter(
		"otelcol_deltatocumulative.datapoints.dropped",
		metric.WithDescription("number of datapoints dropped due to given 'reason'"),
		metric.WithUnit("{datapoint}"),
	)
	errs = errors.Join(errs, err)
	builder.DeltatocumulativeDatapointsLinear, err = getLeveledMeter(builder.meter, configtelemetry.LevelBasic, settings.MetricsLevel).Int64Counter(
		"otelcol_deltatocumulative.datapoints.linear",
		metric.WithDescription("total number of datapoints processed. may have 'error' attribute, if processing failed"),
		metric.WithUnit("{datapoint}"),
	)
	errs = errors.Join(errs, err)
	builder.DeltatocumulativeDatapointsProcessed, err = getLeveledMeter(builder.meter, configtelemetry.LevelBasic, settings.MetricsLevel).Int64Counter(
		"otelcol_deltatocumulative.datapoints.processed",
		metric.WithDescription("number of datapoints processed"),
		metric.WithUnit("{datapoint}"),
	)
	errs = errors.Join(errs, err)
	builder.DeltatocumulativeGapsLength, err = getLeveledMeter(builder.meter, configtelemetry.LevelBasic, settings.MetricsLevel).Int64Counter(
		"otelcol_deltatocumulative.gaps.length",
		metric.WithDescription("total duration where data was expected but not received"),
		metric.WithUnit("s"),
	)
	errs = errors.Join(errs, err)
	builder.DeltatocumulativeStreamsEvicted, err = getLeveledMeter(builder.meter, configtelemetry.LevelBasic, settings.MetricsLevel).Int64Counter(
		"otelcol_deltatocumulative.streams.evicted",
		metric.WithDescription("number of streams evicted"),
		metric.WithUnit("{stream}"),
	)
	errs = errors.Join(errs, err)
	builder.DeltatocumulativeStreamsLimit, err = getLeveledMeter(builder.meter, configtelemetry.LevelBasic, settings.MetricsLevel).Int64Gauge(
		"otelcol_deltatocumulative.streams.limit",
		metric.WithDescription("upper limit of tracked streams"),
		metric.WithUnit("{stream}"),
	)
	errs = errors.Join(errs, err)
	builder.DeltatocumulativeStreamsMaxStale, err = getLeveledMeter(builder.meter, configtelemetry.LevelBasic, settings.MetricsLevel).Int64Gauge(
		"otelcol_deltatocumulative.streams.max_stale",
		metric.WithDescription("duration after which streams inactive streams are dropped"),
		metric.WithUnit("s"),
	)
	errs = errors.Join(errs, err)
	builder.DeltatocumulativeStreamsTracked, err = getLeveledMeter(builder.meter, configtelemetry.LevelBasic, settings.MetricsLevel).Int64UpDownCounter(
		"otelcol_deltatocumulative.streams.tracked",
		metric.WithDescription("number of streams tracked"),
		metric.WithUnit("{dps}"),
	)
	errs = errors.Join(errs, err)
	builder.DeltatocumulativeStreamsTrackedLinear, err = getLeveledMeter(builder.meter, configtelemetry.LevelBasic, settings.MetricsLevel).Int64ObservableUpDownCounter(
		"otelcol_deltatocumulative.streams.tracked.linear",
		metric.WithDescription("number of streams tracked"),
		metric.WithUnit("{dps}"),
	)
	errs = errors.Join(errs, err)
	_, err = getLeveledMeter(builder.meter, configtelemetry.LevelBasic, settings.MetricsLevel).RegisterCallback(builder.observeDeltatocumulativeStreamsTrackedLinear, builder.DeltatocumulativeStreamsTrackedLinear)
	errs = errors.Join(errs, err)
	return &builder, errs
}

func getLeveledMeter(meter metric.Meter, cfgLevel, srvLevel configtelemetry.Level) metric.Meter {
	if cfgLevel <= srvLevel {
		return meter
	}
	return noop.Meter{}
}
