// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package securitylake

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opCreateAwsLogSource = "CreateAwsLogSource"

// CreateAwsLogSourceRequest generates a "aws/request.Request" representing the
// client's request for the CreateAwsLogSource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAwsLogSource for more information on using the CreateAwsLogSource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateAwsLogSourceRequest method.
//	req, resp := client.CreateAwsLogSourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/CreateAwsLogSource
func (c *SecurityLake) CreateAwsLogSourceRequest(input *CreateAwsLogSourceInput) (req *request.Request, output *CreateAwsLogSourceOutput) {
	op := &request.Operation{
		Name:       opCreateAwsLogSource,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/datalake/logsources/aws",
	}

	if input == nil {
		input = &CreateAwsLogSourceInput{}
	}

	output = &CreateAwsLogSourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateAwsLogSource API operation for Amazon Security Lake.
//
// Adds a natively supported Amazon Web Service as an Amazon Security Lake source.
// Enables source types for member accounts in required Amazon Web Services
// Regions, based on the parameters you specify. You can choose any source type
// in any Region for either accounts that are part of a trusted organization
// or standalone accounts. Once you add an Amazon Web Service as a source, Security
// Lake starts collecting logs and events from it.
//
// You can use this API only to enable natively supported Amazon Web Services
// as a source. Use CreateCustomLogSource to enable data collection from a custom
// source.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Security Lake's
// API operation CreateAwsLogSource for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The request is malformed or contains an error such as an invalid parameter
//     value or a missing required parameter.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - InternalServerException
//     Internal service exceptions are sometimes caused by transient issues. Before
//     you start troubleshooting, perform the operation again.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action. Access denied errors
//     appear when Amazon Security Lake explicitly or implicitly denies an authorization
//     request. An explicit denial occurs when a policy contains a Deny statement
//     for the specific Amazon Web Services action. An implicit denial occurs when
//     there is no applicable Deny statement and also no applicable Allow statement.
//
//   - ConflictException
//     Occurs when a conflict with a previous successful write is detected. This
//     generally occurs when the previous write did not have time to propagate to
//     the host serving the current request. A retry (with appropriate backoff logic)
//     is the recommended response to this exception.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/CreateAwsLogSource
func (c *SecurityLake) CreateAwsLogSource(input *CreateAwsLogSourceInput) (*CreateAwsLogSourceOutput, error) {
	req, out := c.CreateAwsLogSourceRequest(input)
	return out, req.Send()
}

// CreateAwsLogSourceWithContext is the same as CreateAwsLogSource with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAwsLogSource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityLake) CreateAwsLogSourceWithContext(ctx aws.Context, input *CreateAwsLogSourceInput, opts ...request.Option) (*CreateAwsLogSourceOutput, error) {
	req, out := c.CreateAwsLogSourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateCustomLogSource = "CreateCustomLogSource"

// CreateCustomLogSourceRequest generates a "aws/request.Request" representing the
// client's request for the CreateCustomLogSource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateCustomLogSource for more information on using the CreateCustomLogSource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateCustomLogSourceRequest method.
//	req, resp := client.CreateCustomLogSourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/CreateCustomLogSource
func (c *SecurityLake) CreateCustomLogSourceRequest(input *CreateCustomLogSourceInput) (req *request.Request, output *CreateCustomLogSourceOutput) {
	op := &request.Operation{
		Name:       opCreateCustomLogSource,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/datalake/logsources/custom",
	}

	if input == nil {
		input = &CreateCustomLogSourceInput{}
	}

	output = &CreateCustomLogSourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateCustomLogSource API operation for Amazon Security Lake.
//
// Adds a third-party custom source in Amazon Security Lake, from the Amazon
// Web Services Region where you want to create a custom source. Security Lake
// can collect logs and events from third-party custom sources. After creating
// the appropriate IAM role to invoke Glue crawler, use this API to add a custom
// source name in Security Lake. This operation creates a partition in the Amazon
// S3 bucket for Security Lake as the target location for log files from the
// custom source. In addition, this operation also creates an associated Glue
// table and an Glue crawler.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Security Lake's
// API operation CreateCustomLogSource for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The request is malformed or contains an error such as an invalid parameter
//     value or a missing required parameter.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - InternalServerException
//     Internal service exceptions are sometimes caused by transient issues. Before
//     you start troubleshooting, perform the operation again.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action. Access denied errors
//     appear when Amazon Security Lake explicitly or implicitly denies an authorization
//     request. An explicit denial occurs when a policy contains a Deny statement
//     for the specific Amazon Web Services action. An implicit denial occurs when
//     there is no applicable Deny statement and also no applicable Allow statement.
//
//   - ConflictException
//     Occurs when a conflict with a previous successful write is detected. This
//     generally occurs when the previous write did not have time to propagate to
//     the host serving the current request. A retry (with appropriate backoff logic)
//     is the recommended response to this exception.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/CreateCustomLogSource
func (c *SecurityLake) CreateCustomLogSource(input *CreateCustomLogSourceInput) (*CreateCustomLogSourceOutput, error) {
	req, out := c.CreateCustomLogSourceRequest(input)
	return out, req.Send()
}

// CreateCustomLogSourceWithContext is the same as CreateCustomLogSource with the addition of
// the ability to pass a context and additional request options.
//
// See CreateCustomLogSource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityLake) CreateCustomLogSourceWithContext(ctx aws.Context, input *CreateCustomLogSourceInput, opts ...request.Option) (*CreateCustomLogSourceOutput, error) {
	req, out := c.CreateCustomLogSourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDataLake = "CreateDataLake"

// CreateDataLakeRequest generates a "aws/request.Request" representing the
// client's request for the CreateDataLake operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDataLake for more information on using the CreateDataLake
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateDataLakeRequest method.
//	req, resp := client.CreateDataLakeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/CreateDataLake
func (c *SecurityLake) CreateDataLakeRequest(input *CreateDataLakeInput) (req *request.Request, output *CreateDataLakeOutput) {
	op := &request.Operation{
		Name:       opCreateDataLake,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/datalake",
	}

	if input == nil {
		input = &CreateDataLakeInput{}
	}

	output = &CreateDataLakeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDataLake API operation for Amazon Security Lake.
//
// Initializes an Amazon Security Lake instance with the provided (or default)
// configuration. You can enable Security Lake in Amazon Web Services Regions
// with customized settings before enabling log collection in Regions. To specify
// particular Regions, configure these Regions using the configurations parameter.
// If you have already enabled Security Lake in a Region when you call this
// command, the command will update the Region if you provide new configuration
// parameters. If you have not already enabled Security Lake in the Region when
// you call this API, it will set up the data lake in the Region with the specified
// configurations.
//
// When you enable Security Lake, it starts ingesting security data after the
// CreateAwsLogSource call. This includes ingesting security data from sources,
// storing data, and making data accessible to subscribers. Security Lake also
// enables all the existing settings and resources that it stores or maintains
// for your Amazon Web Services account in the current Region, including security
// log and event data. For more information, see the Amazon Security Lake User
// Guide (https://docs.aws.amazon.com/security-lake/latest/userguide/what-is-security-lake.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Security Lake's
// API operation CreateDataLake for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The request is malformed or contains an error such as an invalid parameter
//     value or a missing required parameter.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - InternalServerException
//     Internal service exceptions are sometimes caused by transient issues. Before
//     you start troubleshooting, perform the operation again.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action. Access denied errors
//     appear when Amazon Security Lake explicitly or implicitly denies an authorization
//     request. An explicit denial occurs when a policy contains a Deny statement
//     for the specific Amazon Web Services action. An implicit denial occurs when
//     there is no applicable Deny statement and also no applicable Allow statement.
//
//   - ConflictException
//     Occurs when a conflict with a previous successful write is detected. This
//     generally occurs when the previous write did not have time to propagate to
//     the host serving the current request. A retry (with appropriate backoff logic)
//     is the recommended response to this exception.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/CreateDataLake
func (c *SecurityLake) CreateDataLake(input *CreateDataLakeInput) (*CreateDataLakeOutput, error) {
	req, out := c.CreateDataLakeRequest(input)
	return out, req.Send()
}

// CreateDataLakeWithContext is the same as CreateDataLake with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDataLake for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityLake) CreateDataLakeWithContext(ctx aws.Context, input *CreateDataLakeInput, opts ...request.Option) (*CreateDataLakeOutput, error) {
	req, out := c.CreateDataLakeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDataLakeExceptionSubscription = "CreateDataLakeExceptionSubscription"

// CreateDataLakeExceptionSubscriptionRequest generates a "aws/request.Request" representing the
// client's request for the CreateDataLakeExceptionSubscription operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDataLakeExceptionSubscription for more information on using the CreateDataLakeExceptionSubscription
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateDataLakeExceptionSubscriptionRequest method.
//	req, resp := client.CreateDataLakeExceptionSubscriptionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/CreateDataLakeExceptionSubscription
func (c *SecurityLake) CreateDataLakeExceptionSubscriptionRequest(input *CreateDataLakeExceptionSubscriptionInput) (req *request.Request, output *CreateDataLakeExceptionSubscriptionOutput) {
	op := &request.Operation{
		Name:       opCreateDataLakeExceptionSubscription,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/datalake/exceptions/subscription",
	}

	if input == nil {
		input = &CreateDataLakeExceptionSubscriptionInput{}
	}

	output = &CreateDataLakeExceptionSubscriptionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreateDataLakeExceptionSubscription API operation for Amazon Security Lake.
//
// Creates the specified notification subscription in Amazon Security Lake for
// the organization you specify.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Security Lake's
// API operation CreateDataLakeExceptionSubscription for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The request is malformed or contains an error such as an invalid parameter
//     value or a missing required parameter.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - InternalServerException
//     Internal service exceptions are sometimes caused by transient issues. Before
//     you start troubleshooting, perform the operation again.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action. Access denied errors
//     appear when Amazon Security Lake explicitly or implicitly denies an authorization
//     request. An explicit denial occurs when a policy contains a Deny statement
//     for the specific Amazon Web Services action. An implicit denial occurs when
//     there is no applicable Deny statement and also no applicable Allow statement.
//
//   - ConflictException
//     Occurs when a conflict with a previous successful write is detected. This
//     generally occurs when the previous write did not have time to propagate to
//     the host serving the current request. A retry (with appropriate backoff logic)
//     is the recommended response to this exception.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/CreateDataLakeExceptionSubscription
func (c *SecurityLake) CreateDataLakeExceptionSubscription(input *CreateDataLakeExceptionSubscriptionInput) (*CreateDataLakeExceptionSubscriptionOutput, error) {
	req, out := c.CreateDataLakeExceptionSubscriptionRequest(input)
	return out, req.Send()
}

// CreateDataLakeExceptionSubscriptionWithContext is the same as CreateDataLakeExceptionSubscription with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDataLakeExceptionSubscription for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityLake) CreateDataLakeExceptionSubscriptionWithContext(ctx aws.Context, input *CreateDataLakeExceptionSubscriptionInput, opts ...request.Option) (*CreateDataLakeExceptionSubscriptionOutput, error) {
	req, out := c.CreateDataLakeExceptionSubscriptionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDataLakeOrganizationConfiguration = "CreateDataLakeOrganizationConfiguration"

// CreateDataLakeOrganizationConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the CreateDataLakeOrganizationConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDataLakeOrganizationConfiguration for more information on using the CreateDataLakeOrganizationConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateDataLakeOrganizationConfigurationRequest method.
//	req, resp := client.CreateDataLakeOrganizationConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/CreateDataLakeOrganizationConfiguration
func (c *SecurityLake) CreateDataLakeOrganizationConfigurationRequest(input *CreateDataLakeOrganizationConfigurationInput) (req *request.Request, output *CreateDataLakeOrganizationConfigurationOutput) {
	op := &request.Operation{
		Name:       opCreateDataLakeOrganizationConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/datalake/organization/configuration",
	}

	if input == nil {
		input = &CreateDataLakeOrganizationConfigurationInput{}
	}

	output = &CreateDataLakeOrganizationConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreateDataLakeOrganizationConfiguration API operation for Amazon Security Lake.
//
// Automatically enables Amazon Security Lake for new member accounts in your
// organization. Security Lake is not automatically enabled for any existing
// member accounts in your organization.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Security Lake's
// API operation CreateDataLakeOrganizationConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The request is malformed or contains an error such as an invalid parameter
//     value or a missing required parameter.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - InternalServerException
//     Internal service exceptions are sometimes caused by transient issues. Before
//     you start troubleshooting, perform the operation again.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action. Access denied errors
//     appear when Amazon Security Lake explicitly or implicitly denies an authorization
//     request. An explicit denial occurs when a policy contains a Deny statement
//     for the specific Amazon Web Services action. An implicit denial occurs when
//     there is no applicable Deny statement and also no applicable Allow statement.
//
//   - ConflictException
//     Occurs when a conflict with a previous successful write is detected. This
//     generally occurs when the previous write did not have time to propagate to
//     the host serving the current request. A retry (with appropriate backoff logic)
//     is the recommended response to this exception.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/CreateDataLakeOrganizationConfiguration
func (c *SecurityLake) CreateDataLakeOrganizationConfiguration(input *CreateDataLakeOrganizationConfigurationInput) (*CreateDataLakeOrganizationConfigurationOutput, error) {
	req, out := c.CreateDataLakeOrganizationConfigurationRequest(input)
	return out, req.Send()
}

// CreateDataLakeOrganizationConfigurationWithContext is the same as CreateDataLakeOrganizationConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDataLakeOrganizationConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityLake) CreateDataLakeOrganizationConfigurationWithContext(ctx aws.Context, input *CreateDataLakeOrganizationConfigurationInput, opts ...request.Option) (*CreateDataLakeOrganizationConfigurationOutput, error) {
	req, out := c.CreateDataLakeOrganizationConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSubscriber = "CreateSubscriber"

// CreateSubscriberRequest generates a "aws/request.Request" representing the
// client's request for the CreateSubscriber operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSubscriber for more information on using the CreateSubscriber
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateSubscriberRequest method.
//	req, resp := client.CreateSubscriberRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/CreateSubscriber
func (c *SecurityLake) CreateSubscriberRequest(input *CreateSubscriberInput) (req *request.Request, output *CreateSubscriberOutput) {
	op := &request.Operation{
		Name:       opCreateSubscriber,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/subscribers",
	}

	if input == nil {
		input = &CreateSubscriberInput{}
	}

	output = &CreateSubscriberOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSubscriber API operation for Amazon Security Lake.
//
// Creates a subscription permission for accounts that are already enabled in
// Amazon Security Lake. You can create a subscriber with access to data in
// the current Amazon Web Services Region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Security Lake's
// API operation CreateSubscriber for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The request is malformed or contains an error such as an invalid parameter
//     value or a missing required parameter.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - InternalServerException
//     Internal service exceptions are sometimes caused by transient issues. Before
//     you start troubleshooting, perform the operation again.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action. Access denied errors
//     appear when Amazon Security Lake explicitly or implicitly denies an authorization
//     request. An explicit denial occurs when a policy contains a Deny statement
//     for the specific Amazon Web Services action. An implicit denial occurs when
//     there is no applicable Deny statement and also no applicable Allow statement.
//
//   - ConflictException
//     Occurs when a conflict with a previous successful write is detected. This
//     generally occurs when the previous write did not have time to propagate to
//     the host serving the current request. A retry (with appropriate backoff logic)
//     is the recommended response to this exception.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/CreateSubscriber
func (c *SecurityLake) CreateSubscriber(input *CreateSubscriberInput) (*CreateSubscriberOutput, error) {
	req, out := c.CreateSubscriberRequest(input)
	return out, req.Send()
}

// CreateSubscriberWithContext is the same as CreateSubscriber with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSubscriber for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityLake) CreateSubscriberWithContext(ctx aws.Context, input *CreateSubscriberInput, opts ...request.Option) (*CreateSubscriberOutput, error) {
	req, out := c.CreateSubscriberRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSubscriberNotification = "CreateSubscriberNotification"

// CreateSubscriberNotificationRequest generates a "aws/request.Request" representing the
// client's request for the CreateSubscriberNotification operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSubscriberNotification for more information on using the CreateSubscriberNotification
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateSubscriberNotificationRequest method.
//	req, resp := client.CreateSubscriberNotificationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/CreateSubscriberNotification
func (c *SecurityLake) CreateSubscriberNotificationRequest(input *CreateSubscriberNotificationInput) (req *request.Request, output *CreateSubscriberNotificationOutput) {
	op := &request.Operation{
		Name:       opCreateSubscriberNotification,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/subscribers/{subscriberId}/notification",
	}

	if input == nil {
		input = &CreateSubscriberNotificationInput{}
	}

	output = &CreateSubscriberNotificationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSubscriberNotification API operation for Amazon Security Lake.
//
// Notifies the subscriber when new data is written to the data lake for the
// sources that the subscriber consumes in Security Lake. You can create only
// one subscriber notification per subscriber.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Security Lake's
// API operation CreateSubscriberNotification for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The request is malformed or contains an error such as an invalid parameter
//     value or a missing required parameter.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - InternalServerException
//     Internal service exceptions are sometimes caused by transient issues. Before
//     you start troubleshooting, perform the operation again.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action. Access denied errors
//     appear when Amazon Security Lake explicitly or implicitly denies an authorization
//     request. An explicit denial occurs when a policy contains a Deny statement
//     for the specific Amazon Web Services action. An implicit denial occurs when
//     there is no applicable Deny statement and also no applicable Allow statement.
//
//   - ConflictException
//     Occurs when a conflict with a previous successful write is detected. This
//     generally occurs when the previous write did not have time to propagate to
//     the host serving the current request. A retry (with appropriate backoff logic)
//     is the recommended response to this exception.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/CreateSubscriberNotification
func (c *SecurityLake) CreateSubscriberNotification(input *CreateSubscriberNotificationInput) (*CreateSubscriberNotificationOutput, error) {
	req, out := c.CreateSubscriberNotificationRequest(input)
	return out, req.Send()
}

// CreateSubscriberNotificationWithContext is the same as CreateSubscriberNotification with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSubscriberNotification for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityLake) CreateSubscriberNotificationWithContext(ctx aws.Context, input *CreateSubscriberNotificationInput, opts ...request.Option) (*CreateSubscriberNotificationOutput, error) {
	req, out := c.CreateSubscriberNotificationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAwsLogSource = "DeleteAwsLogSource"

// DeleteAwsLogSourceRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAwsLogSource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAwsLogSource for more information on using the DeleteAwsLogSource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteAwsLogSourceRequest method.
//	req, resp := client.DeleteAwsLogSourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/DeleteAwsLogSource
func (c *SecurityLake) DeleteAwsLogSourceRequest(input *DeleteAwsLogSourceInput) (req *request.Request, output *DeleteAwsLogSourceOutput) {
	op := &request.Operation{
		Name:       opDeleteAwsLogSource,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/datalake/logsources/aws/delete",
	}

	if input == nil {
		input = &DeleteAwsLogSourceInput{}
	}

	output = &DeleteAwsLogSourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteAwsLogSource API operation for Amazon Security Lake.
//
// Removes a natively supported Amazon Web Service as an Amazon Security Lake
// source. You can remove a source for one or more Regions. When you remove
// the source, Security Lake stops collecting data from that source in the specified
// Regions and accounts, and subscribers can no longer consume new data from
// the source. However, subscribers can still consume data that Security Lake
// collected from the source before removal.
//
// You can choose any source type in any Amazon Web Services Region for either
// accounts that are part of a trusted organization or standalone accounts.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Security Lake's
// API operation DeleteAwsLogSource for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The request is malformed or contains an error such as an invalid parameter
//     value or a missing required parameter.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - InternalServerException
//     Internal service exceptions are sometimes caused by transient issues. Before
//     you start troubleshooting, perform the operation again.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action. Access denied errors
//     appear when Amazon Security Lake explicitly or implicitly denies an authorization
//     request. An explicit denial occurs when a policy contains a Deny statement
//     for the specific Amazon Web Services action. An implicit denial occurs when
//     there is no applicable Deny statement and also no applicable Allow statement.
//
//   - ConflictException
//     Occurs when a conflict with a previous successful write is detected. This
//     generally occurs when the previous write did not have time to propagate to
//     the host serving the current request. A retry (with appropriate backoff logic)
//     is the recommended response to this exception.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/DeleteAwsLogSource
func (c *SecurityLake) DeleteAwsLogSource(input *DeleteAwsLogSourceInput) (*DeleteAwsLogSourceOutput, error) {
	req, out := c.DeleteAwsLogSourceRequest(input)
	return out, req.Send()
}

// DeleteAwsLogSourceWithContext is the same as DeleteAwsLogSource with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAwsLogSource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityLake) DeleteAwsLogSourceWithContext(ctx aws.Context, input *DeleteAwsLogSourceInput, opts ...request.Option) (*DeleteAwsLogSourceOutput, error) {
	req, out := c.DeleteAwsLogSourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteCustomLogSource = "DeleteCustomLogSource"

// DeleteCustomLogSourceRequest generates a "aws/request.Request" representing the
// client's request for the DeleteCustomLogSource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteCustomLogSource for more information on using the DeleteCustomLogSource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteCustomLogSourceRequest method.
//	req, resp := client.DeleteCustomLogSourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/DeleteCustomLogSource
func (c *SecurityLake) DeleteCustomLogSourceRequest(input *DeleteCustomLogSourceInput) (req *request.Request, output *DeleteCustomLogSourceOutput) {
	op := &request.Operation{
		Name:       opDeleteCustomLogSource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/datalake/logsources/custom/{sourceName}",
	}

	if input == nil {
		input = &DeleteCustomLogSourceInput{}
	}

	output = &DeleteCustomLogSourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteCustomLogSource API operation for Amazon Security Lake.
//
// Removes a custom log source from Amazon Security Lake, to stop sending data
// from the custom source to Security Lake.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Security Lake's
// API operation DeleteCustomLogSource for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The request is malformed or contains an error such as an invalid parameter
//     value or a missing required parameter.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - InternalServerException
//     Internal service exceptions are sometimes caused by transient issues. Before
//     you start troubleshooting, perform the operation again.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action. Access denied errors
//     appear when Amazon Security Lake explicitly or implicitly denies an authorization
//     request. An explicit denial occurs when a policy contains a Deny statement
//     for the specific Amazon Web Services action. An implicit denial occurs when
//     there is no applicable Deny statement and also no applicable Allow statement.
//
//   - ConflictException
//     Occurs when a conflict with a previous successful write is detected. This
//     generally occurs when the previous write did not have time to propagate to
//     the host serving the current request. A retry (with appropriate backoff logic)
//     is the recommended response to this exception.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/DeleteCustomLogSource
func (c *SecurityLake) DeleteCustomLogSource(input *DeleteCustomLogSourceInput) (*DeleteCustomLogSourceOutput, error) {
	req, out := c.DeleteCustomLogSourceRequest(input)
	return out, req.Send()
}

// DeleteCustomLogSourceWithContext is the same as DeleteCustomLogSource with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteCustomLogSource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityLake) DeleteCustomLogSourceWithContext(ctx aws.Context, input *DeleteCustomLogSourceInput, opts ...request.Option) (*DeleteCustomLogSourceOutput, error) {
	req, out := c.DeleteCustomLogSourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDataLake = "DeleteDataLake"

// DeleteDataLakeRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDataLake operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDataLake for more information on using the DeleteDataLake
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteDataLakeRequest method.
//	req, resp := client.DeleteDataLakeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/DeleteDataLake
func (c *SecurityLake) DeleteDataLakeRequest(input *DeleteDataLakeInput) (req *request.Request, output *DeleteDataLakeOutput) {
	op := &request.Operation{
		Name:       opDeleteDataLake,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/datalake/delete",
	}

	if input == nil {
		input = &DeleteDataLakeInput{}
	}

	output = &DeleteDataLakeOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteDataLake API operation for Amazon Security Lake.
//
// When you disable Amazon Security Lake from your account, Security Lake is
// disabled in all Amazon Web Services Regions and it stops collecting data
// from your sources. Also, this API automatically takes steps to remove the
// account from Security Lake. However, Security Lake retains all of your existing
// settings and the resources that it created in your Amazon Web Services account
// in the current Amazon Web Services Region.
//
// The DeleteDataLake operation does not delete the data that is stored in your
// Amazon S3 bucket, which is owned by your Amazon Web Services account. For
// more information, see the Amazon Security Lake User Guide (https://docs.aws.amazon.com/security-lake/latest/userguide/disable-security-lake.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Security Lake's
// API operation DeleteDataLake for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The request is malformed or contains an error such as an invalid parameter
//     value or a missing required parameter.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - InternalServerException
//     Internal service exceptions are sometimes caused by transient issues. Before
//     you start troubleshooting, perform the operation again.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action. Access denied errors
//     appear when Amazon Security Lake explicitly or implicitly denies an authorization
//     request. An explicit denial occurs when a policy contains a Deny statement
//     for the specific Amazon Web Services action. An implicit denial occurs when
//     there is no applicable Deny statement and also no applicable Allow statement.
//
//   - ConflictException
//     Occurs when a conflict with a previous successful write is detected. This
//     generally occurs when the previous write did not have time to propagate to
//     the host serving the current request. A retry (with appropriate backoff logic)
//     is the recommended response to this exception.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/DeleteDataLake
func (c *SecurityLake) DeleteDataLake(input *DeleteDataLakeInput) (*DeleteDataLakeOutput, error) {
	req, out := c.DeleteDataLakeRequest(input)
	return out, req.Send()
}

// DeleteDataLakeWithContext is the same as DeleteDataLake with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDataLake for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityLake) DeleteDataLakeWithContext(ctx aws.Context, input *DeleteDataLakeInput, opts ...request.Option) (*DeleteDataLakeOutput, error) {
	req, out := c.DeleteDataLakeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDataLakeExceptionSubscription = "DeleteDataLakeExceptionSubscription"

// DeleteDataLakeExceptionSubscriptionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDataLakeExceptionSubscription operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDataLakeExceptionSubscription for more information on using the DeleteDataLakeExceptionSubscription
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteDataLakeExceptionSubscriptionRequest method.
//	req, resp := client.DeleteDataLakeExceptionSubscriptionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/DeleteDataLakeExceptionSubscription
func (c *SecurityLake) DeleteDataLakeExceptionSubscriptionRequest(input *DeleteDataLakeExceptionSubscriptionInput) (req *request.Request, output *DeleteDataLakeExceptionSubscriptionOutput) {
	op := &request.Operation{
		Name:       opDeleteDataLakeExceptionSubscription,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/datalake/exceptions/subscription",
	}

	if input == nil {
		input = &DeleteDataLakeExceptionSubscriptionInput{}
	}

	output = &DeleteDataLakeExceptionSubscriptionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteDataLakeExceptionSubscription API operation for Amazon Security Lake.
//
// Deletes the specified notification subscription in Amazon Security Lake for
// the organization you specify.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Security Lake's
// API operation DeleteDataLakeExceptionSubscription for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The request is malformed or contains an error such as an invalid parameter
//     value or a missing required parameter.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - InternalServerException
//     Internal service exceptions are sometimes caused by transient issues. Before
//     you start troubleshooting, perform the operation again.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action. Access denied errors
//     appear when Amazon Security Lake explicitly or implicitly denies an authorization
//     request. An explicit denial occurs when a policy contains a Deny statement
//     for the specific Amazon Web Services action. An implicit denial occurs when
//     there is no applicable Deny statement and also no applicable Allow statement.
//
//   - ConflictException
//     Occurs when a conflict with a previous successful write is detected. This
//     generally occurs when the previous write did not have time to propagate to
//     the host serving the current request. A retry (with appropriate backoff logic)
//     is the recommended response to this exception.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/DeleteDataLakeExceptionSubscription
func (c *SecurityLake) DeleteDataLakeExceptionSubscription(input *DeleteDataLakeExceptionSubscriptionInput) (*DeleteDataLakeExceptionSubscriptionOutput, error) {
	req, out := c.DeleteDataLakeExceptionSubscriptionRequest(input)
	return out, req.Send()
}

// DeleteDataLakeExceptionSubscriptionWithContext is the same as DeleteDataLakeExceptionSubscription with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDataLakeExceptionSubscription for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityLake) DeleteDataLakeExceptionSubscriptionWithContext(ctx aws.Context, input *DeleteDataLakeExceptionSubscriptionInput, opts ...request.Option) (*DeleteDataLakeExceptionSubscriptionOutput, error) {
	req, out := c.DeleteDataLakeExceptionSubscriptionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDataLakeOrganizationConfiguration = "DeleteDataLakeOrganizationConfiguration"

// DeleteDataLakeOrganizationConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDataLakeOrganizationConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDataLakeOrganizationConfiguration for more information on using the DeleteDataLakeOrganizationConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteDataLakeOrganizationConfigurationRequest method.
//	req, resp := client.DeleteDataLakeOrganizationConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/DeleteDataLakeOrganizationConfiguration
func (c *SecurityLake) DeleteDataLakeOrganizationConfigurationRequest(input *DeleteDataLakeOrganizationConfigurationInput) (req *request.Request, output *DeleteDataLakeOrganizationConfigurationOutput) {
	op := &request.Operation{
		Name:       opDeleteDataLakeOrganizationConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/datalake/organization/configuration/delete",
	}

	if input == nil {
		input = &DeleteDataLakeOrganizationConfigurationInput{}
	}

	output = &DeleteDataLakeOrganizationConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteDataLakeOrganizationConfiguration API operation for Amazon Security Lake.
//
// Turns off automatic enablement of Amazon Security Lake for member accounts
// that are added to an organization in Organizations. Only the delegated Security
// Lake administrator for an organization can perform this operation. If the
// delegated Security Lake administrator performs this operation, new member
// accounts won't automatically contribute data to the data lake.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Security Lake's
// API operation DeleteDataLakeOrganizationConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The request is malformed or contains an error such as an invalid parameter
//     value or a missing required parameter.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - InternalServerException
//     Internal service exceptions are sometimes caused by transient issues. Before
//     you start troubleshooting, perform the operation again.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action. Access denied errors
//     appear when Amazon Security Lake explicitly or implicitly denies an authorization
//     request. An explicit denial occurs when a policy contains a Deny statement
//     for the specific Amazon Web Services action. An implicit denial occurs when
//     there is no applicable Deny statement and also no applicable Allow statement.
//
//   - ConflictException
//     Occurs when a conflict with a previous successful write is detected. This
//     generally occurs when the previous write did not have time to propagate to
//     the host serving the current request. A retry (with appropriate backoff logic)
//     is the recommended response to this exception.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/DeleteDataLakeOrganizationConfiguration
func (c *SecurityLake) DeleteDataLakeOrganizationConfiguration(input *DeleteDataLakeOrganizationConfigurationInput) (*DeleteDataLakeOrganizationConfigurationOutput, error) {
	req, out := c.DeleteDataLakeOrganizationConfigurationRequest(input)
	return out, req.Send()
}

// DeleteDataLakeOrganizationConfigurationWithContext is the same as DeleteDataLakeOrganizationConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDataLakeOrganizationConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityLake) DeleteDataLakeOrganizationConfigurationWithContext(ctx aws.Context, input *DeleteDataLakeOrganizationConfigurationInput, opts ...request.Option) (*DeleteDataLakeOrganizationConfigurationOutput, error) {
	req, out := c.DeleteDataLakeOrganizationConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSubscriber = "DeleteSubscriber"

// DeleteSubscriberRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSubscriber operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSubscriber for more information on using the DeleteSubscriber
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteSubscriberRequest method.
//	req, resp := client.DeleteSubscriberRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/DeleteSubscriber
func (c *SecurityLake) DeleteSubscriberRequest(input *DeleteSubscriberInput) (req *request.Request, output *DeleteSubscriberOutput) {
	op := &request.Operation{
		Name:       opDeleteSubscriber,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/subscribers/{subscriberId}",
	}

	if input == nil {
		input = &DeleteSubscriberInput{}
	}

	output = &DeleteSubscriberOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteSubscriber API operation for Amazon Security Lake.
//
// Deletes the subscription permission and all notification settings for accounts
// that are already enabled in Amazon Security Lake. When you run DeleteSubscriber,
// the subscriber will no longer consume data from Security Lake and the subscriber
// is removed. This operation deletes the subscriber and removes access to data
// in the current Amazon Web Services Region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Security Lake's
// API operation DeleteSubscriber for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The request is malformed or contains an error such as an invalid parameter
//     value or a missing required parameter.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - InternalServerException
//     Internal service exceptions are sometimes caused by transient issues. Before
//     you start troubleshooting, perform the operation again.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action. Access denied errors
//     appear when Amazon Security Lake explicitly or implicitly denies an authorization
//     request. An explicit denial occurs when a policy contains a Deny statement
//     for the specific Amazon Web Services action. An implicit denial occurs when
//     there is no applicable Deny statement and also no applicable Allow statement.
//
//   - ConflictException
//     Occurs when a conflict with a previous successful write is detected. This
//     generally occurs when the previous write did not have time to propagate to
//     the host serving the current request. A retry (with appropriate backoff logic)
//     is the recommended response to this exception.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/DeleteSubscriber
func (c *SecurityLake) DeleteSubscriber(input *DeleteSubscriberInput) (*DeleteSubscriberOutput, error) {
	req, out := c.DeleteSubscriberRequest(input)
	return out, req.Send()
}

// DeleteSubscriberWithContext is the same as DeleteSubscriber with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSubscriber for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityLake) DeleteSubscriberWithContext(ctx aws.Context, input *DeleteSubscriberInput, opts ...request.Option) (*DeleteSubscriberOutput, error) {
	req, out := c.DeleteSubscriberRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSubscriberNotification = "DeleteSubscriberNotification"

// DeleteSubscriberNotificationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSubscriberNotification operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSubscriberNotification for more information on using the DeleteSubscriberNotification
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteSubscriberNotificationRequest method.
//	req, resp := client.DeleteSubscriberNotificationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/DeleteSubscriberNotification
func (c *SecurityLake) DeleteSubscriberNotificationRequest(input *DeleteSubscriberNotificationInput) (req *request.Request, output *DeleteSubscriberNotificationOutput) {
	op := &request.Operation{
		Name:       opDeleteSubscriberNotification,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/subscribers/{subscriberId}/notification",
	}

	if input == nil {
		input = &DeleteSubscriberNotificationInput{}
	}

	output = &DeleteSubscriberNotificationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteSubscriberNotification API operation for Amazon Security Lake.
//
// Deletes the specified notification subscription in Amazon Security Lake for
// the organization you specify.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Security Lake's
// API operation DeleteSubscriberNotification for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The request is malformed or contains an error such as an invalid parameter
//     value or a missing required parameter.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - InternalServerException
//     Internal service exceptions are sometimes caused by transient issues. Before
//     you start troubleshooting, perform the operation again.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action. Access denied errors
//     appear when Amazon Security Lake explicitly or implicitly denies an authorization
//     request. An explicit denial occurs when a policy contains a Deny statement
//     for the specific Amazon Web Services action. An implicit denial occurs when
//     there is no applicable Deny statement and also no applicable Allow statement.
//
//   - ConflictException
//     Occurs when a conflict with a previous successful write is detected. This
//     generally occurs when the previous write did not have time to propagate to
//     the host serving the current request. A retry (with appropriate backoff logic)
//     is the recommended response to this exception.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/DeleteSubscriberNotification
func (c *SecurityLake) DeleteSubscriberNotification(input *DeleteSubscriberNotificationInput) (*DeleteSubscriberNotificationOutput, error) {
	req, out := c.DeleteSubscriberNotificationRequest(input)
	return out, req.Send()
}

// DeleteSubscriberNotificationWithContext is the same as DeleteSubscriberNotification with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSubscriberNotification for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityLake) DeleteSubscriberNotificationWithContext(ctx aws.Context, input *DeleteSubscriberNotificationInput, opts ...request.Option) (*DeleteSubscriberNotificationOutput, error) {
	req, out := c.DeleteSubscriberNotificationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeregisterDataLakeDelegatedAdministrator = "DeregisterDataLakeDelegatedAdministrator"

// DeregisterDataLakeDelegatedAdministratorRequest generates a "aws/request.Request" representing the
// client's request for the DeregisterDataLakeDelegatedAdministrator operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeregisterDataLakeDelegatedAdministrator for more information on using the DeregisterDataLakeDelegatedAdministrator
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeregisterDataLakeDelegatedAdministratorRequest method.
//	req, resp := client.DeregisterDataLakeDelegatedAdministratorRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/DeregisterDataLakeDelegatedAdministrator
func (c *SecurityLake) DeregisterDataLakeDelegatedAdministratorRequest(input *DeregisterDataLakeDelegatedAdministratorInput) (req *request.Request, output *DeregisterDataLakeDelegatedAdministratorOutput) {
	op := &request.Operation{
		Name:       opDeregisterDataLakeDelegatedAdministrator,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/datalake/delegate",
	}

	if input == nil {
		input = &DeregisterDataLakeDelegatedAdministratorInput{}
	}

	output = &DeregisterDataLakeDelegatedAdministratorOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeregisterDataLakeDelegatedAdministrator API operation for Amazon Security Lake.
//
// Deletes the Amazon Security Lake delegated administrator account for the
// organization. This API can only be called by the organization management
// account. The organization management account cannot be the delegated administrator
// account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Security Lake's
// API operation DeregisterDataLakeDelegatedAdministrator for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The request is malformed or contains an error such as an invalid parameter
//     value or a missing required parameter.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - InternalServerException
//     Internal service exceptions are sometimes caused by transient issues. Before
//     you start troubleshooting, perform the operation again.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action. Access denied errors
//     appear when Amazon Security Lake explicitly or implicitly denies an authorization
//     request. An explicit denial occurs when a policy contains a Deny statement
//     for the specific Amazon Web Services action. An implicit denial occurs when
//     there is no applicable Deny statement and also no applicable Allow statement.
//
//   - ConflictException
//     Occurs when a conflict with a previous successful write is detected. This
//     generally occurs when the previous write did not have time to propagate to
//     the host serving the current request. A retry (with appropriate backoff logic)
//     is the recommended response to this exception.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/DeregisterDataLakeDelegatedAdministrator
func (c *SecurityLake) DeregisterDataLakeDelegatedAdministrator(input *DeregisterDataLakeDelegatedAdministratorInput) (*DeregisterDataLakeDelegatedAdministratorOutput, error) {
	req, out := c.DeregisterDataLakeDelegatedAdministratorRequest(input)
	return out, req.Send()
}

// DeregisterDataLakeDelegatedAdministratorWithContext is the same as DeregisterDataLakeDelegatedAdministrator with the addition of
// the ability to pass a context and additional request options.
//
// See DeregisterDataLakeDelegatedAdministrator for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityLake) DeregisterDataLakeDelegatedAdministratorWithContext(ctx aws.Context, input *DeregisterDataLakeDelegatedAdministratorInput, opts ...request.Option) (*DeregisterDataLakeDelegatedAdministratorOutput, error) {
	req, out := c.DeregisterDataLakeDelegatedAdministratorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDataLakeExceptionSubscription = "GetDataLakeExceptionSubscription"

// GetDataLakeExceptionSubscriptionRequest generates a "aws/request.Request" representing the
// client's request for the GetDataLakeExceptionSubscription operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDataLakeExceptionSubscription for more information on using the GetDataLakeExceptionSubscription
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetDataLakeExceptionSubscriptionRequest method.
//	req, resp := client.GetDataLakeExceptionSubscriptionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/GetDataLakeExceptionSubscription
func (c *SecurityLake) GetDataLakeExceptionSubscriptionRequest(input *GetDataLakeExceptionSubscriptionInput) (req *request.Request, output *GetDataLakeExceptionSubscriptionOutput) {
	op := &request.Operation{
		Name:       opGetDataLakeExceptionSubscription,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/datalake/exceptions/subscription",
	}

	if input == nil {
		input = &GetDataLakeExceptionSubscriptionInput{}
	}

	output = &GetDataLakeExceptionSubscriptionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDataLakeExceptionSubscription API operation for Amazon Security Lake.
//
// Retrieves the details of exception notifications for the account in Amazon
// Security Lake.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Security Lake's
// API operation GetDataLakeExceptionSubscription for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The request is malformed or contains an error such as an invalid parameter
//     value or a missing required parameter.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - InternalServerException
//     Internal service exceptions are sometimes caused by transient issues. Before
//     you start troubleshooting, perform the operation again.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action. Access denied errors
//     appear when Amazon Security Lake explicitly or implicitly denies an authorization
//     request. An explicit denial occurs when a policy contains a Deny statement
//     for the specific Amazon Web Services action. An implicit denial occurs when
//     there is no applicable Deny statement and also no applicable Allow statement.
//
//   - ConflictException
//     Occurs when a conflict with a previous successful write is detected. This
//     generally occurs when the previous write did not have time to propagate to
//     the host serving the current request. A retry (with appropriate backoff logic)
//     is the recommended response to this exception.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/GetDataLakeExceptionSubscription
func (c *SecurityLake) GetDataLakeExceptionSubscription(input *GetDataLakeExceptionSubscriptionInput) (*GetDataLakeExceptionSubscriptionOutput, error) {
	req, out := c.GetDataLakeExceptionSubscriptionRequest(input)
	return out, req.Send()
}

// GetDataLakeExceptionSubscriptionWithContext is the same as GetDataLakeExceptionSubscription with the addition of
// the ability to pass a context and additional request options.
//
// See GetDataLakeExceptionSubscription for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityLake) GetDataLakeExceptionSubscriptionWithContext(ctx aws.Context, input *GetDataLakeExceptionSubscriptionInput, opts ...request.Option) (*GetDataLakeExceptionSubscriptionOutput, error) {
	req, out := c.GetDataLakeExceptionSubscriptionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDataLakeOrganizationConfiguration = "GetDataLakeOrganizationConfiguration"

// GetDataLakeOrganizationConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the GetDataLakeOrganizationConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDataLakeOrganizationConfiguration for more information on using the GetDataLakeOrganizationConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetDataLakeOrganizationConfigurationRequest method.
//	req, resp := client.GetDataLakeOrganizationConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/GetDataLakeOrganizationConfiguration
func (c *SecurityLake) GetDataLakeOrganizationConfigurationRequest(input *GetDataLakeOrganizationConfigurationInput) (req *request.Request, output *GetDataLakeOrganizationConfigurationOutput) {
	op := &request.Operation{
		Name:       opGetDataLakeOrganizationConfiguration,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/datalake/organization/configuration",
	}

	if input == nil {
		input = &GetDataLakeOrganizationConfigurationInput{}
	}

	output = &GetDataLakeOrganizationConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDataLakeOrganizationConfiguration API operation for Amazon Security Lake.
//
// Retrieves the configuration that will be automatically set up for accounts
// added to the organization after the organization has onboarded to Amazon
// Security Lake. This API does not take input parameters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Security Lake's
// API operation GetDataLakeOrganizationConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The request is malformed or contains an error such as an invalid parameter
//     value or a missing required parameter.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - InternalServerException
//     Internal service exceptions are sometimes caused by transient issues. Before
//     you start troubleshooting, perform the operation again.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action. Access denied errors
//     appear when Amazon Security Lake explicitly or implicitly denies an authorization
//     request. An explicit denial occurs when a policy contains a Deny statement
//     for the specific Amazon Web Services action. An implicit denial occurs when
//     there is no applicable Deny statement and also no applicable Allow statement.
//
//   - ConflictException
//     Occurs when a conflict with a previous successful write is detected. This
//     generally occurs when the previous write did not have time to propagate to
//     the host serving the current request. A retry (with appropriate backoff logic)
//     is the recommended response to this exception.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/GetDataLakeOrganizationConfiguration
func (c *SecurityLake) GetDataLakeOrganizationConfiguration(input *GetDataLakeOrganizationConfigurationInput) (*GetDataLakeOrganizationConfigurationOutput, error) {
	req, out := c.GetDataLakeOrganizationConfigurationRequest(input)
	return out, req.Send()
}

// GetDataLakeOrganizationConfigurationWithContext is the same as GetDataLakeOrganizationConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See GetDataLakeOrganizationConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityLake) GetDataLakeOrganizationConfigurationWithContext(ctx aws.Context, input *GetDataLakeOrganizationConfigurationInput, opts ...request.Option) (*GetDataLakeOrganizationConfigurationOutput, error) {
	req, out := c.GetDataLakeOrganizationConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDataLakeSources = "GetDataLakeSources"

// GetDataLakeSourcesRequest generates a "aws/request.Request" representing the
// client's request for the GetDataLakeSources operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDataLakeSources for more information on using the GetDataLakeSources
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetDataLakeSourcesRequest method.
//	req, resp := client.GetDataLakeSourcesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/GetDataLakeSources
func (c *SecurityLake) GetDataLakeSourcesRequest(input *GetDataLakeSourcesInput) (req *request.Request, output *GetDataLakeSourcesOutput) {
	op := &request.Operation{
		Name:       opGetDataLakeSources,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/datalake/sources",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetDataLakeSourcesInput{}
	}

	output = &GetDataLakeSourcesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDataLakeSources API operation for Amazon Security Lake.
//
// Retrieves a snapshot of the current Region, including whether Amazon Security
// Lake is enabled for those accounts and which sources Security Lake is collecting
// data from.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Security Lake's
// API operation GetDataLakeSources for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The request is malformed or contains an error such as an invalid parameter
//     value or a missing required parameter.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - InternalServerException
//     Internal service exceptions are sometimes caused by transient issues. Before
//     you start troubleshooting, perform the operation again.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action. Access denied errors
//     appear when Amazon Security Lake explicitly or implicitly denies an authorization
//     request. An explicit denial occurs when a policy contains a Deny statement
//     for the specific Amazon Web Services action. An implicit denial occurs when
//     there is no applicable Deny statement and also no applicable Allow statement.
//
//   - ConflictException
//     Occurs when a conflict with a previous successful write is detected. This
//     generally occurs when the previous write did not have time to propagate to
//     the host serving the current request. A retry (with appropriate backoff logic)
//     is the recommended response to this exception.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/GetDataLakeSources
func (c *SecurityLake) GetDataLakeSources(input *GetDataLakeSourcesInput) (*GetDataLakeSourcesOutput, error) {
	req, out := c.GetDataLakeSourcesRequest(input)
	return out, req.Send()
}

// GetDataLakeSourcesWithContext is the same as GetDataLakeSources with the addition of
// the ability to pass a context and additional request options.
//
// See GetDataLakeSources for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityLake) GetDataLakeSourcesWithContext(ctx aws.Context, input *GetDataLakeSourcesInput, opts ...request.Option) (*GetDataLakeSourcesOutput, error) {
	req, out := c.GetDataLakeSourcesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetDataLakeSourcesPages iterates over the pages of a GetDataLakeSources operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetDataLakeSources method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a GetDataLakeSources operation.
//	pageNum := 0
//	err := client.GetDataLakeSourcesPages(params,
//	    func(page *securitylake.GetDataLakeSourcesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SecurityLake) GetDataLakeSourcesPages(input *GetDataLakeSourcesInput, fn func(*GetDataLakeSourcesOutput, bool) bool) error {
	return c.GetDataLakeSourcesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetDataLakeSourcesPagesWithContext same as GetDataLakeSourcesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityLake) GetDataLakeSourcesPagesWithContext(ctx aws.Context, input *GetDataLakeSourcesInput, fn func(*GetDataLakeSourcesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetDataLakeSourcesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetDataLakeSourcesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetDataLakeSourcesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetSubscriber = "GetSubscriber"

// GetSubscriberRequest generates a "aws/request.Request" representing the
// client's request for the GetSubscriber operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSubscriber for more information on using the GetSubscriber
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetSubscriberRequest method.
//	req, resp := client.GetSubscriberRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/GetSubscriber
func (c *SecurityLake) GetSubscriberRequest(input *GetSubscriberInput) (req *request.Request, output *GetSubscriberOutput) {
	op := &request.Operation{
		Name:       opGetSubscriber,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/subscribers/{subscriberId}",
	}

	if input == nil {
		input = &GetSubscriberInput{}
	}

	output = &GetSubscriberOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSubscriber API operation for Amazon Security Lake.
//
// Retrieves the subscription information for the specified subscription ID.
// You can get information about a specific subscriber.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Security Lake's
// API operation GetSubscriber for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The request is malformed or contains an error such as an invalid parameter
//     value or a missing required parameter.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - InternalServerException
//     Internal service exceptions are sometimes caused by transient issues. Before
//     you start troubleshooting, perform the operation again.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action. Access denied errors
//     appear when Amazon Security Lake explicitly or implicitly denies an authorization
//     request. An explicit denial occurs when a policy contains a Deny statement
//     for the specific Amazon Web Services action. An implicit denial occurs when
//     there is no applicable Deny statement and also no applicable Allow statement.
//
//   - ConflictException
//     Occurs when a conflict with a previous successful write is detected. This
//     generally occurs when the previous write did not have time to propagate to
//     the host serving the current request. A retry (with appropriate backoff logic)
//     is the recommended response to this exception.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/GetSubscriber
func (c *SecurityLake) GetSubscriber(input *GetSubscriberInput) (*GetSubscriberOutput, error) {
	req, out := c.GetSubscriberRequest(input)
	return out, req.Send()
}

// GetSubscriberWithContext is the same as GetSubscriber with the addition of
// the ability to pass a context and additional request options.
//
// See GetSubscriber for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityLake) GetSubscriberWithContext(ctx aws.Context, input *GetSubscriberInput, opts ...request.Option) (*GetSubscriberOutput, error) {
	req, out := c.GetSubscriberRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListDataLakeExceptions = "ListDataLakeExceptions"

// ListDataLakeExceptionsRequest generates a "aws/request.Request" representing the
// client's request for the ListDataLakeExceptions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDataLakeExceptions for more information on using the ListDataLakeExceptions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListDataLakeExceptionsRequest method.
//	req, resp := client.ListDataLakeExceptionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/ListDataLakeExceptions
func (c *SecurityLake) ListDataLakeExceptionsRequest(input *ListDataLakeExceptionsInput) (req *request.Request, output *ListDataLakeExceptionsOutput) {
	op := &request.Operation{
		Name:       opListDataLakeExceptions,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/datalake/exceptions",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDataLakeExceptionsInput{}
	}

	output = &ListDataLakeExceptionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDataLakeExceptions API operation for Amazon Security Lake.
//
// Lists the Amazon Security Lake exceptions that you can use to find the source
// of problems and fix them.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Security Lake's
// API operation ListDataLakeExceptions for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The request is malformed or contains an error such as an invalid parameter
//     value or a missing required parameter.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - InternalServerException
//     Internal service exceptions are sometimes caused by transient issues. Before
//     you start troubleshooting, perform the operation again.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action. Access denied errors
//     appear when Amazon Security Lake explicitly or implicitly denies an authorization
//     request. An explicit denial occurs when a policy contains a Deny statement
//     for the specific Amazon Web Services action. An implicit denial occurs when
//     there is no applicable Deny statement and also no applicable Allow statement.
//
//   - ConflictException
//     Occurs when a conflict with a previous successful write is detected. This
//     generally occurs when the previous write did not have time to propagate to
//     the host serving the current request. A retry (with appropriate backoff logic)
//     is the recommended response to this exception.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/ListDataLakeExceptions
func (c *SecurityLake) ListDataLakeExceptions(input *ListDataLakeExceptionsInput) (*ListDataLakeExceptionsOutput, error) {
	req, out := c.ListDataLakeExceptionsRequest(input)
	return out, req.Send()
}

// ListDataLakeExceptionsWithContext is the same as ListDataLakeExceptions with the addition of
// the ability to pass a context and additional request options.
//
// See ListDataLakeExceptions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityLake) ListDataLakeExceptionsWithContext(ctx aws.Context, input *ListDataLakeExceptionsInput, opts ...request.Option) (*ListDataLakeExceptionsOutput, error) {
	req, out := c.ListDataLakeExceptionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDataLakeExceptionsPages iterates over the pages of a ListDataLakeExceptions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDataLakeExceptions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListDataLakeExceptions operation.
//	pageNum := 0
//	err := client.ListDataLakeExceptionsPages(params,
//	    func(page *securitylake.ListDataLakeExceptionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SecurityLake) ListDataLakeExceptionsPages(input *ListDataLakeExceptionsInput, fn func(*ListDataLakeExceptionsOutput, bool) bool) error {
	return c.ListDataLakeExceptionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDataLakeExceptionsPagesWithContext same as ListDataLakeExceptionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityLake) ListDataLakeExceptionsPagesWithContext(ctx aws.Context, input *ListDataLakeExceptionsInput, fn func(*ListDataLakeExceptionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDataLakeExceptionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDataLakeExceptionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDataLakeExceptionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListDataLakes = "ListDataLakes"

// ListDataLakesRequest generates a "aws/request.Request" representing the
// client's request for the ListDataLakes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDataLakes for more information on using the ListDataLakes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListDataLakesRequest method.
//	req, resp := client.ListDataLakesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/ListDataLakes
func (c *SecurityLake) ListDataLakesRequest(input *ListDataLakesInput) (req *request.Request, output *ListDataLakesOutput) {
	op := &request.Operation{
		Name:       opListDataLakes,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/datalakes",
	}

	if input == nil {
		input = &ListDataLakesInput{}
	}

	output = &ListDataLakesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDataLakes API operation for Amazon Security Lake.
//
// Retrieves the Amazon Security Lake configuration object for the specified
// Amazon Web Services Regions. You can use this operation to determine whether
// Security Lake is enabled for a Region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Security Lake's
// API operation ListDataLakes for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The request is malformed or contains an error such as an invalid parameter
//     value or a missing required parameter.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - InternalServerException
//     Internal service exceptions are sometimes caused by transient issues. Before
//     you start troubleshooting, perform the operation again.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action. Access denied errors
//     appear when Amazon Security Lake explicitly or implicitly denies an authorization
//     request. An explicit denial occurs when a policy contains a Deny statement
//     for the specific Amazon Web Services action. An implicit denial occurs when
//     there is no applicable Deny statement and also no applicable Allow statement.
//
//   - ConflictException
//     Occurs when a conflict with a previous successful write is detected. This
//     generally occurs when the previous write did not have time to propagate to
//     the host serving the current request. A retry (with appropriate backoff logic)
//     is the recommended response to this exception.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/ListDataLakes
func (c *SecurityLake) ListDataLakes(input *ListDataLakesInput) (*ListDataLakesOutput, error) {
	req, out := c.ListDataLakesRequest(input)
	return out, req.Send()
}

// ListDataLakesWithContext is the same as ListDataLakes with the addition of
// the ability to pass a context and additional request options.
//
// See ListDataLakes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityLake) ListDataLakesWithContext(ctx aws.Context, input *ListDataLakesInput, opts ...request.Option) (*ListDataLakesOutput, error) {
	req, out := c.ListDataLakesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListLogSources = "ListLogSources"

// ListLogSourcesRequest generates a "aws/request.Request" representing the
// client's request for the ListLogSources operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListLogSources for more information on using the ListLogSources
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListLogSourcesRequest method.
//	req, resp := client.ListLogSourcesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/ListLogSources
func (c *SecurityLake) ListLogSourcesRequest(input *ListLogSourcesInput) (req *request.Request, output *ListLogSourcesOutput) {
	op := &request.Operation{
		Name:       opListLogSources,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/datalake/logsources/list",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListLogSourcesInput{}
	}

	output = &ListLogSourcesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListLogSources API operation for Amazon Security Lake.
//
// Retrieves the log sources in the current Amazon Web Services Region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Security Lake's
// API operation ListLogSources for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The request is malformed or contains an error such as an invalid parameter
//     value or a missing required parameter.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - InternalServerException
//     Internal service exceptions are sometimes caused by transient issues. Before
//     you start troubleshooting, perform the operation again.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action. Access denied errors
//     appear when Amazon Security Lake explicitly or implicitly denies an authorization
//     request. An explicit denial occurs when a policy contains a Deny statement
//     for the specific Amazon Web Services action. An implicit denial occurs when
//     there is no applicable Deny statement and also no applicable Allow statement.
//
//   - ConflictException
//     Occurs when a conflict with a previous successful write is detected. This
//     generally occurs when the previous write did not have time to propagate to
//     the host serving the current request. A retry (with appropriate backoff logic)
//     is the recommended response to this exception.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/ListLogSources
func (c *SecurityLake) ListLogSources(input *ListLogSourcesInput) (*ListLogSourcesOutput, error) {
	req, out := c.ListLogSourcesRequest(input)
	return out, req.Send()
}

// ListLogSourcesWithContext is the same as ListLogSources with the addition of
// the ability to pass a context and additional request options.
//
// See ListLogSources for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityLake) ListLogSourcesWithContext(ctx aws.Context, input *ListLogSourcesInput, opts ...request.Option) (*ListLogSourcesOutput, error) {
	req, out := c.ListLogSourcesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListLogSourcesPages iterates over the pages of a ListLogSources operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListLogSources method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListLogSources operation.
//	pageNum := 0
//	err := client.ListLogSourcesPages(params,
//	    func(page *securitylake.ListLogSourcesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SecurityLake) ListLogSourcesPages(input *ListLogSourcesInput, fn func(*ListLogSourcesOutput, bool) bool) error {
	return c.ListLogSourcesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListLogSourcesPagesWithContext same as ListLogSourcesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityLake) ListLogSourcesPagesWithContext(ctx aws.Context, input *ListLogSourcesInput, fn func(*ListLogSourcesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListLogSourcesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListLogSourcesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListLogSourcesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListSubscribers = "ListSubscribers"

// ListSubscribersRequest generates a "aws/request.Request" representing the
// client's request for the ListSubscribers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSubscribers for more information on using the ListSubscribers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListSubscribersRequest method.
//	req, resp := client.ListSubscribersRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/ListSubscribers
func (c *SecurityLake) ListSubscribersRequest(input *ListSubscribersInput) (req *request.Request, output *ListSubscribersOutput) {
	op := &request.Operation{
		Name:       opListSubscribers,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/subscribers",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSubscribersInput{}
	}

	output = &ListSubscribersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSubscribers API operation for Amazon Security Lake.
//
// List all subscribers for the specific Amazon Security Lake account ID. You
// can retrieve a list of subscriptions associated with a specific organization
// or Amazon Web Services account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Security Lake's
// API operation ListSubscribers for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The request is malformed or contains an error such as an invalid parameter
//     value or a missing required parameter.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - InternalServerException
//     Internal service exceptions are sometimes caused by transient issues. Before
//     you start troubleshooting, perform the operation again.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action. Access denied errors
//     appear when Amazon Security Lake explicitly or implicitly denies an authorization
//     request. An explicit denial occurs when a policy contains a Deny statement
//     for the specific Amazon Web Services action. An implicit denial occurs when
//     there is no applicable Deny statement and also no applicable Allow statement.
//
//   - ConflictException
//     Occurs when a conflict with a previous successful write is detected. This
//     generally occurs when the previous write did not have time to propagate to
//     the host serving the current request. A retry (with appropriate backoff logic)
//     is the recommended response to this exception.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/ListSubscribers
func (c *SecurityLake) ListSubscribers(input *ListSubscribersInput) (*ListSubscribersOutput, error) {
	req, out := c.ListSubscribersRequest(input)
	return out, req.Send()
}

// ListSubscribersWithContext is the same as ListSubscribers with the addition of
// the ability to pass a context and additional request options.
//
// See ListSubscribers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityLake) ListSubscribersWithContext(ctx aws.Context, input *ListSubscribersInput, opts ...request.Option) (*ListSubscribersOutput, error) {
	req, out := c.ListSubscribersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSubscribersPages iterates over the pages of a ListSubscribers operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSubscribers method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListSubscribers operation.
//	pageNum := 0
//	err := client.ListSubscribersPages(params,
//	    func(page *securitylake.ListSubscribersOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SecurityLake) ListSubscribersPages(input *ListSubscribersInput, fn func(*ListSubscribersOutput, bool) bool) error {
	return c.ListSubscribersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSubscribersPagesWithContext same as ListSubscribersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityLake) ListSubscribersPagesWithContext(ctx aws.Context, input *ListSubscribersInput, fn func(*ListSubscribersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSubscribersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSubscribersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListSubscribersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/ListTagsForResource
func (c *SecurityLake) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/tags/{resourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon Security Lake.
//
// Retrieves the tags (keys and values) that are associated with an Amazon Security
// Lake resource: a subscriber, or the data lake configuration for your Amazon
// Web Services account in a particular Amazon Web Services Region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Security Lake's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The request is malformed or contains an error such as an invalid parameter
//     value or a missing required parameter.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - InternalServerException
//     Internal service exceptions are sometimes caused by transient issues. Before
//     you start troubleshooting, perform the operation again.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action. Access denied errors
//     appear when Amazon Security Lake explicitly or implicitly denies an authorization
//     request. An explicit denial occurs when a policy contains a Deny statement
//     for the specific Amazon Web Services action. An implicit denial occurs when
//     there is no applicable Deny statement and also no applicable Allow statement.
//
//   - ConflictException
//     Occurs when a conflict with a previous successful write is detected. This
//     generally occurs when the previous write did not have time to propagate to
//     the host serving the current request. A retry (with appropriate backoff logic)
//     is the recommended response to this exception.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/ListTagsForResource
func (c *SecurityLake) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityLake) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRegisterDataLakeDelegatedAdministrator = "RegisterDataLakeDelegatedAdministrator"

// RegisterDataLakeDelegatedAdministratorRequest generates a "aws/request.Request" representing the
// client's request for the RegisterDataLakeDelegatedAdministrator operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RegisterDataLakeDelegatedAdministrator for more information on using the RegisterDataLakeDelegatedAdministrator
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the RegisterDataLakeDelegatedAdministratorRequest method.
//	req, resp := client.RegisterDataLakeDelegatedAdministratorRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/RegisterDataLakeDelegatedAdministrator
func (c *SecurityLake) RegisterDataLakeDelegatedAdministratorRequest(input *RegisterDataLakeDelegatedAdministratorInput) (req *request.Request, output *RegisterDataLakeDelegatedAdministratorOutput) {
	op := &request.Operation{
		Name:       opRegisterDataLakeDelegatedAdministrator,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/datalake/delegate",
	}

	if input == nil {
		input = &RegisterDataLakeDelegatedAdministratorInput{}
	}

	output = &RegisterDataLakeDelegatedAdministratorOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// RegisterDataLakeDelegatedAdministrator API operation for Amazon Security Lake.
//
// Designates the Amazon Security Lake delegated administrator account for the
// organization. This API can only be called by the organization management
// account. The organization management account cannot be the delegated administrator
// account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Security Lake's
// API operation RegisterDataLakeDelegatedAdministrator for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The request is malformed or contains an error such as an invalid parameter
//     value or a missing required parameter.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - InternalServerException
//     Internal service exceptions are sometimes caused by transient issues. Before
//     you start troubleshooting, perform the operation again.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action. Access denied errors
//     appear when Amazon Security Lake explicitly or implicitly denies an authorization
//     request. An explicit denial occurs when a policy contains a Deny statement
//     for the specific Amazon Web Services action. An implicit denial occurs when
//     there is no applicable Deny statement and also no applicable Allow statement.
//
//   - ConflictException
//     Occurs when a conflict with a previous successful write is detected. This
//     generally occurs when the previous write did not have time to propagate to
//     the host serving the current request. A retry (with appropriate backoff logic)
//     is the recommended response to this exception.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/RegisterDataLakeDelegatedAdministrator
func (c *SecurityLake) RegisterDataLakeDelegatedAdministrator(input *RegisterDataLakeDelegatedAdministratorInput) (*RegisterDataLakeDelegatedAdministratorOutput, error) {
	req, out := c.RegisterDataLakeDelegatedAdministratorRequest(input)
	return out, req.Send()
}

// RegisterDataLakeDelegatedAdministratorWithContext is the same as RegisterDataLakeDelegatedAdministrator with the addition of
// the ability to pass a context and additional request options.
//
// See RegisterDataLakeDelegatedAdministrator for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityLake) RegisterDataLakeDelegatedAdministratorWithContext(ctx aws.Context, input *RegisterDataLakeDelegatedAdministratorInput, opts ...request.Option) (*RegisterDataLakeDelegatedAdministratorOutput, error) {
	req, out := c.RegisterDataLakeDelegatedAdministratorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/TagResource
func (c *SecurityLake) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/tags/{resourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Amazon Security Lake.
//
// Adds or updates one or more tags that are associated with an Amazon Security
// Lake resource: a subscriber, or the data lake configuration for your Amazon
// Web Services account in a particular Amazon Web Services Region. A tag is
// a label that you can define and associate with Amazon Web Services resources.
// Each tag consists of a required tag key and an associated tag value. A tag
// key is a general label that acts as a category for a more specific tag value.
// A tag value acts as a descriptor for a tag key. Tags can help you identify,
// categorize, and manage resources in different ways, such as by owner, environment,
// or other criteria. For more information, see Tagging Amazon Security Lake
// resources (https://docs.aws.amazon.com/security-lake/latest/userguide/tagging-resources.html)
// in the Amazon Security Lake User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Security Lake's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The request is malformed or contains an error such as an invalid parameter
//     value or a missing required parameter.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - InternalServerException
//     Internal service exceptions are sometimes caused by transient issues. Before
//     you start troubleshooting, perform the operation again.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action. Access denied errors
//     appear when Amazon Security Lake explicitly or implicitly denies an authorization
//     request. An explicit denial occurs when a policy contains a Deny statement
//     for the specific Amazon Web Services action. An implicit denial occurs when
//     there is no applicable Deny statement and also no applicable Allow statement.
//
//   - ConflictException
//     Occurs when a conflict with a previous successful write is detected. This
//     generally occurs when the previous write did not have time to propagate to
//     the host serving the current request. A retry (with appropriate backoff logic)
//     is the recommended response to this exception.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/TagResource
func (c *SecurityLake) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityLake) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/UntagResource
func (c *SecurityLake) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/tags/{resourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Amazon Security Lake.
//
// Removes one or more tags (keys and values) from an Amazon Security Lake resource:
// a subscriber, or the data lake configuration for your Amazon Web Services
// account in a particular Amazon Web Services Region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Security Lake's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The request is malformed or contains an error such as an invalid parameter
//     value or a missing required parameter.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - InternalServerException
//     Internal service exceptions are sometimes caused by transient issues. Before
//     you start troubleshooting, perform the operation again.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action. Access denied errors
//     appear when Amazon Security Lake explicitly or implicitly denies an authorization
//     request. An explicit denial occurs when a policy contains a Deny statement
//     for the specific Amazon Web Services action. An implicit denial occurs when
//     there is no applicable Deny statement and also no applicable Allow statement.
//
//   - ConflictException
//     Occurs when a conflict with a previous successful write is detected. This
//     generally occurs when the previous write did not have time to propagate to
//     the host serving the current request. A retry (with appropriate backoff logic)
//     is the recommended response to this exception.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/UntagResource
func (c *SecurityLake) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityLake) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDataLake = "UpdateDataLake"

// UpdateDataLakeRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDataLake operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDataLake for more information on using the UpdateDataLake
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateDataLakeRequest method.
//	req, resp := client.UpdateDataLakeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/UpdateDataLake
func (c *SecurityLake) UpdateDataLakeRequest(input *UpdateDataLakeInput) (req *request.Request, output *UpdateDataLakeOutput) {
	op := &request.Operation{
		Name:       opUpdateDataLake,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/datalake",
	}

	if input == nil {
		input = &UpdateDataLakeInput{}
	}

	output = &UpdateDataLakeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateDataLake API operation for Amazon Security Lake.
//
// Specifies where to store your security data and for how long. You can add
// a rollup Region to consolidate data from multiple Amazon Web Services Regions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Security Lake's
// API operation UpdateDataLake for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The request is malformed or contains an error such as an invalid parameter
//     value or a missing required parameter.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - InternalServerException
//     Internal service exceptions are sometimes caused by transient issues. Before
//     you start troubleshooting, perform the operation again.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action. Access denied errors
//     appear when Amazon Security Lake explicitly or implicitly denies an authorization
//     request. An explicit denial occurs when a policy contains a Deny statement
//     for the specific Amazon Web Services action. An implicit denial occurs when
//     there is no applicable Deny statement and also no applicable Allow statement.
//
//   - ConflictException
//     Occurs when a conflict with a previous successful write is detected. This
//     generally occurs when the previous write did not have time to propagate to
//     the host serving the current request. A retry (with appropriate backoff logic)
//     is the recommended response to this exception.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/UpdateDataLake
func (c *SecurityLake) UpdateDataLake(input *UpdateDataLakeInput) (*UpdateDataLakeOutput, error) {
	req, out := c.UpdateDataLakeRequest(input)
	return out, req.Send()
}

// UpdateDataLakeWithContext is the same as UpdateDataLake with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDataLake for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityLake) UpdateDataLakeWithContext(ctx aws.Context, input *UpdateDataLakeInput, opts ...request.Option) (*UpdateDataLakeOutput, error) {
	req, out := c.UpdateDataLakeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDataLakeExceptionSubscription = "UpdateDataLakeExceptionSubscription"

// UpdateDataLakeExceptionSubscriptionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDataLakeExceptionSubscription operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDataLakeExceptionSubscription for more information on using the UpdateDataLakeExceptionSubscription
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateDataLakeExceptionSubscriptionRequest method.
//	req, resp := client.UpdateDataLakeExceptionSubscriptionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/UpdateDataLakeExceptionSubscription
func (c *SecurityLake) UpdateDataLakeExceptionSubscriptionRequest(input *UpdateDataLakeExceptionSubscriptionInput) (req *request.Request, output *UpdateDataLakeExceptionSubscriptionOutput) {
	op := &request.Operation{
		Name:       opUpdateDataLakeExceptionSubscription,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/datalake/exceptions/subscription",
	}

	if input == nil {
		input = &UpdateDataLakeExceptionSubscriptionInput{}
	}

	output = &UpdateDataLakeExceptionSubscriptionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateDataLakeExceptionSubscription API operation for Amazon Security Lake.
//
// Updates the specified notification subscription in Amazon Security Lake for
// the organization you specify.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Security Lake's
// API operation UpdateDataLakeExceptionSubscription for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The request is malformed or contains an error such as an invalid parameter
//     value or a missing required parameter.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - InternalServerException
//     Internal service exceptions are sometimes caused by transient issues. Before
//     you start troubleshooting, perform the operation again.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action. Access denied errors
//     appear when Amazon Security Lake explicitly or implicitly denies an authorization
//     request. An explicit denial occurs when a policy contains a Deny statement
//     for the specific Amazon Web Services action. An implicit denial occurs when
//     there is no applicable Deny statement and also no applicable Allow statement.
//
//   - ConflictException
//     Occurs when a conflict with a previous successful write is detected. This
//     generally occurs when the previous write did not have time to propagate to
//     the host serving the current request. A retry (with appropriate backoff logic)
//     is the recommended response to this exception.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/UpdateDataLakeExceptionSubscription
func (c *SecurityLake) UpdateDataLakeExceptionSubscription(input *UpdateDataLakeExceptionSubscriptionInput) (*UpdateDataLakeExceptionSubscriptionOutput, error) {
	req, out := c.UpdateDataLakeExceptionSubscriptionRequest(input)
	return out, req.Send()
}

// UpdateDataLakeExceptionSubscriptionWithContext is the same as UpdateDataLakeExceptionSubscription with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDataLakeExceptionSubscription for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityLake) UpdateDataLakeExceptionSubscriptionWithContext(ctx aws.Context, input *UpdateDataLakeExceptionSubscriptionInput, opts ...request.Option) (*UpdateDataLakeExceptionSubscriptionOutput, error) {
	req, out := c.UpdateDataLakeExceptionSubscriptionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateSubscriber = "UpdateSubscriber"

// UpdateSubscriberRequest generates a "aws/request.Request" representing the
// client's request for the UpdateSubscriber operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateSubscriber for more information on using the UpdateSubscriber
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateSubscriberRequest method.
//	req, resp := client.UpdateSubscriberRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/UpdateSubscriber
func (c *SecurityLake) UpdateSubscriberRequest(input *UpdateSubscriberInput) (req *request.Request, output *UpdateSubscriberOutput) {
	op := &request.Operation{
		Name:       opUpdateSubscriber,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/subscribers/{subscriberId}",
	}

	if input == nil {
		input = &UpdateSubscriberInput{}
	}

	output = &UpdateSubscriberOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateSubscriber API operation for Amazon Security Lake.
//
// Updates an existing subscription for the given Amazon Security Lake account
// ID. You can update a subscriber by changing the sources that the subscriber
// consumes data from.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Security Lake's
// API operation UpdateSubscriber for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The request is malformed or contains an error such as an invalid parameter
//     value or a missing required parameter.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - InternalServerException
//     Internal service exceptions are sometimes caused by transient issues. Before
//     you start troubleshooting, perform the operation again.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action. Access denied errors
//     appear when Amazon Security Lake explicitly or implicitly denies an authorization
//     request. An explicit denial occurs when a policy contains a Deny statement
//     for the specific Amazon Web Services action. An implicit denial occurs when
//     there is no applicable Deny statement and also no applicable Allow statement.
//
//   - ConflictException
//     Occurs when a conflict with a previous successful write is detected. This
//     generally occurs when the previous write did not have time to propagate to
//     the host serving the current request. A retry (with appropriate backoff logic)
//     is the recommended response to this exception.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/UpdateSubscriber
func (c *SecurityLake) UpdateSubscriber(input *UpdateSubscriberInput) (*UpdateSubscriberOutput, error) {
	req, out := c.UpdateSubscriberRequest(input)
	return out, req.Send()
}

// UpdateSubscriberWithContext is the same as UpdateSubscriber with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateSubscriber for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityLake) UpdateSubscriberWithContext(ctx aws.Context, input *UpdateSubscriberInput, opts ...request.Option) (*UpdateSubscriberOutput, error) {
	req, out := c.UpdateSubscriberRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateSubscriberNotification = "UpdateSubscriberNotification"

// UpdateSubscriberNotificationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateSubscriberNotification operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateSubscriberNotification for more information on using the UpdateSubscriberNotification
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateSubscriberNotificationRequest method.
//	req, resp := client.UpdateSubscriberNotificationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/UpdateSubscriberNotification
func (c *SecurityLake) UpdateSubscriberNotificationRequest(input *UpdateSubscriberNotificationInput) (req *request.Request, output *UpdateSubscriberNotificationOutput) {
	op := &request.Operation{
		Name:       opUpdateSubscriberNotification,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/subscribers/{subscriberId}/notification",
	}

	if input == nil {
		input = &UpdateSubscriberNotificationInput{}
	}

	output = &UpdateSubscriberNotificationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateSubscriberNotification API operation for Amazon Security Lake.
//
// Updates an existing notification method for the subscription (SQS or HTTPs
// endpoint) or switches the notification subscription endpoint for a subscriber.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Security Lake's
// API operation UpdateSubscriberNotification for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The request is malformed or contains an error such as an invalid parameter
//     value or a missing required parameter.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - InternalServerException
//     Internal service exceptions are sometimes caused by transient issues. Before
//     you start troubleshooting, perform the operation again.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action. Access denied errors
//     appear when Amazon Security Lake explicitly or implicitly denies an authorization
//     request. An explicit denial occurs when a policy contains a Deny statement
//     for the specific Amazon Web Services action. An implicit denial occurs when
//     there is no applicable Deny statement and also no applicable Allow statement.
//
//   - ConflictException
//     Occurs when a conflict with a previous successful write is detected. This
//     generally occurs when the previous write did not have time to propagate to
//     the host serving the current request. A retry (with appropriate backoff logic)
//     is the recommended response to this exception.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/UpdateSubscriberNotification
func (c *SecurityLake) UpdateSubscriberNotification(input *UpdateSubscriberNotificationInput) (*UpdateSubscriberNotificationOutput, error) {
	req, out := c.UpdateSubscriberNotificationRequest(input)
	return out, req.Send()
}

// UpdateSubscriberNotificationWithContext is the same as UpdateSubscriberNotification with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateSubscriberNotification for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityLake) UpdateSubscriberNotificationWithContext(ctx aws.Context, input *UpdateSubscriberNotificationInput, opts ...request.Option) (*UpdateSubscriberNotificationOutput, error) {
	req, out := c.UpdateSubscriberNotificationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// You do not have sufficient access to perform this action. Access denied errors
// appear when Amazon Security Lake explicitly or implicitly denies an authorization
// request. An explicit denial occurs when a policy contains a Deny statement
// for the specific Amazon Web Services action. An implicit denial occurs when
// there is no applicable Deny statement and also no applicable Allow statement.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// A coded string to provide more information about the access denied exception.
	// You can use the error code to check the exception type.
	ErrorCode *string `locationName:"errorCode" type:"string"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The AWS identity.
type AwsIdentity struct {
	_ struct{} `type:"structure"`

	// The external ID used to estalish trust relationship with the AWS identity.
	//
	// ExternalId is a required field
	ExternalId *string `locationName:"externalId" min:"2" type:"string" required:"true"`

	// The AWS identity principal.
	//
	// Principal is a required field
	Principal *string `locationName:"principal" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsIdentity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsIdentity) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AwsIdentity) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AwsIdentity"}
	if s.ExternalId == nil {
		invalidParams.Add(request.NewErrParamRequired("ExternalId"))
	}
	if s.ExternalId != nil && len(*s.ExternalId) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("ExternalId", 2))
	}
	if s.Principal == nil {
		invalidParams.Add(request.NewErrParamRequired("Principal"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExternalId sets the ExternalId field's value.
func (s *AwsIdentity) SetExternalId(v string) *AwsIdentity {
	s.ExternalId = &v
	return s
}

// SetPrincipal sets the Principal field's value.
func (s *AwsIdentity) SetPrincipal(v string) *AwsIdentity {
	s.Principal = &v
	return s
}

// The Security Lake logs source configuration file describes the information
// needed to generate Security Lake logs.
type AwsLogSourceConfiguration struct {
	_ struct{} `type:"structure"`

	// Specify the Amazon Web Services account information where you want to enable
	// Security Lake.
	Accounts []*string `locationName:"accounts" type:"list"`

	// Specify the Regions where you want to enable Security Lake.
	//
	// Regions is a required field
	Regions []*string `locationName:"regions" type:"list" required:"true"`

	// The name for a Amazon Web Services source. This must be a Regionally unique
	// value.
	//
	// SourceName is a required field
	SourceName *string `locationName:"sourceName" type:"string" required:"true" enum:"AwsLogSourceName"`

	// The version for a Amazon Web Services source. This must be a Regionally unique
	// value.
	SourceVersion *string `locationName:"sourceVersion" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsLogSourceConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsLogSourceConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AwsLogSourceConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AwsLogSourceConfiguration"}
	if s.Regions == nil {
		invalidParams.Add(request.NewErrParamRequired("Regions"))
	}
	if s.SourceName == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccounts sets the Accounts field's value.
func (s *AwsLogSourceConfiguration) SetAccounts(v []*string) *AwsLogSourceConfiguration {
	s.Accounts = v
	return s
}

// SetRegions sets the Regions field's value.
func (s *AwsLogSourceConfiguration) SetRegions(v []*string) *AwsLogSourceConfiguration {
	s.Regions = v
	return s
}

// SetSourceName sets the SourceName field's value.
func (s *AwsLogSourceConfiguration) SetSourceName(v string) *AwsLogSourceConfiguration {
	s.SourceName = &v
	return s
}

// SetSourceVersion sets the SourceVersion field's value.
func (s *AwsLogSourceConfiguration) SetSourceVersion(v string) *AwsLogSourceConfiguration {
	s.SourceVersion = &v
	return s
}

// Amazon Security Lake can collect logs and events from natively-supported
// Amazon Web Services services.
type AwsLogSourceResource struct {
	_ struct{} `type:"structure"`

	// The name for a Amazon Web Services source. This must be a Regionally unique
	// value.
	SourceName *string `locationName:"sourceName" type:"string" enum:"AwsLogSourceName"`

	// The version for a Amazon Web Services source. This must be a Regionally unique
	// value.
	SourceVersion *string `locationName:"sourceVersion" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsLogSourceResource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsLogSourceResource) GoString() string {
	return s.String()
}

// SetSourceName sets the SourceName field's value.
func (s *AwsLogSourceResource) SetSourceName(v string) *AwsLogSourceResource {
	s.SourceName = &v
	return s
}

// SetSourceVersion sets the SourceVersion field's value.
func (s *AwsLogSourceResource) SetSourceVersion(v string) *AwsLogSourceResource {
	s.SourceVersion = &v
	return s
}

// The request is malformed or contains an error such as an invalid parameter
// value or a missing required parameter.
type BadRequestException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BadRequestException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BadRequestException) GoString() string {
	return s.String()
}

func newErrorBadRequestException(v protocol.ResponseMetadata) error {
	return &BadRequestException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *BadRequestException) Code() string {
	return "BadRequestException"
}

// Message returns the exception's message.
func (s *BadRequestException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *BadRequestException) OrigErr() error {
	return nil
}

func (s *BadRequestException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *BadRequestException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *BadRequestException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Occurs when a conflict with a previous successful write is detected. This
// generally occurs when the previous write did not have time to propagate to
// the host serving the current request. A retry (with appropriate backoff logic)
// is the recommended response to this exception.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The resource name.
	ResourceName *string `locationName:"resourceName" type:"string"`

	// The resource type.
	ResourceType *string `locationName:"resourceType" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateAwsLogSourceInput struct {
	_ struct{} `type:"structure"`

	// Specify the natively-supported Amazon Web Services service to add as a source
	// in Security Lake.
	//
	// Sources is a required field
	Sources []*AwsLogSourceConfiguration `locationName:"sources" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAwsLogSourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAwsLogSourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAwsLogSourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAwsLogSourceInput"}
	if s.Sources == nil {
		invalidParams.Add(request.NewErrParamRequired("Sources"))
	}
	if s.Sources != nil && len(s.Sources) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Sources", 1))
	}
	if s.Sources != nil {
		for i, v := range s.Sources {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Sources", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSources sets the Sources field's value.
func (s *CreateAwsLogSourceInput) SetSources(v []*AwsLogSourceConfiguration) *CreateAwsLogSourceInput {
	s.Sources = v
	return s
}

type CreateAwsLogSourceOutput struct {
	_ struct{} `type:"structure"`

	// Lists all accounts in which enabling a natively supported Amazon Web Service
	// as a Security Lake source failed. The failure occurred as these accounts
	// are not part of an organization.
	Failed []*string `locationName:"failed" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAwsLogSourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAwsLogSourceOutput) GoString() string {
	return s.String()
}

// SetFailed sets the Failed field's value.
func (s *CreateAwsLogSourceOutput) SetFailed(v []*string) *CreateAwsLogSourceOutput {
	s.Failed = v
	return s
}

type CreateCustomLogSourceInput struct {
	_ struct{} `type:"structure"`

	// The configuration for the third-party custom source.
	//
	// Configuration is a required field
	Configuration *CustomLogSourceConfiguration `locationName:"configuration" type:"structure" required:"true"`

	// The Open Cybersecurity Schema Framework (OCSF) event classes which describes
	// the type of data that the custom source will send to Security Lake. The supported
	// event classes are:
	//
	//    * ACCESS_ACTIVITY
	//
	//    * FILE_ACTIVITY
	//
	//    * KERNEL_ACTIVITY
	//
	//    * KERNEL_EXTENSION
	//
	//    * MEMORY_ACTIVITY
	//
	//    * MODULE_ACTIVITY
	//
	//    * PROCESS_ACTIVITY
	//
	//    * REGISTRY_KEY_ACTIVITY
	//
	//    * REGISTRY_VALUE_ACTIVITY
	//
	//    * RESOURCE_ACTIVITY
	//
	//    * SCHEDULED_JOB_ACTIVITY
	//
	//    * SECURITY_FINDING
	//
	//    * ACCOUNT_CHANGE
	//
	//    * AUTHENTICATION
	//
	//    * AUTHORIZATION
	//
	//    * ENTITY_MANAGEMENT_AUDIT
	//
	//    * DHCP_ACTIVITY
	//
	//    * NETWORK_ACTIVITY
	//
	//    * DNS_ACTIVITY
	//
	//    * FTP_ACTIVITY
	//
	//    * HTTP_ACTIVITY
	//
	//    * RDP_ACTIVITY
	//
	//    * SMB_ACTIVITY
	//
	//    * SSH_ACTIVITY
	//
	//    * CONFIG_STATE
	//
	//    * INVENTORY_INFO
	//
	//    * EMAIL_ACTIVITY
	//
	//    * API_ACTIVITY
	//
	//    * CLOUD_API
	EventClasses []*string `locationName:"eventClasses" type:"list"`

	// Specify the name for a third-party custom source. This must be a Regionally
	// unique value.
	//
	// SourceName is a required field
	SourceName *string `locationName:"sourceName" min:"1" type:"string" required:"true"`

	// Specify the source version for the third-party custom source, to limit log
	// collection to a specific version of custom data source.
	SourceVersion *string `locationName:"sourceVersion" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCustomLogSourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCustomLogSourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateCustomLogSourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateCustomLogSourceInput"}
	if s.Configuration == nil {
		invalidParams.Add(request.NewErrParamRequired("Configuration"))
	}
	if s.SourceName == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceName"))
	}
	if s.SourceName != nil && len(*s.SourceName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SourceName", 1))
	}
	if s.SourceVersion != nil && len(*s.SourceVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SourceVersion", 1))
	}
	if s.Configuration != nil {
		if err := s.Configuration.Validate(); err != nil {
			invalidParams.AddNested("Configuration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfiguration sets the Configuration field's value.
func (s *CreateCustomLogSourceInput) SetConfiguration(v *CustomLogSourceConfiguration) *CreateCustomLogSourceInput {
	s.Configuration = v
	return s
}

// SetEventClasses sets the EventClasses field's value.
func (s *CreateCustomLogSourceInput) SetEventClasses(v []*string) *CreateCustomLogSourceInput {
	s.EventClasses = v
	return s
}

// SetSourceName sets the SourceName field's value.
func (s *CreateCustomLogSourceInput) SetSourceName(v string) *CreateCustomLogSourceInput {
	s.SourceName = &v
	return s
}

// SetSourceVersion sets the SourceVersion field's value.
func (s *CreateCustomLogSourceInput) SetSourceVersion(v string) *CreateCustomLogSourceInput {
	s.SourceVersion = &v
	return s
}

type CreateCustomLogSourceOutput struct {
	_ struct{} `type:"structure"`

	// The created third-party custom source.
	Source *CustomLogSourceResource `locationName:"source" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCustomLogSourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCustomLogSourceOutput) GoString() string {
	return s.String()
}

// SetSource sets the Source field's value.
func (s *CreateCustomLogSourceOutput) SetSource(v *CustomLogSourceResource) *CreateCustomLogSourceOutput {
	s.Source = v
	return s
}

type CreateDataLakeExceptionSubscriptionInput struct {
	_ struct{} `type:"structure"`

	// The expiration period and time-to-live (TTL).
	ExceptionTimeToLive *int64 `locationName:"exceptionTimeToLive" min:"1" type:"long"`

	// The Amazon Web Services account where you want to receive exception notifications.
	//
	// NotificationEndpoint is a required field
	NotificationEndpoint *string `locationName:"notificationEndpoint" type:"string" required:"true"`

	// The subscription protocol to which exception notifications are posted.
	//
	// SubscriptionProtocol is a required field
	SubscriptionProtocol *string `locationName:"subscriptionProtocol" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDataLakeExceptionSubscriptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDataLakeExceptionSubscriptionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDataLakeExceptionSubscriptionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDataLakeExceptionSubscriptionInput"}
	if s.ExceptionTimeToLive != nil && *s.ExceptionTimeToLive < 1 {
		invalidParams.Add(request.NewErrParamMinValue("ExceptionTimeToLive", 1))
	}
	if s.NotificationEndpoint == nil {
		invalidParams.Add(request.NewErrParamRequired("NotificationEndpoint"))
	}
	if s.SubscriptionProtocol == nil {
		invalidParams.Add(request.NewErrParamRequired("SubscriptionProtocol"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExceptionTimeToLive sets the ExceptionTimeToLive field's value.
func (s *CreateDataLakeExceptionSubscriptionInput) SetExceptionTimeToLive(v int64) *CreateDataLakeExceptionSubscriptionInput {
	s.ExceptionTimeToLive = &v
	return s
}

// SetNotificationEndpoint sets the NotificationEndpoint field's value.
func (s *CreateDataLakeExceptionSubscriptionInput) SetNotificationEndpoint(v string) *CreateDataLakeExceptionSubscriptionInput {
	s.NotificationEndpoint = &v
	return s
}

// SetSubscriptionProtocol sets the SubscriptionProtocol field's value.
func (s *CreateDataLakeExceptionSubscriptionInput) SetSubscriptionProtocol(v string) *CreateDataLakeExceptionSubscriptionInput {
	s.SubscriptionProtocol = &v
	return s
}

type CreateDataLakeExceptionSubscriptionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDataLakeExceptionSubscriptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDataLakeExceptionSubscriptionOutput) GoString() string {
	return s.String()
}

type CreateDataLakeInput struct {
	_ struct{} `type:"structure"`

	// Specify the Region or Regions that will contribute data to the rollup region.
	//
	// Configurations is a required field
	Configurations []*DataLakeConfiguration `locationName:"configurations" min:"1" type:"list" required:"true"`

	// The Amazon Resource Name (ARN) used to create and update the Glue table.
	// This table contains partitions generated by the ingestion and normalization
	// of Amazon Web Services log sources and custom sources.
	//
	// MetaStoreManagerRoleArn is a required field
	MetaStoreManagerRoleArn *string `locationName:"metaStoreManagerRoleArn" type:"string" required:"true"`

	// An array of objects, one for each tag to associate with the data lake configuration.
	// For each tag, you must specify both a tag key and a tag value. A tag value
	// cannot be null, but it can be an empty string.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDataLakeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDataLakeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDataLakeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDataLakeInput"}
	if s.Configurations == nil {
		invalidParams.Add(request.NewErrParamRequired("Configurations"))
	}
	if s.Configurations != nil && len(s.Configurations) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Configurations", 1))
	}
	if s.MetaStoreManagerRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("MetaStoreManagerRoleArn"))
	}
	if s.Configurations != nil {
		for i, v := range s.Configurations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Configurations", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurations sets the Configurations field's value.
func (s *CreateDataLakeInput) SetConfigurations(v []*DataLakeConfiguration) *CreateDataLakeInput {
	s.Configurations = v
	return s
}

// SetMetaStoreManagerRoleArn sets the MetaStoreManagerRoleArn field's value.
func (s *CreateDataLakeInput) SetMetaStoreManagerRoleArn(v string) *CreateDataLakeInput {
	s.MetaStoreManagerRoleArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDataLakeInput) SetTags(v []*Tag) *CreateDataLakeInput {
	s.Tags = v
	return s
}

type CreateDataLakeOrganizationConfigurationInput struct {
	_ struct{} `type:"structure"`

	// Enable Security Lake with the specified configuration settings, to begin
	// collecting security data for new accounts in your organization.
	AutoEnableNewAccount []*DataLakeAutoEnableNewAccountConfiguration `locationName:"autoEnableNewAccount" min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDataLakeOrganizationConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDataLakeOrganizationConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDataLakeOrganizationConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDataLakeOrganizationConfigurationInput"}
	if s.AutoEnableNewAccount != nil && len(s.AutoEnableNewAccount) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AutoEnableNewAccount", 1))
	}
	if s.AutoEnableNewAccount != nil {
		for i, v := range s.AutoEnableNewAccount {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AutoEnableNewAccount", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutoEnableNewAccount sets the AutoEnableNewAccount field's value.
func (s *CreateDataLakeOrganizationConfigurationInput) SetAutoEnableNewAccount(v []*DataLakeAutoEnableNewAccountConfiguration) *CreateDataLakeOrganizationConfigurationInput {
	s.AutoEnableNewAccount = v
	return s
}

type CreateDataLakeOrganizationConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDataLakeOrganizationConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDataLakeOrganizationConfigurationOutput) GoString() string {
	return s.String()
}

type CreateDataLakeOutput struct {
	_ struct{} `type:"structure"`

	// The created Security Lake configuration object.
	DataLakes []*DataLakeResource `locationName:"dataLakes" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDataLakeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDataLakeOutput) GoString() string {
	return s.String()
}

// SetDataLakes sets the DataLakes field's value.
func (s *CreateDataLakeOutput) SetDataLakes(v []*DataLakeResource) *CreateDataLakeOutput {
	s.DataLakes = v
	return s
}

type CreateSubscriberInput struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 or Lake Formation access type.
	AccessTypes []*string `locationName:"accessTypes" type:"list" enum:"AccessType"`

	// The supported Amazon Web Services from which logs and events are collected.
	// Security Lake supports log and event collection for natively supported Amazon
	// Web Services.
	//
	// Sources is a required field
	Sources []*LogSourceResource `locationName:"sources" type:"list" required:"true"`

	// The description for your subscriber account in Security Lake.
	SubscriberDescription *string `locationName:"subscriberDescription" type:"string"`

	// The Amazon Web Services identity used to access your data.
	//
	// SubscriberIdentity is a required field
	SubscriberIdentity *AwsIdentity `locationName:"subscriberIdentity" type:"structure" required:"true"`

	// The name of your Security Lake subscriber account.
	//
	// SubscriberName is a required field
	SubscriberName *string `locationName:"subscriberName" type:"string" required:"true"`

	// An array of objects, one for each tag to associate with the subscriber. For
	// each tag, you must specify both a tag key and a tag value. A tag value cannot
	// be null, but it can be an empty string.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSubscriberInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSubscriberInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSubscriberInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateSubscriberInput"}
	if s.Sources == nil {
		invalidParams.Add(request.NewErrParamRequired("Sources"))
	}
	if s.SubscriberIdentity == nil {
		invalidParams.Add(request.NewErrParamRequired("SubscriberIdentity"))
	}
	if s.SubscriberName == nil {
		invalidParams.Add(request.NewErrParamRequired("SubscriberName"))
	}
	if s.Sources != nil {
		for i, v := range s.Sources {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Sources", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.SubscriberIdentity != nil {
		if err := s.SubscriberIdentity.Validate(); err != nil {
			invalidParams.AddNested("SubscriberIdentity", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessTypes sets the AccessTypes field's value.
func (s *CreateSubscriberInput) SetAccessTypes(v []*string) *CreateSubscriberInput {
	s.AccessTypes = v
	return s
}

// SetSources sets the Sources field's value.
func (s *CreateSubscriberInput) SetSources(v []*LogSourceResource) *CreateSubscriberInput {
	s.Sources = v
	return s
}

// SetSubscriberDescription sets the SubscriberDescription field's value.
func (s *CreateSubscriberInput) SetSubscriberDescription(v string) *CreateSubscriberInput {
	s.SubscriberDescription = &v
	return s
}

// SetSubscriberIdentity sets the SubscriberIdentity field's value.
func (s *CreateSubscriberInput) SetSubscriberIdentity(v *AwsIdentity) *CreateSubscriberInput {
	s.SubscriberIdentity = v
	return s
}

// SetSubscriberName sets the SubscriberName field's value.
func (s *CreateSubscriberInput) SetSubscriberName(v string) *CreateSubscriberInput {
	s.SubscriberName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateSubscriberInput) SetTags(v []*Tag) *CreateSubscriberInput {
	s.Tags = v
	return s
}

type CreateSubscriberNotificationInput struct {
	_ struct{} `type:"structure"`

	// Specify the configuration using which you want to create the subscriber notification.
	//
	// Configuration is a required field
	Configuration *NotificationConfiguration `locationName:"configuration" type:"structure" required:"true"`

	// The subscriber ID for the notification subscription.
	//
	// SubscriberId is a required field
	SubscriberId *string `location:"uri" locationName:"subscriberId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSubscriberNotificationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSubscriberNotificationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSubscriberNotificationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateSubscriberNotificationInput"}
	if s.Configuration == nil {
		invalidParams.Add(request.NewErrParamRequired("Configuration"))
	}
	if s.SubscriberId == nil {
		invalidParams.Add(request.NewErrParamRequired("SubscriberId"))
	}
	if s.SubscriberId != nil && len(*s.SubscriberId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SubscriberId", 1))
	}
	if s.Configuration != nil {
		if err := s.Configuration.Validate(); err != nil {
			invalidParams.AddNested("Configuration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfiguration sets the Configuration field's value.
func (s *CreateSubscriberNotificationInput) SetConfiguration(v *NotificationConfiguration) *CreateSubscriberNotificationInput {
	s.Configuration = v
	return s
}

// SetSubscriberId sets the SubscriberId field's value.
func (s *CreateSubscriberNotificationInput) SetSubscriberId(v string) *CreateSubscriberNotificationInput {
	s.SubscriberId = &v
	return s
}

type CreateSubscriberNotificationOutput struct {
	_ struct{} `type:"structure"`

	// The subscriber endpoint to which exception messages are posted.
	SubscriberEndpoint *string `locationName:"subscriberEndpoint" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSubscriberNotificationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSubscriberNotificationOutput) GoString() string {
	return s.String()
}

// SetSubscriberEndpoint sets the SubscriberEndpoint field's value.
func (s *CreateSubscriberNotificationOutput) SetSubscriberEndpoint(v string) *CreateSubscriberNotificationOutput {
	s.SubscriberEndpoint = &v
	return s
}

type CreateSubscriberOutput struct {
	_ struct{} `type:"structure"`

	// Retrieve information about the subscriber created using the CreateSubscriber
	// API.
	Subscriber *SubscriberResource `locationName:"subscriber" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSubscriberOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSubscriberOutput) GoString() string {
	return s.String()
}

// SetSubscriber sets the Subscriber field's value.
func (s *CreateSubscriberOutput) SetSubscriber(v *SubscriberResource) *CreateSubscriberOutput {
	s.Subscriber = v
	return s
}

// The attributes of a third-party custom source.
type CustomLogSourceAttributes struct {
	_ struct{} `type:"structure"`

	// The ARN of the Glue crawler.
	CrawlerArn *string `locationName:"crawlerArn" min:"1" type:"string"`

	// The ARN of the Glue database where results are written, such as: arn:aws:daylight:us-east-1::database/sometable/*.
	DatabaseArn *string `locationName:"databaseArn" min:"1" type:"string"`

	// The ARN of the Glue table.
	TableArn *string `locationName:"tableArn" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomLogSourceAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomLogSourceAttributes) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CustomLogSourceAttributes) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CustomLogSourceAttributes"}
	if s.CrawlerArn != nil && len(*s.CrawlerArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CrawlerArn", 1))
	}
	if s.DatabaseArn != nil && len(*s.DatabaseArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatabaseArn", 1))
	}
	if s.TableArn != nil && len(*s.TableArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TableArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCrawlerArn sets the CrawlerArn field's value.
func (s *CustomLogSourceAttributes) SetCrawlerArn(v string) *CustomLogSourceAttributes {
	s.CrawlerArn = &v
	return s
}

// SetDatabaseArn sets the DatabaseArn field's value.
func (s *CustomLogSourceAttributes) SetDatabaseArn(v string) *CustomLogSourceAttributes {
	s.DatabaseArn = &v
	return s
}

// SetTableArn sets the TableArn field's value.
func (s *CustomLogSourceAttributes) SetTableArn(v string) *CustomLogSourceAttributes {
	s.TableArn = &v
	return s
}

// The configuration for the third-party custom source.
type CustomLogSourceConfiguration struct {
	_ struct{} `type:"structure"`

	// The configuration for the Glue Crawler for the third-party custom source.
	//
	// CrawlerConfiguration is a required field
	CrawlerConfiguration *CustomLogSourceCrawlerConfiguration `locationName:"crawlerConfiguration" type:"structure" required:"true"`

	// The identity of the log provider for the third-party custom source.
	//
	// ProviderIdentity is a required field
	ProviderIdentity *AwsIdentity `locationName:"providerIdentity" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomLogSourceConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomLogSourceConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CustomLogSourceConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CustomLogSourceConfiguration"}
	if s.CrawlerConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("CrawlerConfiguration"))
	}
	if s.ProviderIdentity == nil {
		invalidParams.Add(request.NewErrParamRequired("ProviderIdentity"))
	}
	if s.CrawlerConfiguration != nil {
		if err := s.CrawlerConfiguration.Validate(); err != nil {
			invalidParams.AddNested("CrawlerConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.ProviderIdentity != nil {
		if err := s.ProviderIdentity.Validate(); err != nil {
			invalidParams.AddNested("ProviderIdentity", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCrawlerConfiguration sets the CrawlerConfiguration field's value.
func (s *CustomLogSourceConfiguration) SetCrawlerConfiguration(v *CustomLogSourceCrawlerConfiguration) *CustomLogSourceConfiguration {
	s.CrawlerConfiguration = v
	return s
}

// SetProviderIdentity sets the ProviderIdentity field's value.
func (s *CustomLogSourceConfiguration) SetProviderIdentity(v *AwsIdentity) *CustomLogSourceConfiguration {
	s.ProviderIdentity = v
	return s
}

// The configuration for the Glue Crawler for the third-party custom source.
type CustomLogSourceCrawlerConfiguration struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Identity and Access Management (IAM)
	// role to be used by the Glue crawler. The recommended IAM policies are:
	//
	//    * The managed policy AWSGlueServiceRole
	//
	//    * A custom policy granting access to your Amazon S3 Data Lake
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomLogSourceCrawlerConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomLogSourceCrawlerConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CustomLogSourceCrawlerConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CustomLogSourceCrawlerConfiguration"}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRoleArn sets the RoleArn field's value.
func (s *CustomLogSourceCrawlerConfiguration) SetRoleArn(v string) *CustomLogSourceCrawlerConfiguration {
	s.RoleArn = &v
	return s
}

// The details of the log provider for a third-party custom source.
type CustomLogSourceProvider struct {
	_ struct{} `type:"structure"`

	// The location of the partition in the Amazon S3 bucket for Security Lake.
	Location *string `locationName:"location" type:"string"`

	// The ARN of the IAM role to be used by the entity putting logs into your custom
	// source partition. Security Lake will apply the correct access policies to
	// this role, but you must first manually create the trust policy for this role.
	// The IAM role name must start with the text 'Security Lake'. The IAM role
	// must trust the logProviderAccountId to assume the role.
	RoleArn *string `locationName:"roleArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomLogSourceProvider) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomLogSourceProvider) GoString() string {
	return s.String()
}

// SetLocation sets the Location field's value.
func (s *CustomLogSourceProvider) SetLocation(v string) *CustomLogSourceProvider {
	s.Location = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CustomLogSourceProvider) SetRoleArn(v string) *CustomLogSourceProvider {
	s.RoleArn = &v
	return s
}

// Amazon Security Lake can collect logs and events from third-party custom
// sources.
type CustomLogSourceResource struct {
	_ struct{} `type:"structure"`

	// The attributes of a third-party custom source.
	Attributes *CustomLogSourceAttributes `locationName:"attributes" type:"structure"`

	// The details of the log provider for a third-party custom source.
	Provider *CustomLogSourceProvider `locationName:"provider" type:"structure"`

	// The name for a third-party custom source. This must be a Regionally unique
	// value.
	SourceName *string `locationName:"sourceName" min:"1" type:"string"`

	// The version for a third-party custom source. This must be a Regionally unique
	// value.
	SourceVersion *string `locationName:"sourceVersion" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomLogSourceResource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomLogSourceResource) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CustomLogSourceResource) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CustomLogSourceResource"}
	if s.SourceName != nil && len(*s.SourceName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SourceName", 1))
	}
	if s.SourceVersion != nil && len(*s.SourceVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SourceVersion", 1))
	}
	if s.Attributes != nil {
		if err := s.Attributes.Validate(); err != nil {
			invalidParams.AddNested("Attributes", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributes sets the Attributes field's value.
func (s *CustomLogSourceResource) SetAttributes(v *CustomLogSourceAttributes) *CustomLogSourceResource {
	s.Attributes = v
	return s
}

// SetProvider sets the Provider field's value.
func (s *CustomLogSourceResource) SetProvider(v *CustomLogSourceProvider) *CustomLogSourceResource {
	s.Provider = v
	return s
}

// SetSourceName sets the SourceName field's value.
func (s *CustomLogSourceResource) SetSourceName(v string) *CustomLogSourceResource {
	s.SourceName = &v
	return s
}

// SetSourceVersion sets the SourceVersion field's value.
func (s *CustomLogSourceResource) SetSourceVersion(v string) *CustomLogSourceResource {
	s.SourceVersion = &v
	return s
}

// Automatically enable new organization accounts as member accounts from an
// Amazon Security Lake administrator account.
type DataLakeAutoEnableNewAccountConfiguration struct {
	_ struct{} `type:"structure"`

	// The Amazon Web Services Regions where Security Lake is automatically enabled.
	//
	// Region is a required field
	Region *string `locationName:"region" type:"string" required:"true"`

	// The Amazon Web Services sources that are automatically enabled in Security
	// Lake.
	//
	// Sources is a required field
	Sources []*AwsLogSourceResource `locationName:"sources" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataLakeAutoEnableNewAccountConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataLakeAutoEnableNewAccountConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DataLakeAutoEnableNewAccountConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DataLakeAutoEnableNewAccountConfiguration"}
	if s.Region == nil {
		invalidParams.Add(request.NewErrParamRequired("Region"))
	}
	if s.Sources == nil {
		invalidParams.Add(request.NewErrParamRequired("Sources"))
	}
	if s.Sources != nil && len(s.Sources) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Sources", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRegion sets the Region field's value.
func (s *DataLakeAutoEnableNewAccountConfiguration) SetRegion(v string) *DataLakeAutoEnableNewAccountConfiguration {
	s.Region = &v
	return s
}

// SetSources sets the Sources field's value.
func (s *DataLakeAutoEnableNewAccountConfiguration) SetSources(v []*AwsLogSourceResource) *DataLakeAutoEnableNewAccountConfiguration {
	s.Sources = v
	return s
}

// Provides details of Amazon Security Lake object.
type DataLakeConfiguration struct {
	_ struct{} `type:"structure"`

	// Provides encryption details of Amazon Security Lake object.
	EncryptionConfiguration *DataLakeEncryptionConfiguration `locationName:"encryptionConfiguration" type:"structure"`

	// Provides lifecycle details of Amazon Security Lake object.
	LifecycleConfiguration *DataLakeLifecycleConfiguration `locationName:"lifecycleConfiguration" type:"structure"`

	// The Amazon Web Services Regions where Security Lake is automatically enabled.
	//
	// Region is a required field
	Region *string `locationName:"region" type:"string" required:"true"`

	// Provides replication details of Amazon Security Lake object.
	ReplicationConfiguration *DataLakeReplicationConfiguration `locationName:"replicationConfiguration" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataLakeConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataLakeConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DataLakeConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DataLakeConfiguration"}
	if s.Region == nil {
		invalidParams.Add(request.NewErrParamRequired("Region"))
	}
	if s.LifecycleConfiguration != nil {
		if err := s.LifecycleConfiguration.Validate(); err != nil {
			invalidParams.AddNested("LifecycleConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEncryptionConfiguration sets the EncryptionConfiguration field's value.
func (s *DataLakeConfiguration) SetEncryptionConfiguration(v *DataLakeEncryptionConfiguration) *DataLakeConfiguration {
	s.EncryptionConfiguration = v
	return s
}

// SetLifecycleConfiguration sets the LifecycleConfiguration field's value.
func (s *DataLakeConfiguration) SetLifecycleConfiguration(v *DataLakeLifecycleConfiguration) *DataLakeConfiguration {
	s.LifecycleConfiguration = v
	return s
}

// SetRegion sets the Region field's value.
func (s *DataLakeConfiguration) SetRegion(v string) *DataLakeConfiguration {
	s.Region = &v
	return s
}

// SetReplicationConfiguration sets the ReplicationConfiguration field's value.
func (s *DataLakeConfiguration) SetReplicationConfiguration(v *DataLakeReplicationConfiguration) *DataLakeConfiguration {
	s.ReplicationConfiguration = v
	return s
}

// Provides encryption details of Amazon Security Lake object.
type DataLakeEncryptionConfiguration struct {
	_ struct{} `type:"structure"`

	// The id of KMS encryption key used by Amazon Security Lake to encrypt the
	// Security Lake object.
	KmsKeyId *string `locationName:"kmsKeyId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataLakeEncryptionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataLakeEncryptionConfiguration) GoString() string {
	return s.String()
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *DataLakeEncryptionConfiguration) SetKmsKeyId(v string) *DataLakeEncryptionConfiguration {
	s.KmsKeyId = &v
	return s
}

// The details for an Amazon Security Lake exception.
type DataLakeException struct {
	_ struct{} `type:"structure"`

	// The underlying exception of a Security Lake exception.
	Exception *string `locationName:"exception" type:"string"`

	// The Amazon Web Services Regions where the exception occurred.
	Region *string `locationName:"region" type:"string"`

	// List of all remediation steps for a Security Lake exception.
	Remediation *string `locationName:"remediation" type:"string"`

	// This error can occur if you configure the wrong timestamp format, or if the
	// subset of entries used for validation had errors or missing values.
	Timestamp *time.Time `locationName:"timestamp" type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataLakeException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataLakeException) GoString() string {
	return s.String()
}

// SetException sets the Exception field's value.
func (s *DataLakeException) SetException(v string) *DataLakeException {
	s.Exception = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *DataLakeException) SetRegion(v string) *DataLakeException {
	s.Region = &v
	return s
}

// SetRemediation sets the Remediation field's value.
func (s *DataLakeException) SetRemediation(v string) *DataLakeException {
	s.Remediation = &v
	return s
}

// SetTimestamp sets the Timestamp field's value.
func (s *DataLakeException) SetTimestamp(v time.Time) *DataLakeException {
	s.Timestamp = &v
	return s
}

// Provides lifecycle details of Amazon Security Lake object.
type DataLakeLifecycleConfiguration struct {
	_ struct{} `type:"structure"`

	// Provides data expiration details of Amazon Security Lake object.
	Expiration *DataLakeLifecycleExpiration `locationName:"expiration" type:"structure"`

	// Provides data storage transition details of Amazon Security Lake object.
	Transitions []*DataLakeLifecycleTransition `locationName:"transitions" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataLakeLifecycleConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataLakeLifecycleConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DataLakeLifecycleConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DataLakeLifecycleConfiguration"}
	if s.Expiration != nil {
		if err := s.Expiration.Validate(); err != nil {
			invalidParams.AddNested("Expiration", err.(request.ErrInvalidParams))
		}
	}
	if s.Transitions != nil {
		for i, v := range s.Transitions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Transitions", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExpiration sets the Expiration field's value.
func (s *DataLakeLifecycleConfiguration) SetExpiration(v *DataLakeLifecycleExpiration) *DataLakeLifecycleConfiguration {
	s.Expiration = v
	return s
}

// SetTransitions sets the Transitions field's value.
func (s *DataLakeLifecycleConfiguration) SetTransitions(v []*DataLakeLifecycleTransition) *DataLakeLifecycleConfiguration {
	s.Transitions = v
	return s
}

// Provide expiration lifecycle details of Amazon Security Lake object.
type DataLakeLifecycleExpiration struct {
	_ struct{} `type:"structure"`

	// Number of days before data expires in the Amazon Security Lake object.
	Days *int64 `locationName:"days" min:"1" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataLakeLifecycleExpiration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataLakeLifecycleExpiration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DataLakeLifecycleExpiration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DataLakeLifecycleExpiration"}
	if s.Days != nil && *s.Days < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Days", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDays sets the Days field's value.
func (s *DataLakeLifecycleExpiration) SetDays(v int64) *DataLakeLifecycleExpiration {
	s.Days = &v
	return s
}

// Provide transition lifecycle details of Amazon Security Lake object.
type DataLakeLifecycleTransition struct {
	_ struct{} `type:"structure"`

	// Number of days before data transitions to a different S3 Storage Class in
	// the Amazon Security Lake object.
	Days *int64 `locationName:"days" min:"1" type:"integer"`

	// The range of storage classes that you can choose from based on the data access,
	// resiliency, and cost requirements of your workloads.
	StorageClass *string `locationName:"storageClass" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataLakeLifecycleTransition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataLakeLifecycleTransition) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DataLakeLifecycleTransition) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DataLakeLifecycleTransition"}
	if s.Days != nil && *s.Days < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Days", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDays sets the Days field's value.
func (s *DataLakeLifecycleTransition) SetDays(v int64) *DataLakeLifecycleTransition {
	s.Days = &v
	return s
}

// SetStorageClass sets the StorageClass field's value.
func (s *DataLakeLifecycleTransition) SetStorageClass(v string) *DataLakeLifecycleTransition {
	s.StorageClass = &v
	return s
}

// Provides replication details for objects stored in the Amazon Security Lake
// data lake.
type DataLakeReplicationConfiguration struct {
	_ struct{} `type:"structure"`

	// Specifies one or more centralized rollup Regions. The Amazon Web Services
	// Region specified in the region parameter of the CreateDataLake (https://docs.aws.amazon.com/security-lake/latest/APIReference/API_CreateDataLake.html)
	// or UpdateDataLake (https://docs.aws.amazon.com/security-lake/latest/APIReference/API_UpdateDataLake.html)
	// operations contributes data to the rollup Region or Regions specified in
	// this parameter.
	//
	// Replication enables automatic, asynchronous copying of objects across Amazon
	// S3 buckets. S3 buckets that are configured for object replication can be
	// owned by the same Amazon Web Services account or by different accounts. You
	// can replicate objects to a single destination bucket or to multiple destination
	// buckets. The destination buckets can be in different Regions or within the
	// same Region as the source bucket.
	Regions []*string `locationName:"regions" type:"list"`

	// Replication settings for the Amazon S3 buckets. This parameter uses the Identity
	// and Access Management (IAM) role you created that is managed by Security
	// Lake, to ensure the replication setting is correct.
	RoleArn *string `locationName:"roleArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataLakeReplicationConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataLakeReplicationConfiguration) GoString() string {
	return s.String()
}

// SetRegions sets the Regions field's value.
func (s *DataLakeReplicationConfiguration) SetRegions(v []*string) *DataLakeReplicationConfiguration {
	s.Regions = v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *DataLakeReplicationConfiguration) SetRoleArn(v string) *DataLakeReplicationConfiguration {
	s.RoleArn = &v
	return s
}

// Provides details of Amazon Security Lake object.
type DataLakeResource struct {
	_ struct{} `type:"structure"`

	// Retrieves the status of the configuration operation for an account in Amazon
	// Security Lake.
	CreateStatus *string `locationName:"createStatus" type:"string" enum:"DataLakeStatus"`

	// The Amazon Resource Name (ARN) created by you to provide to the subscriber.
	// For more information about ARNs and how to use them in policies, see the
	// Amazon Security Lake User Guide (https://docs.aws.amazon.com/security-lake/latest/userguide/subscriber-management.html).
	//
	// DataLakeArn is a required field
	DataLakeArn *string `locationName:"dataLakeArn" min:"1" type:"string" required:"true"`

	// Provides encryption details of Amazon Security Lake object.
	EncryptionConfiguration *DataLakeEncryptionConfiguration `locationName:"encryptionConfiguration" type:"structure"`

	// Provides lifecycle details of Amazon Security Lake object.
	LifecycleConfiguration *DataLakeLifecycleConfiguration `locationName:"lifecycleConfiguration" type:"structure"`

	// The Amazon Web Services Regions where Security Lake is enabled.
	//
	// Region is a required field
	Region *string `locationName:"region" type:"string" required:"true"`

	// Provides replication details of Amazon Security Lake object.
	ReplicationConfiguration *DataLakeReplicationConfiguration `locationName:"replicationConfiguration" type:"structure"`

	// The ARN for the Amazon Security Lake Amazon S3 bucket.
	S3BucketArn *string `locationName:"s3BucketArn" type:"string"`

	// The status of the last UpdateDataLake or DeleteDataLake API request.
	UpdateStatus *DataLakeUpdateStatus `locationName:"updateStatus" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataLakeResource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataLakeResource) GoString() string {
	return s.String()
}

// SetCreateStatus sets the CreateStatus field's value.
func (s *DataLakeResource) SetCreateStatus(v string) *DataLakeResource {
	s.CreateStatus = &v
	return s
}

// SetDataLakeArn sets the DataLakeArn field's value.
func (s *DataLakeResource) SetDataLakeArn(v string) *DataLakeResource {
	s.DataLakeArn = &v
	return s
}

// SetEncryptionConfiguration sets the EncryptionConfiguration field's value.
func (s *DataLakeResource) SetEncryptionConfiguration(v *DataLakeEncryptionConfiguration) *DataLakeResource {
	s.EncryptionConfiguration = v
	return s
}

// SetLifecycleConfiguration sets the LifecycleConfiguration field's value.
func (s *DataLakeResource) SetLifecycleConfiguration(v *DataLakeLifecycleConfiguration) *DataLakeResource {
	s.LifecycleConfiguration = v
	return s
}

// SetRegion sets the Region field's value.
func (s *DataLakeResource) SetRegion(v string) *DataLakeResource {
	s.Region = &v
	return s
}

// SetReplicationConfiguration sets the ReplicationConfiguration field's value.
func (s *DataLakeResource) SetReplicationConfiguration(v *DataLakeReplicationConfiguration) *DataLakeResource {
	s.ReplicationConfiguration = v
	return s
}

// SetS3BucketArn sets the S3BucketArn field's value.
func (s *DataLakeResource) SetS3BucketArn(v string) *DataLakeResource {
	s.S3BucketArn = &v
	return s
}

// SetUpdateStatus sets the UpdateStatus field's value.
func (s *DataLakeResource) SetUpdateStatus(v *DataLakeUpdateStatus) *DataLakeResource {
	s.UpdateStatus = v
	return s
}

// Amazon Security Lake collects logs and events from supported Amazon Web Services
// and custom sources. For the list of supported Amazon Web Services, see the
// Amazon Security Lake User Guide (https://docs.aws.amazon.com/security-lake/latest/userguide/internal-sources.html).
type DataLakeSource struct {
	_ struct{} `type:"structure"`

	// The ID of the Security Lake account for which logs are collected.
	Account *string `locationName:"account" type:"string"`

	// The Open Cybersecurity Schema Framework (OCSF) event classes which describes
	// the type of data that the custom source will send to Security Lake. The supported
	// event classes are:
	//
	//    * ACCESS_ACTIVITY
	//
	//    * FILE_ACTIVITY
	//
	//    * KERNEL_ACTIVITY
	//
	//    * KERNEL_EXTENSION
	//
	//    * MEMORY_ACTIVITY
	//
	//    * MODULE_ACTIVITY
	//
	//    * PROCESS_ACTIVITY
	//
	//    * REGISTRY_KEY_ACTIVITY
	//
	//    * REGISTRY_VALUE_ACTIVITY
	//
	//    * RESOURCE_ACTIVITY
	//
	//    * SCHEDULED_JOB_ACTIVITY
	//
	//    * SECURITY_FINDING
	//
	//    * ACCOUNT_CHANGE
	//
	//    * AUTHENTICATION
	//
	//    * AUTHORIZATION
	//
	//    * ENTITY_MANAGEMENT_AUDIT
	//
	//    * DHCP_ACTIVITY
	//
	//    * NETWORK_ACTIVITY
	//
	//    * DNS_ACTIVITY
	//
	//    * FTP_ACTIVITY
	//
	//    * HTTP_ACTIVITY
	//
	//    * RDP_ACTIVITY
	//
	//    * SMB_ACTIVITY
	//
	//    * SSH_ACTIVITY
	//
	//    * CONFIG_STATE
	//
	//    * INVENTORY_INFO
	//
	//    * EMAIL_ACTIVITY
	//
	//    * API_ACTIVITY
	//
	//    * CLOUD_API
	EventClasses []*string `locationName:"eventClasses" type:"list"`

	// The supported Amazon Web Services from which logs and events are collected.
	// Amazon Security Lake supports log and event collection for natively supported
	// Amazon Web Services.
	SourceName *string `locationName:"sourceName" type:"string"`

	// The log status for the Security Lake account.
	SourceStatuses []*DataLakeSourceStatus `locationName:"sourceStatuses" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataLakeSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataLakeSource) GoString() string {
	return s.String()
}

// SetAccount sets the Account field's value.
func (s *DataLakeSource) SetAccount(v string) *DataLakeSource {
	s.Account = &v
	return s
}

// SetEventClasses sets the EventClasses field's value.
func (s *DataLakeSource) SetEventClasses(v []*string) *DataLakeSource {
	s.EventClasses = v
	return s
}

// SetSourceName sets the SourceName field's value.
func (s *DataLakeSource) SetSourceName(v string) *DataLakeSource {
	s.SourceName = &v
	return s
}

// SetSourceStatuses sets the SourceStatuses field's value.
func (s *DataLakeSource) SetSourceStatuses(v []*DataLakeSourceStatus) *DataLakeSource {
	s.SourceStatuses = v
	return s
}

// Retrieves the Logs status for the Amazon Security Lake account.
type DataLakeSourceStatus struct {
	_ struct{} `type:"structure"`

	// Defines path the stored logs are available which has information on your
	// systems, applications, and services.
	Resource *string `locationName:"resource" type:"string"`

	// The health status of services, including error codes and patterns.
	Status *string `locationName:"status" type:"string" enum:"SourceCollectionStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataLakeSourceStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataLakeSourceStatus) GoString() string {
	return s.String()
}

// SetResource sets the Resource field's value.
func (s *DataLakeSourceStatus) SetResource(v string) *DataLakeSourceStatus {
	s.Resource = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DataLakeSourceStatus) SetStatus(v string) *DataLakeSourceStatus {
	s.Status = &v
	return s
}

// The details of the last UpdateDataLake or DeleteDataLake API request which
// failed.
type DataLakeUpdateException struct {
	_ struct{} `type:"structure"`

	// The reason code for the exception of the last UpdateDataLake or DeleteDataLake
	// API request.
	Code *string `locationName:"code" type:"string"`

	// The reason for the exception of the last UpdateDataLakeor DeleteDataLake
	// API request.
	Reason *string `locationName:"reason" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataLakeUpdateException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataLakeUpdateException) GoString() string {
	return s.String()
}

// SetCode sets the Code field's value.
func (s *DataLakeUpdateException) SetCode(v string) *DataLakeUpdateException {
	s.Code = &v
	return s
}

// SetReason sets the Reason field's value.
func (s *DataLakeUpdateException) SetReason(v string) *DataLakeUpdateException {
	s.Reason = &v
	return s
}

// The status of the last UpdateDataLake or DeleteDataLake API request. This
// is set to Completed after the configuration is updated, or removed if deletion
// of the data lake is successful.
type DataLakeUpdateStatus struct {
	_ struct{} `type:"structure"`

	// The details of the last UpdateDataLakeor DeleteDataLake API request which
	// failed.
	Exception *DataLakeUpdateException `locationName:"exception" type:"structure"`

	// The unique ID for the last UpdateDataLake or DeleteDataLake API request.
	RequestId *string `locationName:"requestId" type:"string"`

	// The status of the last UpdateDataLake or DeleteDataLake API request that
	// was requested.
	Status *string `locationName:"status" type:"string" enum:"DataLakeStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataLakeUpdateStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataLakeUpdateStatus) GoString() string {
	return s.String()
}

// SetException sets the Exception field's value.
func (s *DataLakeUpdateStatus) SetException(v *DataLakeUpdateException) *DataLakeUpdateStatus {
	s.Exception = v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *DataLakeUpdateStatus) SetRequestId(v string) *DataLakeUpdateStatus {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DataLakeUpdateStatus) SetStatus(v string) *DataLakeUpdateStatus {
	s.Status = &v
	return s
}

type DeleteAwsLogSourceInput struct {
	_ struct{} `type:"structure"`

	// Specify the natively-supported Amazon Web Services service to remove as a
	// source in Security Lake.
	//
	// Sources is a required field
	Sources []*AwsLogSourceConfiguration `locationName:"sources" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAwsLogSourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAwsLogSourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAwsLogSourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAwsLogSourceInput"}
	if s.Sources == nil {
		invalidParams.Add(request.NewErrParamRequired("Sources"))
	}
	if s.Sources != nil && len(s.Sources) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Sources", 1))
	}
	if s.Sources != nil {
		for i, v := range s.Sources {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Sources", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSources sets the Sources field's value.
func (s *DeleteAwsLogSourceInput) SetSources(v []*AwsLogSourceConfiguration) *DeleteAwsLogSourceInput {
	s.Sources = v
	return s
}

type DeleteAwsLogSourceOutput struct {
	_ struct{} `type:"structure"`

	// Deletion of the Amazon Web Services sources failed as the account is not
	// a part of the organization.
	Failed []*string `locationName:"failed" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAwsLogSourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAwsLogSourceOutput) GoString() string {
	return s.String()
}

// SetFailed sets the Failed field's value.
func (s *DeleteAwsLogSourceOutput) SetFailed(v []*string) *DeleteAwsLogSourceOutput {
	s.Failed = v
	return s
}

type DeleteCustomLogSourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The source name of custom log source that you want to delete.
	//
	// SourceName is a required field
	SourceName *string `location:"uri" locationName:"sourceName" min:"1" type:"string" required:"true"`

	// The source version for the third-party custom source. You can limit the custom
	// source removal to the specified source version.
	SourceVersion *string `location:"querystring" locationName:"sourceVersion" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCustomLogSourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCustomLogSourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteCustomLogSourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteCustomLogSourceInput"}
	if s.SourceName == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceName"))
	}
	if s.SourceName != nil && len(*s.SourceName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SourceName", 1))
	}
	if s.SourceVersion != nil && len(*s.SourceVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SourceVersion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSourceName sets the SourceName field's value.
func (s *DeleteCustomLogSourceInput) SetSourceName(v string) *DeleteCustomLogSourceInput {
	s.SourceName = &v
	return s
}

// SetSourceVersion sets the SourceVersion field's value.
func (s *DeleteCustomLogSourceInput) SetSourceVersion(v string) *DeleteCustomLogSourceInput {
	s.SourceVersion = &v
	return s
}

type DeleteCustomLogSourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCustomLogSourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCustomLogSourceOutput) GoString() string {
	return s.String()
}

type DeleteDataLakeExceptionSubscriptionInput struct {
	_ struct{} `type:"structure" nopayload:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDataLakeExceptionSubscriptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDataLakeExceptionSubscriptionInput) GoString() string {
	return s.String()
}

type DeleteDataLakeExceptionSubscriptionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDataLakeExceptionSubscriptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDataLakeExceptionSubscriptionOutput) GoString() string {
	return s.String()
}

type DeleteDataLakeInput struct {
	_ struct{} `type:"structure"`

	// The list of Regions where Security Lake is enabled.
	//
	// Regions is a required field
	Regions []*string `locationName:"regions" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDataLakeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDataLakeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDataLakeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDataLakeInput"}
	if s.Regions == nil {
		invalidParams.Add(request.NewErrParamRequired("Regions"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRegions sets the Regions field's value.
func (s *DeleteDataLakeInput) SetRegions(v []*string) *DeleteDataLakeInput {
	s.Regions = v
	return s
}

type DeleteDataLakeOrganizationConfigurationInput struct {
	_ struct{} `type:"structure"`

	// Turns off automatic enablement of Security Lake for member accounts that
	// are added to an organization.
	AutoEnableNewAccount []*DataLakeAutoEnableNewAccountConfiguration `locationName:"autoEnableNewAccount" min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDataLakeOrganizationConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDataLakeOrganizationConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDataLakeOrganizationConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDataLakeOrganizationConfigurationInput"}
	if s.AutoEnableNewAccount != nil && len(s.AutoEnableNewAccount) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AutoEnableNewAccount", 1))
	}
	if s.AutoEnableNewAccount != nil {
		for i, v := range s.AutoEnableNewAccount {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AutoEnableNewAccount", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutoEnableNewAccount sets the AutoEnableNewAccount field's value.
func (s *DeleteDataLakeOrganizationConfigurationInput) SetAutoEnableNewAccount(v []*DataLakeAutoEnableNewAccountConfiguration) *DeleteDataLakeOrganizationConfigurationInput {
	s.AutoEnableNewAccount = v
	return s
}

type DeleteDataLakeOrganizationConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDataLakeOrganizationConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDataLakeOrganizationConfigurationOutput) GoString() string {
	return s.String()
}

type DeleteDataLakeOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDataLakeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDataLakeOutput) GoString() string {
	return s.String()
}

type DeleteSubscriberInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// A value created by Security Lake that uniquely identifies your DeleteSubscriber
	// API request.
	//
	// SubscriberId is a required field
	SubscriberId *string `location:"uri" locationName:"subscriberId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSubscriberInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSubscriberInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSubscriberInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteSubscriberInput"}
	if s.SubscriberId == nil {
		invalidParams.Add(request.NewErrParamRequired("SubscriberId"))
	}
	if s.SubscriberId != nil && len(*s.SubscriberId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SubscriberId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSubscriberId sets the SubscriberId field's value.
func (s *DeleteSubscriberInput) SetSubscriberId(v string) *DeleteSubscriberInput {
	s.SubscriberId = &v
	return s
}

type DeleteSubscriberNotificationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the Security Lake subscriber account.
	//
	// SubscriberId is a required field
	SubscriberId *string `location:"uri" locationName:"subscriberId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSubscriberNotificationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSubscriberNotificationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSubscriberNotificationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteSubscriberNotificationInput"}
	if s.SubscriberId == nil {
		invalidParams.Add(request.NewErrParamRequired("SubscriberId"))
	}
	if s.SubscriberId != nil && len(*s.SubscriberId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SubscriberId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSubscriberId sets the SubscriberId field's value.
func (s *DeleteSubscriberNotificationInput) SetSubscriberId(v string) *DeleteSubscriberNotificationInput {
	s.SubscriberId = &v
	return s
}

type DeleteSubscriberNotificationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSubscriberNotificationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSubscriberNotificationOutput) GoString() string {
	return s.String()
}

type DeleteSubscriberOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSubscriberOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSubscriberOutput) GoString() string {
	return s.String()
}

type DeregisterDataLakeDelegatedAdministratorInput struct {
	_ struct{} `type:"structure" nopayload:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeregisterDataLakeDelegatedAdministratorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeregisterDataLakeDelegatedAdministratorInput) GoString() string {
	return s.String()
}

type DeregisterDataLakeDelegatedAdministratorOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeregisterDataLakeDelegatedAdministratorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeregisterDataLakeDelegatedAdministratorOutput) GoString() string {
	return s.String()
}

type GetDataLakeExceptionSubscriptionInput struct {
	_ struct{} `type:"structure" nopayload:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDataLakeExceptionSubscriptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDataLakeExceptionSubscriptionInput) GoString() string {
	return s.String()
}

type GetDataLakeExceptionSubscriptionOutput struct {
	_ struct{} `type:"structure"`

	// The expiration period and time-to-live (TTL).
	ExceptionTimeToLive *int64 `locationName:"exceptionTimeToLive" type:"long"`

	// The Amazon Web Services account where you receive exception notifications.
	NotificationEndpoint *string `locationName:"notificationEndpoint" type:"string"`

	// The subscription protocol to which exception notifications are posted.
	SubscriptionProtocol *string `locationName:"subscriptionProtocol" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDataLakeExceptionSubscriptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDataLakeExceptionSubscriptionOutput) GoString() string {
	return s.String()
}

// SetExceptionTimeToLive sets the ExceptionTimeToLive field's value.
func (s *GetDataLakeExceptionSubscriptionOutput) SetExceptionTimeToLive(v int64) *GetDataLakeExceptionSubscriptionOutput {
	s.ExceptionTimeToLive = &v
	return s
}

// SetNotificationEndpoint sets the NotificationEndpoint field's value.
func (s *GetDataLakeExceptionSubscriptionOutput) SetNotificationEndpoint(v string) *GetDataLakeExceptionSubscriptionOutput {
	s.NotificationEndpoint = &v
	return s
}

// SetSubscriptionProtocol sets the SubscriptionProtocol field's value.
func (s *GetDataLakeExceptionSubscriptionOutput) SetSubscriptionProtocol(v string) *GetDataLakeExceptionSubscriptionOutput {
	s.SubscriptionProtocol = &v
	return s
}

type GetDataLakeOrganizationConfigurationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDataLakeOrganizationConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDataLakeOrganizationConfigurationInput) GoString() string {
	return s.String()
}

type GetDataLakeOrganizationConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The configuration for new accounts.
	AutoEnableNewAccount []*DataLakeAutoEnableNewAccountConfiguration `locationName:"autoEnableNewAccount" min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDataLakeOrganizationConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDataLakeOrganizationConfigurationOutput) GoString() string {
	return s.String()
}

// SetAutoEnableNewAccount sets the AutoEnableNewAccount field's value.
func (s *GetDataLakeOrganizationConfigurationOutput) SetAutoEnableNewAccount(v []*DataLakeAutoEnableNewAccountConfiguration) *GetDataLakeOrganizationConfigurationOutput {
	s.AutoEnableNewAccount = v
	return s
}

type GetDataLakeSourcesInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Web Services account ID for which a static snapshot of the current
	// Amazon Web Services Region, including enabled accounts and log sources, is
	// retrieved.
	Accounts []*string `locationName:"accounts" type:"list"`

	// The maximum limit of accounts for which the static snapshot of the current
	// Region, including enabled accounts and log sources, is retrieved.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// Lists if there are more results available. The value of nextToken is a unique
	// pagination token for each page. Repeat the call using the returned token
	// to retrieve the next page. Keep all other arguments unchanged.
	//
	// Each pagination token expires after 24 hours. Using an expired pagination
	// token will return an HTTP 400 InvalidToken error.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDataLakeSourcesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDataLakeSourcesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDataLakeSourcesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDataLakeSourcesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccounts sets the Accounts field's value.
func (s *GetDataLakeSourcesInput) SetAccounts(v []*string) *GetDataLakeSourcesInput {
	s.Accounts = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetDataLakeSourcesInput) SetMaxResults(v int64) *GetDataLakeSourcesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetDataLakeSourcesInput) SetNextToken(v string) *GetDataLakeSourcesInput {
	s.NextToken = &v
	return s
}

type GetDataLakeSourcesOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) created by you to provide to the subscriber.
	// For more information about ARNs and how to use them in policies, see the
	// Amazon Security Lake User Guide (https://docs.aws.amazon.com/security-lake/latest/userguide/subscriber-management.html).
	DataLakeArn *string `locationName:"dataLakeArn" min:"1" type:"string"`

	// The list of enabled accounts and enabled sources.
	DataLakeSources []*DataLakeSource `locationName:"dataLakeSources" type:"list"`

	// Lists if there are more results available. The value of nextToken is a unique
	// pagination token for each page. Repeat the call using the returned token
	// to retrieve the next page. Keep all other arguments unchanged.
	//
	// Each pagination token expires after 24 hours. Using an expired pagination
	// token will return an HTTP 400 InvalidToken error.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDataLakeSourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDataLakeSourcesOutput) GoString() string {
	return s.String()
}

// SetDataLakeArn sets the DataLakeArn field's value.
func (s *GetDataLakeSourcesOutput) SetDataLakeArn(v string) *GetDataLakeSourcesOutput {
	s.DataLakeArn = &v
	return s
}

// SetDataLakeSources sets the DataLakeSources field's value.
func (s *GetDataLakeSourcesOutput) SetDataLakeSources(v []*DataLakeSource) *GetDataLakeSourcesOutput {
	s.DataLakeSources = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetDataLakeSourcesOutput) SetNextToken(v string) *GetDataLakeSourcesOutput {
	s.NextToken = &v
	return s
}

type GetSubscriberInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// A value created by Amazon Security Lake that uniquely identifies your GetSubscriber
	// API request.
	//
	// SubscriberId is a required field
	SubscriberId *string `location:"uri" locationName:"subscriberId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSubscriberInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSubscriberInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSubscriberInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSubscriberInput"}
	if s.SubscriberId == nil {
		invalidParams.Add(request.NewErrParamRequired("SubscriberId"))
	}
	if s.SubscriberId != nil && len(*s.SubscriberId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SubscriberId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSubscriberId sets the SubscriberId field's value.
func (s *GetSubscriberInput) SetSubscriberId(v string) *GetSubscriberInput {
	s.SubscriberId = &v
	return s
}

type GetSubscriberOutput struct {
	_ struct{} `type:"structure"`

	// The subscriber information for the specified subscriber ID.
	Subscriber *SubscriberResource `locationName:"subscriber" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSubscriberOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSubscriberOutput) GoString() string {
	return s.String()
}

// SetSubscriber sets the Subscriber field's value.
func (s *GetSubscriberOutput) SetSubscriber(v *SubscriberResource) *GetSubscriberOutput {
	s.Subscriber = v
	return s
}

// The configurations for HTTPS subscriber notification.
type HttpsNotificationConfiguration struct {
	_ struct{} `type:"structure"`

	// The key name for the notification subscription.
	AuthorizationApiKeyName *string `locationName:"authorizationApiKeyName" type:"string"`

	// The key value for the notification subscription.
	AuthorizationApiKeyValue *string `locationName:"authorizationApiKeyValue" type:"string"`

	// The subscription endpoint in Security Lake. If you prefer notification with
	// an HTTPs endpoint, populate this field.
	//
	// Endpoint is a required field
	Endpoint *string `locationName:"endpoint" type:"string" required:"true"`

	// The HTTPS method used for the notification subscription.
	HttpMethod *string `locationName:"httpMethod" type:"string" enum:"HttpMethod"`

	// The Amazon Resource Name (ARN) of the EventBridge API destinations IAM role
	// that you created. For more information about ARNs and how to use them in
	// policies, see Managing data access (https://docs.aws.amazon.com//security-lake/latest/userguide/subscriber-data-access.html)
	// and Amazon Web Services Managed Policies (https://docs.aws.amazon.com/security-lake/latest/userguide/security-iam-awsmanpol.html)
	// in the Amazon Security Lake User Guide.
	//
	// TargetRoleArn is a required field
	TargetRoleArn *string `locationName:"targetRoleArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HttpsNotificationConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HttpsNotificationConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HttpsNotificationConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "HttpsNotificationConfiguration"}
	if s.Endpoint == nil {
		invalidParams.Add(request.NewErrParamRequired("Endpoint"))
	}
	if s.TargetRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetRoleArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthorizationApiKeyName sets the AuthorizationApiKeyName field's value.
func (s *HttpsNotificationConfiguration) SetAuthorizationApiKeyName(v string) *HttpsNotificationConfiguration {
	s.AuthorizationApiKeyName = &v
	return s
}

// SetAuthorizationApiKeyValue sets the AuthorizationApiKeyValue field's value.
func (s *HttpsNotificationConfiguration) SetAuthorizationApiKeyValue(v string) *HttpsNotificationConfiguration {
	s.AuthorizationApiKeyValue = &v
	return s
}

// SetEndpoint sets the Endpoint field's value.
func (s *HttpsNotificationConfiguration) SetEndpoint(v string) *HttpsNotificationConfiguration {
	s.Endpoint = &v
	return s
}

// SetHttpMethod sets the HttpMethod field's value.
func (s *HttpsNotificationConfiguration) SetHttpMethod(v string) *HttpsNotificationConfiguration {
	s.HttpMethod = &v
	return s
}

// SetTargetRoleArn sets the TargetRoleArn field's value.
func (s *HttpsNotificationConfiguration) SetTargetRoleArn(v string) *HttpsNotificationConfiguration {
	s.TargetRoleArn = &v
	return s
}

// Internal service exceptions are sometimes caused by transient issues. Before
// you start troubleshooting, perform the operation again.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListDataLakeExceptionsInput struct {
	_ struct{} `type:"structure"`

	// List the maximum number of failures in Security Lake.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// List if there are more results available. The value of nextToken is a unique
	// pagination token for each page. Repeat the call using the returned token
	// to retrieve the next page. Keep all other arguments unchanged.
	//
	// Each pagination token expires after 24 hours. Using an expired pagination
	// token will return an HTTP 400 InvalidToken error.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The Amazon Web Services Regions from which exceptions are retrieved.
	Regions []*string `locationName:"regions" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDataLakeExceptionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDataLakeExceptionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDataLakeExceptionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDataLakeExceptionsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDataLakeExceptionsInput) SetMaxResults(v int64) *ListDataLakeExceptionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDataLakeExceptionsInput) SetNextToken(v string) *ListDataLakeExceptionsInput {
	s.NextToken = &v
	return s
}

// SetRegions sets the Regions field's value.
func (s *ListDataLakeExceptionsInput) SetRegions(v []*string) *ListDataLakeExceptionsInput {
	s.Regions = v
	return s
}

type ListDataLakeExceptionsOutput struct {
	_ struct{} `type:"structure"`

	// Lists the failures that cannot be retried in the current Region.
	Exceptions []*DataLakeException `locationName:"exceptions" type:"list"`

	// List if there are more results available. The value of nextToken is a unique
	// pagination token for each page. Repeat the call using the returned token
	// to retrieve the next page. Keep all other arguments unchanged.
	//
	// Each pagination token expires after 24 hours. Using an expired pagination
	// token will return an HTTP 400 InvalidToken error.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDataLakeExceptionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDataLakeExceptionsOutput) GoString() string {
	return s.String()
}

// SetExceptions sets the Exceptions field's value.
func (s *ListDataLakeExceptionsOutput) SetExceptions(v []*DataLakeException) *ListDataLakeExceptionsOutput {
	s.Exceptions = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDataLakeExceptionsOutput) SetNextToken(v string) *ListDataLakeExceptionsOutput {
	s.NextToken = &v
	return s
}

type ListDataLakesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The list of Regions where Security Lake is enabled.
	Regions []*string `location:"querystring" locationName:"regions" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDataLakesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDataLakesInput) GoString() string {
	return s.String()
}

// SetRegions sets the Regions field's value.
func (s *ListDataLakesInput) SetRegions(v []*string) *ListDataLakesInput {
	s.Regions = v
	return s
}

type ListDataLakesOutput struct {
	_ struct{} `type:"structure"`

	// Retrieves the Security Lake configuration object.
	DataLakes []*DataLakeResource `locationName:"dataLakes" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDataLakesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDataLakesOutput) GoString() string {
	return s.String()
}

// SetDataLakes sets the DataLakes field's value.
func (s *ListDataLakesOutput) SetDataLakes(v []*DataLakeResource) *ListDataLakesOutput {
	s.DataLakes = v
	return s
}

type ListLogSourcesInput struct {
	_ struct{} `type:"structure"`

	// The list of Amazon Web Services accounts for which log sources are displayed.
	Accounts []*string `locationName:"accounts" type:"list"`

	// The maximum number of accounts for which the log sources are displayed.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// If nextToken is returned, there are more results available. You can repeat
	// the call using the returned token to retrieve the next page.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The list of Regions for which log sources are displayed.
	Regions []*string `locationName:"regions" type:"list"`

	// The list of sources for which log sources are displayed.
	Sources []*LogSourceResource `locationName:"sources" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLogSourcesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLogSourcesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListLogSourcesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListLogSourcesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Sources != nil {
		for i, v := range s.Sources {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Sources", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccounts sets the Accounts field's value.
func (s *ListLogSourcesInput) SetAccounts(v []*string) *ListLogSourcesInput {
	s.Accounts = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListLogSourcesInput) SetMaxResults(v int64) *ListLogSourcesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListLogSourcesInput) SetNextToken(v string) *ListLogSourcesInput {
	s.NextToken = &v
	return s
}

// SetRegions sets the Regions field's value.
func (s *ListLogSourcesInput) SetRegions(v []*string) *ListLogSourcesInput {
	s.Regions = v
	return s
}

// SetSources sets the Sources field's value.
func (s *ListLogSourcesInput) SetSources(v []*LogSourceResource) *ListLogSourcesInput {
	s.Sources = v
	return s
}

type ListLogSourcesOutput struct {
	_ struct{} `type:"structure"`

	// If nextToken is returned, there are more results available. You can repeat
	// the call using the returned token to retrieve the next page.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The list of log sources in your organization that send data to the data lake.
	Sources []*LogSource `locationName:"sources" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLogSourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLogSourcesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListLogSourcesOutput) SetNextToken(v string) *ListLogSourcesOutput {
	s.NextToken = &v
	return s
}

// SetSources sets the Sources field's value.
func (s *ListLogSourcesOutput) SetSources(v []*LogSource) *ListLogSourcesOutput {
	s.Sources = v
	return s
}

type ListSubscribersInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of accounts for which the configuration is displayed.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// If nextToken is returned, there are more results available. You can repeat
	// the call using the returned token to retrieve the next page.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSubscribersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSubscribersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSubscribersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListSubscribersInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListSubscribersInput) SetMaxResults(v int64) *ListSubscribersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSubscribersInput) SetNextToken(v string) *ListSubscribersInput {
	s.NextToken = &v
	return s
}

type ListSubscribersOutput struct {
	_ struct{} `type:"structure"`

	// If nextToken is returned, there are more results available. You can repeat
	// the call using the returned token to retrieve the next page.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The subscribers available for the specified Security Lake account ID.
	Subscribers []*SubscriberResource `locationName:"subscribers" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSubscribersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSubscribersOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListSubscribersOutput) SetNextToken(v string) *ListSubscribersOutput {
	s.NextToken = &v
	return s
}

// SetSubscribers sets the Subscribers field's value.
func (s *ListSubscribersOutput) SetSubscribers(v []*SubscriberResource) *ListSubscribersOutput {
	s.Subscribers = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the Amazon Security Lake resource for which
	// you want to retrieve the tags.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// An array of objects, one for each tag (key and value) that’s associated
	// with the Amazon Security Lake resource.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v []*Tag) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// Amazon Security Lake can collect logs and events from natively-supported
// Amazon Web Services services and custom sources.
type LogSource struct {
	_ struct{} `type:"structure"`

	// Specify the account from which you want to collect logs.
	Account *string `locationName:"account" min:"12" type:"string"`

	// Specify the Regions from which you want to collect logs.
	Region *string `locationName:"region" type:"string"`

	// Specify the sources from which you want to collect logs.
	Sources []*LogSourceResource `locationName:"sources" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LogSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LogSource) GoString() string {
	return s.String()
}

// SetAccount sets the Account field's value.
func (s *LogSource) SetAccount(v string) *LogSource {
	s.Account = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *LogSource) SetRegion(v string) *LogSource {
	s.Region = &v
	return s
}

// SetSources sets the Sources field's value.
func (s *LogSource) SetSources(v []*LogSourceResource) *LogSource {
	s.Sources = v
	return s
}

// The supported source types from which logs and events are collected in Amazon
// Security Lake. For a list of supported Amazon Web Services, see the Amazon
// Security Lake User Guide (https://docs.aws.amazon.com/security-lake/latest/userguide/internal-sources.html).
type LogSourceResource struct {
	_ struct{} `type:"structure"`

	// Amazon Security Lake supports log and event collection for natively supported
	// Amazon Web Services. For more information, see the Amazon Security Lake User
	// Guide (https://docs.aws.amazon.com/security-lake/latest/userguide/internal-sources.html).
	AwsLogSource *AwsLogSourceResource `locationName:"awsLogSource" type:"structure"`

	// Amazon Security Lake supports custom source types. For more information,
	// see the Amazon Security Lake User Guide (https://docs.aws.amazon.com/security-lake/latest/userguide/custom-sources.html).
	CustomLogSource *CustomLogSourceResource `locationName:"customLogSource" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LogSourceResource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LogSourceResource) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LogSourceResource) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LogSourceResource"}
	if s.CustomLogSource != nil {
		if err := s.CustomLogSource.Validate(); err != nil {
			invalidParams.AddNested("CustomLogSource", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsLogSource sets the AwsLogSource field's value.
func (s *LogSourceResource) SetAwsLogSource(v *AwsLogSourceResource) *LogSourceResource {
	s.AwsLogSource = v
	return s
}

// SetCustomLogSource sets the CustomLogSource field's value.
func (s *LogSourceResource) SetCustomLogSource(v *CustomLogSourceResource) *LogSourceResource {
	s.CustomLogSource = v
	return s
}

// Specify the configurations you want to use for subscriber notification to
// notify the subscriber when new data is written to the data lake for sources
// that the subscriber consumes in Security Lake.
type NotificationConfiguration struct {
	_ struct{} `type:"structure"`

	// The configurations for HTTPS subscriber notification.
	HttpsNotificationConfiguration *HttpsNotificationConfiguration `locationName:"httpsNotificationConfiguration" type:"structure"`

	// The configurations for SQS subscriber notification.
	SqsNotificationConfiguration *SqsNotificationConfiguration `locationName:"sqsNotificationConfiguration" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotificationConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotificationConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NotificationConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "NotificationConfiguration"}
	if s.HttpsNotificationConfiguration != nil {
		if err := s.HttpsNotificationConfiguration.Validate(); err != nil {
			invalidParams.AddNested("HttpsNotificationConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHttpsNotificationConfiguration sets the HttpsNotificationConfiguration field's value.
func (s *NotificationConfiguration) SetHttpsNotificationConfiguration(v *HttpsNotificationConfiguration) *NotificationConfiguration {
	s.HttpsNotificationConfiguration = v
	return s
}

// SetSqsNotificationConfiguration sets the SqsNotificationConfiguration field's value.
func (s *NotificationConfiguration) SetSqsNotificationConfiguration(v *SqsNotificationConfiguration) *NotificationConfiguration {
	s.SqsNotificationConfiguration = v
	return s
}

type RegisterDataLakeDelegatedAdministratorInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Web Services account ID of the Security Lake delegated administrator.
	//
	// AccountId is a required field
	AccountId *string `locationName:"accountId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegisterDataLakeDelegatedAdministratorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegisterDataLakeDelegatedAdministratorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RegisterDataLakeDelegatedAdministratorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RegisterDataLakeDelegatedAdministratorInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *RegisterDataLakeDelegatedAdministratorInput) SetAccountId(v string) *RegisterDataLakeDelegatedAdministratorInput {
	s.AccountId = &v
	return s
}

type RegisterDataLakeDelegatedAdministratorOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegisterDataLakeDelegatedAdministratorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegisterDataLakeDelegatedAdministratorOutput) GoString() string {
	return s.String()
}

// The resource could not be found.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The name of the resource that could not be found.
	ResourceName *string `locationName:"resourceName" type:"string"`

	// The type of the resource that could not be found.
	ResourceType *string `locationName:"resourceType" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The configurations for SQS subscriber notification.
type SqsNotificationConfiguration struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SqsNotificationConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SqsNotificationConfiguration) GoString() string {
	return s.String()
}

// Provides details about the Amazon Security Lake account subscription. Subscribers
// are notified of new objects for a source as the data is written to your Amazon
// S3 bucket for Security Lake.
type SubscriberResource struct {
	_ struct{} `type:"structure"`

	// You can choose to notify subscribers of new objects with an Amazon Simple
	// Queue Service (Amazon SQS) queue or through messaging to an HTTPS endpoint
	// provided by the subscriber.
	//
	// Subscribers can consume data by directly querying Lake Formation tables in
	// your Amazon S3 bucket through services like Amazon Athena. This subscription
	// type is defined as LAKEFORMATION.
	AccessTypes []*string `locationName:"accessTypes" type:"list" enum:"AccessType"`

	// The date and time when the subscriber was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601"`

	// The Amazon Resource Name (ARN) which uniquely defines the Amazon Web Services
	// RAM resource share. Before accepting the RAM resource share invitation, you
	// can view details related to the RAM resource share.
	//
	// This field is available only for Lake Formation subscribers created after
	// March 8, 2023.
	ResourceShareArn *string `locationName:"resourceShareArn" type:"string"`

	// The name of the resource share.
	ResourceShareName *string `locationName:"resourceShareName" type:"string"`

	// The Amazon Resource Name (ARN) specifying the role of the subscriber.
	RoleArn *string `locationName:"roleArn" type:"string"`

	// The ARN for the Amazon S3 bucket.
	S3BucketArn *string `locationName:"s3BucketArn" type:"string"`

	// Amazon Security Lake supports log and event collection for natively supported
	// Amazon Web Services. For more information, see the Amazon Security Lake User
	// Guide (https://docs.aws.amazon.com/security-lake/latest/userguide/source-management.html).
	//
	// Sources is a required field
	Sources []*LogSourceResource `locationName:"sources" type:"list" required:"true"`

	// The subscriber ARN of the Amazon Security Lake subscriber account.
	//
	// SubscriberArn is a required field
	SubscriberArn *string `locationName:"subscriberArn" min:"1" type:"string" required:"true"`

	// The subscriber descriptions for a subscriber account. The description for
	// a subscriber includes subscriberName, accountID, externalID, and subscriberId.
	SubscriberDescription *string `locationName:"subscriberDescription" type:"string"`

	// The subscriber endpoint to which exception messages are posted.
	SubscriberEndpoint *string `locationName:"subscriberEndpoint" type:"string"`

	// The subscriber ID of the Amazon Security Lake subscriber account.
	//
	// SubscriberId is a required field
	SubscriberId *string `locationName:"subscriberId" type:"string" required:"true"`

	// The Amazon Web Services identity used to access your data.
	//
	// SubscriberIdentity is a required field
	SubscriberIdentity *AwsIdentity `locationName:"subscriberIdentity" type:"structure" required:"true"`

	// The name of your Amazon Security Lake subscriber account.
	//
	// SubscriberName is a required field
	SubscriberName *string `locationName:"subscriberName" type:"string" required:"true"`

	// The subscriber status of the Amazon Security Lake subscriber account.
	SubscriberStatus *string `locationName:"subscriberStatus" type:"string" enum:"SubscriberStatus"`

	// The date and time when the subscriber was last updated.
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SubscriberResource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SubscriberResource) GoString() string {
	return s.String()
}

// SetAccessTypes sets the AccessTypes field's value.
func (s *SubscriberResource) SetAccessTypes(v []*string) *SubscriberResource {
	s.AccessTypes = v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *SubscriberResource) SetCreatedAt(v time.Time) *SubscriberResource {
	s.CreatedAt = &v
	return s
}

// SetResourceShareArn sets the ResourceShareArn field's value.
func (s *SubscriberResource) SetResourceShareArn(v string) *SubscriberResource {
	s.ResourceShareArn = &v
	return s
}

// SetResourceShareName sets the ResourceShareName field's value.
func (s *SubscriberResource) SetResourceShareName(v string) *SubscriberResource {
	s.ResourceShareName = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *SubscriberResource) SetRoleArn(v string) *SubscriberResource {
	s.RoleArn = &v
	return s
}

// SetS3BucketArn sets the S3BucketArn field's value.
func (s *SubscriberResource) SetS3BucketArn(v string) *SubscriberResource {
	s.S3BucketArn = &v
	return s
}

// SetSources sets the Sources field's value.
func (s *SubscriberResource) SetSources(v []*LogSourceResource) *SubscriberResource {
	s.Sources = v
	return s
}

// SetSubscriberArn sets the SubscriberArn field's value.
func (s *SubscriberResource) SetSubscriberArn(v string) *SubscriberResource {
	s.SubscriberArn = &v
	return s
}

// SetSubscriberDescription sets the SubscriberDescription field's value.
func (s *SubscriberResource) SetSubscriberDescription(v string) *SubscriberResource {
	s.SubscriberDescription = &v
	return s
}

// SetSubscriberEndpoint sets the SubscriberEndpoint field's value.
func (s *SubscriberResource) SetSubscriberEndpoint(v string) *SubscriberResource {
	s.SubscriberEndpoint = &v
	return s
}

// SetSubscriberId sets the SubscriberId field's value.
func (s *SubscriberResource) SetSubscriberId(v string) *SubscriberResource {
	s.SubscriberId = &v
	return s
}

// SetSubscriberIdentity sets the SubscriberIdentity field's value.
func (s *SubscriberResource) SetSubscriberIdentity(v *AwsIdentity) *SubscriberResource {
	s.SubscriberIdentity = v
	return s
}

// SetSubscriberName sets the SubscriberName field's value.
func (s *SubscriberResource) SetSubscriberName(v string) *SubscriberResource {
	s.SubscriberName = &v
	return s
}

// SetSubscriberStatus sets the SubscriberStatus field's value.
func (s *SubscriberResource) SetSubscriberStatus(v string) *SubscriberResource {
	s.SubscriberStatus = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *SubscriberResource) SetUpdatedAt(v time.Time) *SubscriberResource {
	s.UpdatedAt = &v
	return s
}

// A tag is a label that you can define and associate with Amazon Web Services
// resources, including certain types of Amazon Security Lake resources. Tags
// can help you identify, categorize, and manage resources in different ways,
// such as by owner, environment, or other criteria. You can associate tags
// with the following types of Security Lake resources: subscribers, and the
// data lake configuration for your Amazon Web Services account in individual
// Amazon Web Services Regions.
//
// A resource can have up to 50 tags. Each tag consists of a required tag key
// and an associated tag value. A tag key is a general label that acts as a
// category for a more specific tag value. Each tag key must be unique and it
// can have only one tag value. A tag value acts as a descriptor for a tag key.
// Tag keys and values are case sensitive. They can contain letters, numbers,
// spaces, or the following symbols: _ . : / = + @ -
//
// For more information, see Tagging Amazon Security Lake resources (https://docs.aws.amazon.com/security-lake/latest/userguide/tagging-resources.html)
// in the Amazon Security Lake User Guide.
type Tag struct {
	_ struct{} `type:"structure"`

	// The name of the tag. This is a general label that acts as a category for
	// a more specific tag value (value).
	//
	// Key is a required field
	Key *string `locationName:"key" min:"1" type:"string" required:"true"`

	// The value that’s associated with the specified tag key (key). This value
	// acts as a descriptor for the tag key. A tag value cannot be null, but it
	// can be an empty string.
	//
	// Value is a required field
	Value *string `locationName:"value" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Amazon Security Lake resource to add
	// or update the tags for.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"1" type:"string" required:"true"`

	// An array of objects, one for each tag (key and value) to associate with the
	// Amazon Security Lake resource. For each tag, you must specify both a tag
	// key and a tag value. A tag value cannot be null, but it can be an empty string.
	//
	// Tags is a required field
	Tags []*Tag `locationName:"tags" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v []*Tag) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// The limit on the number of requests per second was exceeded.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// That the rate of requests to Security Lake is exceeding the request quotas
	// for your Amazon Web Services account.
	QuotaCode *string `locationName:"quotaCode" type:"string"`

	// Retry the request after the specified time.
	RetryAfterSeconds *int64 `location:"header" locationName:"Retry-After" type:"integer"`

	// The code for the service in Service Quotas.
	ServiceCode *string `locationName:"serviceCode" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the Amazon Security Lake resource to remove
	// one or more tags from.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"1" type:"string" required:"true"`

	// A list of one or more tag keys. For each value in the list, specify the tag
	// key for a tag to remove from the Amazon Security Lake resource.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateDataLakeExceptionSubscriptionInput struct {
	_ struct{} `type:"structure"`

	// The time-to-live (TTL) for the exception message to remain.
	ExceptionTimeToLive *int64 `locationName:"exceptionTimeToLive" min:"1" type:"long"`

	// The account that is subscribed to receive exception notifications.
	//
	// NotificationEndpoint is a required field
	NotificationEndpoint *string `locationName:"notificationEndpoint" type:"string" required:"true"`

	// The subscription protocol to which exception messages are posted.
	//
	// SubscriptionProtocol is a required field
	SubscriptionProtocol *string `locationName:"subscriptionProtocol" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDataLakeExceptionSubscriptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDataLakeExceptionSubscriptionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDataLakeExceptionSubscriptionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateDataLakeExceptionSubscriptionInput"}
	if s.ExceptionTimeToLive != nil && *s.ExceptionTimeToLive < 1 {
		invalidParams.Add(request.NewErrParamMinValue("ExceptionTimeToLive", 1))
	}
	if s.NotificationEndpoint == nil {
		invalidParams.Add(request.NewErrParamRequired("NotificationEndpoint"))
	}
	if s.SubscriptionProtocol == nil {
		invalidParams.Add(request.NewErrParamRequired("SubscriptionProtocol"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExceptionTimeToLive sets the ExceptionTimeToLive field's value.
func (s *UpdateDataLakeExceptionSubscriptionInput) SetExceptionTimeToLive(v int64) *UpdateDataLakeExceptionSubscriptionInput {
	s.ExceptionTimeToLive = &v
	return s
}

// SetNotificationEndpoint sets the NotificationEndpoint field's value.
func (s *UpdateDataLakeExceptionSubscriptionInput) SetNotificationEndpoint(v string) *UpdateDataLakeExceptionSubscriptionInput {
	s.NotificationEndpoint = &v
	return s
}

// SetSubscriptionProtocol sets the SubscriptionProtocol field's value.
func (s *UpdateDataLakeExceptionSubscriptionInput) SetSubscriptionProtocol(v string) *UpdateDataLakeExceptionSubscriptionInput {
	s.SubscriptionProtocol = &v
	return s
}

type UpdateDataLakeExceptionSubscriptionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDataLakeExceptionSubscriptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDataLakeExceptionSubscriptionOutput) GoString() string {
	return s.String()
}

type UpdateDataLakeInput struct {
	_ struct{} `type:"structure"`

	// Specify the Region or Regions that will contribute data to the rollup region.
	//
	// Configurations is a required field
	Configurations []*DataLakeConfiguration `locationName:"configurations" min:"1" type:"list" required:"true"`

	// The Amazon Resource Name (ARN) used to create and update the Glue table.
	// This table contains partitions generated by the ingestion and normalization
	// of Amazon Web Services log sources and custom sources.
	MetaStoreManagerRoleArn *string `locationName:"metaStoreManagerRoleArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDataLakeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDataLakeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDataLakeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateDataLakeInput"}
	if s.Configurations == nil {
		invalidParams.Add(request.NewErrParamRequired("Configurations"))
	}
	if s.Configurations != nil && len(s.Configurations) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Configurations", 1))
	}
	if s.Configurations != nil {
		for i, v := range s.Configurations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Configurations", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurations sets the Configurations field's value.
func (s *UpdateDataLakeInput) SetConfigurations(v []*DataLakeConfiguration) *UpdateDataLakeInput {
	s.Configurations = v
	return s
}

// SetMetaStoreManagerRoleArn sets the MetaStoreManagerRoleArn field's value.
func (s *UpdateDataLakeInput) SetMetaStoreManagerRoleArn(v string) *UpdateDataLakeInput {
	s.MetaStoreManagerRoleArn = &v
	return s
}

type UpdateDataLakeOutput struct {
	_ struct{} `type:"structure"`

	// The created Security Lake configuration object.
	DataLakes []*DataLakeResource `locationName:"dataLakes" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDataLakeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDataLakeOutput) GoString() string {
	return s.String()
}

// SetDataLakes sets the DataLakes field's value.
func (s *UpdateDataLakeOutput) SetDataLakes(v []*DataLakeResource) *UpdateDataLakeOutput {
	s.DataLakes = v
	return s
}

type UpdateSubscriberInput struct {
	_ struct{} `type:"structure"`

	// The supported Amazon Web Services from which logs and events are collected.
	// For the list of supported Amazon Web Services, see the Amazon Security Lake
	// User Guide (https://docs.aws.amazon.com/security-lake/latest/userguide/internal-sources.html).
	Sources []*LogSourceResource `locationName:"sources" type:"list"`

	// The description of the Security Lake account subscriber.
	SubscriberDescription *string `locationName:"subscriberDescription" type:"string"`

	// A value created by Security Lake that uniquely identifies your subscription.
	//
	// SubscriberId is a required field
	SubscriberId *string `location:"uri" locationName:"subscriberId" type:"string" required:"true"`

	// The AWS identity used to access your data.
	SubscriberIdentity *AwsIdentity `locationName:"subscriberIdentity" type:"structure"`

	// The name of the Security Lake account subscriber.
	SubscriberName *string `locationName:"subscriberName" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSubscriberInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSubscriberInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateSubscriberInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateSubscriberInput"}
	if s.SubscriberId == nil {
		invalidParams.Add(request.NewErrParamRequired("SubscriberId"))
	}
	if s.SubscriberId != nil && len(*s.SubscriberId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SubscriberId", 1))
	}
	if s.Sources != nil {
		for i, v := range s.Sources {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Sources", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.SubscriberIdentity != nil {
		if err := s.SubscriberIdentity.Validate(); err != nil {
			invalidParams.AddNested("SubscriberIdentity", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSources sets the Sources field's value.
func (s *UpdateSubscriberInput) SetSources(v []*LogSourceResource) *UpdateSubscriberInput {
	s.Sources = v
	return s
}

// SetSubscriberDescription sets the SubscriberDescription field's value.
func (s *UpdateSubscriberInput) SetSubscriberDescription(v string) *UpdateSubscriberInput {
	s.SubscriberDescription = &v
	return s
}

// SetSubscriberId sets the SubscriberId field's value.
func (s *UpdateSubscriberInput) SetSubscriberId(v string) *UpdateSubscriberInput {
	s.SubscriberId = &v
	return s
}

// SetSubscriberIdentity sets the SubscriberIdentity field's value.
func (s *UpdateSubscriberInput) SetSubscriberIdentity(v *AwsIdentity) *UpdateSubscriberInput {
	s.SubscriberIdentity = v
	return s
}

// SetSubscriberName sets the SubscriberName field's value.
func (s *UpdateSubscriberInput) SetSubscriberName(v string) *UpdateSubscriberInput {
	s.SubscriberName = &v
	return s
}

type UpdateSubscriberNotificationInput struct {
	_ struct{} `type:"structure"`

	// The configuration for subscriber notification.
	//
	// Configuration is a required field
	Configuration *NotificationConfiguration `locationName:"configuration" type:"structure" required:"true"`

	// The subscription ID for which the subscription notification is specified.
	//
	// SubscriberId is a required field
	SubscriberId *string `location:"uri" locationName:"subscriberId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSubscriberNotificationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSubscriberNotificationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateSubscriberNotificationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateSubscriberNotificationInput"}
	if s.Configuration == nil {
		invalidParams.Add(request.NewErrParamRequired("Configuration"))
	}
	if s.SubscriberId == nil {
		invalidParams.Add(request.NewErrParamRequired("SubscriberId"))
	}
	if s.SubscriberId != nil && len(*s.SubscriberId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SubscriberId", 1))
	}
	if s.Configuration != nil {
		if err := s.Configuration.Validate(); err != nil {
			invalidParams.AddNested("Configuration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfiguration sets the Configuration field's value.
func (s *UpdateSubscriberNotificationInput) SetConfiguration(v *NotificationConfiguration) *UpdateSubscriberNotificationInput {
	s.Configuration = v
	return s
}

// SetSubscriberId sets the SubscriberId field's value.
func (s *UpdateSubscriberNotificationInput) SetSubscriberId(v string) *UpdateSubscriberNotificationInput {
	s.SubscriberId = &v
	return s
}

type UpdateSubscriberNotificationOutput struct {
	_ struct{} `type:"structure"`

	// The subscriber endpoint to which exception messages are posted.
	SubscriberEndpoint *string `locationName:"subscriberEndpoint" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSubscriberNotificationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSubscriberNotificationOutput) GoString() string {
	return s.String()
}

// SetSubscriberEndpoint sets the SubscriberEndpoint field's value.
func (s *UpdateSubscriberNotificationOutput) SetSubscriberEndpoint(v string) *UpdateSubscriberNotificationOutput {
	s.SubscriberEndpoint = &v
	return s
}

type UpdateSubscriberOutput struct {
	_ struct{} `type:"structure"`

	// The updated subscriber information.
	Subscriber *SubscriberResource `locationName:"subscriber" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSubscriberOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSubscriberOutput) GoString() string {
	return s.String()
}

// SetSubscriber sets the Subscriber field's value.
func (s *UpdateSubscriberOutput) SetSubscriber(v *SubscriberResource) *UpdateSubscriberOutput {
	s.Subscriber = v
	return s
}

const (
	// AccessTypeLakeformation is a AccessType enum value
	AccessTypeLakeformation = "LAKEFORMATION"

	// AccessTypeS3 is a AccessType enum value
	AccessTypeS3 = "S3"
)

// AccessType_Values returns all elements of the AccessType enum
func AccessType_Values() []string {
	return []string{
		AccessTypeLakeformation,
		AccessTypeS3,
	}
}

const (
	// AwsLogSourceNameRoute53 is a AwsLogSourceName enum value
	AwsLogSourceNameRoute53 = "ROUTE53"

	// AwsLogSourceNameVpcFlow is a AwsLogSourceName enum value
	AwsLogSourceNameVpcFlow = "VPC_FLOW"

	// AwsLogSourceNameShFindings is a AwsLogSourceName enum value
	AwsLogSourceNameShFindings = "SH_FINDINGS"

	// AwsLogSourceNameCloudTrailMgmt is a AwsLogSourceName enum value
	AwsLogSourceNameCloudTrailMgmt = "CLOUD_TRAIL_MGMT"

	// AwsLogSourceNameLambdaExecution is a AwsLogSourceName enum value
	AwsLogSourceNameLambdaExecution = "LAMBDA_EXECUTION"

	// AwsLogSourceNameS3Data is a AwsLogSourceName enum value
	AwsLogSourceNameS3Data = "S3_DATA"

	// AwsLogSourceNameEksAudit is a AwsLogSourceName enum value
	AwsLogSourceNameEksAudit = "EKS_AUDIT"

	// AwsLogSourceNameWaf is a AwsLogSourceName enum value
	AwsLogSourceNameWaf = "WAF"
)

// AwsLogSourceName_Values returns all elements of the AwsLogSourceName enum
func AwsLogSourceName_Values() []string {
	return []string{
		AwsLogSourceNameRoute53,
		AwsLogSourceNameVpcFlow,
		AwsLogSourceNameShFindings,
		AwsLogSourceNameCloudTrailMgmt,
		AwsLogSourceNameLambdaExecution,
		AwsLogSourceNameS3Data,
		AwsLogSourceNameEksAudit,
		AwsLogSourceNameWaf,
	}
}

const (
	// DataLakeStatusInitialized is a DataLakeStatus enum value
	DataLakeStatusInitialized = "INITIALIZED"

	// DataLakeStatusPending is a DataLakeStatus enum value
	DataLakeStatusPending = "PENDING"

	// DataLakeStatusCompleted is a DataLakeStatus enum value
	DataLakeStatusCompleted = "COMPLETED"

	// DataLakeStatusFailed is a DataLakeStatus enum value
	DataLakeStatusFailed = "FAILED"
)

// DataLakeStatus_Values returns all elements of the DataLakeStatus enum
func DataLakeStatus_Values() []string {
	return []string{
		DataLakeStatusInitialized,
		DataLakeStatusPending,
		DataLakeStatusCompleted,
		DataLakeStatusFailed,
	}
}

const (
	// HttpMethodPost is a HttpMethod enum value
	HttpMethodPost = "POST"

	// HttpMethodPut is a HttpMethod enum value
	HttpMethodPut = "PUT"
)

// HttpMethod_Values returns all elements of the HttpMethod enum
func HttpMethod_Values() []string {
	return []string{
		HttpMethodPost,
		HttpMethodPut,
	}
}

const (
	// SourceCollectionStatusCollecting is a SourceCollectionStatus enum value
	SourceCollectionStatusCollecting = "COLLECTING"

	// SourceCollectionStatusMisconfigured is a SourceCollectionStatus enum value
	SourceCollectionStatusMisconfigured = "MISCONFIGURED"

	// SourceCollectionStatusNotCollecting is a SourceCollectionStatus enum value
	SourceCollectionStatusNotCollecting = "NOT_COLLECTING"
)

// SourceCollectionStatus_Values returns all elements of the SourceCollectionStatus enum
func SourceCollectionStatus_Values() []string {
	return []string{
		SourceCollectionStatusCollecting,
		SourceCollectionStatusMisconfigured,
		SourceCollectionStatusNotCollecting,
	}
}

const (
	// SubscriberStatusActive is a SubscriberStatus enum value
	SubscriberStatusActive = "ACTIVE"

	// SubscriberStatusDeactivated is a SubscriberStatus enum value
	SubscriberStatusDeactivated = "DEACTIVATED"

	// SubscriberStatusPending is a SubscriberStatus enum value
	SubscriberStatusPending = "PENDING"

	// SubscriberStatusReady is a SubscriberStatus enum value
	SubscriberStatusReady = "READY"
)

// SubscriberStatus_Values returns all elements of the SubscriberStatus enum
func SubscriberStatus_Values() []string {
	return []string{
		SubscriberStatusActive,
		SubscriberStatusDeactivated,
		SubscriberStatusPending,
		SubscriberStatusReady,
	}
}
