#include "main.h"
/*************************************************************************
    Startbildschirm und Anzahl der Argumente

    Intro Screen and argument check
*************************************************************************/

/******************************************************************
	Status_Info

	prints a status line during multiplexing
******************************************************************/

void status_info (
unsigned int nsectors_a,
unsigned int nsectors_a1,
unsigned int nsectors_a2,
unsigned int nsectors_a3,
unsigned int nsectors_a4,
unsigned int nsectors_a5,
unsigned int nsectors_a6,
unsigned int nsectors_a7,
unsigned int nsectors_v,
unsigned int nsectors_p,
double nbytes,
unsigned int buf_v,
unsigned int buf_a,
unsigned int buf_a1,
unsigned int buf_a2,
unsigned int buf_a3,
unsigned int buf_a4,
unsigned int buf_a5,
unsigned int buf_a6,
unsigned int buf_a7)
{
  fprintf(statfile, "  | %7d | %7d | %7d | %7d | %7d | %7d | %7d | %7d     | %7d | %7d | %11.0f \
| %6d | %6d | %6d | %6d | %6d | %6d | %6d | %6d | %6d |\n",
      nsectors_a, nsectors_a1, nsectors_a2, nsectors_a3, nsectors_a4, nsectors_a5, nsectors_a6, nsectors_a7,
 nsectors_v, nsectors_p, nbytes, buf_a, buf_a1, buf_a2, buf_a3, buf_a4, buf_a5, buf_a6, buf_a7, buf_v);
}


void status_header(char *filename)
{
  fprintf(statfile, "\n");
  fprintf(statfile, "Multiplexing file %s\n\n", filename);
  status_footer();
  fprintf(statfile, "  |  Audio1 |  Audio2 |  Video  | Padding | Bytes  MPEG | Audio1 | Audio2 | Video  |\n");
  fprintf(statfile, "  | Sectors | Sectors | Sectors | Sectors | System File | Buffer | Buffer | Buffer |\n");
  status_footer();
}


void status_message (
unsigned char what)
{
  switch (what)
  {
    case STATUS_AUDIO_END:
      fprintf(statfile, "  |file  end|         |         |         |             |        |        |        |\n");
      break;
    case STATUS_AUDIO_TIME_OUT:
      fprintf(statfile, "  |time  out|         |         |         |             |        |        |        |\n");
      break;
    case STATUS_AUDIO1_END:
      fprintf(statfile, "  |         |file  end|         |         |             |        |        |        |\n");
      break;
    case STATUS_AUDIO1_TIME_OUT:
      fprintf(statfile, "  |         |time  out|         |         |             |        |        |        |\n");
      break;
    case STATUS_VIDEO_END:
      fprintf(statfile, "  |         |         |file  end|         |             |        |        |        |\n");
      break;
    case STATUS_VIDEO_TIME_OUT:
      fprintf(statfile, "  |         |         |time  out|         |             |        |        |        |\n");
  }
}

void status_footer ()
{
  fprintf(statfile, "  +---------+---------+---------+---------+-------------+--------+--------+--------+\n");
}
