/*============================================================================*
 *============================================================================*
 * Component:           plextor-tool-applet
 * Filename:            gplextor-tool.c
 *                                                                             
 * Authors:             Georg Huettenegger
 *                                                                             
 * Date of Creation:    Fri Jul 30 16:04:15 1999
 *                                                                             
 * Last Modification:   Fri Jul 30 16:04:15 1999
 *                                                                             
 * Copyright:           Georg Huettenegger                                    
 *                                                                             
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *                                                                             
 *============================================================================*
 *============================================================================*
 */
#include <applet-widget.h>
#include "plextor-tool.h"
#include "gplextor-tool.h"
#include "properties.h"
#include "session.h"
#include "scsi-functions.h"
#include "utility-functions.h"

#if (defined VERBOSE_OUTPUT) || (defined CALL_TRACE)
FILE * gtc_local_ptr;
#endif

/*============================================================================*
 *                                                                             
 * DESCRIPTION:                                                                
 * ------------                                                                
 * Destroy the nice about dialog. (being the callback function).
 *                                                                             
 *----------------------------------------------------------------------------*
 */
static void
close_dialog_about_cb (GtkWidget *widget, GtkWidget **about)
{
#ifdef CALL_TRACE
  flushed_output_0 (gtc_local_ptr, "Trace: close_dialob_about_cb\n");
#endif

  *about = NULL;
}


/*============================================================================*
 *                                                                             
 * DESCRIPTION:                                                                
 * ------------                                                                
 * Display a nice about dialog box.
 *                                                                             
 *----------------------------------------------------------------------------*
 */
static void 
dialog_about (GtkWidget *widget, gpointer data)
{
  static GtkWidget *about = NULL;
  const gchar *authors[] = {
    "Georg Httenegger (georg@ist.org)",
    NULL
  };
#ifdef CALL_TRACE
  GPlextorToolAppletData * gptad = data;

  flushed_output_0 (gptad->out_file_ptr, "Trace: dialog_about\n");
#endif

  
  if (about != NULL) {
    gdk_window_raise (GTK_WIDGET (GNOME_DIALOG (about))->window);
    return;
  }
  
  about = gnome_about_new (_ ("Plextor-Tool-Applet"), VERSION,
                           "Copyright (C) 1999-2002 Georg Httenegger",
                           authors,
                           _ ("The plextor-tool for changing parameters "
                              "of Plextor(r)/MMC cd-rom/cd-r(w) drives.\n"
                              "http://www.technik.sth.ac.at/plextor-tool"),
                           NULL);
  gtk_signal_connect (GTK_OBJECT (about), "destroy", 
                      GTK_SIGNAL_FUNC (close_dialog_about_cb), 
                      (gpointer) &about);
  gtk_widget_show (about);
}

/*============================================================================*
 *                                                                             
 * DESCRIPTION:                                                                
 * ------------                                                                
 * This function is called whenever the device setting is changed.
 *                                                                             
 *----------------------------------------------------------------------------*
 */
static void device_changed_callback (GtkWidget * widget, gpointer data)
{
  GPlextorToolAppletData * gptad = (GPlextorToolAppletData *)data;
#ifdef CALL_TRACE
  flushed_output_0 (gptad->out_file_ptr, "Trace: device_changed_callback\n");
#endif

  g_free (gptad->old_device_selection);
  gptad->old_device_selection = g_strdup
    (gtk_entry_get_text (GTK_ENTRY
                         (GTK_COMBO(gptad->device_selection_combo)
                          ->entry)));

  device_changed (gptad, FALSE);
}

/*============================================================================*
 *                                                                             
 * DESCRIPTION:                                                                
 * ------------                                                                
 * This function is called whenever the speed setting is changed.
 *                                                                             
 *----------------------------------------------------------------------------*
 */

static void speed_changed_callback (GtkWidget * widget, gpointer data)
{
  GPlextorToolAppletData * gptad = (GPlextorToolAppletData *)data;
  
#ifdef CALL_TRACE
  flushed_output_0 (gptad->out_file_ptr, "Trace: speed_changed_callback\n");
#endif

  g_free (gptad->old_speed_selection);
  gptad->old_speed_selection = g_strdup
    (gtk_entry_get_text (GTK_ENTRY
                         (GTK_COMBO(gptad->speed_selection_combo)
                          ->entry)));

  speed_changed (gptad, FALSE);
}

int main (int argc, char * argv[])
{
  const gchar * goad_id;
  GtkWidget * applet;

  /* initialize i18n */
  bindtextdomain (PACKAGE, GNOMELOCALEDIR);
  textdomain (PACKAGE);

#if (defined CALL_TRACE) || (defined VERBOSE_OUTPUT)
  /* use this line if stored output is needed
     gtc_local_ptr = fopen ("/tmp/plextor-tool-applet2.out", "w+");
  */
  gtc_local_ptr = stdout;
#endif

  verbose = 0;
  /* initialize applet */
  applet_widget_init (APPLNAME, VERSION, argc, argv, NULL, 0,
                      NULL);
  applet_factory_new (APPLNAME, NULL,
                      (AppletFactoryActivator) applet_start_new_applet);

  /* next try to get the activate-goad-server parameter */
  goad_id = goad_server_activation_id ();
  if (!goad_id)
  { /* if not supplied just try default string */
    goad_id = APPLNAME;
  }

  /* create applet if error just exit else run gtk applet main */
  applet = make_new_plextor_tool_applet (goad_id);

  if (applet == NULL)
    return 1;

  applet_widget_gtk_main ();

  /* make compiler and os happy */
  return 0;
}

GtkWidget * applet_start_new_applet (const gchar * goad_id,
                                     const char * params[],
                                     int nparams)
{
#ifdef CALL_TRACE
  flushed_output_0 (gtc_local_ptr, "Trace: applet_start_new_applet\n");
#endif

  /* return the function that will actually create the applet */
  return make_new_plextor_tool_applet (goad_id);
}

GtkWidget * make_new_plextor_tool_applet (const gchar * goad_id)
{
  GPlextorToolAppletData  * gptad = g_new0 (GPlextorToolAppletData, 1);
  GPlextorToolData * gptd = NULL;
  /* insert start */
  GtkWidget * vbox;
  /* insert end */

  gptad->applet = applet_widget_new (goad_id);
#if (defined CALL_TRACE) || (defined VERBOSE_OUTPUT)
  gptad->out_file_ptr = gtc_local_ptr;
#endif
#ifdef CALL_TRACE
  flushed_output_0 (gptad->out_file_ptr,
                    "Trace: make_new_plextor_tool_applet\n");
#endif

  gtk_widget_set_usize (gptad->applet, WIDTH, HEIGHT);

  if (gptad->applet == NULL)
    return NULL;

  /* initialize session relevant parameters (using defaults if not
   * available) */
  plextor_tool_session_defaults (gptad);

  if ( (APPLET_WIDGET (gptad->applet)->privcfgpath) &&
       *(APPLET_WIDGET (gptad->applet)->privcfgpath))
  {
    plextor_tool_session_load (APPLET_WIDGET (gptad->applet)->privcfgpath,
                               gptad);
  }

  /* create the user interface located directly in the panel */
  /* first create the device selection combo */
  gptad->device_selection_combo = gtk_combo_new ();

  gptd = find_gptd_with_device_name (gptad, gptad->old_device_selection);

  if (!gptd)
  {
    GtkWidget * error_dialog;
    error_dialog = gnome_error_dialog (_("Plextor-Tool-Applet:\n"
                                         "Did not find a single device"
                                         " (Exiting)!\n"));
    gtk_widget_show_all (error_dialog);
    gtk_signal_connect (GTK_OBJECT (error_dialog), "hide",
                        GTK_SIGNAL_FUNC (gtk_main_quit), NULL);
    gtk_main ();
    return NULL;
  }

  gtk_widget_set_usize (gptad->device_selection_combo, WIDTH, HEIGHT/2-2);

  gtk_combo_set_popdown_strings (GTK_COMBO(gptad->device_selection_combo),
                                 gptad->device_names);
  gtk_entry_set_text (GTK_ENTRY(GTK_COMBO(gptad->device_selection_combo)
                                ->entry),
                      gptad->old_device_selection);
  vbox = gtk_vbox_new (FALSE, 0);

  /* register tooltip help for device selection combo */
  applet_widget_set_widget_tooltip (APPLET_WIDGET(gptad->applet),
                                    gptad->device_selection_combo,
                                    _("Currently Selected Device"));

  /* we don't allow direct modification of the selection combo */
  gtk_entry_set_editable (GTK_ENTRY(GTK_COMBO(gptad->device_selection_combo)
                                    ->entry),
                          FALSE);

  gtk_widget_show (gptad->device_selection_combo);
  gtk_box_pack_start (GTK_BOX (vbox), gptad->device_selection_combo, TRUE,
                      FALSE, 0);
  
  /* whenever there is a change in the selection combo call
   * device_changed_callback */
  gptad->dev_sel_signal_id = gtk_signal_connect 
    (GTK_OBJECT(GTK_COMBO(gptad->device_selection_combo)
                ->entry), "changed",
     GTK_SIGNAL_FUNC (device_changed_callback), gptad);

  /* now create the speed selection combo */
  gptad->speed_selection_combo = gtk_combo_new ();
  gtk_widget_set_usize (gptad->speed_selection_combo, WIDTH, HEIGHT/2-2);
  
  gtk_combo_set_popdown_strings (GTK_COMBO(gptad->speed_selection_combo),
                                 gptd->avail_speeds);
  gtk_entry_set_text (GTK_ENTRY(GTK_COMBO(gptad->speed_selection_combo)
                                ->entry),
                      gptad->old_speed_selection);
  /* register tooltip help for the speed selection combo */
  applet_widget_set_widget_tooltip (APPLET_WIDGET (gptad->applet),
                                    gptad->speed_selection_combo,
                                    _("Currently Selected Speed"));
  gtk_widget_show (gptad->speed_selection_combo);
  /* do not allow modification of the value of the combo box */
  gtk_entry_set_editable (GTK_ENTRY(GTK_COMBO(gptad->speed_selection_combo)
                                    ->entry),
                          FALSE);
  /* whenever there is a change in the selection combo call
   * speed_changed_callback */
  gptad->speed_sel_signal_id = gtk_signal_connect 
    (GTK_OBJECT(GTK_COMBO(gptad->speed_selection_combo)
                ->entry), "changed",
     GTK_SIGNAL_FUNC (speed_changed_callback), gptad); 
  gtk_box_pack_start (GTK_BOX (vbox), gptad->speed_selection_combo, TRUE,
                      FALSE, 0);

  gtk_widget_show (vbox);
  applet_widget_add (APPLET_WIDGET (gptad->applet), GTK_WIDGET (vbox));
  gtk_widget_show (gptad->applet);


  /* register our session saving function */
  gtk_signal_connect (GTK_OBJECT (gptad->applet), "save_session",
                      GTK_SIGNAL_FUNC (plextor_tool_session_save),
                      gptad);

  /* Add the menu items */
  applet_widget_register_stock_callback (APPLET_WIDGET (gptad->applet),
                                         "about",
                                         GNOME_STOCK_MENU_ABOUT,
                                         _ ("About..."),
                                         GTK_SIGNAL_FUNC (dialog_about), 
                                         gptad);
  
  /* Register the properties page */
  applet_widget_register_stock_callback(APPLET_WIDGET(gptad->applet),
                                        "properties",
                                        GNOME_STOCK_MENU_PROP,
                                        _("Properties..."),
                                        GTK_SIGNAL_FUNC (properties_window),
                                        gptad);

  gtk_widget_show_all (gptad->applet);

  return gptad->applet;
}

/*============================================================================*
 *============================================================================*
 * EOF gplextor-tool.c
 *============================================================================*
 *============================================================================*
 */
