// Code generated by protoc-gen-go-grpc. DO NOT EDIT.

package v1

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

// WorkloadAttestorClient is the client API for WorkloadAttestor service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type WorkloadAttestorClient interface {
	// Attests the specified workload process. If the process is not one the
	// attestor is in a position to attest (e.g. k8s attestor attesting a
	// non-k8s workload), the call will succeed but return no selectors. If the
	// process is one the attestor is in a position to attest, but the attestor
	// fails to gather all selectors related to that workload, the call will
	// fail. Otherwise the attestor will return one or more workload selectors.
	Attest(ctx context.Context, in *AttestRequest, opts ...grpc.CallOption) (*AttestResponse, error)
}

type workloadAttestorClient struct {
	cc grpc.ClientConnInterface
}

func NewWorkloadAttestorClient(cc grpc.ClientConnInterface) WorkloadAttestorClient {
	return &workloadAttestorClient{cc}
}

func (c *workloadAttestorClient) Attest(ctx context.Context, in *AttestRequest, opts ...grpc.CallOption) (*AttestResponse, error) {
	out := new(AttestResponse)
	err := c.cc.Invoke(ctx, "/spire.plugin.agent.workloadattestor.v1.WorkloadAttestor/Attest", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// WorkloadAttestorServer is the server API for WorkloadAttestor service.
// All implementations must embed UnimplementedWorkloadAttestorServer
// for forward compatibility
type WorkloadAttestorServer interface {
	// Attests the specified workload process. If the process is not one the
	// attestor is in a position to attest (e.g. k8s attestor attesting a
	// non-k8s workload), the call will succeed but return no selectors. If the
	// process is one the attestor is in a position to attest, but the attestor
	// fails to gather all selectors related to that workload, the call will
	// fail. Otherwise the attestor will return one or more workload selectors.
	Attest(context.Context, *AttestRequest) (*AttestResponse, error)
	mustEmbedUnimplementedWorkloadAttestorServer()
}

// UnimplementedWorkloadAttestorServer must be embedded to have forward compatible implementations.
type UnimplementedWorkloadAttestorServer struct {
}

func (UnimplementedWorkloadAttestorServer) Attest(context.Context, *AttestRequest) (*AttestResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Attest not implemented")
}
func (UnimplementedWorkloadAttestorServer) mustEmbedUnimplementedWorkloadAttestorServer() {}

// UnsafeWorkloadAttestorServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to WorkloadAttestorServer will
// result in compilation errors.
type UnsafeWorkloadAttestorServer interface {
	mustEmbedUnimplementedWorkloadAttestorServer()
}

func RegisterWorkloadAttestorServer(s grpc.ServiceRegistrar, srv WorkloadAttestorServer) {
	s.RegisterService(&WorkloadAttestor_ServiceDesc, srv)
}

func _WorkloadAttestor_Attest_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AttestRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WorkloadAttestorServer).Attest(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/spire.plugin.agent.workloadattestor.v1.WorkloadAttestor/Attest",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WorkloadAttestorServer).Attest(ctx, req.(*AttestRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// WorkloadAttestor_ServiceDesc is the grpc.ServiceDesc for WorkloadAttestor service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var WorkloadAttestor_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "spire.plugin.agent.workloadattestor.v1.WorkloadAttestor",
	HandlerType: (*WorkloadAttestorServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Attest",
			Handler:    _WorkloadAttestor_Attest_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "spire/plugin/agent/workloadattestor/v1/workloadattestor.proto",
}
