/*
Copyright 2024 Keyfactor

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

EJBCA REST Interface

API reference documentation.

API version: 1.0
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package ejbca

import (
	"bytes"
	"context"
	"io"
	"net/http"
	"net/url"
	"strings"
	"time"
)

// V1CertificateApiService V1CertificateApi service
type V1CertificateApiService service

type ApiCertificateRequestRequest struct {
	ctx                           context.Context
	ApiService                    *V1CertificateApiService
	certificateRequestRestRequest *CertificateRequestRestRequest
}

func (r ApiCertificateRequestRequest) CertificateRequestRestRequest(certificateRequestRestRequest CertificateRequestRestRequest) ApiCertificateRequestRequest {
	r.certificateRequestRestRequest = &certificateRequestRestRequest
	return r
}

func (r ApiCertificateRequestRequest) Execute() (*CertificateRestResponse, *http.Response, error) {
	return r.ApiService.CertificateRequestExecute(r)
}

/*
CertificateRequest Enrollment with client generated keys for an existing End Entity

Enroll for a certificate given a PEM encoded PKCS#10 CSR.

	@param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
	@return ApiCertificateRequestRequest
*/
func (a *V1CertificateApiService) CertificateRequest(ctx context.Context) ApiCertificateRequestRequest {
	return ApiCertificateRequestRequest{
		ApiService: a,
		ctx:        ctx,
	}
}

// Execute executes the request
//
//	@return CertificateRestResponse
func (a *V1CertificateApiService) CertificateRequestExecute(r ApiCertificateRequestRequest) (*CertificateRestResponse, *http.Response, error) {
	var (
		localVarHTTPMethod  = http.MethodPost
		localVarPostBody    interface{}
		formFiles           []formFile
		localVarReturnValue *CertificateRestResponse
	)

	localBasePath := "/ejbca/ejbca-rest-api"

	localVarPath := localBasePath + "/v1/certificate/certificaterequest"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.certificateRequestRestRequest
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ApiEnrollKeystoreRequest struct {
	ctx                 context.Context
	ApiService          *V1CertificateApiService
	keyStoreRestRequest *KeyStoreRestRequest
}

func (r ApiEnrollKeystoreRequest) KeyStoreRestRequest(keyStoreRestRequest KeyStoreRestRequest) ApiEnrollKeystoreRequest {
	r.keyStoreRestRequest = &keyStoreRestRequest
	return r
}

func (r ApiEnrollKeystoreRequest) Execute() (*CertificateRestResponse, *http.Response, error) {
	return r.ApiService.EnrollKeystoreExecute(r)
}

/*
EnrollKeystore Keystore enrollment

Creates a keystore for the specified end entity

	@param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
	@return ApiEnrollKeystoreRequest
*/
func (a *V1CertificateApiService) EnrollKeystore(ctx context.Context) ApiEnrollKeystoreRequest {
	return ApiEnrollKeystoreRequest{
		ApiService: a,
		ctx:        ctx,
	}
}

// Execute executes the request
//
//	@return CertificateRestResponse
func (a *V1CertificateApiService) EnrollKeystoreExecute(r ApiEnrollKeystoreRequest) (*CertificateRestResponse, *http.Response, error) {
	var (
		localVarHTTPMethod  = http.MethodPost
		localVarPostBody    interface{}
		formFiles           []formFile
		localVarReturnValue *CertificateRestResponse
	)

	localBasePath := "/ejbca/ejbca-rest-api"

	localVarPath := localBasePath + "/v1/certificate/enrollkeystore"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.keyStoreRestRequest
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ApiEnrollPkcs10CertificateRequest struct {
	ctx                          context.Context
	ApiService                   *V1CertificateApiService
	enrollCertificateRestRequest *EnrollCertificateRestRequest
}

func (r ApiEnrollPkcs10CertificateRequest) EnrollCertificateRestRequest(enrollCertificateRestRequest EnrollCertificateRestRequest) ApiEnrollPkcs10CertificateRequest {
	r.enrollCertificateRestRequest = &enrollCertificateRestRequest
	return r
}

func (r ApiEnrollPkcs10CertificateRequest) Execute() (*CertificateRestResponse, *http.Response, error) {
	return r.ApiService.EnrollPkcs10CertificateExecute(r)
}

/*
EnrollPkcs10Certificate Enrollment with client generated keys, using CSR subject

Enroll for a certificate given a PEM encoded PKCS#10 CSR.

	@param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
	@return ApiEnrollPkcs10CertificateRequest
*/
func (a *V1CertificateApiService) EnrollPkcs10Certificate(ctx context.Context) ApiEnrollPkcs10CertificateRequest {
	return ApiEnrollPkcs10CertificateRequest{
		ApiService: a,
		ctx:        ctx,
	}
}

// Execute executes the request
//
//	@return CertificateRestResponse
func (a *V1CertificateApiService) EnrollPkcs10CertificateExecute(r ApiEnrollPkcs10CertificateRequest) (*CertificateRestResponse, *http.Response, error) {
	var (
		localVarHTTPMethod  = http.MethodPost
		localVarPostBody    interface{}
		formFiles           []formFile
		localVarReturnValue *CertificateRestResponse
	)

	localBasePath := "/ejbca/ejbca-rest-api"

	localVarPath := localBasePath + "/v1/certificate/pkcs10enroll"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.enrollCertificateRestRequest
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ApiFinalizeEnrollmentRequest struct {
	ctx                 context.Context
	ApiService          *V1CertificateApiService
	requestId           int32
	finalizeRestRequest *FinalizeRestRequest
}

// responseFormat must be one of &#39;P12&#39;, &#39;BCFKS&#39;, &#39;JKS&#39;, &#39;DER&#39;
func (r ApiFinalizeEnrollmentRequest) FinalizeRestRequest(finalizeRestRequest FinalizeRestRequest) ApiFinalizeEnrollmentRequest {
	r.finalizeRestRequest = &finalizeRestRequest
	return r
}

func (r ApiFinalizeEnrollmentRequest) Execute() (*CertificateRestResponse, *http.Response, error) {
	return r.ApiService.FinalizeEnrollmentExecute(r)
}

/*
FinalizeEnrollment Finalize enrollment

Finalizes enrollment after administrator approval using request Id

	@param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
	@param requestId Approval request id
	@return ApiFinalizeEnrollmentRequest
*/
func (a *V1CertificateApiService) FinalizeEnrollment(ctx context.Context, requestId int32) ApiFinalizeEnrollmentRequest {
	return ApiFinalizeEnrollmentRequest{
		ApiService: a,
		ctx:        ctx,
		requestId:  requestId,
	}
}

// Execute executes the request
//
//	@return CertificateRestResponse
func (a *V1CertificateApiService) FinalizeEnrollmentExecute(r ApiFinalizeEnrollmentRequest) (*CertificateRestResponse, *http.Response, error) {
	var (
		localVarHTTPMethod  = http.MethodPost
		localVarPostBody    interface{}
		formFiles           []formFile
		localVarReturnValue *CertificateRestResponse
	)

	localBasePath := "/ejbca/ejbca-rest-api"

	localVarPath := localBasePath + "/v1/certificate/{request_id}/finalize"
	localVarPath = strings.Replace(localVarPath, "{"+"request_id"+"}", url.PathEscape(parameterValueToString(r.requestId, "requestId")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.finalizeRestRequest
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ApiGetCertificatesAboutToExpireRequest struct {
	ctx                context.Context
	ApiService         *V1CertificateApiService
	days               *int64
	offset             *int32
	maxNumberOfResults *int32
}

// Request certificates expiring within this number of days
func (r ApiGetCertificatesAboutToExpireRequest) Days(days int64) ApiGetCertificatesAboutToExpireRequest {
	r.days = &days
	return r
}

// Next offset to display results of, if maxNumberOfResults is exceeded. Starts from 0.
func (r ApiGetCertificatesAboutToExpireRequest) Offset(offset int32) ApiGetCertificatesAboutToExpireRequest {
	r.offset = &offset
	return r
}

// Maximum number of certificates to display. If result exceeds this value. Modify &#39;offset&#39; to retrieve more results
func (r ApiGetCertificatesAboutToExpireRequest) MaxNumberOfResults(maxNumberOfResults int32) ApiGetCertificatesAboutToExpireRequest {
	r.maxNumberOfResults = &maxNumberOfResults
	return r
}

func (r ApiGetCertificatesAboutToExpireRequest) Execute() (*ExpiringCertificatesRestResponse, *http.Response, error) {
	return r.ApiService.GetCertificatesAboutToExpireExecute(r)
}

/*
GetCertificatesAboutToExpire Get a list of certificates that are about to expire

List of certificates expiring within specified number of days

	@param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
	@return ApiGetCertificatesAboutToExpireRequest
*/
func (a *V1CertificateApiService) GetCertificatesAboutToExpire(ctx context.Context) ApiGetCertificatesAboutToExpireRequest {
	return ApiGetCertificatesAboutToExpireRequest{
		ApiService: a,
		ctx:        ctx,
	}
}

// Execute executes the request
//
//	@return ExpiringCertificatesRestResponse
func (a *V1CertificateApiService) GetCertificatesAboutToExpireExecute(r ApiGetCertificatesAboutToExpireRequest) (*ExpiringCertificatesRestResponse, *http.Response, error) {
	var (
		localVarHTTPMethod  = http.MethodGet
		localVarPostBody    interface{}
		formFiles           []formFile
		localVarReturnValue *ExpiringCertificatesRestResponse
	)

	localBasePath := "/ejbca/ejbca-rest-api"

	localVarPath := localBasePath + "/v1/certificate/expire"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.days != nil {
		parameterAddToQuery(localVarQueryParams, "days", r.days, "")
	}
	if r.offset != nil {
		parameterAddToQuery(localVarQueryParams, "offset", r.offset, "")
	}
	if r.maxNumberOfResults != nil {
		parameterAddToQuery(localVarQueryParams, "maxNumberOfResults", r.maxNumberOfResults, "")
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ApiRevocationStatusRequest struct {
	ctx                     context.Context
	ApiService              *V1CertificateApiService
	issuerDn                string
	certificateSerialNumber string
}

func (r ApiRevocationStatusRequest) Execute() (*RevokeStatusRestResponse, *http.Response, error) {
	return r.ApiService.RevocationStatusExecute(r)
}

/*
RevocationStatus Checks revocation status of the specified certificate

Checks revocation status of the specified certificate

	@param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
	@param issuerDn Subject DN of the issuing CA
	@param certificateSerialNumber hex serial number (without prefix, e.g. '00')
	@return ApiRevocationStatusRequest
*/
func (a *V1CertificateApiService) RevocationStatus(ctx context.Context, issuerDn string, certificateSerialNumber string) ApiRevocationStatusRequest {
	return ApiRevocationStatusRequest{
		ApiService:              a,
		ctx:                     ctx,
		issuerDn:                issuerDn,
		certificateSerialNumber: certificateSerialNumber,
	}
}

// Execute executes the request
//
//	@return RevokeStatusRestResponse
func (a *V1CertificateApiService) RevocationStatusExecute(r ApiRevocationStatusRequest) (*RevokeStatusRestResponse, *http.Response, error) {
	var (
		localVarHTTPMethod  = http.MethodGet
		localVarPostBody    interface{}
		formFiles           []formFile
		localVarReturnValue *RevokeStatusRestResponse
	)

	localBasePath := "/ejbca/ejbca-rest-api"

	localVarPath := localBasePath + "/v1/certificate/{issuer_dn}/{certificate_serial_number}/revocationstatus"
	localVarPath = strings.Replace(localVarPath, "{"+"issuer_dn"+"}", url.PathEscape(parameterValueToString(r.issuerDn, "issuerDn")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"certificate_serial_number"+"}", url.PathEscape(parameterValueToString(r.certificateSerialNumber, "certificateSerialNumber")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ApiRevokeCertificateRequest struct {
	ctx                     context.Context
	ApiService              *V1CertificateApiService
	issuerDn                string
	certificateSerialNumber string
	reason                  *string
	date                    *time.Time
}

// Must be valid RFC5280 reason. One of  NOT_REVOKED, UNSPECIFIED ,KEY_COMPROMISE,  CA_COMPROMISE, AFFILIATION_CHANGED, SUPERSEDED, CESSATION_OF_OPERATION,  CERTIFICATE_HOLD, REMOVE_FROM_CRL, PRIVILEGES_WITHDRAWN, AA_COMPROMISE
func (r ApiRevokeCertificateRequest) Reason(reason string) ApiRevokeCertificateRequest {
	r.reason = &reason
	return r
}

// ISO 8601 Date string, eg. &#39;2018-06-15T14:07:09Z&#39;
func (r ApiRevokeCertificateRequest) Date(date time.Time) ApiRevokeCertificateRequest {
	r.date = &date
	return r
}

func (r ApiRevokeCertificateRequest) Execute() (*RevokeStatusRestResponse, *http.Response, error) {
	return r.ApiService.RevokeCertificateExecute(r)
}

/*
RevokeCertificate Revokes the specified certificate

Revokes the specified certificate

	@param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
	@param issuerDn Subject DN of the issuing CA
	@param certificateSerialNumber hex serial number (without prefix, e.g. '00')
	@return ApiRevokeCertificateRequest
*/
func (a *V1CertificateApiService) RevokeCertificate(ctx context.Context, issuerDn string, certificateSerialNumber string) ApiRevokeCertificateRequest {
	return ApiRevokeCertificateRequest{
		ApiService:              a,
		ctx:                     ctx,
		issuerDn:                issuerDn,
		certificateSerialNumber: certificateSerialNumber,
	}
}

// Execute executes the request
//
//	@return RevokeStatusRestResponse
func (a *V1CertificateApiService) RevokeCertificateExecute(r ApiRevokeCertificateRequest) (*RevokeStatusRestResponse, *http.Response, error) {
	var (
		localVarHTTPMethod  = http.MethodPut
		localVarPostBody    interface{}
		formFiles           []formFile
		localVarReturnValue *RevokeStatusRestResponse
	)

	localBasePath := "/ejbca/ejbca-rest-api"

	localVarPath := localBasePath + "/v1/certificate/{issuer_dn}/{certificate_serial_number}/revoke"
	localVarPath = strings.Replace(localVarPath, "{"+"issuer_dn"+"}", url.PathEscape(parameterValueToString(r.issuerDn, "issuerDn")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"certificate_serial_number"+"}", url.PathEscape(parameterValueToString(r.certificateSerialNumber, "certificateSerialNumber")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.reason != nil {
		parameterAddToQuery(localVarQueryParams, "reason", r.reason, "")
	}
	if r.date != nil {
		parameterAddToQuery(localVarQueryParams, "date", r.date, "")
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ApiSearchCertificatesRequest struct {
	ctx                           context.Context
	ApiService                    *V1CertificateApiService
	searchCertificatesRestRequest *SearchCertificatesRestRequest
}

// Maximum number of results and collection of search criterias.
func (r ApiSearchCertificatesRequest) SearchCertificatesRestRequest(searchCertificatesRestRequest SearchCertificatesRestRequest) ApiSearchCertificatesRequest {
	r.searchCertificatesRestRequest = &searchCertificatesRestRequest
	return r
}

func (r ApiSearchCertificatesRequest) Execute() (*SearchCertificatesRestResponse, *http.Response, error) {
	return r.ApiService.SearchCertificatesExecute(r)
}

/*
SearchCertificates Searches for certificates confirming given criteria.

Insert as many search criteria as needed. A reference about allowed values for criteria could be found below, under SearchCertificateCriteriaRestRequest model.

	@param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
	@return ApiSearchCertificatesRequest
*/
func (a *V1CertificateApiService) SearchCertificates(ctx context.Context) ApiSearchCertificatesRequest {
	return ApiSearchCertificatesRequest{
		ApiService: a,
		ctx:        ctx,
	}
}

// Execute executes the request
//
//	@return SearchCertificatesRestResponse
func (a *V1CertificateApiService) SearchCertificatesExecute(r ApiSearchCertificatesRequest) (*SearchCertificatesRestResponse, *http.Response, error) {
	var (
		localVarHTTPMethod  = http.MethodPost
		localVarPostBody    interface{}
		formFiles           []formFile
		localVarReturnValue *SearchCertificatesRestResponse
	)

	localBasePath := "/ejbca/ejbca-rest-api"

	localVarPath := localBasePath + "/v1/certificate/search"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.searchCertificatesRestRequest
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ApiStatus2Request struct {
	ctx        context.Context
	ApiService *V1CertificateApiService
}

func (r ApiStatus2Request) Execute() (*RestResourceStatusRestResponse, *http.Response, error) {
	return r.ApiService.Status2Execute(r)
}

/*
Status2 Get the status of this REST Resource

Returns status, API version and EJBCA version.

	@param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
	@return ApiStatus2Request
*/
func (a *V1CertificateApiService) Status2(ctx context.Context) ApiStatus2Request {
	return ApiStatus2Request{
		ApiService: a,
		ctx:        ctx,
	}
}

// Execute executes the request
//
//	@return RestResourceStatusRestResponse
func (a *V1CertificateApiService) Status2Execute(r ApiStatus2Request) (*RestResourceStatusRestResponse, *http.Response, error) {
	var (
		localVarHTTPMethod  = http.MethodGet
		localVarPostBody    interface{}
		formFiles           []formFile
		localVarReturnValue *RestResourceStatusRestResponse
	)

	localBasePath := "/ejbca/ejbca-rest-api"

	localVarPath := localBasePath + "/v1/certificate/status"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}
